/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sStormControlInfo;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2StormControlTableModel
extends AbstractTableModel
implements Observer {
    public static final int LINENUMBER_INDEX = 0;
    public static final int DLF_STORM_EN_INDEX = 1;
    public static final int DLF_STORM_THR_INDEX = 2;
    public static final int MCAST_STORM_EN_INDEX = 3;
    public static final int MCAST_STORM_THR_INDEX = 4;
    public static final int BCAST_STORM_EN_INDEX = 5;
    public static final int BCAST_STORM_THR_INDEX = 6;
    static final String[] columnNames = new String[]{"Port", "DLF Storm Control", "DLF Storm Control Threshold (pps)", "Mcast Storm Control", "Mcast Storm Control Threshold (pps)", "Bcast Storm Control", "Bcast Storm Control Threshold (pps)"};
    private XPL2ModuleModel eqpmtModel = null;
    private XPL2LineModel[] lineModels = null;
    private sStormControlInfo[] stormControlInfo = null;
    private EntityCellRenderer myPortRenderer = new EntityCellRenderer(false);
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private static final SDebug db = new SDebug("XPL2StormControlTableModel");

    public XPL2StormControlTableModel(XPL2ModuleModel xPL2ModuleModel, XPL2LineModel[] xPL2LineModelArray) {
        this.eqpmtModel = xPL2ModuleModel;
        this.refreshMyLines(xPL2LineModelArray);
    }

    public void refreshMyLines(XPL2LineModel[] xPL2LineModelArray) {
        if (this.lineModels != null) {
            this.unRegisterWithLineModels();
        }
        this.lineModels = xPL2LineModelArray;
        this.numLines = this.lineModels.length;
        this.stormControlInfo = new sStormControlInfo[this.numLines];
        this.numLines = this.lineModels.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        this.registerWithLineModels();
        this.fireTableDataChanged();
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block11: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 5: {
                        return this.getStormControlBcastState(n);
                    }
                    case 3: {
                        return this.getStormControlMcastState(n);
                    }
                    case 1: {
                        return this.getStormControlDLFState(n);
                    }
                    case 6: {
                        return this.getStormControlBcastThreshold(n);
                    }
                    case 4: {
                        return this.getStormControlMcastThreshold(n);
                    }
                    case 2: {
                        return this.getStormControlDLFThreshold(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block11;
                db.println("Error in getValueAt in XPL2StormControlTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                return;
            }
            case 5: {
                this.stormControlInfo[n].bcast.status = (Boolean)object;
                break;
            }
            case 3: {
                this.stormControlInfo[n].mcast.status = (Boolean)object;
                break;
            }
            case 1: {
                this.stormControlInfo[n].dlfbc.status = (Boolean)object;
                break;
            }
            case 6: {
                try {
                    int n3;
                    this.stormControlInfo[n].bcast.threshold = n3 = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 4: {
                try {
                    int n4;
                    this.stormControlInfo[n].mcast.threshold = n4 = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 2: {
                try {
                    int n5;
                    this.stormControlInfo[n].dlfbc.threshold = n5 = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            default: {
                return;
            }
        }
        if (!bl) {
            this.isDirty[n][n2] = true;
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    private String getLineNumber(int n) {
        try {
            IPortModel iPortModel = this.lineModels[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        catch (Exception exception) {
            if (XPL2StormControlTableModel.db.on) {
                KDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private sStormControlInfo getStormControlInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType {
        sStormControlInfo sStormControlInfo2 = this.lineModels[n].getLayer2LineModel().getStromControlInfo();
        return sStormControlInfo2;
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][1] || this.isDirty[n][2] || this.isDirty[n][5] || this.isDirty[n][6] || this.isDirty[n][3] || this.isDirty[n][4]) {
            this.lineModels[n].getLayer2LineModel().setStormControlInfo(this.stormControlInfo[n]);
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshFromModel() throws Exception {
        this.refreshMyLines(this.eqpmtModel.getXPL2EtherLines());
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) throws Exception {
        this.stormControlInfo[n] = this.getStormControlInfoFromModel(n);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public Boolean getStormControlDLFState(int n) {
        return this.stormControlInfo[n].dlfbc.status;
    }

    public Boolean getStormControlMcastState(int n) {
        return this.stormControlInfo[n].mcast.status;
    }

    public Boolean getStormControlBcastState(int n) {
        return this.stormControlInfo[n].bcast.status;
    }

    public Integer getStormControlDLFThreshold(int n) {
        return this.stormControlInfo[n].dlfbc.threshold;
    }

    public Integer getStormControlMcastThreshold(int n) {
        return this.stormControlInfo[n].mcast.threshold;
    }

    public Integer getStormControlBcastThreshold(int n) {
        return this.stormControlInfo[n].bcast.threshold;
    }

    private void registerWithLineModels() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }
}

