/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2SvlanTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2SvlanProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected XPL2SvlanTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2Layer2LineModel[] nniLineModels = null;
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("XPL2SvlanProvPane");

    public XPL2SvlanProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.nniLineModels = xPL2ModuleModel.getXPL2NNILinesAndChGrps();
        this.eqpmtModel = xPL2ModuleModel;
        if (this.eqpmtModel == null || this.nniLineModels == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + this.eqpmtModel + " nniLineModels=" + this.nniLineModels);
            }
            return;
        }
        this.dataModel = new XPL2SvlanTableModel(this.eqpmtModel, this.nniLineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.nniLineModels = this.eqpmtModel.getXPL2NNILinesAndChGrps();
        this.dataModel.dispose();
        this.dataModel = new XPL2SvlanTableModel(this.eqpmtModel, this.nniLineModels);
        this.dataModel.addTableModelListener(this);
        this.table.setModel(this.dataModel);
        this.dataModel.refreshFromModel();
        this.customizedProvPane();
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
    }

    @Override
    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.unRegisterWithModel();
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        for (int i = 0; i < this.nniLineModels.length; ++i) {
            this.getObsMgr().addObservable((Observable)((Object)this.nniLineModels[i]));
        }
    }

    protected void unRegisterWithModel() {
        super.registerWithModel();
        for (int i = 0; i < this.nniLineModels.length; ++i) {
            this.getObsMgr().removeObservable((Observable)((Object)this.nniLineModels[i]));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(i));
            tableColumn.setPreferredWidth(120);
        }
        this.table.sizeColumnsToFit(-1);
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (this.checkDiplayWarningMsgAndIfToContinue()) {
            for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
                this.dataModel.applyToModel(i);
            }
            this.resetDirty();
        }
    }

    public boolean checkDiplayWarningMsgAndIfToContinue() {
        block3: {
            try {
                if (this.dataModel.isSVLANRemoved()) {
                    return ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_SVLAN_SETTING, "Warning Message", "SVLAN");
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block3;
                db.println("NoSuchInterface caught in checkDiplayWarningMsgAndIfToContinue() " + (Object)((Object)noSuchInterface));
            }
        }
        return true;
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2SvlanProvPane;
    }
}

