/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.AbstractSimpleMetaData;
import cerent.cms.xml.TypeInfo;
import cerent.util.KDebug;

public abstract class AbstractMetaData
extends AbstractSimpleMetaData {
    protected TypeInfo[] getTypeInfo = null;
    protected TypeInfo[] setTypeInfo = null;
    protected TypeInfo returnTypeInfo = null;
    protected boolean isAction = false;
    public static final String RETURN = "Return";
    private static final String RETURN_HELPER = ".ReturnHelper";
    private static final String RETURN_TYPE = ".ReturnType";
    private static final String MAP_VALUE_TYPE = ".ReturnValueType";
    private static final String IS_ACTION = ".IsAction";
    private static final String ENUM = "Enum";
    private static final String STRUCT = "Struct";
    private static final String GENERIC = "Generic";
    private static final String MAP = "Map";
    public static final String NO_ARGUMENTS = "NO_ARGUMENTS";
    public static final String NO_PERMISSION = "NO_PERMISSION";

    protected AbstractMetaData() {
    }

    public abstract boolean isForPublicMethod();

    public boolean setValue(String string, String string2) {
        boolean bl = true;
        if (string.endsWith(RETURN_HELPER)) {
            this.setReturnHelper(string2);
        } else if (string.endsWith(RETURN_TYPE)) {
            this.setReturnType(string2);
        } else if (string.endsWith(MAP_VALUE_TYPE)) {
            this.setMapValueType(string2);
        } else if (string.endsWith(IS_ACTION)) {
            boolean bl2 = new Boolean(string2.trim());
            this.setIsAction(bl2);
        } else {
            bl = false;
        }
        return bl;
    }

    public void validate() throws CTCUserException {
        if (this.returnTypeInfo.getHelper().length() == 0) {
            throw new CTCUserException("No return type for meta data");
        }
        if (this.returnTypeInfo.getHelper().equals(ENUM) && this.returnTypeInfo.getType().length() == 0) {
            throw new CTCUserException("No ReturnType defined for ReturnHelper=Enum");
        }
        if (this.returnTypeInfo.getHelper().equals(STRUCT) && this.returnTypeInfo.getType().length() == 0) {
            throw new CTCUserException("No ReturnType defined for ReturnHelper=Struct");
        }
        if (this.returnTypeInfo.getHelper().startsWith(GENERIC) && this.returnTypeInfo.getType().length() == 0) {
            throw new CTCUserException("No ReturnType defined for generic return type");
        }
        if (this.returnTypeInfo.getHelper().startsWith(MAP) && (this.returnTypeInfo.getMapKeyType().length() == 0 || this.returnTypeInfo.getMapValueType().length() == 0)) {
            throw new CTCUserException("Either no ReturnType or ReturnValueType defined for Map return type");
        }
    }

    @Override
    public String getReturnHelper() {
        return this.returnTypeInfo.getHelper();
    }

    public void setReturnHelper(String string) {
        this.returnTypeInfo.setHelper(string);
    }

    @Override
    public String getReturnType() {
        return this.returnTypeInfo.getType();
    }

    public void setReturnType(String string) {
        this.returnTypeInfo.setType(string);
    }

    @Override
    public String getMapValueType() {
        return this.returnTypeInfo.getMapValueType();
    }

    public void setMapValueType(String string) {
        this.returnTypeInfo.setMapValueType(string);
    }

    @Override
    public String getMapKeyType() {
        return this.returnTypeInfo.getMapKeyType();
    }

    @Override
    public boolean getIsAction() {
        return this.isAction;
    }

    public void setIsAction(boolean bl) {
        this.isAction = bl;
    }

    @Override
    public void print(KDebug kDebug) {
        super.print(kDebug);
        kDebug.println("ReturnHelper = \"" + this.returnTypeInfo.getHelper() + "\"" + " ;");
        kDebug.println("IsAction = \"" + this.isAction + "\"" + " ;");
    }
}

