/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.ModelAttributes;
import cerent.cms.xml.MetaDataRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MetaDataValidator {
    private HashMap map = null;
    private String metaDataFileName = "";
    private String netype = "";
    private static final String INFO_MSG = "[INFO ]: ";
    private static final String WARNING_MSG = "[WARNING]: ";
    private static final String ERROR_MSG = "[ERROR]: ";
    private static final int REQ_NUM_EQUAL_TOKENS = 2;
    private static final int REQ_NUM_DOLLAR_SIGN_TOKENS = 2;
    private static final String nl = System.getProperty("line.separator");
    private static final String nlTab = nl + '\t';
    private URL metaDataUrl = null;
    private boolean isValid = false;
    private static boolean verboseMode = false;
    private static MetaDataValidator validator = null;

    protected MetaDataValidator(String string, String string2, boolean bl) {
        verboseMode = bl;
        this.netype = string;
        this.metaDataUrl = this.createMetaDataUrl(string2);
        validator = this;
        this.map = new HashMap();
    }

    private URL createMetaDataUrl(String string) {
        File file = new File(string);
        if (file.isFile()) {
            try {
                this.metaDataUrl = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        } else {
            this.metaDataUrl = MetaDataRepository.getMetaDataUrl();
            return this.metaDataUrl;
        }
        return this.metaDataUrl;
    }

    public boolean validateMetaData() {
        return validator.isValidPropertyFile();
    }

    protected static void infoPrintLine(String string) {
        if (verboseMode) {
            System.out.println(INFO_MSG + string);
        }
    }

    protected static void infoPrintLine(String string, int n) {
        if (verboseMode) {
            System.out.println("[INFO ]: Line " + n + " - " + string);
        }
    }

    protected static void errorPrintLine(String string) {
        System.out.println(ERROR_MSG + string);
    }

    protected static void errorPrintLine(String string, int n) {
        System.out.println("[ERROR]: Line " + n + " - " + string);
    }

    protected static void warningPrintLine(String string) {
        System.out.println(WARNING_MSG + string);
    }

    protected static void warningPrintLine(String string, int n) {
        System.out.println("[WARNING]: Line " + n + " - " + string);
    }

    private int getNumberOfOccurrencesInString(String string, String string2) {
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            ++n;
            n2 = string.indexOf(string2, n2 + 1);
        }
        return n;
    }

    private void validateCorrectNumberOfEquals(String string, int n) throws CTCUserException {
        String string2 = "=";
        int n2 = this.getNumberOfOccurrencesInString(string, string2);
        if (n2 > 1) {
            this.isValid = false;
            throw new CTCUserException("Only 1 equal sign allowed. Found " + n2 + nlTab + string);
        }
        if (n2 <= 0) {
            this.isValid = false;
            throw new CTCUserException("One equal sign required. Found " + n2 + nlTab + string);
        }
    }

    private void validateBeginningOfLine(String string, int n) throws CTCUserException {
        char c;
        if (string.length() > 0 && !Character.isLetter(c = string.charAt(0))) {
            this.isValid = false;
            throw new CTCUserException("Line must begin with an alpha character " + nlTab + string);
        }
    }

    private boolean isBlankOrCommentLine(String string, int n) {
        if (string.startsWith("#") || string.length() == 0) {
            MetaDataValidator.infoPrintLine("Skipping Comment or Empty Line", n);
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isSpaceChar(c) || Character.isISOControl(c)) continue;
            return false;
        }
        MetaDataValidator.infoPrintLine("Empty Line With Only Spaces Found", n);
        return true;
    }

    private void validateCorrectNumberOfDollarSigns(String string, int n) throws CTCUserException {
        String string2 = "$";
        int n2 = this.getNumberOfOccurrencesInString(string, string2);
        if (n2 > 1) {
            this.isValid = true;
            MetaDataValidator.warningPrintLine("Possible Error - More than 1 " + string2 + " exists " + nlTab + string, n);
        } else if (n2 <= 0) {
            this.isValid = false;
            throw new CTCUserException("One dollar sign required. Found " + n2 + " at line " + n + nlTab + string);
        }
    }

    private void validateLineTokens(String string, int n, String string2, int n2) throws CTCUserException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n3 = stringTokenizer.countTokens();
        if (n3 != n2) {
            this.isValid = false;
            throw new CTCUserException("Entries required on both sides of " + string2 + nlTab + string);
        }
    }

    private void validateLineEqualTokens(String string, int n) throws CTCUserException {
        String string2 = "=";
        try {
            int n2 = string.indexOf("$");
            String string3 = string.substring(++n2);
            MetaDataValidator.infoPrintLine("Substring line = " + string3, n);
            this.validateLineTokens(string3, n, string2, 2);
        }
        catch (CTCUserException cTCUserException) {
            this.isValid = false;
            throw new CTCUserException("Entries required on both sides of " + string2 + nlTab + string);
        }
    }

    private void validateLineDollarTokens(String string, int n) throws CTCUserException {
        String string2 = "$";
        this.validateLineTokens(string, n, string2, 2);
    }

    private void validateNoDuplicateLinesExist(String string, int n) throws CTCUserException {
        boolean bl = false;
        Integer n2 = new Integer(n);
        bl = this.map.containsKey(string);
        if (bl) {
            this.isValid = false;
            int n3 = (Integer)this.map.get(string);
            throw new CTCUserException("Duplicate lines found at " + n2 + " and " + n3 + nlTab + string);
        }
        this.map.put(string, n2);
    }

    private void validateClassNameIsValid(String string, int n) throws CTCUserException {
        Class<?> clazz;
        string = string.substring(0, string.lastIndexOf(61));
        string = string.substring(0, string.lastIndexOf(46));
        int n2 = string.indexOf(36);
        int n3 = string.lastIndexOf(36);
        int n4 = string.indexOf(46, n3);
        String string2 = string.substring(0, n2);
        String string3 = string;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CTCUserException("Class " + string2 + " Does not exist - Check path and Classname");
        }
        ModelAttributes modelAttributes = new ModelAttributes(clazz);
        String string4 = ModelAttributes.getNonFQName(string);
        boolean bl = modelAttributes.hasAttributeName(string4);
        if (!bl) {
            throw new CTCUserException("Class " + string3 + " Not Found - Check path and Classname");
        }
    }

    private String basename(String string) {
        String string2 = string;
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidPropertyFile() {
        this.isValid = false;
        String string = "";
        BufferedReader bufferedReader = null;
        String string2 = "";
        try {
            this.metaDataFileName = this.metaDataUrl.getFile();
            bufferedReader = new BufferedReader(new InputStreamReader(this.metaDataUrl.openStream()));
            System.out.println("  NCV/CV Validation using " + this.basename(this.metaDataFileName) + " for " + this.netype + " Platform");
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                MetaDataValidator.errorPrintLine("Unable to Read Line from " + string);
            }
            int n = 0;
            this.isValid = true;
            while (string2 != null) {
                try {
                    if (!this.isBlankOrCommentLine(string2, ++n)) {
                        this.validateCorrectNumberOfEquals(string2, n);
                        this.validateCorrectNumberOfDollarSigns(string2, n);
                        this.validateBeginningOfLine(string2, n);
                        this.validateLineDollarTokens(string2, n);
                        this.validateLineEqualTokens(string2, n);
                        this.validateNoDuplicateLinesExist(string2, n);
                        this.validateClassNameIsValid(string2, n);
                    }
                }
                catch (CTCUserException cTCUserException) {
                    this.isValid = false;
                    MetaDataValidator.errorPrintLine(cTCUserException.getMessage(), n);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            MetaDataValidator.errorPrintLine(exception.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                bufferedReader = null;
            }
        }
        return this.isValid;
    }

    public static void usage() {
        System.out.println("Usage: MetaDataValidator [-v]  [?]");
        System.out.println("       -?  Display Usage");
        System.out.println("       -v  Verbose Mode");
        System.out.println("       -mMetaDataFileLocation");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            String string = "";
            String string2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.startsWith("-?") || string3.startsWith("?")) {
                    MetaDataValidator.usage();
                    continue;
                }
                if (string3.startsWith("-v") || string3.startsWith("-V")) {
                    verboseMode = true;
                    continue;
                }
                if (string3.startsWith("-m") || string3.startsWith("-M")) {
                    string = string3.substring(2);
                    continue;
                }
                if (string3.startsWith("-n") || string3.startsWith("-N")) {
                    string2 = string3.substring(2);
                    continue;
                }
                if (!string3.startsWith("-")) continue;
                MetaDataValidator.usage();
            }
            MetaDataValidator metaDataValidator = new MetaDataValidator(string2, string, verboseMode);
            bl = metaDataValidator.validateMetaData();
        }
        catch (Exception exception) {
            MetaDataValidator.errorPrintLine(exception.getMessage());
            exception.printStackTrace(System.out);
        }
        int n = bl ? 0 : 1;
        System.exit(n);
    }
}

