/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.XmlDocumentState;
import cerent.cms.xml.XmlNodeFactory;
import cerent.util.SDebug;
import cerent.util.xml.DOMUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom3.UserDataHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OutOfBandUtil {
    private static final String OOB_TAG = "OutOfBand";
    static final String ELE_VALET = "Elements";
    static final String TEXT_VALET = "Texts";
    static final String CDATA_VALET = "CDATAs";
    static final String CMMT_VALET = "Comments";
    private static final String PARKING_LOT = "ParkingLot";
    private static final String ATTR_FAULTS_TAG = "AttributeFaults";
    private static final String ATTR_FAULT_TAG = "AttributeFault";
    private static final String NAME_ATTR = "name";
    private static SDebug db = new SDebug("OutOfBandUtil");

    private OutOfBandUtil() {
    }

    public static Element getOOB(Node node, boolean bl) {
        Element element = OutOfBandUtil.getOOB(node);
        if (bl && element == null) {
            element = OutOfBandUtil.addOOB(node);
        }
        return element;
    }

    public static Element getOOB(Node node) {
        Element element = null;
        Document document = DOMUtil.getOwnerDocument((Node)node);
        Element element2 = document.getDocumentElement();
        NodeList nodeList = element2.getElementsByTagName(OOB_TAG);
        int n = nodeList.getLength();
        if (n == 1) {
            element = (Element)nodeList.item(0);
        } else if (n > 1) {
            throw new IllegalStateException("Can't have more than 1 OOB element");
        }
        return element;
    }

    public static boolean hasParkingLot(Node node) {
        boolean bl = false;
        if (OutOfBandUtil.getValets(DOMUtil.getOwnerDocument((Node)node)) != null) {
            bl = true;
        }
        return bl;
    }

    public static XmlDocumentState getValets(Document document) {
        Object object = null;
        try {
            object = ((NodeImpl)document).getUserData(PARKING_LOT);
            XmlDocumentState xmlDocumentState = (XmlDocumentState)object;
            return xmlDocumentState;
        }
        catch (ClassCastException classCastException) {
            if (db.on() && object != null) {
                db.println("getValets():  ClassCastException - Most likely an attempt was made to reuse UserData from a different ELE class loader.  Current loader: " + ((Object)((Object)db)).getClass().getClassLoader().toString() + "  UserData from loader: " + object.getClass().getClassLoader().toString());
            }
            OutOfBandUtil.setValets(document, null);
            return null;
        }
    }

    public static void makeParkingLot(Element element) {
        Element element2 = OutOfBandUtil.getOOB(element, true);
        XmlDocumentState xmlDocumentState = OutOfBandUtil.getValets(element, element2);
        Element element3 = OutOfBandUtil.getAttrFaultsFromOOB(element2);
        if (element3 != null) {
            OutOfBandUtil.parkNodes(element3, xmlDocumentState, false);
            element2.removeChild(element3);
            xmlDocumentState.getElementValet().appendChild(element3);
        }
        Iterator iterator = DOMUtil.getRootChildren((Document)element.getOwnerDocument());
        Node node = null;
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node != null) {
                element.removeChild(node);
                xmlDocumentState.getValetByNodeType(node.getNodeType()).appendChild(node);
                node = null;
            }
            if (node2.getNodeName().equals(element2.getNodeName())) continue;
            OutOfBandUtil.parkNodes(node2, xmlDocumentState, true);
            node = node2;
        }
        if (node != null) {
            element.removeChild(node);
            xmlDocumentState.getValetByNodeType(node.getNodeType()).appendChild(node);
        }
    }

    private static void parkNodes(Node node, XmlDocumentState xmlDocumentState, boolean bl) {
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = n2 - 1; n >= 0; --n) {
            node2 = nodeList.item(n);
            OutOfBandUtil.parkNodes(node2, xmlDocumentState, false);
        }
        if (!bl) {
            n = node.getNodeType();
            node2 = xmlDocumentState.getValetByNodeType((short)n);
            if (n == 3 || n == 4 || n == 8) {
                Node node3 = node.getParentNode();
                if (node3 != null) {
                    node3.removeChild(node);
                }
                node2.appendChild(node);
            } else if (n != 1) {
                throw new IllegalStateException("Node of unknown type found while creating parking lot");
            }
        }
    }

    private static XmlDocumentState getValets(Node node, Node node2) {
        Document document = DOMUtil.getOwnerDocument((Node)node);
        XmlDocumentState xmlDocumentState = OutOfBandUtil.getValets(document);
        if (xmlDocumentState == null) {
            Element element = OutOfBandUtil.createParkingLotNode(document, node2);
            Element element2 = OutOfBandUtil.createElementValet(document, element);
            Element element3 = OutOfBandUtil.createTextValet(document, element);
            Element element4 = OutOfBandUtil.createCdataValet(document, element);
            Element element5 = OutOfBandUtil.createCommentValet(document, element);
            xmlDocumentState = new XmlDocumentState(element, element2, element3, element4, element5);
            OutOfBandUtil.setValets(document, xmlDocumentState);
        }
        return xmlDocumentState;
    }

    static void setValets(Document document, XmlDocumentState xmlDocumentState) {
        NodeImpl nodeImpl = (NodeImpl)document;
        nodeImpl.setUserData(PARKING_LOT, (Object)xmlDocumentState, (UserDataHandler)null);
    }

    public static void reconstructParkingLot(Document document) {
        Element element;
        XmlDocumentState xmlDocumentState = OutOfBandUtil.getValets(document);
        if (xmlDocumentState == null && (element = OutOfBandUtil.getOOB(document.getDocumentElement())) != null) {
            for (Node node = element.getLastChild(); node != null; node = node.getPreviousSibling()) {
                if (!node.getNodeName().equals(PARKING_LOT)) continue;
                xmlDocumentState = new XmlDocumentState();
                xmlDocumentState.setParkingLot(node);
                xmlDocumentState.findValets();
                break;
            }
            if (xmlDocumentState == null) {
                OutOfBandUtil.getValets(document, element);
            } else {
                OutOfBandUtil.validateValets(xmlDocumentState, document, element);
                OutOfBandUtil.setValets(document, xmlDocumentState);
            }
        }
    }

    private static void validateValets(XmlDocumentState xmlDocumentState, Document document, Node node) {
        if (!xmlDocumentState.validate()) {
            Element element;
            Element element2 = (Element)xmlDocumentState.getParkingLot();
            if (element2 == null) {
                element2 = OutOfBandUtil.createParkingLotNode(document, node);
                xmlDocumentState.setParkingLot(element2);
            }
            if (xmlDocumentState.getElementValet() == null) {
                element = OutOfBandUtil.createElementValet(document, element2);
                xmlDocumentState.setElementValet(element);
            }
            if (xmlDocumentState.getTextValet() == null) {
                element = OutOfBandUtil.createTextValet(document, element2);
                xmlDocumentState.setTextValet(element);
            }
            if (xmlDocumentState.getCdataValet() == null) {
                element = OutOfBandUtil.createCdataValet(document, element2);
                xmlDocumentState.setCdataValet(element);
            }
            if (xmlDocumentState.getCommentValet() == null) {
                element = OutOfBandUtil.createCommentValet(document, element2);
                xmlDocumentState.setCommentValet(element);
            }
        }
    }

    private static Element createParkingLotNode(Document document, Node node) {
        return OutOfBandUtil.createValet(document, node, PARKING_LOT);
    }

    private static Element createElementValet(Document document, Node node) {
        return OutOfBandUtil.createValet(document, node, ELE_VALET);
    }

    private static Element createTextValet(Document document, Node node) {
        return OutOfBandUtil.createValet(document, node, TEXT_VALET);
    }

    private static Element createCdataValet(Document document, Node node) {
        return OutOfBandUtil.createValet(document, node, CDATA_VALET);
    }

    private static Element createCommentValet(Document document, Node node) {
        return OutOfBandUtil.createValet(document, node, CMMT_VALET);
    }

    private static Element createValet(Document document, Node node, String string) {
        Element element = null;
        element = document.createElement(string);
        node.appendChild(element);
        return element;
    }

    public static Node getNodeByType(short s, Document document) {
        return OutOfBandUtil.getNodeByType(s, OutOfBandUtil.getValets(document));
    }

    public static Node getNodeByType(short s, XmlDocumentState xmlDocumentState) {
        Node node;
        Node node2 = null;
        if (xmlDocumentState != null && (node = xmlDocumentState.getValetByNodeType(s)) != null) {
            if (s == 1) {
                node2 = OutOfBandUtil.getElementNode(node);
                if (node2 != null) {
                    if (node2.equals(node)) {
                        node2 = null;
                    } else if (node2.getNodeType() == 1) {
                        Node node3 = node2.getParentNode();
                        node3.removeChild(node2);
                        DOMUtil.removeAttributeNodes((Element)((Element)node2));
                    }
                }
            } else {
                node2 = node.getLastChild();
                if (node2 != null) {
                    node.removeChild(node2);
                }
            }
        }
        if (node2 != null && node2.getNodeType() != s) {
            OutOfBandUtil.parkNodes(node2, xmlDocumentState, false);
            return OutOfBandUtil.getNodeByType(s, xmlDocumentState);
        }
        return node2;
    }

    private static Node getElementNode(Node node) {
        if (node == null) {
            return node;
        }
        Node node2 = node;
        for (Node node3 = node.getLastChild(); node3 != null; node3 = node3.getLastChild()) {
            node2 = node3;
        }
        return node2;
    }

    private static Element addOOB(Node node) {
        Document document = DOMUtil.getOwnerDocument((Node)node);
        Element element = document.getDocumentElement();
        Element element2 = document.createElement(OOB_TAG);
        element.appendChild(element2);
        return element2;
    }

    public static Element removeOOB(Node node) {
        Element element = OutOfBandUtil.getOOB(node);
        if (element != null) {
            Document document = DOMUtil.getOwnerDocument((Node)node);
            ((NodeImpl)document).setUserData(PARKING_LOT, null, (UserDataHandler)null);
            Element element2 = document.getDocumentElement();
            element2.removeChild(element);
        }
        return element;
    }

    public static Element getAttrFaults(Node node) {
        Element element = OutOfBandUtil.getOOB(node);
        return OutOfBandUtil.getAttrFaultsFromOOB(element);
    }

    private static Element getAttrFaultsFromOOB(Element element) {
        Element element2 = null;
        if (element != null) {
            Iterator iterator = DOMUtil.getChildElementsIterator((Node)element);
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!node.getNodeName().equals(ATTR_FAULTS_TAG)) continue;
                element2 = (Element)node;
                break;
            }
        }
        return element2;
    }

    private static Element addAttrFaults(Node node) {
        Element element = OutOfBandUtil.getAttrFaults(node);
        if (element == null) {
            Document document = DOMUtil.getOwnerDocument((Node)node);
            Element element2 = OutOfBandUtil.getOOB(node, true);
            element = XmlNodeFactory.makeElement(element2, ATTR_FAULTS_TAG);
            XmlDocumentState xmlDocumentState = OutOfBandUtil.getValets(document);
            if (xmlDocumentState != null) {
                element2.insertBefore(element, xmlDocumentState.getParkingLot());
            } else {
                element2.appendChild(element);
            }
        }
        return element;
    }

    public static Element addAttributeFault(Node node, String string, Node node2) {
        Element element = OutOfBandUtil.addAttrFaults(node);
        Element element2 = XmlNodeFactory.makeElement(element, ATTR_FAULT_TAG);
        Document document = DOMUtil.getOwnerDocument((Node)node);
        element.appendChild(element2);
        element2.setAttribute(NAME_ATTR, string);
        if (node2 != null) {
            if (node2 instanceof Document) {
                node2 = ((Document)node2).getDocumentElement();
            }
            Document document2 = DOMUtil.getOwnerDocument((Node)node2);
            Node node3 = node2;
            if (document != document2) {
                node3 = document.importNode(node2, true);
            }
            element2.appendChild(node3);
        }
        return element2;
    }

    public static Map getAttributeFaults(Node node) {
        HashMap<String, Node> hashMap = null;
        Element element = OutOfBandUtil.getAttrFaults(node);
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            hashMap = new HashMap<String, Node>(n);
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute(NAME_ATTR);
                NodeList nodeList2 = element2.getChildNodes();
                int n2 = nodeList2.getLength();
                Node node2 = null;
                if (n2 == 1) {
                    node2 = nodeList2.item(0);
                }
                if (node2 == null) continue;
                hashMap.put(string, node2);
            }
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        Document document = DOMUtil.createDocument();
        Element element = document.createElement("stuff");
        document.appendChild(element);
        element.appendChild(document.createElement("child1"));
        element.appendChild(document.createElement("child2"));
        Document document2 = XmlNodeFactory.makeFaultDocument("-1234", "getXXX", new Exception("error 1"));
        Document document3 = XmlNodeFactory.makeFaultDocument("-5678", "getYYY", new Exception("error 2"));
        OutOfBandUtil.addAttributeFault(document, "a.b.c.d", document2);
        OutOfBandUtil.addAttributeFault(document, "w.x.y.z", document3);
        String string = "???";
        try {
            string = DOMUtil.nodeToString((Node)document, (int)2, (boolean)false);
        }
        catch (CTCUserException cTCUserException) {
            SDebug.printStackTrace((Throwable)cTCUserException);
        }
        System.out.println(string);
    }
}

