/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.MetaDataRepository;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.XmlAdapter;
import cerent.cms.xml.helper.SchemaHelper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

public class SchemaGenerator {
    private static String schemaFile = "./schema/CTCSchema.xsd";

    private SchemaGenerator() {
    }

    public static String getSchemaFile() {
        return schemaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeFile(String string) {
        String string2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            string2 = schemaFile;
            fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            System.out.println("\nSchema file located at " + schemaFile);
        }
        catch (IOException iOException) {
            System.out.println("ERROR: SchemaGenerator: Unable to write to file:");
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println("ERROR: NodeAdapter: Unable to close file:");
            }
        }
    }

    public static void main(String[] stringArray, Object object) {
        SchemaGenerator.main(stringArray);
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            schemaFile = stringArray.length > 0 ? stringArray[0] : ((object = XmlAdapter.getSchemaUrl()) == null ? null : ((URL)object).getFile());
            object = MetaDataRepository.getInstance(false);
            SchemaGenerator.createSchema((MetaDataRepository)object);
            SchemaGenerator.writeFile(SchemaTagFactory.createOpenSchemaTag() + SchemaTagFactory.createFaultSchema() + SchemaTagFactory.createIndexSchema() + SchemaHelper.finishAndGetModelSchema() + SchemaTagFactory.createComment("Globals used by models") + SchemaHelper.getSchemaGlobals() + SchemaTagFactory.createCloseSchemaTag());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace(System.out);
            System.out.println("Schema NOT generated.");
        }
    }

    private static void createSchema(MetaDataRepository metaDataRepository) {
        try {
            String[] stringArray = metaDataRepository.getFullyQualifiedModelClassnames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.contains("com.cisco.ctc") && string.contains("m6")) {
                    string = "com.cisco.ctcutsX.model.PlatformNodeModel";
                } else if (string.contains("com.cisco.ctc") && string.contains("m6sdh")) {
                    string = "com.cisco.ctcutsXsdh.model.PlatformNodeModel";
                } else if (string.contains("com.cisco.ctc") && string.contains("m2")) {
                    string = "com.cisco.ctcutsX.model.PlatformNodeModel";
                } else if (string.contains("com.cisco.ctc") && string.contains("m2sdh")) {
                    string = "com.cisco.ctcutsXsdh.model.PlatformNodeModel";
                }
                try {
                    Class[] classArray = ReflectionUtil.superclasses(string);
                    if (classArray.length == 1) {
                        SchemaHelper.addModel(string);
                        continue;
                    }
                    String[] stringArray2 = new String[classArray.length - 1];
                    for (int j = 0; j < stringArray2.length; ++j) {
                        stringArray2[j] = classArray[j + 1].getName();
                    }
                    SchemaHelper.addModel(string, stringArray2);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (CTCUserException cTCUserException) {
            System.out.println("\nUnable to retrieve list of Models.");
            System.out.println("Schema generation STOPPING.  Schema incomplete.");
            cTCUserException.printStackTrace();
        }
    }
}

