/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.UserValue;
import cerent.cms.xml.ConverterFactory;
import cerent.cms.xml.IMethodMetaData;
import cerent.cms.xml.MetaData;
import cerent.cms.xml.MethodState;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.XmlHelperFactory;
import cerent.cms.xml.XmlTagFactory;
import cerent.util.EnumStrings;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.StringIndex;
import cerent.util.UTF8Utils;
import cerent.util.xml.DOMUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Helper {
    protected static boolean doHexDump = Preferences.instance().getBoolean("ctc", "xml.hexdebugdump", true);
    public static final String RESULT = "";
    public static final String NO_ARGUMENTS = "NO_ARGUMENTS";
    public static final String NO_PERMISSION = "NO_PERMISSION";
    public static final String ARRAY_TAG = "Array";
    public static final String COLLECTION_TAG = "Collection";
    public static final String MAP_TAG = "Map";
    public static final String ELEMENT_TAG = "Element";
    public static final String NOT_IMPLEMENTED = "SORRY! NOT IMPLEMENTED YET!!";
    public static final String USER_EXCEPTION = "USER_EXCEPTION";
    public static final String NO_PERMISSION_EXCEPTION = "NO_PERMISSION_EXCEPTION";
    public static final String UNKNOWN_EXCEPTION = "UNKNOWN_EXCEPTION";
    public static final String METADATA_NOTFOUND_EXCEPTION = "METADATA_NOTFOUND_EXCEPTION";
    public static final String NODETOOBJECT = "nodeToObject";
    public static final String OBJECTTOXML = "objectToXml";
    public static final ConverterFactory converter = ConverterFactory.getInstance();
    public static final Debug db = new Debug("Helper");
    public static final Debug dba = new Debug("HelperApi");

    public static Node toXml(MethodState methodState, Node node, String string, IMethodMetaData iMethodMetaData, Node node2) throws CTCUserException {
        Object object;
        String[] stringArray;
        if (methodState == null) {
            throw new IllegalArgumentException("Helper.toXml methodState arg cannot be null");
        }
        Method method = methodState.getMethod();
        if (db.on()) {
            db.println("public method toXml(cmd,tag,metadata,xml) called on " + methodState);
        }
        if ((stringArray = methodState.getArgNames()) == null) {
            stringArray = DOMUtil.getChildNodeTags((Node)node);
        }
        StringIndex[] stringIndexArray = new StringIndex[stringArray.length];
        iMethodMetaData.doesMatchByArgNames(stringArray, stringIndexArray);
        Node node3 = null;
        Object object2 = null;
        Object[] objectArray = null;
        if (node != null && iMethodMetaData.getArgNames().length > 0 && iMethodMetaData.getArgNames()[0] != null && !iMethodMetaData.getArgNames()[0].equals(NO_ARGUMENTS)) {
            int n;
            objectArray = new Object[iMethodMetaData.getArgNames().length];
            object = DOMUtil.getChildElementsIterator((Node)node);
            List list = DOMUtil.copyToList((Iterator)object);
            for (n = 0; n < objectArray.length; ++n) {
                int n2 = stringIndexArray[n].index;
                Node node4 = (Node)list.get(n2);
                try {
                    objectArray[n] = Helper.nodeToObjectUsingReflection(node4, iMethodMetaData.getRealArgTypes()[n], iMethodMetaData.getArgHelpers()[n], methodState);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CTCUserException("[Helper] " + classNotFoundException.toString());
                }
            }
            if (db.on()) {
                db.print("With parameters ( ");
                for (n = 0; n < objectArray.length; ++n) {
                    db.print(" " + objectArray[n]);
                }
                db.println(" )");
            }
        }
        object2 = Helper.performMethodCall(methodState, objectArray);
        object = iMethodMetaData.getReturnHelper();
        if (object2 == null) {
            if (db.on()) {
                db.println("[Helper] Return Value of public method call is NULL on " + methodState);
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                object2 = RESULT;
                object = "String";
            }
        }
        try {
            node3 = Helper.objectToXmlUsingReflection(object2, method.getName(), (String)object, methodState.getInstance(), node2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CTCUserException("[Helper] " + classNotFoundException.toString());
        }
        return node3;
    }

    public static Node toXml(Object object, Node node, String string, MetaData metaData, Node node2) throws CTCUserException {
        if (db.on()) {
            db.println("toXml(node,tag,metaData) called on " + object.getClass().getName());
        }
        if (metaData.getGETArgNames()[0].equals(NO_PERMISSION)) {
            if (db.on()) {
                db.println("Cannot perform get on " + object.getClass().getName() + " Reason:" + NO_PERMISSION);
            }
            throw new CTCUserException("Cannot perform get on " + object.getClass().getName() + " Reason:" + NO_PERMISSION);
        }
        Node node3 = null;
        Object object2 = null;
        Object object3 = null;
        if (node != null && !metaData.getGETArgNames()[0].equals(NO_ARGUMENTS)) {
            int n;
            Object[] objectArray = new Object[metaData.getGETArgNames().length];
            for (n = 0; n < objectArray.length; ++n) {
                Node node4 = null;
                NodeList nodeList = ((Element)node).getElementsByTagName(metaData.getGETArgNames()[n]);
                if (nodeList.getLength() != 1) {
                    throw new CTCUserException("[Helper.java] One Element Expected! \nNumber of elements in tag <" + metaData.getGETArgNames()[n] + "> = " + nodeList.getLength());
                }
                node4 = nodeList.item(0);
                try {
                    objectArray[n] = Helper.nodeToObjectUsingReflection(node4, metaData.getGETRealArgTypes()[n], metaData.getGETArgHelpers()[n], object);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CTCUserException("[Helper] " + classNotFoundException.toString());
                }
            }
            if (db.on()) {
                db.print("With parameters ( ");
                for (n = 0; n < objectArray.length; ++n) {
                    db.print(" " + objectArray[n]);
                }
                db.println(" )");
            }
            object2 = objectArray.length == 1 ? objectArray[0] : objectArray;
        }
        if ((object3 = Helper.performGet(object, object2)) == null && db.on()) {
            db.println("[Helper] Return Value of get() is NULL on " + object.getClass().getName());
        }
        try {
            node3 = Helper.objectToXmlUsingReflection(object3, object.getClass().getName(), metaData.getReturnHelper(), object, node2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CTCUserException("[Helper] " + classNotFoundException.toString());
        }
        return node3;
    }

    public static Node fromXml(Object object, Node node, String string, MetaData metaData, Node node2) throws CTCUserException {
        if (db.on()) {
            db.println("fromXml(cmd,tag,metaData,xml) called on " + object.getClass().getName());
        }
        if (metaData.getSETArgNames()[0].equals(NO_PERMISSION)) {
            if (db.on()) {
                db.println("Cannot perform set on " + object.getClass().getName() + " Reason:" + NO_PERMISSION);
            }
            throw new CTCUserException("Cannot perform set on " + object.getClass().getName() + " Reason:" + NO_PERMISSION);
        }
        Node node3 = null;
        Object object2 = null;
        Object var7_7 = null;
        if (node != null && !metaData.getSETArgNames()[0].equals(NO_ARGUMENTS)) {
            int n;
            Object[] objectArray = new Object[metaData.getSETArgNames().length];
            for (n = 0; n < objectArray.length; ++n) {
                Node node4 = null;
                NodeList nodeList = ((Element)node).getElementsByTagName(metaData.getSETArgNames()[n]);
                if (nodeList.getLength() != 1) {
                    throw new CTCUserException("[Helper.java] One Element Expected! \nNumber of Elements by " + metaData.getSETArgNames()[n] + " = " + nodeList.getLength());
                }
                node4 = nodeList.item(0);
                if (node4 == null) {
                    throw new CTCUserException("Invalid XML");
                }
                try {
                    objectArray[n] = Helper.nodeToObjectUsingReflection(node4, metaData.getSETRealArgTypes()[n], metaData.getSETArgHelpers()[n], object);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CTCUserException("[Helper] " + classNotFoundException.toString());
                }
            }
            if (db.on()) {
                db.print("With parameters ( ");
                for (n = 0; n < objectArray.length; ++n) {
                    db.print(" " + objectArray[n]);
                }
                db.println(" )");
            }
            object2 = objectArray.length == 1 ? objectArray[0] : objectArray;
        }
        node3 = Helper.performSet(object, object2);
        return node3;
    }

    public static Node objectToXmlUsingReflection(Object object, String string, String string2, Object object2, Node node) throws ClassNotFoundException, CTCUserException {
        if (db.on()) {
            db.println("Creating objectToXmlUsingReflection for " + string);
        }
        Class clazz = XmlHelperFactory.getXmlHelperBasedOnClassName(string2);
        return Helper.objectToXmlUsingReflection(object, string, clazz, object2, node);
    }

    public static Node objectToXmlUsingReflection(Object object, String string, Class clazz, Object object2, Node node) throws ClassNotFoundException, CTCUserException {
        String string2;
        if (db.on()) {
            db.println("Creating objectToXmlUsingReflection for " + string);
        }
        if (db.doTiming()) {
            db.logThreadTiming("before type conv: " + object.getClass().getName());
        }
        if (object != null && converter.canConvert(object, 0)) {
            string2 = null;
            if (object2 != null) {
                string2 = Helper.performGetNode(object2);
            }
            object = converter.convert(object, (INodeModel)string2);
        }
        string2 = OBJECTTOXML;
        Object object3 = null;
        Object[] objectArray = new Object[]{object, string, node};
        Class[] classArray = new Class[]{Object.class, String.class, Node.class};
        try {
            Method method = clazz.getMethod(string2, classArray);
            method.setAccessible(true);
            if (db.doTiming()) {
                db.logThreadTiming("start resp encoding: " + object.getClass().getName());
            }
            object3 = method.invoke(null, objectArray);
            if (db.doTiming()) {
                db.logThreadTiming("stop resp encoding");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            db.print(exception.toString());
            throw new CTCUserException("[ERROR]Helper.java " + exception.toString(), (Throwable)exception);
        }
        return (Node)object3;
    }

    public static Object nodeToObjectUsingReflection(Node node, String string, String string2) throws ClassNotFoundException, CTCUserException {
        return Helper.nodeToObjectUsingReflection(node, string, string2, null);
    }

    public static Object nodeToObjectUsingReflection(Node node, String string, Object object) throws ClassNotFoundException, CTCUserException {
        Class clazz = ReflectionUtil.forName(string);
        Class clazz2 = XmlHelperFactory.lookupHelperClass(clazz);
        return Helper.nodeToObjectUsingReflection(node, string, clazz2.getName(), object);
    }

    public static Object nodeToObjectUsingReflection(Node node, String string, String string2, Object object) throws ClassNotFoundException, CTCUserException {
        Method method;
        if (db.on()) {
            db.println("Creating nodeToObjectUsingReflection for " + string);
        }
        boolean bl = converter.canConvert(string, 1);
        Class clazz = null;
        Class clazz2 = null;
        if (bl) {
            clazz = converter.getConvertClass(string, 1);
            string = clazz.getName();
            if (db.on()) {
                db.println("Creating for converted class of: " + string);
            }
        } else if (db.on()) {
            db.println("Error: Converter for class " + string + " Not Found!!");
        }
        clazz2 = XmlHelperFactory.getXmlHelperBasedOnClassName(string2);
        if (db.on()) {
            db.println(" using helperClass " + clazz2);
        }
        String string3 = NODETOOBJECT;
        Object object2 = null;
        Class[] classArray = new Class[]{Node.class, String.class, Object.class};
        Class[] classArray2 = new Class[]{Node.class, String.class};
        Object[] objectArray = new Object[]{node, string, object};
        Object[] objectArray2 = new Object[]{node, string};
        try {
            method = null;
            try {
                method = clazz2.getMethod(string3, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz2.getMethod(string3, classArray2);
                objectArray = objectArray2;
            }
            if (db.on()) {
                db.println("in nodeToObjectUsingReflection using conv method: " + method.getName());
            }
            method.setAccessible(true);
            if (db.doTiming()) {
                db.logThreadTiming("start response encode");
            }
            object2 = method.invoke(null, objectArray);
            if (db.doTiming()) {
                db.logThreadTiming("stop response encode");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            if (Helper.db.on) {
                db.print(exception.toString());
            }
            throw new CTCUserException("[ERROR]Helper.java " + exception.toString(), (Throwable)exception);
        }
        if (db.on()) {
            db.println("in nodeToObjectUsingReflection : returning " + object2 + " of type " + object2.getClass());
        }
        if (bl) {
            if (clazz.equals(object2) || converter.canConvert(object2, 1)) {
                method = null;
                if (object != null) {
                    method = Helper.performGetNode(object);
                }
                object2 = converter.convert(object2, (INodeModel)method);
            } else if (db.on()) {
                db.println("convert method needed for: " + object2);
            }
        }
        return object2;
    }

    public static Object performMethodCall(MethodState methodState, Object[] objectArray) throws CTCUserException {
        Method method = methodState.getMethod();
        if (method == null) {
            db.println("[ERROR] Unable to perform public method call ");
            db.println("[REASON] method is NULL");
            throw new CTCUserException("Method is NULL");
        }
        Class<?> clazz = method.getClass();
        Object object = methodState.getInstance();
        Object object2 = null;
        try {
            if (db.doDumpObj()) {
                db.dumpObj("public method " + clazz.getName() + "." + method.getName() + " invoke", objectArray);
            }
            if (db.doTiming()) {
                db.logThreadTiming("start public method call " + method.getName());
            }
            if (dba.on()) {
                int n = objectArray == null ? 0 : objectArray.length;
                dba.println("(" + method + ") num input args: " + n);
                for (int i = 0; i < n; ++i) {
                    String string;
                    String string2 = string = objectArray[i] == null ? RESULT : objectArray[i].toString();
                    if (doHexDump) {
                        string = UTF8Utils.toHexDump((String)string);
                    }
                    db.println("  arg # " + i + ": " + string);
                }
            }
            object2 = method.invoke(object, objectArray);
            if (dba.on()) {
                String string;
                dba.println("(" + method + ") return: ");
                String string3 = string = object2 == null ? RESULT : object2.toString();
                if (doHexDump) {
                    string = UTF8Utils.toHexDump((String)string);
                }
                db.println("  " + string);
            }
            if (db.doTiming()) {
                db.logThreadTiming("stop public method call");
            }
            if (db.doDumpObj()) {
                db.dumpObj("public method return", object2);
                db.newline();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException("error in calling public method " + methodState, invocationTargetException);
        }
        catch (Exception exception) {
            if (Helper.db.on) {
                db.println("[ERROR] Unable to call " + methodState);
            }
            if (Helper.db.on) {
                db.println("[REASON] " + exception.toString());
            }
            throw new CTCUserException(exception.toString(), (Throwable)exception);
        }
        return object2;
    }

    public static Object performGet(Object object, Object object2) throws CTCUserException {
        if (object == null) {
            db.println("[ERROR] Unable to perform get() ");
            db.println("[REASON] value is NULL");
            throw new CTCUserException("Value is NULL");
        }
        Object object3 = null;
        try {
            String string;
            if (db.doDumpObj()) {
                db.dumpObj(object.getClass().getName() + " get args", object2);
            }
            if (db.doTiming()) {
                int n;
                string = " ";
                if (object instanceof CachedValue && (n = ((CachedValue)object).getState()) != 2) {
                    string = " not CLEAN ";
                }
                db.logThreadTiming("start NCV/CV/UV attr get" + string + object.getClass().getName());
            }
            if (object instanceof NonCachedValue) {
                object3 = ((NonCachedValue)object).get(object2);
            } else if (object instanceof UserValue) {
                object3 = object2 == null ? ((UserValue)object).get() : ((UserValue)object).get(object2);
            } else {
                db.println("[FATAL ERROR] Should Never BE HERE " + object.getClass().getName());
                db.println("[ERROR] Unable to perform get() on " + object.getClass().getName());
                db.println("[REASON] Undefined type of Value");
                throw new CTCUserException("Undefined type of Value");
            }
            if (dba.on()) {
                dba.println("(" + object.getClass().getName() + ") GET value: ");
                String string2 = string = object3 == null ? RESULT : object3.toString();
                if (doHexDump) {
                    string = UTF8Utils.toHexDump((String)string);
                }
                db.println("  " + string);
            }
            if (db.doTiming()) {
                db.logThreadTiming("stop NCV/CV/UV attr get");
            }
        }
        catch (UserException userException) {
            db.println("[ERROR] Unable to perform get() on " + object.getClass().getName());
            db.println("[REASON] " + userException.toString());
            throw new CTCUserException(userException);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("[ERROR] Unable to perform get() on " + object.getClass().getName());
            db.println("[REASON] " + abstractCmsIOException.toString());
            throw new CTCUserException(RESULT, (Throwable)abstractCmsIOException);
        }
        catch (Exception exception) {
            db.println("[ERROR] Unable to perform get() on " + object.getClass().getName());
            db.println("[REASON] " + exception.toString());
            throw new CTCUserException(exception.toString(), (Throwable)exception);
        }
        if (object3 != null && ReflectionUtil.isIdlInterfaceClass(object3.getClass())) {
            object3 = null;
        }
        if (db.doDumpObj()) {
            db.dumpObj("get return", object3);
            db.newline();
        }
        return object3;
    }

    public static Node performSet(Object object, Object object2) throws CTCUserException {
        if (object == null) {
            db.println("[ERROR] Unable to perform set() ");
            db.println("[REASON] value is NULL");
            throw new CTCUserException("Value is NULL");
        }
        try {
            if (db.doDumpObj()) {
                db.dumpObj(object.getClass().getName() + " set args", object2);
                db.newline();
            }
            if (db.doTiming()) {
                db.logThreadTiming("start NCV/CV/UV set attr");
            }
            if (dba.on()) {
                Object[] objectArray;
                if (object2 instanceof Object[]) {
                    objectArray = (Object[])object2;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = object2;
                }
                Object[] objectArray3 = objectArray;
                int n = objectArray3 == null ? 0 : objectArray3.length;
                dba.println("(" + object.getClass().getName() + ") num SET input args: " + n);
                for (int i = 0; i < n; ++i) {
                    String string;
                    String string2 = string = objectArray3[i] == null ? RESULT : objectArray3[i].toString();
                    if (doHexDump) {
                        string = UTF8Utils.toHexDump((String)string);
                    }
                    db.println("  arg # " + i + ": " + string);
                }
            }
            if (object instanceof NonCachedValue) {
                ((NonCachedValue)object).set(object2);
            } else if (object instanceof UserValue) {
                ((UserValue)object).set(object2);
            } else {
                db.println("[FATAL ERROR] Should Never BE HERE " + object.getClass().getName());
                db.println("[ERROR] Unable to perform get() on " + object.getClass().getName());
                db.println("[REASON] Undefined type of Value");
                throw new CTCUserException("Undefined type of Value");
            }
            if (db.doTiming()) {
                db.logThreadTiming("stop NCV/CV/UV set attr");
            }
        }
        catch (UserException userException) {
            db.println("[ERROR] Unable to perform get() on " + object.getClass().getName());
            db.println("[REASON] " + userException.toString());
            throw new CTCUserException(userException);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("[ERROR] Unable to perform get() on " + object.getClass().getName());
            db.println("[REASON] " + abstractCmsIOException.toString());
            throw new CTCUserException(RESULT, (Throwable)abstractCmsIOException);
        }
        catch (Exception exception) {
            db.println("[ERROR] Unable to perform set() on " + object.getClass().getName());
            db.println("[REASON] " + exception.toString());
            throw new CTCUserException(exception.toString());
        }
        return null;
    }

    public static INodeModel performGetNode(Object object) throws CTCUserException {
        if (object == null) {
            if (db.on()) {
                db.println("[ERROR] Unable to perform getNode() ");
                db.println("[REASON] value is NULL");
            }
            throw new CTCUserException("HELPER: Value is NULL");
        }
        NodeModelDelegate nodeModelDelegate = null;
        try {
            if (object instanceof CachedValue) {
                nodeModelDelegate = ((CachedValue)object).getNode();
            } else if (object instanceof NonCachedValue) {
                nodeModelDelegate = ((NonCachedValue)object).getNode();
            } else if (object instanceof Model) {
                nodeModelDelegate = ((Model)object).getNodeModel();
            } else if (object instanceof MethodState) {
                Object object2 = ((MethodState)object).getInstance();
                if (object2 instanceof Model) {
                    nodeModelDelegate = ((Model)object2).getNodeModel();
                }
            } else if (db.on()) {
                db.println("Unable to performgetNode() on " + object.getClass().getName());
                db.println("Type of value is not Cached Value, NonCachedValue");
                db.println("Model, or MethodState.  Conversion method should not");
                db.println("require use of NodeModel.");
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("[ERROR] Unable to perform getNode() on " + object.getClass().getName());
                db.println("[REASON] " + exception.toString());
            }
            throw new CTCUserException(exception.getMessage());
        }
        return nodeModelDelegate;
    }

    public static Object nodeToObject(Node node, String string, Object object) throws CTCUserException {
        throw new CTCUserException("[Helper]nodeToObject(...) called in Base Helper.java in " + node.getNodeName());
    }

    public static String objectToXml(Object object, String string, Node node) throws CTCUserException {
        throw new CTCUserException("[Helper]objectToXml(...) called in Base Helper.java in " + string);
    }

    public static Node toXml(Object object, Node node, String string, Node node2) throws CTCUserException {
        throw new CTCUserException("Helper: " + object.getClass().getName() + " not implemented");
    }

    public static Node fromXml(Object object, Node node, String string, Node node2) throws CTCUserException {
        throw new CTCUserException("Helper: " + object.getClass().getName() + " not implemented");
    }

    public static void handleInvokeException(InvocationTargetException invocationTargetException) throws CTCUserException {
        Helper.handleInvokeException(null, invocationTargetException);
    }

    public static void handleInvokeException(String string, InvocationTargetException invocationTargetException) throws CTCUserException {
        Throwable throwable = XmlTagFactory.getOriginatingException(invocationTargetException);
        if (!(throwable instanceof UserException)) {
            if (throwable instanceof CTCUserException) {
                throw (CTCUserException)throwable;
            }
            if (string == null) {
                throw new CTCUserException(throwable.toString(), throwable);
            }
            throw new CTCUserException(string + " - " + throwable.toString(), throwable);
        }
    }

    protected Helper() {
    }

    public static class Debug
    extends SDebug {
        static final int INDENT_OFFSET = 2;
        boolean doDumpObj;
        boolean doTiming;

        public Debug(String string) {
            super(string);
        }

        public final boolean getDumpObj() {
            return this.doDumpObj;
        }

        public final void setDumpObj(boolean bl) {
            this.doDumpObj = bl;
        }

        boolean doDumpObj() {
            return this.getDumpObj();
        }

        void dump(int n, String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
            stringBuilder.append(string2);
            db.display(stringBuilder.toString());
        }

        void newline() {
            this.dump(0, Helper.RESULT, Helper.RESULT);
        }

        void dump(int n, String string) {
            this.dump(n, string, Helper.RESULT);
        }

        void dumpObj(String string, Object object) {
            this.dumpObj(0, "*** " + string, object);
        }

        void dumpObj(int n, String string, Object object) {
            Object object2 = null;
            int n2 = n + 2;
            this.dump(n, string);
            Class<?> clazz = null;
            if (object == null) {
                object2 = "is null";
            } else if (object instanceof NonCachedValue || object instanceof UserValue) {
                clazz = object.getClass();
                object2 = object;
            } else {
                clazz = object.getClass();
                int n3 = ReflectionUtil.categorizeClass(clazz);
                switch (n3) {
                    case 1: {
                        int n4 = Array.getLength(object);
                        this.dump(n2, "array of " + n4 + " items");
                        for (int i = 0; i < n4; ++i) {
                            this.dumpObj(n2, "item " + i + ": ", Array.get(object, i));
                        }
                        break;
                    }
                    case 2: {
                        Iterator iterator;
                        int n5 = -1;
                        if (object instanceof Iterator) {
                            iterator = (Iterator)object;
                        } else {
                            Collection collection = (Collection)object;
                            n5 = collection.size();
                            iterator = collection.iterator();
                        }
                        this.dump(n2, "collection/iter " + clazz.getName() + " of " + n5 + " items");
                        int n6 = 0;
                        while (iterator.hasNext()) {
                            this.dumpObj(n2, "item " + n6 + ": ", iterator.next());
                            ++n6;
                        }
                        break;
                    }
                    case 3: {
                        Map map = (Map)object;
                        Set set = ((Map)object).keySet();
                        Iterator iterator = set.iterator();
                        this.dump(n2, "map " + clazz.getName() + " of " + map.size() + " items");
                        int n7 = 0;
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            this.dumpObj(n2, "key " + n7 + ": ", e);
                            this.dumpObj(n2, "value" + n7 + ": ", map.get(e));
                            ++n7;
                        }
                        break;
                    }
                    case 4: {
                        IModel iModel = (IModel)object;
                        this.dumpObj(n2, "model " + clazz.getName() + ": ", Helper.RESULT + iModel.getIndex());
                        break;
                    }
                    case 6: {
                        Field[] fieldArray = ReflectionUtil.getStructFields(clazz);
                        this.dump(n2, "struct " + clazz.getName());
                        for (int i = 0; i < fieldArray.length; ++i) {
                            try {
                                Field field = fieldArray[i];
                                this.dumpObj(n2, field.getName() + ": ", field.get(object));
                                continue;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                Debug.printStackTrace((Throwable)illegalAccessException);
                            }
                        }
                        break;
                    }
                    case 7: {
                        Method[] methodArray = ReflectionUtil.getBeanMethods(clazz);
                        for (int i = 0; i < methodArray.length; ++i) {
                            Method method = methodArray[i];
                            try {
                                this.dump(n2, "bean " + clazz.getName());
                                if (method.getParameterTypes().length != 0) continue;
                                this.dumpObj(n2, method.getName() + ": ", method.invoke(object, new Object[0]));
                                continue;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                Debug.printStackTrace((Throwable)illegalAccessException);
                                continue;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                this.dump(n2, "exception dumping accessor: " + method.getName());
                            }
                        }
                        break;
                    }
                    case 5: {
                        if (!(object instanceof IDLEntity)) break;
                        try {
                            Method method = clazz.getMethod("value", new Class[0]);
                            int n8 = (Integer)method.invoke(object, new Object[0]);
                            String[] stringArray = EnumStrings.getStrings(clazz);
                            try {
                                object2 = stringArray[n8] + " (" + n8 + " - " + clazz.getName() + ")";
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                object2 = Helper.RESULT + n8;
                            }
                        }
                        catch (Exception exception) {
                            Debug.printStackTrace((Throwable)exception);
                        }
                        break;
                    }
                    default: {
                        object2 = object;
                    }
                }
            }
            if (object2 != null) {
                if (object2 instanceof String) {
                    this.dump(n2, "\"" + object2 + "\"");
                } else if (object instanceof Number) {
                    this.dump(n2, Helper.RESULT, object.toString() + " (0x" + Long.toHexString(((Number)object).longValue()) + ")");
                } else if (object instanceof Boolean) {
                    this.dump(n2, Helper.RESULT + (Boolean)object);
                } else {
                    this.dump(n2, clazz.getName() + ": ", object.toString());
                }
            }
        }

        public final void setLogTiming(boolean bl) {
            this.doTiming = bl;
        }

        public boolean doTiming() {
            return this.doTiming;
        }

        public void logThreadTiming(String string) {
            String string2 = " ";
            Thread.currentThread();
            if (Thread.interrupted()) {
                string2 = " INTERRUPTED ";
            }
            this.println(Thread.currentThread() + string2 + string + " " + System.currentTimeMillis() + " msecs");
        }
    }
}

