/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GapSplitter {
    private static final SDebug db = new SDebug("GapSplitter");

    private GapSplitter() {
    }

    public static List splitGap(int[] nArray, int[] nArray2, int[] nArray3) {
        ArrayList arrayList = new ArrayList();
        if (nArray.length != nArray2.length || nArray.length != nArray3.length) {
            throw new IllegalArgumentException("The lists are not the same size.");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= nArray3[i] && nArray2[i] <= nArray3[i]) continue;
            throw new IllegalArgumentException("At least one number is larger than the boundary number.");
        }
        GapSplitter.makeStandardGaps(nArray, nArray2, nArray3, new int[0], arrayList);
        return arrayList;
    }

    private static void makeStandardGaps(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, List list) {
        int n;
        if (db.on()) {
            db.fine("startNums=");
            for (n = 0; n < nArray.length; ++n) {
                db.fine(nArray[n] + " ");
            }
            db.fine("\nendNums=");
            for (n = 0; n < nArray.length; ++n) {
                db.fine(nArray2[n] + " ");
            }
            db.fine("\n");
        }
        if (GapSplitter.isStandard(nArray, nArray2, nArray3)) {
            list.add(GapSplitter.createGap(nArray, nArray2, nArray4));
            return;
        }
        n = nArray[0];
        int n2 = nArray2[0];
        if (n < n2) {
            int n3;
            if (!GapSplitter.isHeadArr(nArray)) {
                GapSplitter.makeStandardGaps(nArray, GapSplitter.createTailArr(nArray3, n), nArray3, nArray4, list);
            }
            int n4 = GapSplitter.isHeadArr(nArray) ? n : n + 1;
            int n5 = n3 = GapSplitter.isTailArr(nArray2, nArray3) ? n2 : n2 - 1;
            if (n4 <= n3) {
                GapSplitter.makeStandardGaps(GapSplitter.createHeadArr(nArray, n4), GapSplitter.createTailArr(nArray3, n3), nArray3, nArray4, list);
            }
            if (!GapSplitter.isTailArr(nArray2, nArray3)) {
                GapSplitter.makeStandardGaps(GapSplitter.createHeadArr(nArray, n2), nArray2, nArray3, nArray4, list);
            }
        } else {
            GapSplitter.makeStandardGaps(GapSplitter.removeTopLayer(nArray), GapSplitter.removeTopLayer(nArray2), GapSplitter.removeTopLayer(nArray3), GapSplitter.addBottomNum(nArray4, n), list);
        }
    }

    private static boolean isHeadArr(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == 1) continue;
            return false;
        }
        return true;
    }

    private static int[] createHeadArr(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        Arrays.fill(nArray2, 1);
        nArray2[0] = n;
        return nArray2;
    }

    private static boolean isTailArr(int[] nArray, int[] nArray2) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int[] createTailArr(int[] nArray, int n) {
        int[] nArray2 = (int[])nArray.clone();
        nArray2[0] = n;
        return nArray2;
    }

    private static int[] removeTopLayer(int[] nArray) {
        int[] nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private static int[] addBottomNum(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray2.length - 1] = n;
        return nArray2;
    }

    private static boolean isStandard(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] != 1) {
                return false;
            }
            if (nArray2[i] == nArray3[i]) continue;
            return false;
        }
        return true;
    }

    private static List createGap(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray[0] > nArray2[0]) {
            throw new IllegalArgumentException("The starting number is larger than the ending number!");
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray4 = new int[nArray3.length + nArray.length];
        int[] nArray5 = new int[nArray3.length + nArray2.length];
        arrayList.add(nArray4);
        arrayList.add(nArray5);
        for (n = 0; n < nArray3.length; ++n) {
            nArray4[n] = nArray3[n];
            nArray5[n] = nArray3[n];
        }
        for (n = nArray3.length; n < nArray4.length; ++n) {
            nArray4[n] = nArray[n - nArray3.length];
        }
        for (n = nArray3.length; n < nArray5.length; ++n) {
            nArray5[n] = nArray2[n - nArray3.length];
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{3, 4, 6, 7};
        int[] nArray2 = new int[]{3, 4, 6, 7};
        int[] nArray3 = new int[]{10, 10, 10, 10};
        List list = GapSplitter.splitGap(nArray, nArray2, nArray3);
        for (int i = 0; i < list.size(); ++i) {
            int n;
            List list2 = (List)list.get(i);
            System.out.print("[");
            int[] nArray4 = (int[])list2.get(0);
            int[] nArray5 = (int[])list2.get(1);
            for (n = 0; n < nArray4.length; ++n) {
                System.out.print(nArray4[n] + " ");
            }
            System.out.print(",");
            for (n = 0; n < nArray5.length; ++n) {
                System.out.print(nArray5[n] + " ");
            }
            System.out.println("]");
        }
    }
}

