/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IpAddr;
import cerent.cms.model.IpConfigError;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetUtil {
    public static final String UNSPECIFIED_IPV6 = "0:0:0:0:0:0:0:0";
    public static char[] hexCharSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private InetUtil() {
    }

    public static String regEx() {
        return "([0-9]{1,3}\\.){3}[0-9]{1,3}";
    }

    public static int makeNetMask(int n) {
        return n == 0 ? 0 : -1 << 32 - n;
    }

    public static int maskToPrefix(IIpAddr iIpAddr) {
        int n = InetUtil.makeIpV4(iIpAddr);
        int n2 = 32;
        n ^= 0xFFFFFFFF;
        while (n != 0) {
            n >>= 1;
            --n2;
        }
        return n2;
    }

    public static String makeDottedString(IIpAddr iIpAddr, boolean bl) {
        if (bl) {
            return InetUtil.makeDottedStringV6(iIpAddr);
        }
        return InetUtil.makeDottedString(InetUtil.makeIpV4(iIpAddr));
    }

    public static String makeDottedString(IIpAddr iIpAddr) {
        if (!InetUtil.validV6IpAddr(iIpAddr)) {
            return InetUtil.makeDottedString(InetUtil.makeIpV4(iIpAddr));
        }
        return InetUtil.makeDottedStringV6(iIpAddr);
    }

    public static String makeDottedString(String string) throws UnknownHostException, NumberFormatException {
        return InetUtil.makeDottedString(InetUtil.makeIpAddr(string));
    }

    public static boolean validV6IpAddr(IIpAddr iIpAddr) {
        return !InetUtil.validV4IpAddr(iIpAddr) || InetUtil.isLoopBackIpv6Addr(iIpAddr);
    }

    public static boolean isLoopBackIpv6Addr(IIpAddr iIpAddr) {
        int n = 0;
        for (n = 0; n < 15; ++n) {
            if (iIpAddr.getAddr()[n] == 0) continue;
            return false;
        }
        return iIpAddr.getAddr()[n] == 1;
    }

    public static boolean validV4IpAddr(IIpAddr iIpAddr) {
        for (int i = 0; i < 12; ++i) {
            if (iIpAddr.getAddr()[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static String toHexString(byte[] byArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(byArray.length + 7);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexCharSet[(byArray[i] & 0xF0) >>> 4]);
            stringBuffer.append(hexCharSet[byArray[i] & 0xF]);
            n = (short)(n + 1);
            if (n != 2 || i == 15) continue;
            stringBuffer.append(':');
            n = 0;
        }
        return stringBuffer.toString();
    }

    public static String makeDottedStringV6(IIpAddr iIpAddr) {
        String string = InetUtil.toHexString(iIpAddr.getAddr());
        String string2 = null;
        try {
            string2 = Inet6Address.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new NumberFormatException("The IP address " + string + " is invalid.");
        }
        return string2;
    }

    public static boolean isIPv6Address(IIpAddr iIpAddr) {
        boolean bl = false;
        String string = InetUtil.makeDottedString(iIpAddr);
        try {
            if (InetAddress.getByName(string).getAddress().length == 16) {
                bl = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return bl;
    }

    public static String makeDottedString(int n) {
        String string = (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n & 0xFF);
        return string;
    }

    public static int parseDottedString(String string) throws NumberFormatException {
        try {
            byte[] byArray = InetAddress.getByName(string).getAddress();
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                n = n << 8 | byArray[i] & 0xFF;
            }
            return n;
        }
        catch (UnknownHostException unknownHostException) {
            throw new NumberFormatException("The IP address " + string + " is invalid.");
        }
    }

    public static IIpAddr makeIpAddr(String string) {
        try {
            byte[] byArray = InetAddress.getByName(string).getAddress();
            if (byArray.length == 4) {
                byte[] byArray2 = new byte[16];
                System.arraycopy(byArray, 0, byArray2, 16 - byArray.length, byArray.length);
                byArray = byArray2;
            } else if (byArray.length != 16) {
                throw new NumberFormatException("'" + string + "' cannot be " + "converted to an IP address.\n" + 4 + " or " + 16 + " bytes were expected but " + byArray.length + " bytes were received.");
            }
            return new IpAddr(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new NumberFormatException("The IP address " + string + " is invalid.");
        }
    }

    public static IIpAddr makeIpAddr(int n) {
        byte[] byArray = new byte[16];
        for (int i = 15; i >= 12; --i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        return new IpAddr(byArray);
    }

    public static int makeIpV4(IIpAddr iIpAddr) {
        return iIpAddr.getAddr()[12] << 24 | iIpAddr.getAddr()[13] << 16 & 0xFF0000 | iIpAddr.getAddr()[14] << 8 & 0xFF00 | iIpAddr.getAddr()[15] & 0xFF;
    }

    public static void validateIpConfig(ISecureIpConfig iSecureIpConfig, IIpConfig iIpConfig, String string) throws IpConfigError {
        IIpAddr iIpAddr = iIpConfig.getIpAddress();
        IIpAddr iIpAddr2 = iSecureIpConfig.getIpAddress();
        IIpAddr iIpAddr3 = iIpConfig.getDefaultRouter();
        int n = InetUtil.makeNetMask(iIpConfig.getNetMaskPrefixLength());
        int n2 = InetUtil.makeNetMask(iSecureIpConfig.getNetMaskPrefixLength());
        InetUtil.validateConfig(iIpAddr2, iIpAddr3, n2, string);
        InetUtil.checkForSameSubnet(iIpAddr2, n2, iIpAddr, n);
    }

    public static void checkForSameSubnet(IIpAddr iIpAddr, int n, IIpAddr iIpAddr2, int n2) throws IpConfigError {
        int n3;
        int n4 = InetUtil.makeIpV4(iIpAddr2);
        if ((n4 & n2) == ((n3 = InetUtil.makeIpV4(iIpAddr)) & n)) {
            throw new IpConfigError("The IP address for the controller LAN port cannot be on the same \nsubnet as the IP address for the backplane LAN port.");
        }
    }

    public static void validateIpConfig(IIpConfig iIpConfig, String string) throws IpConfigError {
        IIpAddr iIpAddr = iIpConfig.getIpAddress();
        IIpAddr iIpAddr2 = iIpConfig.getDefaultRouter();
        int n = InetUtil.makeNetMask(iIpConfig.getNetMaskPrefixLength());
        InetUtil.validateConfig(iIpAddr, iIpAddr2, n, string);
    }

    public static void validateConfig(IIpAddr iIpAddr, IIpAddr iIpAddr2, int n, String string) throws IpConfigError {
        int n2;
        int n3 = InetUtil.makeIpV4(iIpAddr);
        int n4 = 0;
        if (iIpAddr2 != null) {
            n4 = InetUtil.makeIpV4(iIpAddr2);
        }
        if (n3 == 0) {
            throw new IpConfigError("The IP address cannot be all zeroes.");
        }
        if (n3 >>> 31 == 0) {
            n2 = 0;
        } else if (n3 >>> 30 == 2) {
            n2 = 1;
        } else if (n3 >>> 29 == 6) {
            n2 = 2;
        } else {
            throw new IpConfigError("The IP address must be a class A, B or C address.");
        }
        int[] nArray = new int[]{InetUtil.makeNetMask(8), InetUtil.makeNetMask(16), InetUtil.makeNetMask(24)};
        InetUtil.checkAllZerosOrOnes(n3, "IP address", Math.min(n, nArray[n2]), "network");
        InetUtil.checkAllZerosOrOnes(n3, "IP address", ~n, string);
        if (n4 != 0) {
            if ((n3 & n) != (n4 & n)) {
                throw new IpConfigError("The default router address and this IP address must be on the same subnet.  \nThe default router can be set to 0.0.0.0 if it is not needed.");
            }
            InetUtil.checkAllZerosOrOnes(n4, "default router", ~n, string);
        }
    }

    private static void checkAllZerosOrOnes(int n, String string, int n2, String string2) throws IpConfigError {
        int n3 = n & n2;
        if (n3 == 0) {
            throw new IpConfigError("The " + string2 + " part of " + " the " + string + " cannot be all zeroes.");
        }
        if (n3 == n2) {
            throw new IpConfigError("The " + string2 + " part of " + " the " + string + " cannot be all ones.");
        }
    }
}

