/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class MacAddrFormat
extends NumberFormat {
    private static final MacAddrFormat instance = new MacAddrFormat();
    private static final String hexDigits = "0123456789abcdef";

    public static String regEx() {
        return "([0-9a-fA-F]{2}:){5}[0-9a-fA-F]{2}";
    }

    public static String format(byte[] byArray) {
        return instance.format(MacAddrFormat.toLong(byArray));
    }

    public static String formatMacAddr(long l) {
        return instance.format(l);
    }

    public static long toLong(byte[] byArray) {
        long l = 0L;
        int n = Math.min(byArray.length, 6);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                l <<= 8;
            }
            l += (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    public static byte[] toBytes(long l) {
        byte[] byArray = new byte[6];
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    public static long parseMacAddr(String string) throws ParseException {
        return (Long)instance.parse(string);
    }

    private MacAddrFormat() {
        this.setParseIntegerOnly(true);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((long)d, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        for (int i = 44; i >= 0; i -= 4) {
            stringBuffer.append(hexDigits.charAt((int)(l >> i) & 0xF));
            if (i <= 0 || i % 8 != 0) continue;
            stringBuffer.append(':');
        }
        return stringBuffer;
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        long l = 0L;
        int n = parsePosition.getIndex() - 1;
        int n2 = 0;
        while (++n < string.length() && n2 < 12) {
            char c = string.charAt(n);
            if (c == ':') continue;
            int n3 = hexDigits.indexOf(Character.toLowerCase(c));
            if (n3 >= 0) {
                ++n2;
                l <<= 4;
                l += (long)n3;
                continue;
            }
            parsePosition.setErrorIndex(n);
            return new Long(0L);
        }
        parsePosition.setIndex(n);
        return new Long(l);
    }

    public static int compareMacAddr(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray[i] - byArray2[i];
        }
        return 0;
    }
}

