/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class ActionOrganizer {
    private static final Insets TB_MARGIN = new Insets(2, 2, 2, 2);
    private ActionListener listener;
    private HashMap toolbarMap = new HashMap();
    private HashMap menuMap = new HashMap();

    public ActionOrganizer(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public AbstractButton addToolbar(JToolBar jToolBar, String string, String string2) {
        URL uRL = this.getClass().getResource(string);
        JButton jButton = null;
        jButton = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton(new ImageIcon(string2));
        jButton.addActionListener(this.listener);
        jButton.setToolTipText(string2);
        jButton.setMargin(TB_MARGIN);
        jButton.setActionCommand(string2);
        jToolBar.add(jButton);
        this.toolbarMap.put(string2, jButton);
        return jButton;
    }

    public AbstractButton addMenuItem(JComponent jComponent, String string, String string2, int n) {
        return this.addMenuItem(jComponent, new JMenuItem(string2, n), string, string2);
    }

    public AbstractButton addMenuItem(JComponent jComponent, JMenuItem jMenuItem, String string, String string2) {
        if (string != null) {
            jMenuItem.setIcon(new ImageIcon(this.getClass().getResource(string)));
        }
        jMenuItem.addActionListener(this.listener);
        jMenuItem.setActionCommand(string2);
        if (jComponent instanceof JMenu) {
            JMenu jMenu = (JMenu)jComponent;
            if (!jMenu.isMenuComponent(jMenuItem)) {
                jComponent.add(jMenuItem);
            }
        } else {
            jComponent.add(jMenuItem);
        }
        this.menuMap.put(string2, jMenuItem);
        return jMenuItem;
    }

    public void removeMenuItem(JPopupMenu jPopupMenu, String string) {
        this.removeMenuCommand(jPopupMenu, string);
    }

    public void removeMenuItem(JMenuItem jMenuItem, String string) {
        this.removeMenuCommand(jMenuItem, string);
    }

    private void removeMenuCommand(JComponent jComponent, String string) {
        Component component = (Component)this.menuMap.get(string);
        if (component != null) {
            this.menuMap.remove(string);
            jComponent.remove(component);
            if (component instanceof JMenuItem) {
                ((JMenuItem)component).removeActionListener(this.listener);
            }
        }
    }

    public AbstractButton createButton(String string) {
        return this.createButton(null, string);
    }

    public AbstractButton createButton(Icon icon, String string) {
        JButton jButton = new JButton(string);
        if (icon != null) {
            jButton.setIcon(icon);
        }
        jButton.addActionListener(this.listener);
        jButton.setActionCommand(string);
        this.toolbarMap.put(string, jButton);
        return jButton;
    }

    public AbstractButton getAbstractButton(String string) {
        AbstractButton abstractButton = (AbstractButton)this.menuMap.get(string);
        if (abstractButton == null) {
            abstractButton = (AbstractButton)this.toolbarMap.get(string);
        }
        return abstractButton;
    }

    public AbstractButton getMenuItem(String string) {
        return (AbstractButton)this.menuMap.get(string);
    }

    public AbstractButton getToolbarItem(String string) {
        return (AbstractButton)this.menuMap.get(string);
    }

    public void setEnabled(String string, boolean bl) {
        this.setEnabled(string, bl, null);
    }

    public void setEnabled(String string, boolean bl, String string2) {
        AbstractButton abstractButton = (AbstractButton)this.menuMap.get(string);
        if (abstractButton != null) {
            abstractButton.setEnabled(bl);
            if (string2 != null) {
                abstractButton.setToolTipText(string2);
            }
        }
        if ((abstractButton = (AbstractButton)this.toolbarMap.get(string)) != null) {
            abstractButton.setEnabled(bl);
            if (string2 != null) {
                abstractButton.setToolTipText(string2);
            }
        }
    }

    public boolean isEnabled(String string) {
        AbstractButton abstractButton = (AbstractButton)this.menuMap.get(string);
        if (abstractButton != null) {
            return abstractButton.isEnabled();
        }
        abstractButton = (AbstractButton)this.toolbarMap.get(string);
        if (abstractButton != null) {
            return abstractButton.isEnabled();
        }
        return false;
    }

    public void clear() {
        this.menuMap.clear();
        this.toolbarMap.clear();
    }
}

