/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class BinaryTextField
extends JTextField {
    private static String digitsString = "01";
    private static int MAX_LENGTH = 32;

    public BinaryTextField(int n) {
        super(n);
    }

    @Override
    protected Document createDefaultModel() {
        return new LetterOrDigitDocument(MAX_LENGTH);
    }

    static class LetterOrDigitDocument
    extends PlainDocument {
        int documentMaxLength;

        public LetterOrDigitDocument(int n) {
            this.documentMaxLength = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            if (string != null) {
                if (string.length() + this.getLength() > this.documentMaxLength) {
                    bl = false;
                } else {
                    for (int i = 0; bl && i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (-1 != digitsString.indexOf(c)) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

