/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.LetterOrDigitPasswordField;

public class IOSPasswordField
extends LetterOrDigitPasswordField {
    public static final String IOS_PID_CHARS = "?$ ";
    public static final int MAX_IOS_LENGTH = 25;
    private int maxLength = 25;
    private String exceptionMsg = "";

    public IOSPasswordField() {
        super(25, IOS_PID_CHARS);
    }

    public IOSPasswordField(int n) {
        super(n, IOS_PID_CHARS);
        this.maxLength = n;
    }

    public boolean isValidPID() throws Exception {
        char[] cArray = this.getPassword();
        boolean bl = true;
        if (cArray.length < 1) {
            bl = false;
            this.exceptionMsg = "The minimum length is 1.";
        } else if (cArray.length > this.maxLength) {
            bl = false;
            this.exceptionMsg = "The maximum length is " + this.maxLength + ".";
        } else {
            char c = cArray[0];
            if (c == ' ' || Character.isDigit(c)) {
                bl = false;
                this.exceptionMsg = "The first character cannot be a space or a number.";
            }
        }
        return bl;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }
}

