/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.EID;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.gui.LetterOrDigitPasswordField;

public class TL1PasswordField
extends LetterOrDigitPasswordField {
    public static final String TL1_PID_CHARS = "+#%";
    public static final String ALLOWED_PID_SPECIAL_CHARS = "+#%~=!@$^&*()_-`'{}[]|:;\\/<>,.?\"";
    public static final String NON_TL1_PID_CHARS = "~=!@$^&*()_-`'{}[]|:;\\/<>,.?\"";
    public static final int MAX_PASSWORD_LENGTH = 80;

    public TL1PasswordField(int n) {
        super(n, ALLOWED_PID_SPECIAL_CHARS, 80);
    }

    public void isValidPID() throws Exception {
        char[] cArray = this.getPassword();
        if (cArray.length < 1) {
            throw new Exception("The minimum length is 1.");
        }
        if (cArray.length > 10) {
            throw new Exception("The maximum length is 10.");
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (!Character.isLetter(cArray[i])) {
                ++n;
            }
            if (TL1_PID_CHARS.indexOf(cArray[i]) <= -1) continue;
            ++n2;
        }
        if (n < 2 || n2 < 1) {
            throw new Exception("The field must contain at least two non-alphabetical characters and at least one of the following characters: +#%.");
        }
    }

    public void isNotTooSimple(String string) throws Exception {
        String string2 = new String(this.getPassword());
        boolean bl = false;
        if (string2.length() < 6) {
            throw new Exception("The password must be at least six characters long.");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (Character.isLetter(c)) {
                ++n;
            }
            if (c == '+' || c == '#' || c == '%' || c == '~' || c == '=' || c == '!' || c == '@' || c == '$' || c == '^' || c == '&' || c == '*' || c == '(' || c == ')' || c == '_' || c == '-' || c == '`' || c == '\'' || c == '{' || c == '}' || c == '[' || c == ']' || c == '|' || c == ':' || c == ';' || c == '\\' || c == '/' || c == '<' || c == '>' || c == ',' || c == '.' || c == '?' || c == '\"') {
                ++n3;
            }
            if (!Character.isDigit(c)) continue;
            ++n2;
        }
        if (string2.toUpperCase().indexOf(string.toUpperCase()) != -1) {
            bl = true;
        }
        if (bl) {
            throw new Exception(KErrorMsg.getString((EID)KEMC.EID_PASSWORD_TOO_SIMPLE));
        }
    }
}

