/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.IopComponent;
import java.io.IOException;
import java.io.PrintStream;

public class CodeSets
implements IopComponent {
    private int _charNativeCodeSet;
    private int[] _charConversionCodeSets;
    private int _wcharNativeCodeSet;
    private int[] _wcharConversionCodeSets;
    public static final int ISO8859_1 = 65537;
    public static final int UTF16 = 65801;
    public static final int UTF8 = 0x5010001;

    public CodeSets(CdrReader cdrReader) throws IOException {
        int n;
        this._charNativeCodeSet = cdrReader.getInt();
        int n2 = cdrReader.getInt();
        if (n2 <= 0) {
            this._charConversionCodeSets = null;
        } else {
            this._charConversionCodeSets = new int[n2];
            for (n = 0; n < n2; ++n) {
                this._charConversionCodeSets[n] = cdrReader.getInt();
            }
        }
        this._wcharNativeCodeSet = cdrReader.getInt();
        n2 = cdrReader.getInt();
        if (n2 <= 0) {
            this._wcharConversionCodeSets = null;
        } else {
            this._wcharConversionCodeSets = new int[n2];
            for (n = 0; n < n2; ++n) {
                this._wcharConversionCodeSets[n] = cdrReader.getInt();
            }
        }
    }

    @Override
    public CdrWriter write(CdrWriter cdrWriter) {
        int n;
        cdrWriter.putInt(this._charNativeCodeSet);
        if (this._charConversionCodeSets == null) {
            cdrWriter.putInt(0);
        } else {
            cdrWriter.putInt(this._charConversionCodeSets.length);
            for (n = 0; n < this._charConversionCodeSets.length; ++n) {
                cdrWriter.putInt(this._charConversionCodeSets[n]);
            }
        }
        cdrWriter.putInt(this._wcharNativeCodeSet);
        if (this._wcharConversionCodeSets == null) {
            cdrWriter.putInt(0);
        } else {
            cdrWriter.putInt(this._wcharConversionCodeSets.length);
            for (n = 0; n < this._wcharConversionCodeSets.length; ++n) {
                cdrWriter.putInt(this._wcharConversionCodeSets[n]);
            }
        }
        return cdrWriter;
    }

    @Override
    public void print(PrintStream printStream, String string) {
        int n;
        String string2;
        printStream.println(string + "char code sets:");
        printStream.println(string + "     native code set = " + this.csName(this._charNativeCodeSet));
        printStream.print(string + "conversion code sets = ");
        if (this._charConversionCodeSets != null) {
            string2 = "";
            for (n = 0; n < this._charConversionCodeSets.length; ++n) {
                printStream.print(string2 + this.csName(this._charConversionCodeSets[n]));
                string2 = ", ";
            }
            printStream.println();
        } else {
            printStream.println("NONE");
        }
        printStream.println(string + "wchar code sets:");
        printStream.println(string + "     native code set = " + this.csName(this._wcharNativeCodeSet));
        printStream.print(string + "conversion code sets = ");
        if (this._wcharConversionCodeSets != null) {
            string2 = "";
            for (n = 0; n < this._wcharConversionCodeSets.length; ++n) {
                printStream.print(string2 + this.csName(this._wcharConversionCodeSets[n]));
                string2 = ", ";
            }
            printStream.println();
        } else {
            printStream.println("NONE");
        }
    }

    private String csName(int n) {
        switch (n) {
            case 65537: {
                return "ISO-8859-1";
            }
            case 65801: {
                return "UTF-16";
            }
            case 0x5010001: {
                return "UTF-8";
            }
        }
        return "Unknown TCS: " + Integer.toHexString(n);
    }
}

