/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.IopProfile;
import cerent.util.ior.TaggedComponent;
import java.io.IOException;
import java.io.PrintStream;

public class MultiComponentProfile
implements IopProfile {
    private TaggedComponent[] _components;

    public MultiComponentProfile(CdrReader cdrReader) throws IOException {
        int n = cdrReader.getInt();
        if (n <= 0) {
            this._components = null;
        } else {
            this._components = new TaggedComponent[n];
            for (int i = 0; i < n; ++i) {
                this._components[i] = new TaggedComponent(cdrReader);
            }
        }
    }

    @Override
    public CdrWriter write(CdrWriter cdrWriter) throws IOException {
        if (this._components == null) {
            cdrWriter.putInt(0);
        } else {
            cdrWriter.putInt(this._components.length);
            for (int i = 0; i < this._components.length; ++i) {
                this._components[i].write(cdrWriter);
            }
        }
        return cdrWriter;
    }

    @Override
    public void print(PrintStream printStream, String string) {
        printStream.println(string + "multi-component-profile");
        string = string + "  ";
        if (this._components == null) {
            printStream.println(string + "no components");
        } else {
            printStream.println(string + "#components: " + this._components.length);
            for (int i = 0; i < this._components.length; ++i) {
                this._components[i].print(printStream, string);
            }
        }
    }

    public int getNumComponents() {
        return this._components == null ? 0 : this._components.length;
    }

    public void setNumComponents(int n) {
        this._components = n <= 0 ? null : new TaggedComponent[n];
    }

    public TaggedComponent getComponentAt(int n) {
        return this._components[n];
    }

    public void setComponentAt(int n, TaggedComponent taggedComponent) {
        this._components[n] = taggedComponent;
    }
}

