/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CannotDeleteLastSource;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.ErrorWritingToDb;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.OnlyOneDropPerBidirCktAllowed;
import cerent.cms.model.TooManySourcePerCircuit;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.crs.model.AbstractModel;
import com.cisco.crs.model.CrsCircuitInfo;
import com.cisco.crs.model.PlatformNodeModel;

public class CircuitModel
extends AbstractModel
implements ICircuitModel {
    private CrsCircuitInfo crsCircuitRef;
    private String myString;

    public CircuitModel(PlatformNodeModel platformNodeModel, CrsCircuitInfo crsCircuitInfo) {
        super(platformNodeModel, platformNodeModel.getChildDebug(CircuitModel.class));
        this.crsCircuitRef = crsCircuitInfo;
    }

    public void init() {
        super.init0();
    }

    @Override
    public void dispose() {
        this.myString = null;
        this.crsCircuitRef = null;
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("CircuitModel::destroy()");
        }
        super.destroy();
        this.myString = null;
        this.crsCircuitRef = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            if (object instanceof CircuitModel) {
                return this.getUniquePart() == ((CircuitModel)object).getUniquePart();
            }
            return false;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Caught AbstractCmsIOException in CircuitModel::equals");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return false;
        }
    }

    public int hashCode() {
        return this.getUniquePart();
    }

    private ICircuitInfo getInfo() {
        return this.crsCircuitRef.getCktInfo();
    }

    public short getProvVersion() {
        return this.getInfo().getCircuitProvVersion();
    }

    public short getSla() {
        return this.getInfo().getSla();
    }

    public void setSla(short s) {
        this.getInfo().setSla(s);
    }

    public int getCktOptDir() {
        return this.getInfo().getCktOptDir();
    }

    public void setCktOptDir(int n) {
        this.getInfo().setCktOptDir(n);
    }

    public int getCktOptChannel() {
        return this.getInfo().getCktOptChannel();
    }

    public void setCktOptChannel(int n) {
        this.getInfo().setCktOptChannel(n);
    }

    public ICircuitEnd getSrcPoint() {
        return this.getInfo().getSrcPoint();
    }

    public ICircuitEnd getSecSrcPoint() {
        return this.getInfo().getSecSrcPoint();
    }

    public ICircuitDropInfo[] getDropInfo() {
        return this.getInfo().getDropInfo();
    }

    public boolean getMonitor() {
        return this.getInfo().getMonitor();
    }

    public int getSize() {
        return this.getInfo().getCircuitSize();
    }

    public void setSize(int n) {
        this.getInfo().setCircuitSize(n);
    }

    public Integer getKey() {
        return new Integer(this.getId().getUniquePart().getUniqueId());
    }

    public int getType() {
        return this.getInfo().getCircuitType();
    }

    public int getDirection() {
        return this.getInfo().getDir();
    }

    public String getName() {
        return this.getInfo().getCircuitName();
    }

    public void setName(String string) throws InvalidCircuitName {
        this.getInfo().setCircuitName(string);
    }

    public ICircuitId getId() {
        return this.crsCircuitRef.getCktId();
    }

    public int getNodeId() {
        return this.getId().getNodeId();
    }

    public int getUniquePart() {
        return this.getId().getUniquePart().getUniqueId();
    }

    public void addDrop(ICircuitDropInfo iCircuitDropInfo) throws OnlyOneDropPerBidirCktAllowed {
        this.crsCircuitRef.addDrop(iCircuitDropInfo);
    }

    public void delDrop(ICircuitEnd iCircuitEnd) throws CannotDeleteLastDrop {
        this.crsCircuitRef.delDrop(iCircuitEnd);
    }

    public IVlanModel[] getVlanList() {
        return new IVlanModel[0];
    }

    public void addVlan(IVlanModel iVlanModel) {
    }

    public void delVlan(IVlanModel iVlanModel) {
    }

    public void updateVlanList(IVlanModel[] iVlanModelArray) {
    }

    public void delete() throws ErrorWritingToDb {
    }

    protected void printString(KDebug kDebug) {
        kDebug.println("CircuitModel CRS info ");
        kDebug.println("Circuit Name " + this.getName());
        kDebug.println("Observers are :");
        this.printObservers();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "CRSCircuit[nodeId=" + this.getNodeId() + ", uniquePart=" + this.getUniquePart() + ",  name=" + this.getName() + "]";
            }
            catch (Exception exception) {
                return "CRSCircuit[deleted/inaccessible]";
            }
        }
        return this.myString;
    }

    public ICircuitId setId() {
        return null;
    }

    public void freeId() {
    }

    public int getVcatRoutingPref() {
        return this.getInfo().getVcatRoutingPref();
    }

    public void addSource(ICircuitEnd iCircuitEnd) throws TooManySourcePerCircuit, AbstractCmsIOException {
    }

    public void delSource(ICircuitEnd iCircuitEnd) throws CannotDeleteLastSource, AbstractCmsIOException {
    }

    public ICircuitEnd[] getSrcInfo() throws AbstractCmsIOException {
        ICircuitEnd[] iCircuitEndArray = this.getInfo().getSrcInfo();
        int n = iCircuitEndArray.length;
        ICircuitEnd[] iCircuitEndArray2 = new ICircuitEnd[n];
        for (int i = 0; i < n; ++i) {
            iCircuitEndArray2[i] = new CircuitEnd(iCircuitEndArray[i]);
        }
        return iCircuitEndArray2;
    }
}

