/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.fv.IFvPortModel;
import cerent.cms.idl.Common.ePST;
import cerent.cms.idl.Common.eSST;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Dwdm.eDwdmFecMode;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.Wavelength;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.WindowHelper;
import cerent.util.tty.CLIG709Action;
import cerent.util.tty.CLIProactiveProtectionAction;
import com.cisco.crs.model.AbstractModel;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.PlimPortModel;
import com.cisco.crs.model.parser.ShowControllersDwdmParser;
import java.util.Collections;
import java.util.List;

public class PlimInterfaceModel
extends AbstractModel
implements IPlimTrkLineModel {
    private PlimPortModel portModel;
    private int ifIndex;

    public PlimInterfaceModel(PlatformNodeModel platformNodeModel, PlimPortModel plimPortModel, int n) {
        super(platformNodeModel, platformNodeModel.getChildDebug(PlimInterfaceModel.class));
        this.portModel = plimPortModel;
        this.ifIndex = n;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public void addHigherLayerModel(IInterfaceModel iInterfaceModel) {
    }

    public String getAlias() throws NoSuchInterface {
        return "";
    }

    public void setAlias(String string) throws NoSuchInterface {
    }

    public void setInService(boolean bl) throws NoSuchInterface {
    }

    public void delete() {
    }

    public void deleteAll() {
    }

    public List getConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    public IPortModel getPortModel() throws AbstractCmsNoSuchEntityException {
        return this.portModel;
    }

    public IInterfaceModel getHoIfModelFromMemberId(short s) {
        return null;
    }

    public IInterfaceModel getLoIfModelFromMemberId(short s) {
        return null;
    }

    public int getAdminState() throws NoSuchInterface {
        return this.portModel.getAdminState();
    }

    public IServiceState getServiceSt() throws NoSuchInterface {
        return ServiceStateFactory.getServiceState(new sServiceState(ePST.from_int(this.portModel.getServiceStateType()), new eSST[]{eSST.SST_NONE}));
    }

    public int compareTo(Object object) {
        return 0;
    }

    public boolean getOTNStatus() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.G709Attr g709Attr = this.portModel.getG709Attrs();
        if (g709Attr != null) {
            return g709Attr.isOtnStatus();
        }
        throw new NoSuchInterface("Interface not found");
    }

    private eDwdmFecMode getFECMode() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.G709Attr g709Attr = this.portModel.getG709Attrs();
        if (g709Attr != null) {
            return g709Attr.getFecMode();
        }
        throw new NoSuchInterface("Interface not found");
    }

    public int getFECModeValue() throws NoSuchInterface, WrongInterfaceType {
        return this.getFECMode().value();
    }

    public String getTTIExpected() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.TTI tTI = this.portModel.getTTI();
        if (tTI == null) {
            return null;
        }
        return tTI.getExpected();
    }

    public void setTTIExpected(String string) throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.TTI tTI = this.portModel.getTTI();
        if (tTI != null) {
            tTI.setExpected(string);
        }
    }

    public String getTTITransmitted() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.TTI tTI = this.portModel.getTTI();
        if (tTI == null) {
            return null;
        }
        return tTI.getTx();
    }

    public void setTTITransmitted(String string) throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.TTI tTI = this.portModel.getTTI();
        if (tTI != null) {
            tTI.setTx(string);
        }
    }

    public short getOTNSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.G709Attr g709Attr = this.portModel.getG709Attrs();
        if (g709Attr != null) {
            return g709Attr.getSdBerLevel();
        }
        throw new NoSuchInterface("Interface not found");
    }

    public short getOTNSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.G709Attr g709Attr = this.portModel.getG709Attrs();
        if (g709Attr != null) {
            return g709Attr.getSfBerLevel();
        }
        throw new NoSuchInterface("Interface not found");
    }

    public void setOTNData(boolean bl, int n, int n2, int n3) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        if (bl) {
            this.setOTNStatus(bl);
            this.setFECModeValue(n);
            this.setSdBer(n2);
        } else {
            this.setFECModeValue(n);
            this.setSdBer(n2);
            this.setOTNStatus(bl);
        }
    }

    public void setOTNStatus(boolean bl) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        PlimPortId.PlimType plimType;
        int n;
        CLIG709Action cLIG709Action;
        try {
            cLIG709Action = new CLIG709Action(this.node.getHostName());
            n = this.getPortModel().getEntityIndex();
            plimType = ((PlimPortModel)this.getPortModel()).getPlimType();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
        if (plimType == PlimPortId.PlimType.POS) {
            return;
        }
        if (bl) {
            new Thread("setG709"){

                @Override
                public void run() {
                    cLIG709Action.enableG709(n);
                }
            }.start();
        } else {
            new Thread("setG709"){

                @Override
                public void run() {
                    cLIG709Action.disableG709(n);
                }
            }.start();
        }
    }

    public void setFECModeValue(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        int n2;
        CLIG709Action cLIG709Action;
        try {
            cLIG709Action = new CLIG709Action(this.node.getHostName());
            n2 = this.getPortModel().getEntityIndex();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
        if (n == 0) {
            new Thread("setG709FEC"){

                @Override
                public void run() {
                    boolean bl = cLIG709Action.disableFEC(n2);
                    if (bl) {
                        PlimInterfaceModel.this.notifyError(EMC.EID_CRS_SETDISFEC_FAILED);
                    } else {
                        PlimInterfaceModel.this.portModel.requireLock();
                        ShowControllersDwdmParser.G709Attr g709Attr = PlimInterfaceModel.this.portModel.getG709Attrs();
                        g709Attr.setFecMode(eDwdmFecMode.DISABLE_FEC);
                    }
                }
            }.start();
        }
        if (n == 1) {
            new Thread("setG709FEC"){

                @Override
                public void run() {
                    boolean bl = cLIG709Action.setStdFEC(n2);
                    if (bl) {
                        PlimInterfaceModel.this.notifyError(EMC.EID_CRS_SETSTDFEC_FAILED);
                    } else {
                        PlimInterfaceModel.this.portModel.requireLock();
                        ShowControllersDwdmParser.G709Attr g709Attr = PlimInterfaceModel.this.portModel.getG709Attrs();
                        g709Attr.setFecMode(eDwdmFecMode.STANDARD_FEC);
                    }
                }
            }.start();
        }
        if (n == 2) {
            new Thread("setG709FEC"){

                @Override
                public void run() {
                    boolean bl = cLIG709Action.setEnhFEC(n2);
                    if (bl) {
                        PlimInterfaceModel.this.notifyError(EMC.EID_CRS_SETENHFEC_FAILED);
                    } else {
                        PlimInterfaceModel.this.portModel.requireLock();
                        ShowControllersDwdmParser.G709Attr g709Attr = PlimInterfaceModel.this.portModel.getG709Attrs();
                        g709Attr.setFecMode(eDwdmFecMode.ENHANCED_FEC);
                    }
                }
            }.start();
        }
    }

    public void setSdBer(final int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        int n2;
        CLIG709Action cLIG709Action;
        try {
            cLIG709Action = new CLIG709Action(this.node.getHostName());
            n2 = this.getPortModel().getEntityIndex();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
        new Thread("setG709SdBER"){

            @Override
            public void run() {
                boolean bl = cLIG709Action.setSdBer(n2, n);
                if (bl) {
                    PlimInterfaceModel.this.notifyError(EMC.EID_CRS_SETSDBER_FAILED);
                } else {
                    PlimInterfaceModel.this.portModel.requireLock();
                    ShowControllersDwdmParser.G709Attr g709Attr = PlimInterfaceModel.this.portModel.getG709Attrs();
                    g709Attr.setSdBerLevel((short)n);
                }
            }
        }.start();
    }

    public void setMappingType(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
    }

    public void setOTNSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError {
    }

    public int getMappingTypeValue() throws NoSuchInterface, WrongInterfaceType {
        return 0;
    }

    public boolean isWavelengthSupported() throws NoSuchInterface, WrongInterfaceType {
        return true;
    }

    public int getActualWaveLength() throws NoSuchInterface, WrongInterfaceType {
        return this.getExpectedWaveLength();
    }

    public int getExpectedWaveLength() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.DwdmWavelength dwdmWavelength = this.portModel.getDwdmWavelength();
        if (dwdmWavelength != null) {
            return dwdmWavelength.getValue();
        }
        return 174;
    }

    public void setWaveLength(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError, ProvisionError {
        throw new ProvisionError("setWaveLength not supported on PLIM interfaces");
    }

    public String toString() {
        return this.portModel.toShortString() + " - PLIM Interface " + this.getIfIndex();
    }

    public String prettyString() {
        int n;
        try {
            n = this.getExpectedWaveLength();
        }
        catch (Exception exception) {
            n = 174;
        }
        StringBuilder stringBuilder = new StringBuilder("PLIM Interface ");
        stringBuilder.append(this.getIfIndex()).append(", wavelength = ").append(Wavelength.getWavelengthStringFromWavelength(n)).append(" (").append(n).append(")");
        try {
            if (this.getOTNStatus()) {
                stringBuilder.append(", OTN enabled, FEC mode ").append(this.getFECMode().toString()).append(", SD BER 10E-").append(this.getOTNSdBerLevel()).append(", SF BER 10E-").append(this.getOTNSfBerLevel());
            } else {
                stringBuilder.append(", OTN disabled");
            }
        }
        catch (Exception exception) {
            stringBuilder.append(", OTN unknown: " + exception.getMessage());
        }
        return stringBuilder.toString();
    }

    public IInterfaceModel[] getHigherLayerModelsForNet() {
        return null;
    }

    public IElementModel getElementModelForInterface() throws AbstractCmsNoSuchElementException {
        return null;
    }

    public int getProtectionRole() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        return 0;
    }

    public boolean isCurrentlyActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        return false;
    }

    public IInterfaceModel[] getLowerLayerModelsForNet() {
        return null;
    }

    public int getLmpId() {
        ShowControllersDwdmParser.LmpId lmpId = this.portModel.getLmpId();
        if (lmpId == null) {
            return 0;
        }
        return lmpId.getValue();
    }

    public void setCoordinateMaintState(boolean bl) throws NoSuchInterface, UnsupportedOperation {
        throw new UnsupportedOperation("setCoordinateMaintState not supported on PLIM interfaces.");
    }

    public IModuleModel getModuleModel() {
        return null;
    }

    public short getShelfNum() {
        return 0;
    }

    public IFvPortModel getThePortModel() throws AbstractCmsNoSuchEntityException {
        return this.getPortModel();
    }

    public String getConnectionId() throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.ConnectionId connectionId = this.portModel.getConnectionId();
        if (connectionId == null) {
            return null;
        }
        return connectionId.getValue();
    }

    public void setConnectionId(String string) throws NoSuchInterface, WrongInterfaceType {
        ShowControllersDwdmParser.ConnectionId connectionId = this.portModel.getConnectionId();
        if (connectionId != null) {
            connectionId.setValue(string);
        }
    }

    public void setFrrAttributes(int n, String string, String string2, String string3, String string4) throws NoSuchInterface {
        this.setProactiveProtection(n);
        this.setTriggerThreshold(string);
        this.setRevertTheshold(string2);
        this.setTriggerWindow(string3);
        this.setRevertWindow(string4);
    }

    private void setRevertWindow(final String string) throws NoSuchInterface {
        try {
            final CLIProactiveProtectionAction cLIProactiveProtectionAction = new CLIProactiveProtectionAction((INodeModel)this.node, (KDebug)this.db);
            final int n = this.getPortModel().getEntityIndex();
            final PlatformNodeModel platformNodeModel = this.node;
            new Thread("setRevertWindow"){

                @Override
                public void run() {
                    boolean bl = cLIProactiveProtectionAction.setRevertWindow(n, string);
                    if (bl) {
                        WindowHelper.postAlert((DetailedLog)new DetailedLog(3, "Router  " + platformNodeModel.getName() + ": Revert Window of value " + string + " is invalid"));
                    }
                }
            }.start();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
    }

    private void setTriggerThreshold(final String string) throws NoSuchInterface {
        try {
            final CLIProactiveProtectionAction cLIProactiveProtectionAction = new CLIProactiveProtectionAction((INodeModel)this.node, (KDebug)this.db);
            final int n = this.getPortModel().getEntityIndex();
            final PlatformNodeModel platformNodeModel = this.node;
            new Thread("setTriggerThreshold"){

                @Override
                public void run() {
                    boolean bl = cLIProactiveProtectionAction.setTriggerThreshold(n, string);
                    if (bl) {
                        WindowHelper.postAlert((DetailedLog)new DetailedLog(3, "Router  " + platformNodeModel.getName() + ": Trigger Threshold of value " + string + " is invalid"));
                    }
                }
            }.start();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
    }

    private void setTriggerWindow(final String string) throws NoSuchInterface {
        try {
            final CLIProactiveProtectionAction cLIProactiveProtectionAction = new CLIProactiveProtectionAction((INodeModel)this.node, (KDebug)this.db);
            final int n = this.getPortModel().getEntityIndex();
            final PlatformNodeModel platformNodeModel = this.node;
            new Thread("setTriggerWindow"){

                @Override
                public void run() {
                    boolean bl = cLIProactiveProtectionAction.setTriggerWindow(n, string);
                    if (bl) {
                        WindowHelper.postAlert((DetailedLog)new DetailedLog(3, "Router  " + platformNodeModel.getName() + ": Trigger Window of value " + string + " is invalid"));
                    }
                }
            }.start();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
    }

    private void setRevertTheshold(final String string) throws NoSuchInterface {
        try {
            final CLIProactiveProtectionAction cLIProactiveProtectionAction = new CLIProactiveProtectionAction((INodeModel)this.node, (KDebug)this.db);
            final PlatformNodeModel platformNodeModel = this.node;
            final int n = this.getPortModel().getEntityIndex();
            new Thread("setRevertThreshold"){

                @Override
                public void run() {
                    boolean bl = cLIProactiveProtectionAction.setRevertThreshold(n, string);
                    if (bl) {
                        WindowHelper.postAlert((DetailedLog)new DetailedLog(3, "Router  " + platformNodeModel.getName() + ": Revert Threshold of value " + string + " is invalid"));
                    }
                }
            }.start();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
    }

    private void setProactiveProtection(final int n) throws NoSuchInterface {
        try {
            final CLIProactiveProtectionAction cLIProactiveProtectionAction = new CLIProactiveProtectionAction((INodeModel)this.node, (KDebug)this.db);
            final PlatformNodeModel platformNodeModel = this.node;
            final int n2 = this.getPortModel().getEntityIndex();
            new Thread("setProactiveProtection"){

                @Override
                public void run() {
                    boolean bl = cLIProactiveProtectionAction.setProactiveProtection(n2, n);
                    if (bl) {
                        WindowHelper.postAlert((DetailedLog)new DetailedLog(3, "Failed to enable proactive protection on Router : " + platformNodeModel.getName()));
                    }
                }
            }.start();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new NoSuchInterface("PlimInterfaceModel: plim port not found.");
        }
    }

    public Object[] getTriggerThresholdsList() {
        IModuleModel iModuleModel = null;
        try {
            iModuleModel = this.getPortModel().getModuleModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return new Object[0];
        }
        if (iModuleModel != null) {
            Attribute[] attributeArray = ElementDefaults.getAttributeMap((IModel)iModuleModel).getAttributeArray("declFRRTriggerThreshold");
            Object[] objectArray = this.convertAttrArrayToObjectArray(attributeArray);
            return objectArray;
        }
        return new Object[0];
    }

    public Object[] getRevertThresholdsList() {
        IModuleModel iModuleModel = null;
        try {
            iModuleModel = this.getPortModel().getModuleModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return new Object[0];
        }
        if (iModuleModel != null) {
            Attribute[] attributeArray = ElementDefaults.getAttributeMap((IModel)iModuleModel).getAttributeArray("declFRRRevertThreshold");
            Object[] objectArray = this.convertAttrArrayToObjectArray(attributeArray);
            return objectArray;
        }
        return new Object[0];
    }

    private Object[] convertAttrArrayToObjectArray(Attribute[] attributeArray) {
        Object[] objectArray = new Object[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            objectArray[i] = attributeArray[i].getKey();
        }
        return objectArray;
    }

    private void notifyError(EID eID) {
        String string = ErrorMsg.getString((EID)eID, (Object)this.getNodeModel().getHostName());
        DetailedLog detailedLog = new DetailedLog(3, string);
        EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
    }
}

