/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.cn;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.IStateTransition;
import cerent.cms.model.ModelUpdateType;
import cerent.launcher.CmsClassLoader;
import cerent.util.DebugCategory;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.IDebugCategory;
import cerent.util.IDebugDiag;
import cerent.util.IOriginLevel;
import cerent.util.KDebug;
import cerent.util.OriginLevel;
import cerent.util.SDebug;
import cerent.util.SupplementalException;
import com.cisco.crs.model.PlatformNodeModel;

public class FSM
extends CmsObservable
implements IStateTransition {
    private PlatformNodeModel node;
    private Integer oldState;
    private Integer currentState;
    private Integer reasonForTransition;
    private Integer reasonForInternalTransition;
    private Exception fsmException;
    private FSMDebug dbFSM;

    public FSM(PlatformNodeModel platformNodeModel) {
        this.node = platformNodeModel;
        this.oldState = IStateTransition.UNINITIALIZED;
        this.currentState = IStateTransition.UNINITIALIZED;
        this.reasonForTransition = IStateTransition.UNINITIALIZED;
        this.reasonForInternalTransition = IStateTransition.UNINITIALIZED;
        this.fsmException = IStateTransition.NO_EXCEPTION;
        this.dbFSM = new FSMDebug(platformNodeModel.getDebug());
        if (this.dbFSM.on()) {
            this.dbFSM.println("FSM.FSM(): state=UNINITIALIZED");
        }
    }

    public void dispose() {
        if (this.dbFSM.on()) {
            this.dbFSM.println("FSM.dispose(): state=null");
        }
        this.dbFSM.dispose();
    }

    public Integer getCurrentState() {
        return this.currentState;
    }

    public Integer getOldState() {
        return this.oldState;
    }

    public Exception getException() {
        return this.fsmException;
    }

    public Integer getReasonForStateTransition() {
        return this.reasonForTransition;
    }

    private void doNotification() {
        if (this.dbFSM.on()) {
            this.dbFSM.println("FSM.doNotification(): oldState=" + FSM.toString(this.oldState) + " newState=" + FSM.toString(this.currentState) + " reason=" + FSM.toString(this.reasonForTransition) + (this.fsmException.equals(IStateTransition.NO_EXCEPTION) ? " (No except'n)" : " exception=" + this.fsmException.toString()));
        }
        this.setChanged();
        if (this.currentState == IStateTransition.DESTROYED) {
            this.notifyObservers(ModelUpdateType.DELETED);
        } else {
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
        if (this.dbFSM.on()) {
            this.dbFSM.println("FSM.doNotification exit.");
        }
    }

    public synchronized void setState(Integer n, Integer n2, Exception exception) {
        if (n == this.currentState) {
            this.reasonForInternalTransition = n2;
            this.reasonForTransition = n2;
            this.fsmException = exception;
        }
        if (n != this.currentState) {
            if (this.currentState == IStateTransition.INITED) {
                String string = "setState(): State changed from INITED, NewState=" + FSM.toString(n) + ",ReasonForTransition=" + FSM.toString(n2);
                SupplementalException supplementalException = new SupplementalException(string, exception, (IDebugCategory)DebugCategory.LOC_CATEGORY_TYPE, (IOriginLevel)OriginLevel.INTERNAL_ELE_LEVEL_TYPE, this.node.getNodeId());
                EventBus.instance().notifyEvent((Object)EventBusServices.SUPPLEMENTAL_EXCEPTION_PROCESSING, (Object)supplementalException);
                if (exception.equals(IStateTransition.NO_EXCEPTION)) {
                    this.dbFSM.severe(string + "(No except'n)");
                } else {
                    this.dbFSM.severe(string + " and corresponding Exception is -" + exception);
                }
                if (this.dbFSM.on()) {
                    if (exception.equals(IStateTransition.NO_EXCEPTION)) {
                        this.dbFSM.println("(No except'n)");
                    } else {
                        this.dbFSM.println("Exception: " + exception + " Printing Stack Trace:");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            } else if (this.dbFSM.on()) {
                this.dbFSM.println("FSM.setState(): NewState=" + FSM.toString(n) + ",ReasonForTransition=" + FSM.toString(n2));
            }
        }
        if (n != this.currentState && this.currentState != IStateTransition.DESTROYED) {
            this.oldState = this.currentState;
            this.currentState = n;
            this.reasonForTransition = n2;
            this.reasonForInternalTransition = null;
            this.fsmException = exception;
            this.node.updateFSM();
            this.doNotification();
        }
    }

    public void printStates() {
        if (this.dbFSM.on()) {
            this.dbFSM.print(this.toString());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FSM State info:");
        stringBuilder.append("\n\tnewState = ").append(FSM.toString(this.getCurrentState()));
        stringBuilder.append("\n\toldState = ").append(FSM.toString(this.getOldState()));
        stringBuilder.append("\n\treason = ").append(FSM.toString(this.getReasonForStateTransition()));
        if (this.fsmException.equals(IStateTransition.NO_EXCEPTION)) {
            stringBuilder.append("; (No except'n)");
        } else {
            stringBuilder.append("; exception = ").append(this.fsmException);
        }
        stringBuilder.append("; reasonForInternalTransition = ").append(FSM.toString(this.reasonForInternalTransition));
        return stringBuilder.toString();
    }

    public static String toString(Integer n) {
        if (n == null) {
            return null;
        }
        return FSM.toString((int)n);
    }

    public static String toString(int n) {
        String string = "Invalid Value";
        switch (n) {
            case 0: {
                string = "UNINITIALIZED";
                break;
            }
            case 2: {
                string = "INITED";
                break;
            }
            case 3: {
                string = "RETRY_INIT";
                break;
            }
            case 7: {
                string = "DESTROYED";
                break;
            }
            case 100: {
                string = "COMM_FAILURE";
                break;
            }
            case 102: {
                string = "CONNECTION_FAILURE";
                break;
            }
            case 105: {
                string = "RUNTIME_FAILURE";
                break;
            }
            case 108: {
                string = "DISPOSE";
                break;
            }
            case 109: {
                string = "SUCCESS";
                break;
            }
            default: {
                string = "Invalid Value";
            }
        }
        return string;
    }

    public class FSMDebug
    extends SDebug
    implements IDebugDiag {
        public FSMDebug(KDebug kDebug) {
            super(kDebug, "fsm");
        }

        public final void nodeInfo() {
            try {
                this.println("CRS-1/CTC Node Model");
                this.println("NodeId = " + FSM.this.node.getNodeId());
                this.println("Connected = " + FSM.this.node.getConnectionState());
                this.println("Current State FSM = " + FSM.toString(FSM.this.node.getFSM().getCurrentState()));
                this.println("Old State FSM = " + FSM.toString(FSM.this.node.getFSM().getOldState()));
                CmsClassLoader cmsClassLoader = (CmsClassLoader)FSM.this.node.getClass().getClassLoader();
                this.println("NMD class loader : " + cmsClassLoader);
                this.println("Node Software Version is : " + FSM.this.node.getSwVersion());
            }
            catch (Exception exception) {
                this.println("exception in NmdInfo()" + exception);
            }
        }

        public final void showFSM() {
            FSM.this.printStates();
        }

        public final void fsmInited() {
            FSM.this.setState(IStateTransition.INITED, IStateTransition.SUCCESS, IStateTransition.NO_EXCEPTION);
        }

        public final void fsmUninitialized() {
            FSM.this.setState(IStateTransition.UNINITIALIZED, IStateTransition.UNINITIALIZED, IStateTransition.NO_EXCEPTION);
        }

        public final void connectionFailure() {
            FSM.this.setState(IStateTransition.RETRY_INIT, IStateTransition.CONNECTION_FAILURE, IStateTransition.CONNECTION_FAILURE_EXCEPTION);
        }

        public final void communicationFailure() {
            FSM.this.setState(IStateTransition.RETRY_INIT, IStateTransition.COMM_FAILURE, IStateTransition.COMM_FAILURE_EXCEPTION);
        }

        public final void communicationFailureNoException() {
            FSM.this.setState(IStateTransition.RETRY_INIT, IStateTransition.COMM_FAILURE, IStateTransition.NO_EXCEPTION);
        }

        public final void initedCommunicationFailure() {
            FSM.this.setState(IStateTransition.INITED, IStateTransition.COMM_FAILURE, IStateTransition.COMM_FAILURE_EXCEPTION);
        }

        public void dumpDiag() {
            this.nodeInfo();
            this.showFSM();
        }
    }
}

