/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.cn;

import cerent.cms.model.IPoller;
import cerent.util.SDebug;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.cn.FSM;
import com.cisco.crs.model.cn.Poller;

public class PollerThread
extends Thread {
    private static final long POLLING_PERIOD = 30000L;
    private SDebug db;
    private Poller poller;
    private FSM fsm;

    public PollerThread(PlatformNodeModel platformNodeModel) {
        super("Poller for " + platformNodeModel.getName());
        this.db = platformNodeModel.getDebug();
        this.poller = new Poller(platformNodeModel);
        this.fsm = platformNodeModel.getFSM();
    }

    public IPoller getPoller() {
        return this.poller;
    }

    private long getPollingPeriod() {
        return 30000L;
    }

    private synchronized void pause() {
        block2: {
            try {
                this.wait(this.getPollingPeriod());
            }
            catch (InterruptedException interruptedException) {
                if (!this.db.isFinestEnabled()) break block2;
                SDebug.printStackTrace((Throwable)interruptedException);
            }
        }
    }

    public void doDestroy() {
        this.poller.dispose();
        this.poller = null;
    }

    @Override
    public void run() {
        this.db.fine("PollerThread.run(): Default Poller run()");
        while (this.poller != null) {
            try {
                if (this.poller.poll()) {
                    if (this.db.on()) {
                        this.db.println("Polling succeeded");
                    }
                } else if (this.db.on()) {
                    this.db.println("Polling failed");
                }
                this.pause();
            }
            catch (Throwable throwable) {
                this.db.fine("Caught an Exception in the poller thread");
                if (!this.db.isFinestEnabled()) continue;
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
        this.db.fine("PollerThread.run():pollerThread exiting, w FSM state:");
        this.fsm.printStates();
    }
}

