/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.core;

import cerent.cms.model.CmsObservable;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.crs.model.CLICommandFailure;
import com.cisco.crs.model.CLICommander;
import com.cisco.crs.model.core.CLIParserError;
import com.cisco.crs.model.core.CLIResponse;
import com.cisco.crs.model.core.CachedValue;
import com.cisco.crs.model.core.ICLIAdapter;
import com.cisco.crs.model.core.IValue;
import com.cisco.crs.model.core.Value;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class NonCachedValue
extends CmsObservable
implements IValue {
    private ICLIAdapter cliAdapter;
    protected Value value;
    protected SDebug db;

    public NonCachedValue(ICLIAdapter iCLIAdapter) {
        this.cliAdapter = iCLIAdapter;
        this.db = new SDebug((KDebug)iCLIAdapter.getNMD().getDebug(), iCLIAdapter.getLabel());
        this.db.addCommand(this, "dumpValue", "Dump Value attributes");
        this.value = new Value(this.db);
    }

    public final void dumpValue() {
        boolean bl = this instanceof CachedValue;
        String string = this.cliAdapter.getClass().getSimpleName();
        this.db.println("Dump " + (bl ? "cached " : "non cached ") + "value for " + string);
        this.db.println("Current value: " + this.value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.value.getLastUpdateMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d/yy h:mm:ss.SSS");
        this.db.println("Last update: " + simpleDateFormat.format(calendar.getTime()));
    }

    @Override
    public Value get() throws CLICommandFailure, CLIParserError {
        String string;
        if (this.db.isFinestEnabled()) {
            this.db.println("get() for: " + this.cliAdapter.getCLICommand());
        }
        CLICommander cLICommander = this.cliAdapter.getNMD().getCLICommander();
        try {
            string = cLICommander.sendCommand(this.cliAdapter.getCLICommand());
        }
        catch (CLICommandFailure cLICommandFailure) {
            if (this.db.on()) {
                this.db.println("Received CLICommandFailure: " + cLICommandFailure.getMessage());
            }
            throw cLICommandFailure;
        }
        try {
            CLIResponse cLIResponse = this.cliAdapter.getParser().parseResponse(string);
            if (this.db.isFinestEnabled()) {
                this.db.println("get() newValue is: " + (cLIResponse != null ? cLIResponse.prettyString() : null));
            }
            this.value.update(cLIResponse);
        }
        catch (CLIParserError cLIParserError) {
            if (this.db.on()) {
                this.db.println("Received CLIParserError: " + cLIParserError.getMessage());
            }
            throw cLIParserError;
        }
        return this.value;
    }

    @Override
    public void dispose() {
        this.value.dispose();
        super.destroy();
    }

    protected ICLIAdapter getCLIAdapter() {
        return this.cliAdapter;
    }
}

