/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.core;

import cerent.util.SDebug;
import com.cisco.crs.model.core.CLIResponse;
import com.cisco.crs.model.core.MultipleCLIResponse;

public class Value {
    private CLIResponse value;
    private long lastUpdateMillis;
    private SDebug db;

    public Value(SDebug sDebug) {
        this.db = sDebug;
        this.lastUpdateMillis = System.currentTimeMillis();
    }

    public boolean isNull() {
        return this.value == null;
    }

    public CLIResponse get() {
        return this.value;
    }

    public boolean update(CLIResponse cLIResponse) {
        if (this.isNull()) {
            if (this.db.isFinestEnabled()) {
                this.db.println("update: value was null - updating cache");
            }
            this.doUpdate(cLIResponse);
            return true;
        }
        if (cLIResponse.isGrouping()) {
            CLIResponse[] cLIResponseArray;
            CLIResponse[] cLIResponseArray2 = this.value.getResponses();
            if (cLIResponseArray2.length != (cLIResponseArray = cLIResponse.getResponses()).length) {
                throw new IllegalAccessError("Current and new value have different number of grouped responses: " + cLIResponseArray2.length + " != " + cLIResponseArray.length);
            }
            MultipleCLIResponse multipleCLIResponse = (MultipleCLIResponse)this.value;
            boolean bl = false;
            for (int i = 0; i < cLIResponseArray.length; ++i) {
                CLIResponse cLIResponse2 = cLIResponseArray2[i];
                CLIResponse cLIResponse3 = cLIResponseArray[i];
                if (cLIResponse2.isEqual(cLIResponse3)) continue;
                if (this.db.isFinestEnabled()) {
                    this.db.println("update: inner value at index " + i + "changed - updating cache");
                }
                multipleCLIResponse.update(i, cLIResponse3);
                bl = true;
            }
            if (bl) {
                this.lastUpdateMillis = System.currentTimeMillis();
                return true;
            }
        } else if (!this.value.isEqual(cLIResponse)) {
            if (this.db.isFinestEnabled()) {
                this.db.println("update: value changed - updating cache");
            }
            this.doUpdate(cLIResponse);
            return true;
        }
        return false;
    }

    private void doUpdate(CLIResponse cLIResponse) {
        if (this.db.isFinestEnabled()) {
            this.db.println("doUpdate: new value is " + cLIResponse);
        }
        this.value = cLIResponse;
        this.lastUpdateMillis = System.currentTimeMillis();
    }

    public long getLastUpdateMillis() {
        return this.lastUpdateMillis;
    }

    public void dispose() {
        this.value = null;
        this.lastUpdateMillis = System.currentTimeMillis();
    }

    public String toString() {
        if (this.isNull()) {
            return "null";
        }
        return this.value.prettyString();
    }
}

