/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310cl.ui.shelf;

import cerent.cms.model.IChassisModel;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.util.gui.IconImpl;
import com.cisco.ctc310cl.ui.shelf.CardPainter;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShelfLayout
extends AbstractShelfLayout {
    static final int SHELF_SLOT_COUNT = 2;
    static final Font TEXT_FONT = new Font("Arial", 0, 10);
    static int[] slot2x = new int[]{0, 1};
    static int[] slot2y = new int[]{0, 0};
    protected static JPanel rightLabelsPanel;

    public ShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        super(iChassisModel, shelfViewController);
    }

    @Override
    public int getShelfSlotCount() {
        return 2;
    }

    @Override
    protected Font getTextFont() {
        return TEXT_FONT;
    }

    @Override
    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = new JPanel(new GridLayout(1, 1, 0, 0));
            rightLabelsPanel = new JPanel(new GridLayout(1, 1, 0, 0));
            Dimension dimension = new Dimension(10, 12);
            this.labels = new JLabel[2];
            for (int i = 0; i < this.cards.length; ++i) {
                JLabel jLabel = new JLabel();
                jLabel.setFont(TEXT_FONT);
                jLabel.setPreferredSize(dimension);
                jLabel.setMinimumSize(dimension);
                jLabel.setHorizontalAlignment(0);
                if (i == 0) {
                    jLabel.setText("" + (i + 1));
                    this.labels[i] = jLabel;
                    this.labelsPanel.add(jLabel);
                    continue;
                }
                jLabel.setText("" + (i + 1));
                this.labels[i] = jLabel;
                rightLabelsPanel.add(jLabel);
            }
        }
    }

    @Override
    protected void createFanPanel() {
    }

    @Override
    protected void createSlotsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.slotsPanel = new JPanel(gridBagLayout);
        Dimension dimension = new Dimension(600, 80);
        this.slotsPanel.setMinimumSize(dimension);
        for (int i = 0; i < 2; ++i) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = slot2x[i];
            gridBagConstraints.gridy = slot2y[i];
            IconImpl iconImpl = new IconImpl(CardPainter.getSlotDim(i + 1));
            this.cards[i] = new CardPanel(iconImpl, this);
            this.cards[i].setFont(TEXT_FONT);
            this.cards[i].addMouseListener(this.mouseListener);
            gridBagLayout.setConstraints(this.cards[i], gridBagConstraints);
            this.slotsPanel.add(this.cards[i]);
        }
    }

    @Override
    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(rightLabelsPanel, gridBagConstraints);
        this.add(rightLabelsPanel);
    }

    @Override
    protected void removeLabels() {
        this.remove(this.labelsPanel);
        this.remove(rightLabelsPanel);
    }

    @Override
    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
    }

    protected Dimension getSlotDim(int n) {
        return CardPainter.getSlotDim(n);
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

