/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310masdh;

import cerent.cms.IPlatform;
import cerent.cms.ReferencePlatform;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import com.cisco.ctc310masdh.model.AlarmDecoderDefs;
import com.cisco.ctc310masdh.model.nedefaults.NodeDefaults;
import com.cisco.ctc310masdh.model.vf.Blsr2FiberVersionedFeature;
import com.cisco.ctc310masdh.model.vf.Blsr4FiberVersionedFeature;
import com.cisco.ctc310masdh.ui.CardViewPanel;
import com.cisco.ctc310masdh.ui.PlatformCardTabbedViewFactory;
import com.cisco.ctc310masdh.ui.network.IconStore;
import com.cisco.ctc310masdh.ui.shelf.CardFactory;
import com.cisco.ctc310masdh.ui.shelf.CardPainter;
import com.cisco.ctc310masdh.ui.shelf.ShelfLayout;
import com.cisco.ctc310masdh.ui.shelf.ShelfMaintenancePane;
import com.cisco.ctc310masdh.ui.shelf.ShelfProvPane;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Platform
extends ReferencePlatform {
    private static final int[] supportedXcCardEqTypes = new int[]{232};
    private static final LANAccessMode[] LAN_ACCESS_MODE = new LANAccessMode[]{LANAccessMode.DCC_ONLY, LANAccessMode.FRONT_ONLY, LANAccessMode.BACKPLANE_ONLY, LANAccessMode.FRONT_BACKPLANE};
    private static final HashMap versionedFeatureMap = new HashMap();
    private static final int[] vwMasks;
    private static final int XCON_A_SLOT = 3;
    private static final int XCON_B_SLOT = 4;
    private static final int XCON_A_SLOT_INDEX = 12288;
    private static final int XCON_B_SLOT_INDEX = 16384;
    private static final int XCON_A_INDEX = 12289;
    private static final int XCON_B_INDEX = 16385;
    private static final String[] pmColumnNames;
    private static final Map opticalLoopbackMap;
    private static final Map timingModeMap;
    private static Platform instance;

    public static IPlatform instance() {
        return instance;
    }

    private Platform() {
    }

    @Override
    public boolean is310maSDH() {
        return true;
    }

    @Override
    public boolean suppressPortGroupingCkt() {
        return true;
    }

    @Override
    public boolean supportsEthernetDropAndContinueOnCE2() {
        return true;
    }

    @Override
    public Image[] getIcons(NodeModelDelegate nodeModelDelegate) {
        return IconStore.getIcons(nodeModelDelegate);
    }

    @Override
    public CardTabbedViewFactory getCardTabbedViewFactory() {
        return PlatformCardTabbedViewFactory.instance();
    }

    @Override
    public AbstractCardViewPanel getCardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        return new CardViewPanel(moduleModel, cardViewController);
    }

    @Override
    public CardGraphic createCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        return CardFactory.createCard(entityModel, abstractShelfLayout);
    }

    @Override
    public ICardPainter getCardPainter(CardGraphic cardGraphic) {
        return new CardPainter(cardGraphic);
    }

    @Override
    public AbstractShelfLayout getShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        return new ShelfLayout(iChassisModel, shelfViewController);
    }

    @Override
    public AbstractShelfProvPane getShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        return new ShelfProvPane(string, tabbedView, iGuestPaneFactory);
    }

    @Override
    public AbstractShelfMaintenancePane getShelfMaintenancePane(String string, TabbedView tabbedView) {
        return new ShelfMaintenancePane(string, tabbedView);
    }

    @Override
    public AbstractVersionedFeature getVersionedFeature(Feature feature) {
        return (AbstractVersionedFeature)versionedFeatureMap.get(feature);
    }

    @Override
    public String[] getSonetMonTypeNames() {
        return AlarmDecoderDefs.getSonetMonTypeNames();
    }

    @Override
    public String[] getSdhMonTypeNames() {
        return AlarmDecoderDefs.getSdhMonTypeNames();
    }

    @Override
    public Map[] getEqTypeNameMapsForDefaults() {
        return NodeDefaults.getEqTypeNameMaps();
    }

    @Override
    public Object[][] getDefaultsList(String string) {
        return NodeDefaults.getDefaultsList(string);
    }

    @Override
    public Object[] getListOfDefaultsLists() {
        return NodeDefaults.getListOfDefaultsLists();
    }

    @Override
    public Map getTimingModeAttributeMap() {
        return timingModeMap;
    }

    @Override
    public Map getLoopbackAttributeMap() {
        return opticalLoopbackMap;
    }

    @Override
    public String[] getPmColumnNames() {
        return pmColumnNames;
    }

    @Override
    public int[] getVwMasks() {
        return vwMasks;
    }

    @Override
    public int[] getOsiModes() {
        int[] nArray = new int[]{0, 1};
        return nArray;
    }

    @Override
    public int getXconASlot() {
        return 3;
    }

    @Override
    public int getXconBSlot() {
        return 4;
    }

    @Override
    public int getXconASlotIndex() {
        return 12288;
    }

    @Override
    public int getXconBSlotIndex() {
        return 16384;
    }

    @Override
    public int getXconAIndex() {
        return 12289;
    }

    @Override
    public int getXconBIndex() {
        return 16385;
    }

    @Override
    public int[] getSupportedXcCardEqTypes() {
        return supportedXcCardEqTypes;
    }

    @Override
    public LANAccessMode[] getSupportedLanAccessModes() {
        return LAN_ACCESS_MODE;
    }

    @Override
    public String getPlatformName() {
        return "15310 MA";
    }

    @Override
    public boolean supportsXCSwitchOperations() {
        return false;
    }

    @Override
    public String getXconCardName() {
        return "CTX-2500";
    }

    @Override
    public String getReprovisioningScopeForDefaults() {
        return "These include the General, Network, PowerMonitor, Security and Timing attributes.";
    }

    @Override
    public boolean supportsTdmInfo() {
        return false;
    }

    @Override
    public boolean isBlsrProtectionSupport() {
        return false;
    }

    @Override
    public String getControlCardName() {
        return "CTX-2500";
    }

    @Override
    public boolean hasDccTunneling() {
        return false;
    }

    @Override
    public boolean isPotentiallyLcdIpCapable() {
        return false;
    }

    @Override
    public int getBiggestStitchedEtherPath() {
        return 2;
    }

    @Override
    public boolean Oc3SupportsLDC() {
        return true;
    }

    @Override
    public boolean isE1TimingSupported() {
        return true;
    }

    public boolean supportsE1Timing(int n) {
        return true;
    }

    public boolean supportsCompleteE1TimingOptions(int n) {
        return n == 234 || n == 233;
    }

    @Override
    public boolean supportsE1AutoProvision() {
        return true;
    }

    @Override
    public boolean supportsDs3eAutoProvision() {
        return false;
    }

    @Override
    public boolean isUcpUnicCapable() {
        return false;
    }

    @Override
    public boolean supportsDWDM() {
        return false;
    }

    @Override
    protected int[] eqTypesWithoutUniqueNames() {
        int[] nArray = new int[]{163, 284};
        return nArray;
    }

    @Override
    public boolean supportsTdmTransceiver(int n) {
        return n == 232;
    }

    @Override
    public boolean allowsManualXcSwitching() {
        return false;
    }

    @Override
    public boolean supportsJ2PathTraceOnEc1() {
        return false;
    }

    @Override
    public boolean supportsServerTrail() {
        return true;
    }

    public boolean supportsRpr() {
        return false;
    }

    @Override
    public boolean supportsE1ImpedenceSetting() {
        return true;
    }

    static {
        versionedFeatureMap.put(Feature.BLSR_2F_VERSIONING, new Blsr2FiberVersionedFeature());
        versionedFeatureMap.put(Feature.BLSR_4F_VERSIONING, new Blsr4FiberVersionedFeature());
        vwMasks = new int[]{8, 4, 2, 1};
        pmColumnNames = new String[]{"Param", "Curr", "Prev", "Prev-1", "Prev-2", "Prev-3", "Prev-4", "Prev-5", "Prev-6", "Prev-7", "Prev-8", "Prev-9", "Prev-10", "Prev-11", "Prev-12", "Prev-13", "Prev-14", "Prev-15", "Prev-16", "Prev-17", "Prev-18", "Prev-19", "Prev-20", "Prev-21", "Prev-22", "Prev-23", "Prev-24", "Prev-25", "Prev-26", "Prev-27", "Prev-28", "Prev-29", "Prev-30", "Prev-31"};
        opticalLoopbackMap = new TreeMap();
        timingModeMap = new TreeMap();
        Platform.putAttribute(opticalLoopbackMap, 0, "None");
        Platform.putAttribute(opticalLoopbackMap, 1, "Terminal (Inward)");
        Platform.putAttribute(opticalLoopbackMap, 2, "Facility (Line)");
        Platform.putAttribute(timingModeMap, 0, "External");
        Platform.putAttribute(timingModeMap, 1, "Line");
        Platform.putAttribute(timingModeMap, 2, "Mixed");
        instance = new Platform();
    }
}

