/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310masdh.ui.shelf;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.MfgData;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;

public class CardPainter
implements ICardPainter {
    private static final float CARD_H_TO_CARD_W_RATIO = 4.1666665f;
    private static final float PORT_W_TO_CARD_W_RATIO = 0.23529412f;
    private static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.31111112f;
    private static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    static final float CONTROLLER_Y_OFFSET_TO_CARD_H_RATIO = 0.55f;
    public static final int CARD_WIDTH = 60;
    public static final int CARD_HEIGHT = Math.round(249.99998f);
    public static final int PORT_WIDTH = Math.round(14.117647f);
    public static final int PORT_HEIGHT = Math.round((float)PORT_WIDTH * 1.5f);
    public static final int SMALL_PORT_HEIGHT = PORT_WIDTH;
    private static final int PORT_LOOPBACK_DIST = 3;
    private static final int PORT_CONN1_X;
    private static final int PORT_CONN2_X;
    private static final int PORT_CONN1_Y;
    private static final int PORT_CONN2_Y;
    private static final int SMALL_PORT_CONN1_Y;
    private static final int SMALL_PORT_CONN2_Y;
    static final int OPTICON_X_OFFSET;
    private static final int MULTIPORT_OPTICON_X_OFFSET;
    static final int OPTICON_Y_OFFSET;
    static final int CONTROLLER_OPTICON_Y_OFFSET;
    private static final int HEIGHT;
    protected static final int LAN_WIDTH = 15;
    private static final float RECT_H_TO_CARD_H_RATIO = 0.006818182f;
    private static final float RECT_OFFSET_TO_CARD_H_RATIO = 0.2f;
    private static final float BOTTOM_RECT_OFFSET_TO_CARD_H_RATIO = 0.8636364f;
    private static final float NAME_X_OFFSET_TO_CARD_W_RATIO = 0.083333336f;
    private static final float NAME_Y_OFFSET_TO_CARD_H_RATIO = 0.15384616f;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.2347826f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.25f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.01632653f;
    private static final float ACTIVE_LIGHT_NAME_X_OFFSET_TO_CARD_W_RATIO = 0.41666666f;
    private static final int RECT_HEIGHT;
    private static final int RECT_OFFSET;
    private static final int TOP_RECT_OFFSET;
    private static final int TOP_RECT_HEIGHT;
    private static final int BOTTOM_RECT_OFFSET;
    private static final int BOTTOM_RECT_HEIGHT;
    protected static final int TAB_MARGIN = 2;
    private static final int NAME_X_OFFSET;
    protected static final int NAME_Y_OFFSET;
    private static final int ACTIVE_LIGHT_Y_OFFSET;
    private static final int ACTIVE_LIGHT_NAME_X_OFFSET;
    private static final int ACTIVE_LIGHT_WIDTH;
    private static final int ACTIVE_LIGHT_HEIGHT;
    private static final int OPTICON_X_SPACING = 0;
    static final int OPTICON_Y_SPACING;
    static final int SMALL_OPTICON_Y_SPACING;
    static final int RJ45_Y_SPACING;
    static final int CONTROLLER_OPTICON_Y_SPACING;
    private static final int MINI_PORT_WIDTH;
    private static final int MINI_PORT_HEIGHT;
    private static final int MINI_MULTIPORT_OPTICON_X_OFFSET;
    private static final int MINI_OPTICON_Y_OFFSET;
    private static final int MINI_OPTICON_X_SPACING = 0;
    static final int MINI_OPTICON_Y_SPACING;
    private static final float[] dash1;
    private final int WIDTH;
    private final Rectangle topRectangle;
    private final Rectangle bottomRectangle;
    private final Rectangle mainRectangle;
    protected CardGraphic cg;
    private Rectangle topBackgroundRectangle;
    private Rectangle bottomBackgroundRectangle;

    public CardPainter(CardGraphic cardGraphic) {
        this.cg = cardGraphic;
        this.WIDTH = cardGraphic.getSlotsOccupied() * 60;
        this.topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        this.bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        int n = 60;
        this.topBackgroundRectangle = new Rectangle(0, 0, n, TOP_RECT_HEIGHT);
        this.bottomBackgroundRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, n, HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, HEIGHT);
    }

    @Override
    public void updateWidth() {
    }

    @Override
    public int getOpticonXOffset() {
        return OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonYOffset() {
        if (this.cg.getEqType() == 232) {
            return CONTROLLER_OPTICON_Y_OFFSET;
        }
        return OPTICON_Y_OFFSET;
    }

    @Override
    public int getMultiPortOpticonXOffset() {
        return MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getOpticonYSpacing() {
        return OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniMultiPortOticonXOffset() {
        return MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getCardWidth() {
        return 60;
    }

    @Override
    public int getCardHeight() {
        return CARD_HEIGHT;
    }

    @Override
    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    @Override
    public int getPortWidth() {
        return PORT_WIDTH;
    }

    @Override
    public int getPortHeight() {
        return PORT_HEIGHT;
    }

    @Override
    public int getMiniPortWidth() {
        return MINI_PORT_WIDTH;
    }

    @Override
    public int getMiniPortHeight() {
        return MINI_PORT_HEIGHT;
    }

    @Override
    public int getMiniOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getMiniOpticonYSpacing() {
        return MINI_OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniOpticonYOffset() {
        return MINI_OPTICON_Y_OFFSET;
    }

    @Override
    public int getSmallMiniPortWidth() {
        return 0;
    }

    @Override
    public int getSmallMiniPortHeight() {
        return 0;
    }

    @Override
    public int getSmallMiniOpticonYSpacing() {
        return 0;
    }

    @Override
    public int getSmallMiniOpticonYOffset() {
        return 0;
    }

    @Override
    public int getSmallerPortConn1Y() {
        return 0;
    }

    @Override
    public int getSmallerPortConn2Y() {
        return 0;
    }

    @Override
    public int getPortX(int n, int n2) {
        return MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    @Override
    public int getPortY(int n, int n2) {
        if (n == 0) {
            return OPTICON_Y_OFFSET + OPTICON_Y_SPACING * n2;
        }
        return OPTICON_Y_OFFSET + SMALL_OPTICON_Y_SPACING * n2;
    }

    @Override
    public int getSmallPortWidth() {
        return 0;
    }

    @Override
    public int getSmallPortHeight() {
        return SMALL_PORT_HEIGHT;
    }

    @Override
    public int getPortConn1X() {
        return PORT_CONN1_X;
    }

    @Override
    public int getPortConn2X() {
        return PORT_CONN2_X;
    }

    @Override
    public int getPortConn1Y() {
        return PORT_CONN1_Y;
    }

    @Override
    public int getPortConn2Y() {
        return PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1Y() {
        return SMALL_PORT_CONN1_Y;
    }

    @Override
    public int getSmallPortConn2Y() {
        return SMALL_PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1X() {
        return 0;
    }

    @Override
    public int getSmallPortConn2X() {
        return 0;
    }

    @Override
    public int getPortLoopbackDist() {
        return 3;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        this.paintActual(graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.setColor(Color.black);
        int n3 = this.cg.getState();
        String string = "";
        Color color = graphics2D.getColor();
        Color color2 = this.cg.getCurrentColor();
        switch (n3) {
            case 5: {
                string = "Act";
                color2 = Color.green;
                break;
            }
            case 4: {
                string = "Sby";
                color2 = Color.yellow;
                break;
            }
            case 2: {
                string = "Ldg";
                color2 = Color.white;
                break;
            }
            case 3: {
                string = "Fail";
                break;
            }
            case 1: {
                string = "Mis";
                break;
            }
            case 0: {
                string = "NP";
                break;
            }
            case 6: {
                string = "Del";
                break;
            }
        }
        graphics2D.setColor(Color.black);
        Font font = graphics.getFont();
        graphics2D.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 5));
        graphics2D.drawString(string, ACTIVE_LIGHT_NAME_X_OFFSET, ACTIVE_LIGHT_Y_OFFSET + ACTIVE_LIGHT_HEIGHT);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        graphics2D.setColor(color2);
        graphics2D.fillRect(60 - ACTIVE_LIGHT_WIDTH - 2, ACTIVE_LIGHT_Y_OFFSET, ACTIVE_LIGHT_WIDTH, ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(60 - ACTIVE_LIGHT_WIDTH - 2, ACTIVE_LIGHT_Y_OFFSET, ACTIVE_LIGHT_WIDTH, ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(this.topRectangle);
        graphics2D.draw(this.bottomRectangle);
        graphics2D.setColor(Color.black);
        String string2 = this.cg.getEqLabel();
        if (string2.length() > 4) {
            String string3;
            graphics2D.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 4));
            font = graphics2D.getFont();
            FontMetrics fontMetrics2 = component.getFontMetrics(font);
            int n4 = fontMetrics2.getAscent();
            String string4 = string2;
            String string5 = "";
            String string6 = "";
            int n5 = n2 + NAME_Y_OFFSET;
            int n6 = string2.length();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
            if (string2.startsWith("DS3_EC1")) {
                string4 = string3 = string2.replace('_', '-');
            } else if (string2.startsWith("E1")) {
                string3 = string2.replace('_', '-');
                string4 = string3.substring(0, 5);
                string5 = string3.substring(6, n6);
            } else if (string2.startsWith("CTX_2")) {
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
            } else if (string2.startsWith("ML")) {
                string4 = string2.substring(0, 2);
                string5 = string2.substring(3, n6);
            } else if (string2.startsWith("CE")) {
                string4 = string2.substring(0, 2);
                string5 = string2.substring(3, n6);
            }
            if (string5.length() != 0 && string6.length() != 0) {
                n5 -= n4;
            }
            int n7 = fontMetrics2.stringWidth(string4);
            graphics2D.drawString(string4, (n + 60 - n7) / 2, n5);
            if (string5.length() > 0) {
                n7 = fontMetrics2.stringWidth(string5);
                graphics2D.drawString(string5, (n + 60 - n7) / 2, n5 += n4);
            }
            if (string6.length() > 0) {
                n7 = fontMetrics2.stringWidth(string6);
                graphics2D.drawString(string6, (n + 60 - n7) / 2, n5 += n4);
            }
        } else if (string2 != null) {
            int n8 = 0;
            if (string2.startsWith("UNK")) {
                n8 = -1;
            }
            graphics2D.drawString(string2, n + NAME_X_OFFSET + n8, n2 + NAME_Y_OFFSET);
        }
        graphics2D.setStroke(stroke);
    }

    public void paintActual(Graphics2D graphics2D) {
        int n = this.cg.getState();
        int n2 = this.cg.getSlot();
        int n3 = this.cg.getSlotsOccupied();
        String string = null;
        int n4 = 60;
        boolean bl = false;
        try {
            IEntityModel iEntityModel = this.cg.getModel();
            if (iEntityModel instanceof MfgEntityModel) {
                string = new MfgData(((MfgEntityModel)iEntityModel).getMfgData()).getName();
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        for (int i = 0; i < n3; ++i) {
            block10: {
                block12: {
                    block11: {
                        block9: {
                            bl = false;
                            this.topBackgroundRectangle = new Rectangle(i * n4, 0, n4, TOP_RECT_OFFSET);
                            this.bottomBackgroundRectangle = new Rectangle(i * n4, BOTTOM_RECT_OFFSET, n4, HEIGHT);
                            if (string == null || !string.equals("FILLER")) break block9;
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(this.topBackgroundRectangle);
                            graphics2D.fill(this.bottomBackgroundRectangle);
                            bl = true;
                            break block10;
                        }
                        if (i != 0) break block11;
                        if (this.cg.getState() == 1 && this.cg.hasProvisionedCard()) break block12;
                    }
                    if (i <= 0 || string == null) break block10;
                }
                graphics2D.setColor(Color.lightGray);
                bl = true;
            }
            if (!bl) continue;
            if (i > 0) {
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.draw(this.mainRectangle);
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics2D.setColor(Color.gray);
                graphics2D.setColor(Color.black);
                continue;
            }
            graphics2D.setColor(Color.black);
        }
    }

    public static void paintRJ45(Graphics2D graphics2D, String string, int n, int n2) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, PORT_WIDTH, PORT_WIDTH);
        graphics2D.draw(double_);
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(7.0f);
        graphics2D.setFont(font2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.stringWidth(string);
        graphics2D.drawString(string, n + (PORT_WIDTH - n4) / 2 + 1, n2 + PORT_WIDTH + 8);
        graphics2D.setFont(font);
    }

    static {
        PORT_CONN2_X = PORT_CONN1_X = PORT_WIDTH / 2;
        PORT_CONN1_Y = PORT_HEIGHT / 3;
        PORT_CONN2_Y = PORT_CONN1_Y * 2;
        SMALL_PORT_CONN1_Y = SMALL_PORT_HEIGHT / 3;
        SMALL_PORT_CONN2_Y = SMALL_PORT_CONN1_Y * 2;
        OPTICON_X_OFFSET = (60 - PORT_WIDTH) / 2;
        MULTIPORT_OPTICON_X_OFFSET = (60 - PORT_WIDTH) / 2;
        OPTICON_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.31111112f);
        CONTROLLER_OPTICON_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.55f);
        HEIGHT = CARD_HEIGHT;
        RECT_HEIGHT = Math.round((float)CARD_HEIGHT * 0.006818182f);
        TOP_RECT_OFFSET = RECT_OFFSET = Math.round((float)CARD_HEIGHT * 0.2f);
        TOP_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_RECT_OFFSET = Math.round((float)CARD_HEIGHT * 0.8636364f);
        BOTTOM_RECT_HEIGHT = RECT_HEIGHT;
        NAME_X_OFFSET = Math.round(5.0f) - 1;
        NAME_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.15384616f);
        ACTIVE_LIGHT_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.2347826f);
        ACTIVE_LIGHT_NAME_X_OFFSET = Math.round(25.0f);
        ACTIVE_LIGHT_WIDTH = Math.round(15.0f) - 1;
        ACTIVE_LIGHT_HEIGHT = Math.round((float)CARD_HEIGHT * 0.01632653f);
        OPTICON_Y_SPACING = Math.round((float)CARD_HEIGHT * 0.11363637f);
        SMALL_OPTICON_Y_SPACING = Math.round((float)((double)((float)CARD_HEIGHT * 0.11363637f) * 0.75));
        RJ45_Y_SPACING = Math.round((float)((double)((float)CARD_HEIGHT * 0.11363637f) * 0.4));
        CONTROLLER_OPTICON_Y_SPACING = Math.round((float)((double)((float)CARD_HEIGHT * 0.11363637f) * 0.5));
        MINI_PORT_WIDTH = PORT_WIDTH;
        MINI_PORT_HEIGHT = Math.round(10.588236f);
        MINI_MULTIPORT_OPTICON_X_OFFSET = (60 - MINI_PORT_WIDTH) / 2;
        MINI_OPTICON_Y_OFFSET = OPTICON_Y_OFFSET - 5;
        MINI_OPTICON_Y_SPACING = MINI_PORT_HEIGHT + 5;
        dash1 = new float[]{1.5f};
    }
}

