/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455;

import cerent.cms.IPlatform;
import cerent.cms.ReferencePlatform;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.SDHTDMTerminology;
import cerent.util.TDMTerminology;
import com.cisco.ctc455.model.AlarmDecoderDefs;
import com.cisco.ctc455.model.nedefaults.NodeDefaults;
import com.cisco.ctc455.model.vf.Blsr2FiberVersionedFeature;
import com.cisco.ctc455.model.vf.Blsr4FiberVersionedFeature;
import com.cisco.ctc455.ui.PlatformCardTabbedViewFactory;
import com.cisco.ctc455.ui.network.IconStore;
import com.cisco.ctc455.ui.shelf.ShelfMaintenancePane;
import com.cisco.ctc455.ui.shelf.ShelfProvPane;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Platform
extends ReferencePlatform {
    private static final int[] supportedXcCardEqTypes = new int[]{59, 43, 3, 84, 107, 216, 217};
    private static final LANAccessMode[] LAN_ACCESS_MODE = new LANAccessMode[]{LANAccessMode.DCC_ONLY, LANAccessMode.FRONT_ONLY, LANAccessMode.BACKPLANE_ONLY, LANAccessMode.FRONT_BACKPLANE};
    private static final HashMap versionedFeatureMap = new HashMap();
    private static final int[] vwMasks;
    private static final int XCON_A_SLOT = 8;
    private static final int XCON_B_SLOT = 10;
    private static final int XCON_A_SLOT_INDEX = 32768;
    private static final int XCON_B_SLOT_INDEX = 40960;
    private static final int XCON_A_INDEX = 32769;
    private static final int XCON_B_INDEX = 40961;
    private static final String[] pmColumnNames;
    private static final Map opticalLoopbackMap;
    private static final Map timingModeMap;
    private static final int AICI_PORT_IO_MIN = 35;
    private static Platform instance;

    public static IPlatform instance() {
        return instance;
    }

    private Platform() {
    }

    @Override
    public boolean is455() {
        return true;
    }

    @Override
    public TDMTerminology getTDMTerminology() {
        return SDHTDMTerminology.instance();
    }

    @Override
    public Image[] getIcons(NodeModelDelegate nodeModelDelegate) {
        return IconStore.getIcons(nodeModelDelegate);
    }

    @Override
    public CardTabbedViewFactory getCardTabbedViewFactory() {
        return PlatformCardTabbedViewFactory.instance();
    }

    @Override
    public AbstractShelfProvPane getShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        return new ShelfProvPane(string, tabbedView, iGuestPaneFactory);
    }

    @Override
    public AbstractShelfMaintenancePane getShelfMaintenancePane(String string, TabbedView tabbedView) {
        return new ShelfMaintenancePane(string, tabbedView);
    }

    @Override
    public AbstractVersionedFeature getVersionedFeature(Feature feature) {
        return (AbstractVersionedFeature)versionedFeatureMap.get(feature);
    }

    @Override
    public String[] getSonetMonTypeNames() {
        return AlarmDecoderDefs.getSonetMonTypeNames();
    }

    @Override
    public String[] getSdhMonTypeNames() {
        return AlarmDecoderDefs.getSdhMonTypeNames();
    }

    @Override
    public Map[] getEqTypeNameMapsForDefaults() {
        return NodeDefaults.getEqTypeNameMaps();
    }

    @Override
    public Object[][] getDefaultsList(String string) {
        return NodeDefaults.getDefaultsList(string);
    }

    @Override
    public Object[] getListOfDefaultsLists() {
        return NodeDefaults.getListOfDefaultsLists();
    }

    @Override
    public Map getTimingModeAttributeMap() {
        return timingModeMap;
    }

    @Override
    public Map getLoopbackAttributeMap() {
        return opticalLoopbackMap;
    }

    @Override
    public String[] getPmColumnNames() {
        return pmColumnNames;
    }

    @Override
    public int[] getVwMasks() {
        return vwMasks;
    }

    @Override
    public int getXconASlot() {
        return 8;
    }

    @Override
    public int getXconBSlot() {
        return 10;
    }

    @Override
    public int getXconASlotIndex() {
        return 32768;
    }

    @Override
    public int getXconBSlotIndex() {
        return 40960;
    }

    @Override
    public int getXconAIndex() {
        return 32769;
    }

    @Override
    public int getXconBIndex() {
        return 40961;
    }

    @Override
    public int[] getSupportedXcCardEqTypes() {
        return supportedXcCardEqTypes;
    }

    @Override
    public boolean isXcEnabled(INodeModel iNodeModel) {
        return iNodeModel.getNodeType() != 2 && !iNodeModel.isMstpUts();
    }

    @Override
    public LANAccessMode[] getSupportedLanAccessModes() {
        return LAN_ACCESS_MODE;
    }

    @Override
    public boolean isConfigurableSDPSupported() {
        return true;
    }

    @Override
    public boolean canSendPdip() {
        return false;
    }

    @Override
    public String getPlatformName() {
        return "15455";
    }

    @Override
    public int getAiciIoPortsStartNum() {
        return 35;
    }

    @Override
    public boolean hasVC11() {
        return true;
    }

    @Override
    public boolean hasXcMixedMode(IChassisModel iChassisModel) {
        boolean bl = false;
        if (iChassisModel == null) {
            return bl;
        }
        boolean bl2 = false;
        for (int i = 0; i < supportedXcCardEqTypes.length; ++i) {
            if (iChassisModel.getDescendantsOfEqType(supportedXcCardEqTypes[i]).size() <= 0) continue;
            bl2 = true;
            break;
        }
        if (bl2 && ((EntityModel)((Object)iChassisModel)).getDescendantsOfType(eEqType.XCVXC_CARD).size() > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean supportsTdmTransceiver(int n) {
        return n == 106 || n == 60 || n == 219 || n == 220;
    }

    @Override
    public boolean supportsDelayedUpgrade() {
        return true;
    }

    @Override
    protected int[] eqTypesWithoutUniqueNames() {
        int[] nArray = new int[]{187, 283, 331};
        return nArray;
    }

    @Override
    public boolean supportsMultishelf() {
        return true;
    }

    @Override
    public int baysPerRack() {
        return 3;
    }

    @Override
    public boolean supportsServerTrail() {
        return true;
    }

    public boolean supportsRpr() {
        return true;
    }

    @Override
    public boolean supportsPseudoCLI() {
        return true;
    }

    @Override
    public boolean supportsGzSvlan() {
        return true;
    }

    @Override
    public boolean supportsDWDM() {
        return true;
    }

    @Override
    public boolean supportsEthernetDropAndContinueOnCE2() {
        return true;
    }

    @Override
    public boolean supportsOBFLDiagnostics() {
        return true;
    }

    @Override
    public boolean supportsSRLGAndCoM() {
        return true;
    }

    static {
        versionedFeatureMap.put(Feature.BLSR_2F_VERSIONING, new Blsr2FiberVersionedFeature());
        versionedFeatureMap.put(Feature.BLSR_4F_VERSIONING, new Blsr4FiberVersionedFeature());
        vwMasks = new int[]{8, 4, 2, 1};
        pmColumnNames = new String[]{"Param", "Curr", "Prev", "Prev-1", "Prev-2", "Prev-3", "Prev-4", "Prev-5", "Prev-6", "Prev-7", "Prev-8", "Prev-9", "Prev-10", "Prev-11", "Prev-12", "Prev-13", "Prev-14", "Prev-15", "Prev-16", "Prev-17", "Prev-18", "Prev-19", "Prev-20", "Prev-21", "Prev-22", "Prev-23", "Prev-24", "Prev-25", "Prev-26", "Prev-27", "Prev-28", "Prev-29", "Prev-30", "Prev-31"};
        opticalLoopbackMap = new TreeMap();
        timingModeMap = new TreeMap();
        instance = new Platform();
        Platform.putAttribute(opticalLoopbackMap, 0, "None");
        Platform.putAttribute(opticalLoopbackMap, 1, "Terminal (Inward)");
        Platform.putAttribute(opticalLoopbackMap, 2, "Facility (Line)");
        Platform.putAttribute(timingModeMap, 0, "External");
        Platform.putAttribute(timingModeMap, 1, "Line");
        Platform.putAttribute(timingModeMap, 2, "Mixed");
    }
}

