/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.ms;

import cerent.cms.model.IEntityModel;
import cerent.cms.ui.ms.MsCardGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.ctc455.ui.ms.MsCardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class MsFmecBlankCard
extends MsCardGraphic {
    public static final int FMEC_WIDTH = 17;
    public static final int FMEC_HEIGHT = MsCardPainter.CARD_HEIGHT * 16 / 45;
    public static final int FMEC_SM_WIDTH = 8;
    public static final int FMEC_SM_HEIGHT = FMEC_HEIGHT / 2;
    public static final int FMEC_TAB_MARGIN = 2;
    public static final Dimension SINGLE_SLOT_DIM = new Dimension(17, FMEC_HEIGHT);
    protected Rectangle mainRectangle;
    protected Dimension slotDim;

    public MsFmecBlankCard(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(iEntityModel, abstractShelfLayout, sDebug);
    }

    public MsFmecBlankCard(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout) {
        this(iEntityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "MsFmecBLankCard:" + iEntityModel.getSlot()), "FMEC-BLANK");
    }

    public MsFmecBlankCard(IEntityModel iEntityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, String string) {
        this(iEntityModel, abstractShelfLayout, sDebug);
        iEntityModel.setEqLabel(string);
    }

    protected int getCardHeight() {
        return FMEC_HEIGHT;
    }

    protected int getCardWidth() {
        return this.slotDim.width;
    }

    @Override
    public Dimension getDimension() {
        return this.slotDim;
    }

    @Override
    protected void setSlotsOccupied(int n) {
        super.setSlotsOccupied(n);
        this.updateLocalDim();
    }

    @Override
    protected void initSlotsOccupied() {
        if (this.mainRectangle == null) {
            this.updateLocalDim();
        }
    }

    private void updateLocalDim() {
        this.mainRectangle = new Rectangle(0, 0, 17 * this.slotsOccupied, FMEC_HEIGHT);
        this.slotDim = new Dimension(17 * this.slotsOccupied, FMEC_HEIGHT);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.setColor(this.currentColor);
        graphics2D.fill(this.mainRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setTransform(affineTransform2);
    }

    @Override
    public String getTooltipText(MouseEvent mouseEvent) {
        return this.getEqLabel();
    }
}

