/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import cerent.cms.model.IChassisModel;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.util.gui.IconImpl;
import com.cisco.ctc455.ui.shelf.FmecBlankCard;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShelfLayout
extends AbstractShelfLayout {
    public static final int SHELF_SLOT_COUNT = 17;
    public static final int FMEC_SHELF_SLOT_COUNT = 12;
    private static final Font TEXT_FONT = new Font("Arial", 0, 8);
    private static final Font labelFont = new Font("Arial", 0, 10);
    private JPanel fmecLabelsPanel;
    private JPanel fmecSlotsPanel;

    public ShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        super(iChassisModel, shelfViewController);
    }

    @Override
    public int getShelfSlotCount() {
        return 29;
    }

    @Override
    protected Font getTextFont() {
        return TEXT_FONT;
    }

    @Override
    protected int getFirstRowSlotCount() {
        return 17;
    }

    @Override
    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = new JPanel(new GridLayout(1, 17, 0, 0));
            Dimension dimension = new Dimension(26, 12);
            this.labels = new JLabel[this.getShelfSlotCount()];
            for (int i = 0; i < 17; ++i) {
                JLabel jLabel = new JLabel("" + (i + 1));
                jLabel.setFont(labelFont);
                jLabel.setPreferredSize(dimension);
                jLabel.setMinimumSize(dimension);
                jLabel.setHorizontalAlignment(0);
                this.labels[i] = jLabel;
                this.labelsPanel.add(jLabel);
            }
            this.createFmecLabels();
        }
    }

    @Override
    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel(new FlowLayout(0, 0, 0));
        Dimension dimension = new Dimension(26, Math.round(220.0f));
        for (int i = 0; i < 17; ++i) {
            IconImpl iconImpl = new IconImpl(dimension);
            this.cards[i] = new CardPanel(iconImpl, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.slotsPanel.add(this.cards[i]);
        }
        this.createFmecSlotsPanel();
    }

    @Override
    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
        this.addFmecLabels();
    }

    @Override
    protected void removeLabels() {
        this.remove(this.labelsPanel);
    }

    protected Font getTextFont(int n) {
        return TEXT_FONT;
    }

    @Override
    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
        this.addFmecPanels();
    }

    private void createFmecLabels() {
        if (this.fmecLabelsPanel == null) {
            this.fmecLabelsPanel = new JPanel(new GridLayout(1, 12, 0, 0));
            Dimension dimension = new Dimension(37, 12);
            for (int i = 17; i < 29; ++i) {
                JLabel jLabel = new JLabel("" + (i + 1));
                jLabel.setFont(labelFont);
                jLabel.setPreferredSize(dimension);
                jLabel.setMinimumSize(dimension);
                jLabel.setHorizontalAlignment(0);
                this.labels[i] = jLabel;
                this.fmecLabelsPanel.add(jLabel);
            }
        }
    }

    private void createFmecSlotsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.fmecSlotsPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        for (int i = 17; i < 29; ++i) {
            IconImpl iconImpl = new IconImpl(FmecBlankCard.SINGLE_SLOT_DIM);
            this.cards[i] = new CardPanel(iconImpl, this);
            gridBagLayout.setConstraints(this.cards[i], gridBagConstraints);
            this.fmecSlotsPanel.add(this.cards[i]);
            ++gridBagConstraints.gridx;
        }
    }

    private void addFmecLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.fmecLabelsPanel, gridBagConstraints);
        this.add(this.fmecLabelsPanel);
    }

    private void addFmecPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.fmecSlotsPanel, gridBagConstraints);
        this.add(this.fmecSlotsPanel);
    }

    @Override
    public void destroy() {
        if (this.fmecSlotsPanel != null) {
            this.fmecSlotsPanel.removeAll();
            this.fmecSlotsPanel = null;
        }
        super.destroy();
    }
}

