/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.SonetMedia.eStm1eMode;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import com.cisco.ctc455.ui.stm1e.STM1E12PortTableModel;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class STM1E12PortProvPane
extends NodeProvPane
implements TableModelListener {
    protected TdmLineModel[] lineModels = null;
    protected INodeModel node = null;
    protected int numLines = 0;
    protected STM1E12PortTableModel dataModel = null;
    private static final SDebug db = new SDebug("STM1E12PortProvPane");

    public STM1E12PortProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        JScrollPane jScrollPane = null;
        Object var5_5 = null;
        this.lineModels = tdmLineModelArray;
        this.numLines = tdmLineModelArray.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        jScrollPane = new JScrollPane(this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.prepareColumns();
        this.registerWithModel();
        this.add(jScrollPane, "Center");
    }

    @Override
    public boolean hasSubTabs() {
        return false;
    }

    protected STM1E12PortTableModel getDataModel() {
        return new STM1E12PortTableModel(this.node, this.lineModels);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void prepareColumns() {
        TableColumn tableColumn = null;
        Object var2_2 = null;
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(120);
        this.setAttrCellEditor(1, "STM1E_12_LINE_CARD." + eStm1eMode.class.getName());
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.dataModel.applyChanges();
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap((IModel)this.node).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("Warning: cannot find attributes for " + string);
            this.table.removeColumn(tableColumn);
        }
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                STM1E12PortProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In refreshLine changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.STM1E12PortProvPane;
    }
}

