/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.model;

import cerent.cms.idl.Node.eDbType;
import cerent.cms.model.DataTransferJob;
import cerent.cms.model.SwUpgradeModel;
import cerent.util.SDebug;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobStatus;
import com.cisco.ctc600.model.DatabaseManagementModel;
import com.cisco.ctc600.model.PlatformNodeModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DataTransferJob600
extends DataTransferJob {
    private ArrayList selList;
    static final SDebug db = new SDebug("DataTransferJob600");
    protected int[] restoreInfoType = null;
    protected int[] restoreInfoSize = null;
    private File tmpFile;
    private DatabaseManagementModel dbModel = null;
    private static final int SUCCESS = 0;
    private static final int CORRUPT = 1;

    public DataTransferJob600(PlatformNodeModel platformNodeModel, String string, int n, IJobProgressControl iJobProgressControl) {
        super(platformNodeModel, string, n, iJobProgressControl);
        this.dbModel = (DatabaseManagementModel)platformNodeModel.getDatabaseManagementModel();
    }

    @Override
    public JobStatus executeJob() {
        JobStatus jobStatus;
        if (this.operation != 3) {
            int n;
            if (this.dbModel.getDbTypesFromFile() == null) {
                try {
                    this.dbModel.validateDbBackupFile(this.fileName);
                }
                catch (Exception exception) {
                    db.fine("Either CTM or CTS caused something wrong. CTC would never come here");
                }
            }
            if ((n = this.buildRestoreInfo()) != 0 && n == 1) {
                return new JobStatus(2, (Object)new Exception("Database backup file is corrupt"));
            }
            db.finest("Using " + this.fileName + " for " + this.operationName);
            jobStatus = super.executeJob();
        } else {
            SwUpgradeModel swUpgradeModel = SwUpgradeModel.getInstance(this.nodeModel);
            swUpgradeModel.init();
            jobStatus = swUpgradeModel.isOperationAllowed(3) ? super.executeJob() : new JobStatus(2, (Object)new Exception("Download not allowed"));
        }
        this.cleanup();
        return jobStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildRestoreInfo() {
        this.selList = new ArrayList();
        int[] nArray = this.dbModel.getUserSelection();
        for (int i = 0; i < nArray.length; ++i) {
            this.selList.add(eDbType.from_int(nArray[i]));
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.restoreInfoType = this.dbModel.getDbTypesFromFile();
        this.restoreInfoSize = this.dbModel.getDbSizesFromFile();
        stringBuffer.append(this.dbModel.getDbNodeName() + "|" + this.dbModel.getDbSwVersion() + "|" + this.dbModel.getDbVersion() + "|");
        int n = Integer.parseInt(this.dbModel.getDbVersion());
        if (n >= 3) {
            stringBuffer.append(this.dbModel.getDbNeType() + "|");
        }
        stringBuffer.append(this.selList.size() + ":");
        for (int i = 0; i < this.restoreInfoType.length; ++i) {
            if (!this.selList.contains(eDbType.from_int(this.restoreInfoType[i]))) continue;
            stringBuffer.append(this.restoreInfoType[i] + ",");
            stringBuffer.append(this.restoreInfoSize[i] + ":");
        }
        stringBuffer.append("|;");
        db.fine("StringBuffer = " + stringBuffer.toString());
        FilterOutputStream filterOutputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            this.tmpFile = File.createTempFile("dbRestore", ".db");
            db.fine("Temporary filename generated = " + this.tmpFile.getCanonicalPath());
            filterOutputStream = new DataOutputStream(new FileOutputStream(this.tmpFile));
            ((DataOutputStream)filterOutputStream).writeBytes(stringBuffer.toString());
            if (this.dbModel.isFileFromOlderDB()) {
                this.buildOldDbRestoreInfo((DataOutputStream)filterOutputStream);
                int n2 = 0;
                return n2;
            }
            filterInputStream = new DataInputStream(new FileInputStream(this.fileName));
            byte[] byArray = new byte[1024];
            ((DataInputStream)filterInputStream).read(byArray, 0, this.dbModel.getFirstDbStarts());
            for (int i = 0; i < this.restoreInfoType.length; ++i) {
                int n3 = 0;
                int n4 = this.restoreInfoSize[i];
                boolean bl = this.selList.contains(eDbType.from_int(this.restoreInfoType[i]));
                db.fine("Starting to copy db = " + this.restoreInfoType[i] + ", filesize = " + n4 + ", needsToWrite = " + bl);
                while (n3 < this.restoreInfoSize[i] && filterInputStream.available() > 0) {
                    int n5 = ((DataInputStream)filterInputStream).read(byArray, 0, Math.min(1024, n4));
                    if (n5 <= 0) continue;
                    n3 += n5;
                    n4 -= n5;
                    if (!bl) continue;
                    ((DataOutputStream)filterOutputStream).write(byArray, 0, n5);
                    db.fine("bytesRead = " + n3 + ", bytesLeft = " + n4 + ", actualRead = " + n5);
                }
                if (n3 == this.restoreInfoSize[i]) continue;
                int n6 = 1;
                return n6;
            }
            this.fileName = this.tmpFile.getCanonicalPath();
            db.fine("filename to be send = " + this.fileName);
        }
        catch (Exception exception) {
            db.info("Caught exception");
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    SDebug.printStackTrace((Throwable)iOException);
                }
            }
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    SDebug.printStackTrace((Throwable)iOException);
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildOldDbRestoreInfo(DataOutputStream dataOutputStream) {
        byte[] byArray = new byte[1024];
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.fileName));
            for (int i = 0; i < this.restoreInfoType.length; ++i) {
                ZipEntry zipEntry;
                if (!this.selList.contains(eDbType.from_int(this.restoreInfoType[i]))) continue;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (this.restoreInfoType[i] != Integer.parseInt(zipEntry.getName())) continue;
                    int n = this.restoreInfoSize[i];
                    int n2 = 0;
                    db.fine("Starting to copy db = " + this.restoreInfoType[i] + ", filesize = " + n);
                    while (n2 < this.restoreInfoSize[i]) {
                        int n3 = zipInputStream.read(byArray, 0, Math.min(1024, n));
                        if (n3 <= 0) continue;
                        n2 += n3;
                        n -= n3;
                        dataOutputStream.write(byArray, 0, n3);
                    }
                    break block12;
                }
                if (zipEntry != null) continue;
                zipInputStream.close();
                zipInputStream = new ZipInputStream(new FileInputStream(this.fileName));
            }
            dataOutputStream.close();
            this.fileName = this.tmpFile.getCanonicalPath();
            db.fine("filename to be send = " + this.fileName);
        }
        catch (Exception exception) {
            db.info("Caught exception");
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    SDebug.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private void cleanup() {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }
}

