/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ILineModelUpdater;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import com.cisco.ctc600.ui.asap.AsapEtherLoopbackTabbedPane;
import java.awt.Component;

public class AsapEtherMaintenancePane
extends AbstractSubTabbedPane
implements ITabName {
    protected AsapEtherLineModel[] etherLineModels;
    protected AsapPosLineModel[] posLineModels;
    private ModuleModel mm;
    private NodeModelDelegate nodeModel;
    private TDMTerminology terms;
    private static final SDebug dbg = new SDebug("AsapEtherMaintenancePane");

    public AsapEtherMaintenancePane(String string, TabbedView tabbedView, AsapEtherLineModel[] asapEtherLineModelArray, AsapPosLineModel[] asapPosLineModelArray) {
        super(string, tabbedView);
        this.etherLineModels = asapEtherLineModelArray;
        this.posLineModels = asapPosLineModelArray;
        this.mm = (ModuleModel)tabbedView.getUiModel();
        this.nodeModel = (NodeModelDelegate)this.mm.getNodeModel();
        this.terms = this.nodeModel.getTDMTerminology();
        super.registerWithModel();
    }

    @Override
    protected void createSubTabs() {
        this.subTabs.setTabPlacement(2);
        this.subTabs.addTab("Loopback", (Component)((Object)new AsapEtherLoopbackTabbedPane("Loopback", this.subTabs, this.etherLineModels, this.posLineModels)));
        String string = "Path Trace";
        if (this.nodeModel.isSdhAu3Supported()) {
            string = this.terms.getTdmHoTerm(2) + " " + "Path Trace";
            this.subTabs.addTab(string, (Component)CardTabbedView.getPathTracePane(this.posLineModels, this.subTabs, new ILineModelUpdater(){

                @Override
                public boolean updateIsForMe(ModuleModelUpdate moduleModelUpdate) {
                    return moduleModelUpdate instanceof EtherLineUpdate;
                }
            }, 2));
        }
        if (this.nodeModel.isSdhAu4Supported()) {
            string = this.terms.getTdmHoTerm(1) + " " + "Path Trace";
        }
        this.subTabs.addTab(string, (Component)CardTabbedView.getPathTracePane(this.posLineModels, this.subTabs, new ILineModelUpdater(){

            @Override
            public boolean updateIsForMe(ModuleModelUpdate moduleModelUpdate) {
                return moduleModelUpdate instanceof EtherLineUpdate;
            }
        }, 1));
        this.subTabs.addTab("AINS Soak", (Component)((Object)new SoakMaintenancePane("AINS Soak", this.subTabs, this.etherLineModels, true)));
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof EtherLineUpdate) {
            if (dbg.on()) {
                dbg.println("Received EtherLineUpdate...");
            }
            this.etherLineModels = (AsapEtherLineModel[])((EtherLineUpdate)object).getEtherLineModels();
            this.posLineModels = (AsapPosLineModel[])((EtherLineUpdate)object).getPosLineModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

