/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Common.sClassBSubnetAddr;
import cerent.cms.idl.Node.xInvalidSubnetAddr;
import cerent.cms.idl.Node.xStandbyTccNotReady;
import cerent.cms.idl.Node.xSubnetAddrAlreadyExists;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.SubnetAddrFormat;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IntegerPropertyEditor;
import com.cisco.ctc600.model.InternalSubnetModel;
import com.cisco.ctc600.model.PlatformNodeModel;
import com.cisco.ctc600.ui.shelf.ShelfProvPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;
import org.omg.CORBA.UserException;

public class InternalSubnetPane
extends NodeProvPane
implements KeyListener {
    private IntegerPropertyEditor tscOneField1 = null;
    private IntegerPropertyEditor tscOneField2 = null;
    private IntegerPropertyEditor tscTwoField1 = null;
    private IntegerPropertyEditor tscTwoField2 = null;
    private InternalSubnetModel subnetModel = null;
    private PlatformNodeModel nodeModel = null;
    private boolean isDirty = false;
    protected static final SDebug db = new SDebug((KDebug)ShelfProvPane.db, "InternalSubnetPane");

    public InternalSubnetPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory, PlatformNodeModel platformNodeModel) {
        super(string, tabbedView);
        this.nodeModel = platformNodeModel;
        this.subnetModel = platformNodeModel.getInternalSubnetModel();
        if (this.subnetModel != null) {
            this.subnetModel.addObserver((Observer)((Object)this));
        }
    }

    private void init() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(new EtchedBorder(1));
        this.tscOneField1 = this.createTextField("TSC A: ", "");
        jPanel.add(this.tscOneField1);
        this.tscOneField2 = this.createTextField(".", "");
        jPanel.add(this.tscOneField2);
        this.tscTwoField1 = this.createTextField("    TSC B: ", "");
        jPanel.add(this.tscTwoField1);
        this.tscTwoField2 = this.createTextField(".", "");
        jPanel.add(this.tscTwoField2);
        this.add(jPanel);
    }

    private IntegerPropertyEditor createTextField(String string, String string2) {
        IntegerPropertyEditor integerPropertyEditor = new IntegerPropertyEditor(string, string2);
        integerPropertyEditor.setEditorSize(3);
        if (super.isUserAuthorized()) {
            integerPropertyEditor.getTxtInput().addKeyListener(this);
            integerPropertyEditor.getTxtInput().setEditable(true);
        } else {
            integerPropertyEditor.getTxtInput().setEditable(false);
        }
        return integerPropertyEditor;
    }

    @Override
    public void refreshFromModel() {
        try {
            sClassBSubnetAddr[] sClassBSubnetAddrArray = this.subnetModel.getInternalSubnet();
            byte[] byArray = sClassBSubnetAddrArray[0].addr;
            byte[] byArray2 = sClassBSubnetAddrArray[1].addr;
            String string = SubnetAddrFormat.format(byArray);
            this.tscOneField1.setValue(string.substring(0, string.indexOf(".")));
            this.tscOneField2.setValue(string.substring(string.indexOf(".") + 1, string.length()));
            String string2 = SubnetAddrFormat.format(byArray2);
            this.tscTwoField1.setValue(string2.substring(0, string2.indexOf(".")));
            this.tscTwoField2.setValue(string2.substring(string2.indexOf(".") + 1, string2.length()));
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH);
        }
    }

    private void setInternalSubnet() throws Exception {
        try {
            byte[] byArray = new byte[]{new Integer(this.tscOneField1.getValue().toString()).byteValue(), new Integer(this.tscOneField2.getValue().toString()).byteValue()};
            byte[] byArray2 = new byte[]{new Integer(this.tscTwoField1.getValue().toString()).byteValue(), new Integer(this.tscTwoField2.getValue().toString()).byteValue()};
            sClassBSubnetAddr[] sClassBSubnetAddrArray = new sClassBSubnetAddr[]{new sClassBSubnetAddr(byArray), new sClassBSubnetAddr(byArray2)};
            this.subnetModel.setInternalSubnet(sClassBSubnetAddrArray[0], sClassBSubnetAddrArray[1]);
        }
        catch (xInvalidSubnetAddr xInvalidSubnetAddr2) {
            super.setDirty(true);
            SDebug.printStackTrace((Throwable)((Object)xInvalidSubnetAddr2));
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_SUBNET_ADDR);
        }
        catch (xSubnetAddrAlreadyExists xSubnetAddrAlreadyExists2) {
            super.setDirty(true);
            SDebug.printStackTrace((Throwable)((Object)xSubnetAddrAlreadyExists2));
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SUBNET_ADDR_EXISTS);
        }
        catch (xStandbyTccNotReady xStandbyTccNotReady2) {
            super.setDirty(true);
            SDebug.printStackTrace((Throwable)((Object)xStandbyTccNotReady2));
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STBY_CONTROLLER_NOT_RDY_PARAM_1, (Object)"TSC");
        }
        catch (UserException userException) {
            super.setDirty(true);
            SDebug.printStackTrace((Throwable)userException);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INTERNAL_SUBNET_ERROR_PARAM_1, (Object)userException.toString());
        }
        catch (Exception exception) {
            super.setDirty(true);
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INTERNAL_SUBNET_ERROR_PARAM_1, (Object)exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.tscOneField1 == null) {
                this.init();
            }
            super.enteringPage();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.isDirty && !this.validateUserInput()) {
            throw this.createLeavePageException("The subnet address is invalid.");
        }
        super.leavingPage();
    }

    @Override
    public boolean onValidate() {
        if (!this.validateUserInput()) {
            return false;
        }
        if (!this.nodeModel.isResetAllowed()) {
            ErrorMsg.displayWarning((Component)((Object)this), (WID)EMC.WID_ACTION_FAILED_SWUPGRADE_PARAM_1, (Object)"Changes of Internal Subnet ");
            this.refreshFromModel();
            return true;
        }
        String string = this.nodeModel.getName();
        String string2 = "Warning!!! Changing the internal subnet address \nwill cause the node '" + string + "' to reboot.\n\n" + "Change subnet address anyway?";
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)"Confirmation")) {
            try {
                this.setInternalSubnet();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INTERNAL_SUBNET_ERROR_PARAM_1, (Object)exception.toString());
            }
        } else {
            this.refreshFromModel();
        }
        return true;
    }

    private boolean validateUserInput() {
        int n;
        if (this.tscOneField1.getTxtInput().getText().equals("") || this.tscOneField2.getTxtInput().getText().equals("") || this.tscTwoField1.getTxtInput().getText().equals("") || this.tscTwoField2.getTxtInput().getText().equals("")) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INCOMPLETE_INTERNAL_SUBNET_ADDR);
            return false;
        }
        int n2 = Integer.parseInt(this.tscOneField1.getTxtInput().getText());
        int n3 = Integer.parseInt(this.tscOneField2.getTxtInput().getText());
        int n4 = Integer.parseInt(this.tscTwoField1.getTxtInput().getText());
        if (n2 == n4 & n3 == (n = Integer.parseInt(this.tscTwoField2.getTxtInput().getText()))) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_IDENTICAL_TSC_SUBNET_ADDRS);
            return false;
        }
        if (n2 > 255 || n3 > 255 || n4 > 255 || n > 255) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_SUBNET_ADDR);
            return false;
        }
        return true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.isDirty = true;
        super.setDirty(true);
        if (keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
            return;
        }
        Object object = keyEvent.getSource();
        if (object instanceof JTextField) {
            JTextField jTextField = (JTextField)object;
            try {
                if (jTextField.getText().length() >= 3) {
                    Toolkit.getDefaultToolkit().beep();
                    jTextField.setCaretPosition(jTextField.getSelectionStart());
                    jTextField.setText(jTextField.getText(0, jTextField.getText().length() - 1));
                }
            }
            catch (BadLocationException badLocationException) {
                SDebug.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void dispose() {
        if (this.subnetModel != null) {
            this.subnetModel.deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.InternalSubnetPane;
    }
}

