/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class TSCCard
extends CardGraphic {
    protected static final int OPER_LED_X_OFFSET = 2;
    protected static final int OPER_LED_Y_OFFSET = 35;
    private int lowerLedsTopY;
    private int lowerLedsBottomY;
    protected Rectangle lanRectangle = new Rectangle(11, 197, 9, 7);
    private eTimingMode timingMode = null;
    private boolean isHoldOver = false;
    private boolean isFreeRun = false;
    private SynchronizationModel syncModel;
    private IAlarmStore eleAlarmStore;
    public static final String FREE_RUN_SYNC = "FRNGSYNC";
    public static final String HOLD_OVER_SYNC = "HLDOVRSYNC";

    public TSCCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "TSCCard:" + entityModel.getSlot()));
        this.initializeLED();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.getActiveColor(this.getState()));
        graphics2D.fillOval(9, 27, 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", 9, 33);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("ACT", 16, 33);
        graphics2D.setFont(font);
        graphics2D.setColor(this.getLineColor(this.getState()));
        graphics2D.fillOval(2, 35, 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", 2, 41);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("LINE", 9, 41);
        graphics2D.setFont(font);
        graphics2D.setColor(this.getExternalColor(this.getState()));
        graphics2D.fillOval(2, 42, 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", 2, 48);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("EXT", 9, 48);
        graphics2D.setFont(font);
        graphics2D.setColor(this.getFreeRunColor(this.getState()));
        graphics2D.fillOval(2, 49, 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", 2, 55);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("FRN", 9, 55);
        graphics2D.setFont(font);
        graphics2D.setColor(this.getHoldOverColor(this.getState()));
        graphics2D.fillOval(2, 56, 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", 2, 62);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("HOLD", 9, 62);
        graphics2D.setFont(font);
        graphics2D.fillOval(2, 176, 5, 5);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("O", 2, 181);
        graphics2D.drawString("ACO", 9, 181);
        graphics2D.setFont(font);
        graphics2D.fillOval(2, 183, 5, 5);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("O", 2, 188);
        graphics2D.drawString("LAMP", 9, 188);
        graphics2D.setFont(font);
        graphics2D.fillOval(2, 207, 5, 5);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("O", 2, 212);
        graphics2D.drawString("RST", 9, 212);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("LAN", 9, 195);
        graphics2D.draw(this.lanRectangle);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    private void initializeLED() {
        this.syncModel = this.entityM.getChassis().getSyncModel();
        if (this.syncModel != null) {
            this.syncModel.addObserver(this);
        }
        this.eleAlarmStore = this.entityM.getNodeModelDelegate().getElementAlarmStore();
        if (this.eleAlarmStore != null) {
            this.eleAlarmStore.addObserver((Observer)this);
        }
        this.updateTimingMode(this.syncModel);
        int n = this.entityM.getNodeModelDelegate().getAlarmDecoder().getCondition(FREE_RUN_SYNC, 0);
        ArrayList arrayList = this.eleAlarmStore.getAlarmByCondition(n);
        n = this.entityM.getNodeModelDelegate().getAlarmDecoder().getCondition(HOLD_OVER_SYNC, 0);
        arrayList.addAll(this.eleAlarmStore.getAlarmByCondition(n));
        this.update((Observable)this.eleAlarmStore.getStoreObservable(), arrayList);
    }

    @Override
    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        if (observable instanceof SynchronizationModel) {
            this.updateTimingMode((SynchronizationModel)((Object)observable));
        } else if (observable instanceof StoreObservable && object instanceof ArrayList) {
            this.updateLED((ArrayList)object);
            super.refreshCard();
        }
        super.update(observable, object);
    }

    private void updateTimingMode(SynchronizationModel synchronizationModel) {
        block2: {
            try {
                this.timingMode = synchronizationModel.getConfig().timingMode;
            }
            catch (NoSuchEquipment noSuchEquipment) {
                this.db.println("Caught NoSuchEquipment in updateTimingMode!");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
        }
    }

    private void updateLED(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            EventInfo eventInfo = (EventInfo)arrayList.get(i);
            if (eventInfo.getCondCode().equals(FREE_RUN_SYNC)) {
                boolean bl = this.isFreeRun = eventInfo.getState() == 'R';
            }
            if (!eventInfo.getCondCode().equals(HOLD_OVER_SYNC)) continue;
            this.isHoldOver = eventInfo.getState() == 'R';
        }
    }

    protected Color getActiveColor(int n) {
        switch (n) {
            case 5: {
                return ElementDefaults.IS_COLOR;
            }
        }
        return ElementDefaults.OOS_DSBLD_COLOR.darker();
    }

    protected Color getLineColor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return ElementDefaults.OOS_DSBLD_COLOR.darker();
            }
        }
        if (this.timingMode == eTimingMode.LINE_TIME && !this.isFreeRun && !this.isHoldOver) {
            return ElementDefaults.IS_COLOR;
        }
        return ElementDefaults.OOS_DSBLD_COLOR.darker();
    }

    protected Color getExternalColor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return ElementDefaults.OOS_DSBLD_COLOR.darker();
            }
        }
        if (this.timingMode == eTimingMode.EXT_TIME && !this.isFreeRun && !this.isHoldOver) {
            return ElementDefaults.IS_COLOR;
        }
        return ElementDefaults.OOS_DSBLD_COLOR.darker();
    }

    protected Color getFreeRunColor(int n) {
        switch (n) {
            case 5: {
                return this.isFreeRun ? ElementDefaults.IS_COLOR : ElementDefaults.OOS_DSBLD_COLOR.darker();
            }
        }
        return ElementDefaults.OOS_DSBLD_COLOR.darker();
    }

    protected Color getHoldOverColor(int n) {
        switch (n) {
            case 5: {
                return this.isHoldOver ? ElementDefaults.MAJOR_ALARM_COLOR : ElementDefaults.OOS_DSBLD_COLOR.darker();
            }
        }
        return ElementDefaults.OOS_DSBLD_COLOR.darker();
    }

    protected Color getAlarmCutOffColor(int n) {
        switch (n) {
            default: 
        }
        return ElementDefaults.OOS_DSBLD_COLOR.darker();
    }

    @Override
    public void dispose() {
        if (this.syncModel != null) {
            this.syncModel.deleteObserver(this);
            this.syncModel = null;
        }
        if (this.eleAlarmStore != null) {
            this.eleAlarmStore.deleteObserver((Observer)this);
            this.eleAlarmStore = null;
        }
        super.dispose();
    }
}

