/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctcutsX.ui;

import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.shelf.ADM10GCardView;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AiciCardView;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.MuxDmuxCardView;
import cerent.cms.ui.shelf.OpticsCardView;
import cerent.cms.ui.shelf.OscCardView;
import cerent.cms.ui.shelf.TncCardView;
import cerent.cms.ui.shelf.WssCardView;
import cerent.cms.ui.shelf.WxcCardView;
import cerent.cms.ui.shelf.XP40GCardView;
import cerent.cms.ui.xpl2.XPL2CardView;
import cerent.util.SDebug;
import javax.swing.JLabel;

public class CardViewPanel
extends AbstractCardViewPanel {
    private static final SDebug db = new SDebug("CardViewPanel");

    public CardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        super(moduleModel, cardViewController);
    }

    @Override
    protected void initPanel() {
        this.cardName = this.model.getEqLabel();
        if (this.model.getEqType() == 356 || this.model.getEqType() == 358) {
            sMfgData_2_01 sMfgData_2_012 = this.model.getMfgData();
            String string = sMfgData_2_012.productId;
            if (string.startsWith("15454-40E-MXP-C")) {
                this.cardName = this.cardName + " (EP)";
            }
            if (string.startsWith("15454-40ME-MXP-C")) {
                this.cardName = this.cardName + " (ME)";
            }
            if (string.startsWith("15454-40E-TXP-C")) {
                this.cardName = this.cardName + " (EP)";
            }
            if (string.startsWith("15454-40ME-TXP-C")) {
                this.cardName = this.cardName + " (ME)";
            }
        }
        this.cardNameLabel = AbstractShelfLayout.formatLabel(new JLabel(this.cardName));
        this.add(this.cardNameLabel, 0, 1, 2, 1);
        this.setupCardView();
        this.add(this.cardView, 1, 2, 1, -1);
    }

    @Override
    protected void setupCardView() {
        if (this.model instanceof XPL2ModuleModel) {
            this.cardView = new XPL2CardView(this.model, (AbstractCardViewPanel)this);
        } else if (this.model instanceof DwdmModuleModel) {
            this.cardView = this.model.getEqType() == 273 ? new ADM10GCardView((EntityModel)this.model, (AbstractCardViewPanel)this) : (this.model.getEqType() == 300 || this.model.getEqType() == 301 || this.model.getEqType() == 356 || this.model.getEqType() == 358 ? new XP40GCardView(this.model, (AbstractCardViewPanel)this) : new DwdmCardView((EntityModel)this.model, (AbstractCardViewPanel)this));
        } else {
            switch (this.model.getEqType()) {
                case 129: 
                case 130: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 196: 
                case 239: 
                case 240: 
                case 249: 
                case 277: 
                case 278: 
                case 281: 
                case 286: 
                case 287: 
                case 294: 
                case 295: 
                case 296: 
                case 298: 
                case 299: 
                case 321: {
                    this.cardView = new OpticsCardView(this.model, this);
                    break;
                }
                case 131: 
                case 132: 
                case 192: 
                case 241: 
                case 264: 
                case 265: 
                case 268: 
                case 269: {
                    this.cardView = new MuxDmuxCardView(this.model, this);
                    break;
                }
                case 266: 
                case 270: {
                    this.cardView = new WxcCardView(this.model, this);
                    break;
                }
                case 191: 
                case 242: 
                case 263: 
                case 267: {
                    this.cardView = new WssCardView(this.model, this);
                    break;
                }
                case 127: 
                case 128: {
                    this.cardView = new OscCardView(this.model, this);
                    break;
                }
                case 97: {
                    this.cardView = new AiciCardView(this.model);
                    break;
                }
                case 330: {
                    this.cardView = new TncCardView((EntityModel)this.model, (AbstractCardViewPanel)this);
                    break;
                }
                default: {
                    super.setupCardView();
                }
            }
        }
        if (db.on()) {
            db.println("setupCardView cardView is " + this.cardView);
        }
    }
}

