/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctcutsX.ui.ms;

import cerent.cms.model.EntityModel;
import cerent.cms.ui.ms.MsCardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class MsCardPainter
implements ICardPainter {
    private static final float CARD_H_TO_CARD_W_RATIO = 0.054166667f;
    private static final float PORT_W_TO_CARD_W_RATIO = 0.41666666f;
    private static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.3181818f;
    private static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    public static final int CARD_HEIGHT = 6;
    public static final int CARD_WIDTH = Math.round(110.769226f);
    private static final int PORT_WIDTH = Math.round((float)CARD_WIDTH * 0.41666666f);
    private static final int PORT_HEIGHT = PORT_WIDTH * 2;
    private static final int SMALL_PORT_HEIGHT = PORT_WIDTH;
    private static final int PORT_LOOPBACK_DIST = 3;
    private static final int PORT_CONN1_X;
    private static final int PORT_CONN2_X;
    private static final int PORT_CONN1_Y;
    private static final int PORT_CONN2_Y;
    private static final int SMALL_PORT_CONN1_Y;
    private static final int SMALL_PORT_CONN2_Y;
    static final int OPTICON_X_OFFSET;
    private static final int MULTIPORT_OPTICON_X_OFFSET;
    private static final int OPTICON_Y_OFFSET;
    private final int HEIGHT;
    private static final float RECT_H_TO_CARD_H_RATIO = 0.013636364f;
    private static final float RECT_OFFSET_TO_CARD_H_RATIO = 0.23636363f;
    private static final float BOTTOM_RECT_OFFSET_TO_CARD_H_RATIO = 0.81363636f;
    private static final float EXTRACTOR_H_TO_CARD_H_RATIO = 0.11818182f;
    private static final float EXTRACTOR_W_TO_EXTRACTOR_H_RATIO = 0.46153846f;
    private static final float NAME_X_OFFSET_TO_CARD_W_RATIO = 0.083333336f;
    private static final float NAME_Y_OFFSET_TO_CARD_H_RATIO = 0.19545455f;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.25f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.018181818f;
    private static final int RECT_HEIGHT;
    private static final int RECT_OFFSET;
    private static final int TOP_RECT_OFFSET;
    private static final int TOP_RECT_HEIGHT;
    private static final int BOTTOM_RECT_OFFSET;
    private static final int BOTTOM_RECT_HEIGHT;
    private static final int EXTRACTOR_HEIGHT;
    private static final int EXTRACTOR_WIDTH;
    private static final int TAB_MARGIN;
    private static final int TAB_RADIUS;
    private static final int TAB_DIAMETER;
    private static final int TAB_ARC_WIDTH;
    private static final int TAB_ARC_HEIGHT;
    private static final int BOTTOM_EXTRACTOR_OFFSET;
    private static final int BOTTOM_EXTRACTOR_HEIGHT;
    private static final int TOP_EXTRACTOR_OFFSET = 0;
    private static final int TOP_EXTRACTOR_HEIGHT;
    private static final int NAME_X_OFFSET;
    private static final int NAME_Y_OFFSET;
    private static final int ACTIVE_LIGHT_Y_OFFSET;
    private static final int ACTIVE_LIGHT_WIDTH;
    private static final int ACTIVE_LIGHT_HEIGHT;
    private static final int OPTICON_X_SPACING = 0;
    private static final int OPTICON_Y_SPACING;
    private static final int SMALL_OPTICON_Y_SPACING;
    private static final int MINI_PORT_WIDTH;
    private static final int MINI_PORT_HEIGHT;
    private static final int MINI_MULTIPORT_OPTICON_X_OFFSET;
    private static final int MINI_OPTICON_Y_OFFSET;
    private static final int MINI_OPTICON_X_SPACING = 0;
    private static final int MINI_OPTICON_Y_SPACING;
    private static final float[] dash1;
    public static final Rectangle topExtractorRectangle;
    public static final Rectangle bottomExtractorRectangle;
    public static final Arc2D.Double topExtractorMain;
    public static final Arc2D.Double topExtractorSmall;
    public static final Line2D.Double topExtractorLine;
    public static final Arc2D.Double bottomExtractorMain;
    public static final Arc2D.Double bottomExtractorSmall;
    public static final Line2D.Double bottomExtractorLine;
    private final int WIDTH;
    private final Rectangle topRectangle;
    private final Rectangle bottomRectangle;
    private final Rectangle mainRectangle;
    protected MsCardGraphic cg;
    private Rectangle topBackgroundRectangle;
    private Rectangle bottomBackgroundRectangle;

    public MsCardPainter(MsCardGraphic msCardGraphic) {
        this.cg = msCardGraphic;
        this.WIDTH = CARD_WIDTH;
        this.HEIGHT = msCardGraphic.getSlotsOccupied() * 6;
        this.topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        this.bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, this.HEIGHT);
        int n = CARD_WIDTH;
        this.topBackgroundRectangle = new Rectangle(0, 0, n, TOP_EXTRACTOR_HEIGHT);
        this.bottomBackgroundRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, n, this.HEIGHT);
    }

    @Override
    public void updateWidth() {
    }

    @Override
    public int getOpticonXOffset() {
        return OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonYOffset() {
        return OPTICON_Y_OFFSET;
    }

    @Override
    public int getMultiPortOpticonXOffset() {
        return MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getOpticonYSpacing() {
        return OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniMultiPortOticonXOffset() {
        return MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getCardWidth() {
        return CARD_WIDTH;
    }

    @Override
    public int getCardHeight() {
        return 6;
    }

    @Override
    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    @Override
    public int getPortWidth() {
        return PORT_WIDTH;
    }

    @Override
    public int getPortHeight() {
        return PORT_HEIGHT;
    }

    @Override
    public int getMiniPortWidth() {
        return MINI_PORT_WIDTH;
    }

    @Override
    public int getMiniPortHeight() {
        return MINI_PORT_HEIGHT;
    }

    @Override
    public int getMiniOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getMiniOpticonYSpacing() {
        return MINI_OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniOpticonYOffset() {
        return MINI_OPTICON_Y_OFFSET;
    }

    @Override
    public int getSmallMiniPortWidth() {
        return 0;
    }

    @Override
    public int getSmallMiniPortHeight() {
        return 0;
    }

    @Override
    public int getSmallMiniOpticonYSpacing() {
        return 0;
    }

    @Override
    public int getSmallMiniOpticonYOffset() {
        return 0;
    }

    @Override
    public int getSmallerPortConn1Y() {
        return 0;
    }

    @Override
    public int getSmallerPortConn2Y() {
        return 0;
    }

    @Override
    public int getPortX(int n, int n2) {
        return MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    @Override
    public int getPortY(int n, int n2) {
        if (n == 0) {
            return OPTICON_Y_OFFSET + OPTICON_Y_SPACING * n2;
        }
        return OPTICON_Y_OFFSET + SMALL_OPTICON_Y_SPACING * n2;
    }

    @Override
    public int getSmallPortWidth() {
        return 0;
    }

    @Override
    public int getSmallPortHeight() {
        return SMALL_PORT_HEIGHT;
    }

    @Override
    public int getPortConn1X() {
        return PORT_CONN1_X;
    }

    @Override
    public int getPortConn2X() {
        return PORT_CONN2_X;
    }

    @Override
    public int getPortConn1Y() {
        return PORT_CONN1_Y;
    }

    @Override
    public int getPortConn2Y() {
        return PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1Y() {
        return SMALL_PORT_CONN1_Y;
    }

    @Override
    public int getSmallPortConn2Y() {
        return SMALL_PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1X() {
        return 0;
    }

    @Override
    public int getSmallPortConn2X() {
        return 0;
    }

    @Override
    public int getPortLoopbackDist() {
        return 3;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        this.paintActual(graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(0.25f));
        graphics2D.draw(this.mainRectangle);
        int n3 = 0;
        int n4 = 0;
        if (this.cg.getSlotsOccupied() > 1) {
            n4 += (this.cg.getSlotsOccupied() - 1) * 6;
        }
        Image image = new ImageIcon("images/extract_1.gif").getImage();
        graphics2D.drawImage(image, n3, n4, null);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(stroke);
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(1, 5.0f);
        graphics2D.setFont(font2);
        graphics2D.setFont(font);
        n3 = CARD_WIDTH - 15;
        n4 = 0;
        if (this.cg.getSlotsOccupied() > 1) {
            n4 += (this.cg.getSlotsOccupied() - 1) * 6;
        }
        image = new ImageIcon("images/extract_1_1.gif").getImage();
        graphics2D.drawImage(image, n3, n4, null);
    }

    public void paintActual(Graphics2D graphics2D) {
        int n = this.cg.getState();
        int n2 = this.cg.getSlot();
        int n3 = this.cg.getSlotsOccupied();
        String string = null;
        int n4 = CARD_WIDTH;
        boolean bl = false;
        ArrayList arrayList = ((EntityModel)this.cg.getModel()).getNodeModelDelegate().getMfgData(this.cg.getModel().getShelfId());
        for (int i = 0; i < n3; ++i) {
            block4: {
                block6: {
                    block5: {
                        block3: {
                            bl = false;
                            this.topBackgroundRectangle = new Rectangle(i * n4, 0, n4, TOP_EXTRACTOR_HEIGHT);
                            this.bottomBackgroundRectangle = new Rectangle(i * n4, BOTTOM_RECT_OFFSET, n4, this.HEIGHT);
                            string = (String)arrayList.get(n2 + i - 1);
                            if (string == null || !string.equals("FILLER")) break block3;
                            graphics2D.setColor(Color.white);
                            graphics2D.fill(this.topBackgroundRectangle);
                            graphics2D.fill(this.bottomBackgroundRectangle);
                            bl = true;
                            break block4;
                        }
                        if (i != 0) break block5;
                        if (this.cg.getState() == 1 && this.cg.hasProvisionedCard()) break block6;
                    }
                    if (i <= 0 || string == null || string.equals("")) break block4;
                }
                graphics2D.setColor(this.cg.getCurrentColor());
                graphics2D.fill(this.topBackgroundRectangle);
                graphics2D.fill(this.bottomBackgroundRectangle);
                bl = true;
            }
            if (!bl || i <= 0) continue;
            Rectangle rectangle = new Rectangle(i * n4 + TAB_MARGIN, 0 + TAB_MARGIN, EXTRACTOR_WIDTH - 2 * TAB_MARGIN, TOP_EXTRACTOR_HEIGHT - 2 * TAB_MARGIN);
            Rectangle rectangle2 = new Rectangle(i * n4 + TAB_MARGIN, BOTTOM_EXTRACTOR_OFFSET + TAB_MARGIN, EXTRACTOR_WIDTH - 2 * TAB_MARGIN, BOTTOM_EXTRACTOR_HEIGHT - 2 * TAB_MARGIN);
            Arc2D.Double double_ = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, 0 - TAB_ARC_HEIGHT, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, 90.0, 0);
            Arc2D.Double double_2 = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, 0 + TAB_ARC_HEIGHT, TAB_DIAMETER, TAB_DIAMETER, 90.0, -180.0, 0);
            Line2D.Double double_3 = new Line2D.Double(i * n4, EXTRACTOR_HEIGHT, EXTRACTOR_WIDTH + TAB_ARC_WIDTH + i * n4, EXTRACTOR_HEIGHT);
            Arc2D.Double double_4 = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET + TAB_DIAMETER, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, -90.0, 0);
            Arc2D.Double double_5 = new Arc2D.Double(i * n4 + EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET, TAB_DIAMETER, TAB_DIAMETER, -90.0, 180.0, 0);
            Line2D.Double double_6 = new Line2D.Double(i * n4, BOTTOM_EXTRACTOR_OFFSET, EXTRACTOR_WIDTH + TAB_ARC_WIDTH + i * n4, BOTTOM_EXTRACTOR_OFFSET);
            Line2D.Double double_7 = new Line2D.Double(i * n4, 0.0, i * n4, EXTRACTOR_HEIGHT);
            Line2D.Double double_8 = new Line2D.Double(i * (n4 * 2), 0.0, i * (n4 * 2), EXTRACTOR_HEIGHT);
            Line2D.Double double_9 = new Line2D.Double(i * n4, BOTTOM_RECT_OFFSET, i * n4, BOTTOM_EXTRACTOR_OFFSET + EXTRACTOR_HEIGHT);
            Line2D.Double double_10 = new Line2D.Double(i * (n4 * 2), BOTTOM_RECT_OFFSET, i * (n4 * 2), BOTTOM_EXTRACTOR_OFFSET + EXTRACTOR_HEIGHT);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(this.mainRectangle);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.gray);
            graphics2D.draw(rectangle);
            graphics2D.draw(rectangle2);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
            graphics2D.draw(double_3);
            graphics2D.draw(double_4);
            graphics2D.draw(double_5);
            graphics2D.draw(double_6);
            graphics2D.draw(double_8);
            graphics2D.draw(double_7);
            graphics2D.draw(double_10);
            graphics2D.draw(double_9);
        }
    }

    static {
        PORT_CONN2_X = PORT_CONN1_X = PORT_WIDTH / 2;
        PORT_CONN1_Y = PORT_HEIGHT / 3;
        PORT_CONN2_Y = PORT_CONN1_Y * 2;
        SMALL_PORT_CONN1_Y = SMALL_PORT_HEIGHT / 3;
        SMALL_PORT_CONN2_Y = SMALL_PORT_CONN1_Y * 2;
        OPTICON_X_OFFSET = (CARD_WIDTH - PORT_WIDTH) / 2;
        MULTIPORT_OPTICON_X_OFFSET = (CARD_WIDTH - PORT_WIDTH) / 2;
        OPTICON_Y_OFFSET = Math.round(1.9090909f);
        RECT_HEIGHT = Math.round(0.08181818f);
        TOP_RECT_OFFSET = RECT_OFFSET = Math.round(1.4181818f);
        TOP_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_RECT_OFFSET = Math.round(4.8818183f);
        BOTTOM_RECT_HEIGHT = RECT_HEIGHT;
        EXTRACTOR_HEIGHT = Math.round(0.7090909f);
        EXTRACTOR_WIDTH = Math.round((float)EXTRACTOR_HEIGHT * 0.46153846f);
        TAB_MARGIN = CARD_WIDTH / 2;
        TAB_RADIUS = (CARD_WIDTH - EXTRACTOR_WIDTH) / 2;
        TAB_DIAMETER = TAB_RADIUS * 2;
        TAB_ARC_WIDTH = CARD_WIDTH - EXTRACTOR_WIDTH - TAB_RADIUS;
        TAB_ARC_HEIGHT = EXTRACTOR_HEIGHT - TAB_DIAMETER;
        BOTTOM_EXTRACTOR_OFFSET = 6 - EXTRACTOR_HEIGHT - 1;
        BOTTOM_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        TOP_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        NAME_X_OFFSET = Math.round((float)CARD_WIDTH * 0.083333336f) - 1;
        NAME_Y_OFFSET = Math.round(1.1727273f);
        ACTIVE_LIGHT_Y_OFFSET = Math.round(1.6363637f);
        ACTIVE_LIGHT_WIDTH = Math.round((float)CARD_WIDTH * 0.25f) - 1;
        ACTIVE_LIGHT_HEIGHT = Math.round(0.10909091f);
        OPTICON_Y_SPACING = Math.round(0.6818182f);
        SMALL_OPTICON_Y_SPACING = Math.round(0.5113636f);
        MINI_PORT_WIDTH = PORT_WIDTH;
        MINI_PORT_HEIGHT = Math.round((float)CARD_WIDTH * 0.41666666f * 1.15f);
        MINI_MULTIPORT_OPTICON_X_OFFSET = (CARD_WIDTH - MINI_PORT_WIDTH) / 2;
        MINI_OPTICON_Y_OFFSET = OPTICON_Y_OFFSET - 4;
        MINI_OPTICON_Y_SPACING = MINI_PORT_HEIGHT + 3;
        dash1 = new float[]{1.5f};
        topExtractorRectangle = new Rectangle(TAB_MARGIN, 0 + TAB_MARGIN, EXTRACTOR_WIDTH - 2 * TAB_MARGIN, TOP_EXTRACTOR_HEIGHT - 2 * TAB_MARGIN);
        bottomExtractorRectangle = new Rectangle(TAB_MARGIN, BOTTOM_EXTRACTOR_OFFSET + TAB_MARGIN, EXTRACTOR_WIDTH - 2 * TAB_MARGIN, BOTTOM_EXTRACTOR_HEIGHT - 2 * TAB_MARGIN);
        topExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, 0 - TAB_ARC_HEIGHT, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, 90.0, 0);
        topExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH, 0 + TAB_ARC_HEIGHT, TAB_DIAMETER, TAB_DIAMETER, 90.0, -180.0, 0);
        topExtractorLine = new Line2D.Double(0.0, EXTRACTOR_HEIGHT, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, EXTRACTOR_HEIGHT);
        bottomExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET + TAB_DIAMETER, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, -90.0, 0);
        bottomExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET, TAB_DIAMETER, TAB_DIAMETER, -90.0, 180.0, 0);
        bottomExtractorLine = new Line2D.Double(0.0, BOTTOM_EXTRACTOR_OFFSET, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, BOTTOM_EXTRACTOR_OFFSET);
    }
}

