/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctcutsXsdh.ui;

import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.MSIsc100T.MSIsc100TCardView;
import cerent.cms.ui.ml2.ML2CardView;
import cerent.cms.ui.ml2.ML2EnhCardView;
import cerent.cms.ui.mrc.MrcCardView;
import cerent.cms.ui.ransvc.RanSvcCardView;
import cerent.cms.ui.shelf.ADM10GCardView;
import cerent.cms.ui.shelf.AiciCardView;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.E142CardView;
import cerent.cms.ui.shelf.G1000CardView;
import cerent.cms.ui.shelf.MuxDmuxCardView;
import cerent.cms.ui.shelf.OpticsCardView;
import cerent.cms.ui.shelf.OscCardView;
import cerent.cms.ui.shelf.TncCardView;
import cerent.cms.ui.shelf.WssCardView;
import cerent.cms.ui.shelf.WxcCardView;
import cerent.cms.ui.shelf.XP40GCardView;
import cerent.cms.ui.xpl2.XPL2CardView;
import cerent.util.SDebug;

public class CardViewPanel
extends AbstractCardViewPanel {
    private static final SDebug db = new SDebug("CardViewPanel");

    public CardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        super(moduleModel, cardViewController);
    }

    @Override
    protected void setupCardView() {
        if (this.model instanceof XPL2ModuleModel) {
            this.cardView = new XPL2CardView(this.model, (AbstractCardViewPanel)this);
        } else if (this.model instanceof DwdmModuleModel) {
            this.cardView = this.model.getEqType() == 273 ? new ADM10GCardView((EntityModel)this.model, (AbstractCardViewPanel)this) : (this.model.getEqType() == 300 || this.model.getEqType() == 301 || this.model.getEqType() == 356 || this.model.getEqType() == 358 ? new XP40GCardView(this.model, (AbstractCardViewPanel)this) : new DwdmCardView((EntityModel)this.model, (AbstractCardViewPanel)this));
        } else {
            switch (this.model.getEqType()) {
                case 108: 
                case 109: {
                    this.cardView = new E142CardView(this.model);
                    break;
                }
                case 97: {
                    this.cardView = new AiciCardView(this.model);
                    break;
                }
                case 102: 
                case 103: 
                case 221: {
                    if (!(this.model instanceof L2scModuleModel)) break;
                    L2scModuleModel l2scModuleModel = (L2scModuleModel)this.model;
                    this.cardView = new ML2CardView(l2scModuleModel, l2scModuleModel.getL2scEtherPorts(), l2scModuleModel.getL2scPosPorts());
                    break;
                }
                case 238: {
                    if (!(this.model instanceof L2scModuleModel)) break;
                    L2scModuleModel l2scModuleModel = (L2scModuleModel)this.model;
                    this.cardView = new MSIsc100TCardView((ModuleModel)l2scModuleModel, l2scModuleModel.getL2scEtherPorts());
                    break;
                }
                case 62: {
                    this.cardView = new G1000CardView(this.model);
                    break;
                }
                case 187: 
                case 229: 
                case 283: {
                    if (!(this.model instanceof ML2ModuleModel)) break;
                    ML2ModuleModel mL2ModuleModel = (ML2ModuleModel)this.model;
                    this.cardView = new ML2CardView(mL2ModuleModel, mL2ModuleModel.getEtherPortModels(), mL2ModuleModel.getPosPortModels(), mL2ModuleModel.isInMapperMode());
                    break;
                }
                case 285: {
                    this.cardView = new ML2EnhCardView(this.model);
                    break;
                }
                case 129: 
                case 130: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 196: 
                case 239: 
                case 240: 
                case 249: 
                case 277: 
                case 278: 
                case 281: 
                case 286: 
                case 287: 
                case 294: 
                case 295: 
                case 296: 
                case 298: 
                case 299: 
                case 321: {
                    this.cardView = new OpticsCardView(this.model, this);
                    break;
                }
                case 131: 
                case 132: 
                case 192: 
                case 241: 
                case 264: 
                case 265: 
                case 268: 
                case 269: {
                    this.cardView = new MuxDmuxCardView(this.model, this);
                    break;
                }
                case 266: 
                case 270: {
                    this.cardView = new WxcCardView(this.model, this);
                    break;
                }
                case 191: 
                case 242: 
                case 263: 
                case 267: {
                    this.cardView = new WssCardView(this.model, this);
                    break;
                }
                case 127: 
                case 128: {
                    this.cardView = new OscCardView(this.model, this);
                    break;
                }
                case 219: 
                case 220: 
                case 253: {
                    this.cardView = new MrcCardView((PluggableCarrierModel)this.model);
                    break;
                }
                case 248: {
                    this.cardView = new RanSvcCardView(this.model);
                    break;
                }
                case 330: {
                    this.cardView = new TncCardView((EntityModel)this.model, (AbstractCardViewPanel)this);
                    break;
                }
                default: {
                    super.setupCardView();
                }
            }
        }
        if (db.on()) {
            db.println("setupCardView cardView is " + this.cardView);
        }
    }
}

