/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctcutsXsdh.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingProvPane;
import cerent.cms.ui.shelf.GeneralPane;
import cerent.cms.ui.shelf.SppAnsPane;
import cerent.cms.ui.shelf.SppRingPane;
import cerent.cms.ui.shelf.sdh.SdhSppTimingProvPane;
import cerent.cms.ui.uts.AlarmExtProvPane;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShelfProvPane
extends AbstractShelfProvPane {
    private HashMap msTabMap;
    private HashMap ssTabMap;

    public ShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        super(string, tabbedView, iGuestPaneFactory);
    }

    @Override
    protected void localInit() {
        boolean bl = false;
        if (this.getUiModel() instanceof IChassisModel) {
            ChassisModel chassisModel = (ChassisModel)this.getUiModel();
            if (chassisModel.isUTSChassis()) {
                bl = true;
            }
            if (this.getUiModel().getNodeModel().getNodeType() != 2 && !bl) {
                this.newTab(this.RING_TAB, (Component)((Object)new SppRingPane(this.RING_TAB, this.subTabs)));
            } else {
                this.newTab("SVLAN", (Component)((Object)this.getSvlanPane("SVLAN", this.subTabs)));
            }
            if (!this.getUiModel().getNodeModel().isMultishelf()) {
                this.newTab("WDM-ANS", (Component)((Object)new SppAnsPane("WDM-ANS", this.subTabs)));
                this.newTab("SVLAN", (Component)((Object)this.getSvlanPane("SVLAN", this.subTabs)));
            }
            if (chassisModel.isM6Chassis()) {
                this.newTab("Alarm Extenders", (Component)((Object)new AlarmExtProvPane("Alarm Extenders", this.subTabs, this, this.getAlarmInput(), this.getControlOutput())));
            }
        } else {
            this.newTab("WDM-ANS", (Component)((Object)new SppAnsPane("WDM-ANS", this.subTabs)));
            this.newTab("SVLAN", (Component)((Object)this.getSvlanPane("SVLAN", this.subTabs)));
        }
    }

    @Override
    public EnvAlarmModel[] getAlarmInput() {
        EntityModel entityModel = null;
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        try {
            entityModel = (EntityModel)iChassisModel.getEntityTableModel().getEntityModelBySlot(iChassisModel.getShelfId(), 21);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        List list = entityModel.getDescendantsOfType(eEqType.ENVIRONMENT_ALARM);
        return list.toArray(new EnvAlarmModel[0]);
    }

    private EnvControlModel[] getControlOutput() {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)iChassisModel.getEntityTableModel().getEntityModelBySlot(iChassisModel.getShelfId(), 21);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        List list = entityModel.getDescendantsOfType(eEqType.ENVIRONMENT_CONTROL);
        return list.toArray(new EnvControlModel[0]);
    }

    @Override
    protected Pane getGeneralPane(TabbedView tabbedView) {
        return new GeneralPane("General", tabbedView);
    }

    @Override
    protected AbstractSppTimingProvPane getSppTimingPane(String string, TabbedView tabbedView) {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        return new SdhSppTimingProvPane(string, tabbedView, iChassisModel.getSyncModel(), iChassisModel.getElementModels());
    }

    @Override
    protected Map getTabMap() {
        if (this.getUiModel().getNodeModel().isMultishelf()) {
            return this.msTabMap;
        }
        return this.ssTabMap;
    }

    @Override
    protected void initPositions() {
        ChassisModel chassisModel;
        int n = this.getUiModel().getNodeModel().getNodeType();
        this.ssTabMap = new HashMap();
        this.ssTabMap.put("General", new Integer(0));
        boolean bl = false;
        if (this.getUiModel() instanceof IChassisModel && (chassisModel = (ChassisModel)this.getUiModel()).isUTSChassis()) {
            bl = true;
        }
        if (n != 2 && !bl) {
            this.ssTabMap.put("Ether Bridge", new Integer(1));
            this.ssTabMap.put("Network", new Integer(2));
            this.ssTabMap.put("OSI", new Integer(3));
            this.ssTabMap.put(this.RING_TAB, new Integer(4));
            this.ssTabMap.put("Protection", new Integer(5));
            this.ssTabMap.put("Security", new Integer(6));
            this.ssTabMap.put("SNMP", new Integer(7));
            this.ssTabMap.put("Comm Channels", new Integer(8));
            this.ssTabMap.put("Timing", new Integer(9));
            this.ssTabMap.put("Alarm Profiles", new Integer(10));
            this.ssTabMap.put("Defaults", new Integer(11));
            this.ssTabMap.put("WDM-ANS", new Integer(12));
            this.ssTabMap.put("SVLAN", new Integer(13));
        } else {
            this.ssTabMap.put("Network", new Integer(1));
            this.ssTabMap.put("OSI", new Integer(2));
            this.ssTabMap.put("Protection", new Integer(3));
            this.ssTabMap.put("Security", new Integer(4));
            this.ssTabMap.put("SNMP", new Integer(5));
            this.ssTabMap.put("Comm Channels", new Integer(6));
            this.ssTabMap.put("Timing", new Integer(7));
            this.ssTabMap.put("Alarm Profiles", new Integer(8));
            this.ssTabMap.put("Defaults", new Integer(9));
            this.ssTabMap.put("WDM-ANS", new Integer(10));
            this.ssTabMap.put("SVLAN", new Integer(11));
            if (this.getUiModel() instanceof IChassisModel && (chassisModel = (ChassisModel)this.getUiModel()).isM6Chassis()) {
                this.ssTabMap.put("Alarm Extenders", new Integer(12));
            }
        }
        this.msTabMap = new HashMap();
        this.msTabMap.put("General", new Integer(0));
        this.msTabMap.put("Network", new Integer(1));
        this.msTabMap.put("OSI", new Integer(2));
        this.msTabMap.put("Protection", this.getUiModel() instanceof IChassisModel ? new Integer(1) : new Integer(3));
        this.msTabMap.put("Security", new Integer(4));
        this.msTabMap.put("SNMP", new Integer(5));
        this.msTabMap.put("Comm Channels", new Integer(6));
        this.msTabMap.put("Alarm Profiles", this.getUiModel() instanceof IChassisModel ? new Integer(3) : new Integer(7));
        this.msTabMap.put("Defaults", new Integer(8));
        this.msTabMap.put("WDM-ANS", new Integer(9));
        this.msTabMap.put("Timing", new Integer(2));
        if (this.getUiModel() instanceof IChassisModel) {
            this.msTabMap.put("SVLAN", new Integer(4));
            if (((ChassisModel)this.getUiModel()).isM6Chassis()) {
                this.msTabMap.put("Alarm Extenders", new Integer(5));
            }
        } else {
            this.msTabMap.put("SVLAN", new Integer(10));
            if (this.getUiModel() instanceof IChassisModel && ((ChassisModel)this.getUiModel()).isM6Chassis()) {
                this.msTabMap.put("Alarm Extenders", new Integer(11));
            }
        }
    }
}

