/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CouldNotGenerateUniqueId;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IdAlreadyPresent;
import cerent.cms.model.InvalidCircuitInfoParameters;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetCmsCommFailException;
import cerent.cms.model.NetModelObserver;
import cerent.cms.model.NodeModel;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Observable;

public class CircuitFactoryModel
extends NetModelObserver
implements ICircuitFactoryModel,
IObserver {
    ICircuitFactoryModel delegate;
    NodeModel nodeModel = null;

    public CircuitFactoryModel(NodeModel nodeModel) {
        super(null);
        this.db = new CircuitFactoryDebug(nodeModel.db, "CircuitFactoryModel");
        this.nodeModel = nodeModel;
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public ICircuitModel getCircuitModelById(ICircuitId iCircuitId) {
        return null;
    }

    public ICircuitModel[] getCircuits() {
        return this.getDelegate().getCircuits();
    }

    public ICircuitModel createCircuit(ICircuitInfo iCircuitInfo) throws InvalidCircuitInfoParameters, CouldNotGenerateUniqueId, AbstractCmsIOException, IdAlreadyPresent, InvalidCircuitName {
        return this.getDelegate().createCircuit(iCircuitInfo);
    }

    public ICircuitModel createCircuit(INodeModel iNodeModel, ICircuitInfo iCircuitInfo) throws InvalidCircuitInfoParameters, CouldNotGenerateUniqueId, AbstractCmsIOException, IdAlreadyPresent, InvalidCircuitName {
        return this.getDelegate().createCircuit(iNodeModel, iCircuitInfo);
    }

    public void init() {
        if (this.db.on()) {
            this.db.println("init");
        }
        this.init0();
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        super.destroy();
    }

    private void destroyDelegate() {
        block10: {
            if (this.db.on()) {
                this.db.println("destroyDelegate");
            }
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.delegate, this);
            if (!this.nodeModel.provides(Feature.NMD_BASED_CM_DESTROY)) {
                if (this.db.on()) {
                    this.db.println("CFM.destroyDelegate(): NMD_BASED_CM_DESTROY Feature is not provided.");
                }
                try {
                    if (this.nodeModel.getNeType() != null && this.nodeModel.getNeType().indexOf("15454") != -1) {
                        if (this.nodeModel.provides(Feature.HTTP_DATA_TRANSFER)) {
                            if (this.db.on()) {
                                this.db.println("CFM.destroyDelegate(): destroyed CFMD for 15454 node");
                            }
                            this.delegate.destroy();
                        }
                    } else {
                        if (this.db.on()) {
                            this.db.println("CFM.destroyDelegate(): destroyed CFMD for non-15454 node");
                        }
                        this.delegate.destroy();
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block10;
                    this.db.println("CFM.destroyDelegate() " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.delegate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose");
        }
        CircuitFactoryModel circuitFactoryModel = this;
        synchronized (circuitFactoryModel) {
            if (this.delegate != null) {
                this.destroyDelegate();
            }
        }
        this.db.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(ICircuitFactoryModel iCircuitFactoryModel) {
        if (this.db.on) {
            this.db.println("setDelegate");
        }
        CircuitFactoryModel circuitFactoryModel = this;
        synchronized (circuitFactoryModel) {
            if (this.delegate != null) {
                this.destroyDelegate();
            }
            this.delegate = iCircuitFactoryModel;
            ModelIndirectObservable.instance().addObserver((IObservable)this.delegate, this);
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable == this.delegate || this.delegate != null && this.delegate.equals(iObservable)) {
            if (this.db.on) {
                this.db.println("Sending update Message " + object);
            }
            this.setChanged();
            this.notifyObservers(object);
        } else {
            ICircuitFactoryModel iCircuitFactoryModel;
            if (this.db.on()) {
                this.db.println("update from " + iObservable.getClass().toString());
            }
            if ((iCircuitFactoryModel = this.delegate) != null) {
                iCircuitFactoryModel.update((Observable)iObservable, object);
            }
        }
    }

    private ICircuitFactoryModel getDelegate() {
        ICircuitFactoryModel iCircuitFactoryModel = this.delegate;
        if (iCircuitFactoryModel == null) {
            throw new NetCmsCommFailException("No delegate for CircuitFactoryModel");
        }
        return iCircuitFactoryModel;
    }

    private void notifyAdded() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public class CircuitFactoryDebug
    extends SDebug {
        public CircuitFactoryDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void sendAddedUpdate() {
            CircuitFactoryModel.this.notifyAdded();
        }

        public void dispose() {
            super.dispose();
        }
    }
}

