/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CircuitEnd;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.IVlanInfo;

public class CktInfo
implements ICircuitInfo {
    protected short circuitProvVersion;
    private ICircuitEnd[] srcInfo;
    protected ICircuitDropInfo[] dropInfo;
    protected boolean monitor;
    protected IVlanInfo[] vlans;
    protected int circuitSize;
    protected int circuitType;
    protected int dir;
    protected String circuitName;
    protected short sla;
    protected int cktOptDir;
    protected int cktOptChannel;
    protected int vcatRoutingPref;

    public CktInfo() {
    }

    public CktInfo(short s, ICircuitEnd[] iCircuitEndArray, ICircuitDropInfo[] iCircuitDropInfoArray, boolean bl, IVlanInfo[] iVlanInfoArray, int n, int n2, int n3, String string, short s2, short s3, short s4, int n4) {
        this.circuitProvVersion = s;
        this.srcInfo = iCircuitEndArray;
        this.dropInfo = iCircuitDropInfoArray;
        this.monitor = bl;
        this.vlans = iVlanInfoArray;
        this.circuitSize = n;
        this.circuitType = n2;
        this.dir = n3;
        this.circuitName = string;
        this.sla = s2;
        this.cktOptChannel = s3;
        this.cktOptDir = s4;
        this.vcatRoutingPref = n4;
    }

    public short getCircuitProvVersion() {
        return this.circuitProvVersion;
    }

    public void setCircuitProvVersion(short s) {
        this.circuitProvVersion = s;
    }

    public ICircuitEnd getSrcPoint() {
        if (this.srcInfo != null && this.srcInfo.length > 0) {
            return this.srcInfo[0];
        }
        return CktInfo.createNullCircuitEnd();
    }

    public void setSrcPoint(ICircuitEnd iCircuitEnd) {
        if (this.srcInfo == null || this.srcInfo.length < 1) {
            this.srcInfo = new ICircuitEnd[2];
            this.srcInfo[1] = CktInfo.createNullCircuitEnd();
        }
        this.srcInfo[0] = iCircuitEnd;
    }

    public ICircuitEnd getSecSrcPoint() {
        if (this.srcInfo != null && this.srcInfo.length > 1) {
            return this.srcInfo[1];
        }
        return CktInfo.createNullCircuitEnd();
    }

    public void setSecSrcPoint(ICircuitEnd iCircuitEnd) {
        if (this.srcInfo == null || this.srcInfo.length < 2) {
            CircuitEnd circuitEnd = this.getSrcPoint() != null ? this.getSrcPoint() : CktInfo.createNullCircuitEnd();
            this.srcInfo = new ICircuitEnd[2];
            this.srcInfo[0] = circuitEnd;
        }
        this.srcInfo[1] = iCircuitEnd;
    }

    public ICircuitEnd[] getSrcInfo() {
        return this.srcInfo;
    }

    public void addSrcPoint(ICircuitEnd iCircuitEnd) {
        int n = this.srcInfo != null ? this.srcInfo.length : 0;
        ICircuitEnd[] iCircuitEndArray = new ICircuitEnd[n + 1];
        for (int i = 0; i < n; ++i) {
            iCircuitEndArray[i] = this.srcInfo[i];
        }
        iCircuitEndArray[i] = iCircuitEnd;
        this.srcInfo = iCircuitEndArray;
    }

    public void setSrcInfo(ICircuitEnd[] iCircuitEndArray) {
        this.srcInfo = iCircuitEndArray;
    }

    public ICircuitDropInfo[] getDropInfo() {
        return this.dropInfo;
    }

    public void setDropInfo(ICircuitDropInfo[] iCircuitDropInfoArray) {
        this.dropInfo = iCircuitDropInfoArray;
    }

    public boolean getMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean bl) {
        this.monitor = bl;
    }

    public IVlanInfo[] getVlans() {
        return this.vlans;
    }

    public void setVlans(IVlanInfo[] iVlanInfoArray) {
        this.vlans = iVlanInfoArray;
    }

    public int getCircuitSize() {
        return this.circuitSize;
    }

    public void setCircuitSize(int n) {
        this.circuitSize = n;
    }

    public int getCircuitType() {
        return this.circuitType;
    }

    public void setCircuitType(int n) {
        this.circuitType = n;
    }

    public int getDir() {
        return this.dir;
    }

    public void setDir(int n) {
        this.dir = n;
    }

    public String getCircuitName() {
        return this.circuitName;
    }

    public void setCircuitName(String string) {
        this.circuitName = string;
    }

    public short getSla() {
        return this.sla;
    }

    public void setSla(short s) {
        this.sla = s;
    }

    public int getVcatRoutingPref() {
        return this.vcatRoutingPref;
    }

    public void setVcatRoutingPref(int n) {
        this.vcatRoutingPref = n;
    }

    public int getCktOptDir() {
        return this.cktOptDir;
    }

    public void setCktOptDir(int n) {
        this.cktOptDir = n;
    }

    public int getCktOptChannel() {
        return this.cktOptChannel;
    }

    public void setCktOptChannel(int n) {
        this.cktOptChannel = n;
    }

    private static CircuitEnd createNullCircuitEnd() {
        return new CircuitEnd(0, 0, null, null, false, 0);
    }
}

