/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.util.SDebug;
import java.util.HashSet;

public class DomainModel
extends CmsObservable {
    private String name = "";
    private HashSet nodeSet = new HashSet();
    public static SDebug db = new SDebug("DomainModel");

    public DomainModel(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int size() {
        return this.nodeSet.size();
    }

    public synchronized boolean contains(NodeModel nodeModel) {
        return this.nodeSet.contains(nodeModel);
    }

    private void sendUpdate(NodeModel nodeModel) {
        if (DomainModel.db.on) {
            db.println("sendUpdate: domain=" + this.name + " node=" + nodeModel.getName());
        }
        this.setChanged();
        this.notifyObservers(nodeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(NodeModel nodeModel) {
        if (DomainModel.db.on) {
            db.println("add: node=" + nodeModel.getName() + " to domain=" + this.name);
        }
        HashSet hashSet = this.nodeSet;
        synchronized (hashSet) {
            this.nodeSet.add(nodeModel);
        }
        this.sendUpdate(nodeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(NodeModel nodeModel) {
        if (DomainModel.db.on) {
            db.println("remove: node=" + nodeModel.getName() + " from domain=" + this.name);
        }
        HashSet hashSet = this.nodeSet;
        synchronized (hashSet) {
            this.nodeSet.remove(nodeModel);
        }
        this.sendUpdate(nodeModel);
    }

    public synchronized NodeModel[] getModelList() {
        return this.nodeSet.toArray(new NodeModel[0]);
    }

    synchronized void dispose() {
        if (DomainModel.db.on) {
            db.println("dispose: domain=" + this.name);
        }
        this.nodeSet = new HashSet();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }
}

