/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkwideModel;
import cerent.util.IAttributeCache;
import cerent.util.TimeBasedAttributeCache;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ModelTimeBasedAttributeCache
extends TimeBasedAttributeCache<NetworkwideModel> {
    private ModelAttributeCache modelCache = new ModelAttributeCache();
    private Random random = new Random(System.currentTimeMillis());

    public ModelTimeBasedAttributeCache(long l) {
        super(new ConcurrentHashMap(), l);
    }

    public IAttributeCache<IModel> getModelAttributeCache() {
        return this.modelCache;
    }

    @Override
    protected Map<Integer, Object> createNewAttrMap(NetworkwideModel networkwideModel) {
        networkwideModel.link(this);
        networkwideModel.observe();
        return new ConcurrentHashMap<Integer, Object>();
    }

    @Override
    protected Object rawCache(Map<Integer, Object> map, int n, Object object, boolean bl) {
        Object object2 = null;
        if (map instanceof ConcurrentMap && !bl) {
            ConcurrentMap concurrentMap = (ConcurrentMap)map;
            object2 = concurrentMap.putIfAbsent(n, object instanceof TimeBasedAttributeCache.TimestampedValue ? object : new ExtendableTimestampedValue(object));
        } else {
            object2 = map.put(n, object instanceof TimeBasedAttributeCache.TimestampedValue ? object : new ExtendableTimestampedValue(object));
        }
        return object2;
    }

    @Override
    public boolean doExtendTime(TimeBasedAttributeCache.TimestampedValue timestampedValue, Map<Integer, Object> map, NetworkwideModel networkwideModel, int n) {
        ExtendableTimestampedValue extendableTimestampedValue;
        boolean bl = false;
        if (timestampedValue instanceof ExtendableTimestampedValue && !(extendableTimestampedValue = (ExtendableTimestampedValue)timestampedValue).isExtended()) {
            extendableTimestampedValue.setTimestamp(System.currentTimeMillis() + (long)(this.random.nextDouble() * (double)this.maxElapsedTime));
            bl = true;
            extendableTimestampedValue.setExtended(true);
        }
        return bl;
    }

    public void invalidate(INodeModel iNodeModel) {
        NetworkwideModel networkwideModel;
        NetworkwideModel networkwideModel2;
        if (this.db != null && this.db.on()) {
            this.db.println("Invalidating node: " + iNodeModel);
        }
        Object[] objectArray = this.objCache.keySet().toArray();
        Arrays.sort(objectArray);
        NetworkwideModel networkwideModel3 = new NetworkwideModel((IModel)iNodeModel);
        int n = Arrays.binarySearch(objectArray, networkwideModel3);
        if (n < 0) {
            return;
        }
        int n2 = 0;
        int n3 = n;
        while (n3 >= 0 && (networkwideModel2 = (NetworkwideModel)objectArray[n3]).compareTo(networkwideModel3) == 0) {
            n2 = n3--;
        }
        n3 = 0;
        int n4 = 0;
        for (int i = n2; i < objectArray.length && (networkwideModel = (NetworkwideModel)objectArray[i]).compareTo(networkwideModel3) == 0; ++i) {
            ++n3;
            Map<Integer, Object> map = this.invalidate(networkwideModel);
            n4 += map == null ? 0 : map.size();
        }
        if (this.db.on()) {
            this.db.println("# models/attrs invalidated: " + n3 + "/" + n4);
        }
    }

    @Override
    public Map<Integer, Object> invalidate(NetworkwideModel networkwideModel) {
        if (this.db != null && this.db.on()) {
            this.db.println("Invalidating model: " + networkwideModel);
        }
        networkwideModel.unobserve();
        networkwideModel.unlink();
        return super.invalidate(networkwideModel);
    }

    public void dump() {
        if (this.db == null) {
            return;
        }
        this.db.println("Summary of model cache content: ");
        this.db.println("  total # of model instances: " + this.objCache.size());
        int n = 0;
        for (Map map : this.objCache.values()) {
            n += map.size();
        }
        this.db.println(" total # of attr instances: " + n);
    }

    static class ExtendableTimestampedValue
    extends TimeBasedAttributeCache.TimestampedValue {
        private boolean extended;

        public ExtendableTimestampedValue(Object object) {
            super(object);
        }

        public ExtendableTimestampedValue(Object object, long l) {
            super(object, l);
        }

        public boolean isExtended() {
            return this.extended;
        }

        public void setExtended(boolean bl) {
            this.extended = bl;
        }
    }

    class ModelAttributeCache
    implements IAttributeCache<IModel> {
        ModelAttributeCache() {
        }

        public Object cache(IModel iModel, int n, Object object) {
            return this.cache(iModel, n, object, false);
        }

        public Object cache(IModel iModel, int n, Object object, boolean bl) {
            if (iModel instanceof INodeModel) {
                throw new IllegalArgumentException("this cache is not intended for INodeModel caching");
            }
            NetworkwideModel networkwideModel = new NetworkwideModel(iModel);
            return ModelTimeBasedAttributeCache.this.cache(networkwideModel, n, object, bl);
        }

        public Object lookup(IModel iModel, int n) {
            NetworkwideModel networkwideModel = new NetworkwideModel(iModel);
            return ModelTimeBasedAttributeCache.this.lookup(networkwideModel, n);
        }

        public Map<Integer, Object> invalidate(IModel iModel) {
            NetworkwideModel networkwideModel = new NetworkwideModel(iModel);
            return ModelTimeBasedAttributeCache.this.invalidate(networkwideModel);
        }

        public Object invalidate(IModel iModel, int n) {
            NetworkwideModel networkwideModel = new NetworkwideModel(iModel);
            return ModelTimeBasedAttributeCache.this.invalidate(networkwideModel, n);
        }

        public void clear() {
            for (NetworkwideModel networkwideModel : ModelTimeBasedAttributeCache.this.objCache.keySet()) {
                networkwideModel.unobserve();
                networkwideModel.unlink();
            }
            ModelTimeBasedAttributeCache.this.clear();
        }
    }
}

