/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Attribute;
import cerent.cms.ncp.INetCircuitServiceState;
import cerent.cms.ui.NetworkDefaults;
import cerent.util.TDMTerminology;

public class NetServiceState
implements INetCircuitServiceState {
    private static Attribute[] cktServiceStateAttrs;

    private NetServiceState() {
    }

    public static String getPrimaryStateStringFromServiceState(int n) {
        if (n == -1) {
            return "";
        }
        return NetworkDefaults.getCmsHostTDMTerms().getTermForPrimaryState(n);
    }

    public static String getServiceStateStringFromServiceState(int n) {
        if (n == -1) {
            return "Unknown";
        }
        if (n == -2) {
            return "";
        }
        return NetworkDefaults.getCmsHostTDMTerms().getTermForServiceState(n);
    }

    public static Attribute[] getNetCircuitServiceStateAttrs() {
        if (cktServiceStateAttrs == null) {
            TDMTerminology tDMTerminology = NetworkDefaults.getCmsHostTDMTerms();
            cktServiceStateAttrs = new Attribute[3];
            NetServiceState.cktServiceStateAttrs[0] = new Attribute(tDMTerminology.getTermForPrimaryState(0), 0);
            NetServiceState.cktServiceStateAttrs[1] = new Attribute(tDMTerminology.getTermForPrimaryState(1), 1);
            NetServiceState.cktServiceStateAttrs[2] = new Attribute(tDMTerminology.getTermForPrimaryState(2), 2);
        }
        return cktServiceStateAttrs;
    }

    public static boolean isFormOfIS(int n) {
        return n == 0;
    }

    public static boolean isFormOfAINS(int n) {
        return n == 1;
    }

    public static boolean isFormOfOOS(int n) {
        return n != 0;
    }

    public static boolean isFormOfOOSOOG(int n) {
        return n == 17 || n == 18 || n == 19 || n == 24 || n == 27 || n == 28 || n == 29;
    }

    public static boolean isFormOfOOS_AU(int n) {
        return n == 1 || n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 10 || n == 22 || n == 23 || n == 24 || n == 29;
    }

    public static boolean isFormOfOOS_Non_AU(int n) {
        return !NetServiceState.isFormOfOOS_AU(n) && !NetServiceState.isFormOfIS(n);
    }
}

