/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IPortModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.ProxyConfigHelper;
import cerent.util.tty.TTYLogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeHelper
implements INodeHelper {
    private static NodeHelper instance = null;

    public static synchronized NodeHelper getInstance() {
        if (instance == null) {
            instance = new NodeHelper();
        }
        return instance;
    }

    public IEntityTableModel getEntityTableModel(String string) {
        INetElement iNetElement = Network.instance().findNetElemByIp(string);
        if (iNetElement == null) {
            return null;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        return iNodeModel.getEntityTable();
    }

    private NodeHelper() {
    }

    public String getSideConnectedToNodeName(INodeModel iNodeModel, int n) {
        INodeModel iNodeModel2 = this.getSideConnectedToNodeModel(iNodeModel, n);
        if (iNodeModel2 != null) {
            return iNodeModel2.getName();
        }
        return "not connected";
    }

    public INodeModel getSideConnectedToNodeModel(INodeModel iNodeModel, int n) {
        Network network = Network.instance();
        INetElement iNetElement = network.findNetElem(iNodeModel);
        List<INetLink> list = network.findAllNetLinksWithNetElemAndSide(iNetElement, n);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getDst().getNodeId() == iNodeModel.getNodeId()) continue;
            INetElement iNetElement2 = list.get(i).getDst();
            int n2 = list.get(i).getDstEntityIndex();
            IEntityTableModel iEntityTableModel = iNetElement2.getNodeModel().getEntityTable();
            if (iEntityTableModel == null) continue;
            try {
                IInterfaceModel iInterfaceModel = ((IPortModel)iEntityTableModel.getEntityModelByIndex(n2)).getInterfaceModel();
                if (!(iInterfaceModel instanceof IOpticsModel)) continue;
                return iNetElement2.getNodeModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized Collection<INodeModel> getAllNodesInNetwork() {
        Collection collection = Network.instance().getElements();
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        for (INetElement iNetElement : collection) {
            arrayList.add(iNetElement.getNodeModel());
        }
        return arrayList;
    }

    public synchronized Collection<INodeModel> getAllGNENodesInNetwork() {
        Collection collection = Network.instance().getElements();
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        for (INetElement iNetElement : collection) {
            if (ProxyConfigHelper.getProxyConfig((NetElement)iNetElement) != 2) continue;
            arrayList.add(iNetElement.getNodeModel());
        }
        return arrayList;
    }

    public void initTtyLogFactory() {
        TTYLogFactory.setClassLoader((ClassLoader)this.getClass().getClassLoader());
    }
}

