/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvEditDialog;
import cerent.cms.fv.IFvEleAlarmStore;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.fv.net.IFvNetSidePosition;
import cerent.cms.loader.ElementFactory;
import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.loader.IElementFactory;
import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsSecurityException;
import cerent.cms.model.AbstractNodeModel;
import cerent.cms.model.AlarmMessage;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitFactoryModel;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CmsMissingFeatureException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModels;
import cerent.cms.model.DefaultGreTunnelExists;
import cerent.cms.model.DefaultRouterConflict;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.DestinationExists;
import cerent.cms.model.ElementModels;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.FramingType;
import cerent.cms.model.IAlarmDecoderDefs;
import cerent.cms.model.IAlarmMessage;
import cerent.cms.model.IAlarmModel;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IChassisModels;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDatabaseManagementModel;
import cerent.cms.model.IDccConnectionTableModel;
import cerent.cms.model.IDelayedUpgradeModel;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.IEtherMacAddr;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IInterfaceModels;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ILanRipConfigModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILmpCtrlChannelModels;
import cerent.cms.model.ILmpDataLinkModels;
import cerent.cms.model.ILmpTeLinkModels;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeAdapter;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IOhCircuitFactoryModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOpticalPatchCordModel;
import cerent.cms.model.IOspfLanConfigModel;
import cerent.cms.model.IOspfTopologyModel;
import cerent.cms.model.IPoller;
import cerent.cms.model.IPoolModels;
import cerent.cms.model.IProgressManager;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IRipAddressSummaryModel;
import cerent.cms.model.IRprModel;
import cerent.cms.model.ISVlanProfileModels;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISideModels;
import cerent.cms.model.ISnmpModel;
import cerent.cms.model.IStateTransition;
import cerent.cms.model.IStaticRoute;
import cerent.cms.model.IStringTag;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.ISwUpgradeModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.IVcatTermModels;
import cerent.cms.model.IVirtualLinksManager;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.IncompatibleException;
import cerent.cms.model.InvalidData;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.InvalidNextHop;
import cerent.cms.model.InvalidNodeId;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.InvalidStaticDefaultRouteMask;
import cerent.cms.model.InvalidStaticRouteToAllOnes;
import cerent.cms.model.InvalidStaticRouteToBroadcast;
import cerent.cms.model.InvalidStaticRouteToClassA;
import cerent.cms.model.InvalidStaticRouteToClassB;
import cerent.cms.model.InvalidStaticRouteToClassC;
import cerent.cms.model.InvalidStaticRouteToClassDE;
import cerent.cms.model.InvalidStaticRouteToInternalNet;
import cerent.cms.model.InvalidStaticRouteToLocalNet;
import cerent.cms.model.InvalidStaticRouteToSelf;
import cerent.cms.model.InvalidStaticRouteToSelfSubnet;
import cerent.cms.model.InvalidUpperBound;
import cerent.cms.model.InvalidUserOrPasswordException;
import cerent.cms.model.MaxStaticRoutes;
import cerent.cms.model.ModelAttributeCacheManager;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetCmsCommFailException;
import cerent.cms.model.NetModelObserver;
import cerent.cms.model.NetworkConsistencyChecker;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchProperty;
import cerent.cms.model.NodePollerException;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.ObjectIdent;
import cerent.cms.model.OhCircuitFactoryModel;
import cerent.cms.model.OhConnectionModels;
import cerent.cms.model.OneAlarmState;
import cerent.cms.model.OneNodeStatus;
import cerent.cms.model.ProgressManager;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SvlanCircuitModels;
import cerent.cms.model.TdmProtocolType;
import cerent.cms.model.VcatTermModels;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.EventUtils;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.IEventStore;
import cerent.cms.model.event.NetworkAlarmDecoder;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.model.event.NetworkEventStore;
import cerent.cms.model.ucp.IUcpCircuits;
import cerent.cms.model.ucp.IUcpLinks;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.event.IAlarmDecoder;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.BusEvent;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.IIPAddressTranslator;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPAddressTranslator;
import cerent.util.InetUtil;
import cerent.util.JarFileDeleteEvent;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.ReflectionUtil;
import cerent.util.SDebug;
import cerent.util.SerializationUtil;
import cerent.util.SystemTime;
import cerent.util.TDMTerminology;
import cerent.util.UObservable;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobProgressControl;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.view.fv.IFvOpenActions;
import cerent.util.view.fv.IViewGraph;
import cerent.util.xml.DOMUtil;
import cerent.util.xml.XercesDOMParser;
import com.cisco.ctc.CtcApplication;
import com.cisco.ctc.RemoteEleConstants;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.fv.FunctOpenActions;
import com.cisco.fv.gui.FunctionalNetworkDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeModel
extends AbstractNodeModel
implements IObserver,
IFvNetNode {
    private static final String UNKNOWN_HOST = "unknown";
    private static final IIPAddressTranslator trans = IPAddressTranslator.instance();
    private boolean _loggingIn;
    private String _defNodeName;
    private String _nodeName;
    private String _nodeIPv6Name;
    private String _neType;
    private String _swVersion;
    private ConnectionNotifier _connectionNotifier;
    private INodeModel _delegate;
    private Boolean _delegateSupportsRemoteEle;
    private Thread _delegateCreator;
    private ConnectionModels _connModels;
    private CircuitFactoryModel _cktFactoryModel;
    private ElementModels _elementModels;
    private OhConnectionModels _ohConnModels;
    private OhCircuitFactoryModel _ohCktFactoryModel;
    private VcatTermModels _vcatTermModels;
    private Exception _failedException;
    private SvlanCircuitModels _svlanCktModels;
    private boolean _cmsHost;
    private NodeModelDebug _nmdb;
    private IPoller _poller;
    private boolean _enabled;
    private String _username;
    private String _password;
    private NetworkAlarmDecoder _decoder;
    private boolean _disconnectedIsPosted;
    private boolean _incompatibleIsPosted;
    private boolean _authFailedIsPosted;
    private int _oldNodeId;
    private int[] _oldFramingTypes = new int[]{0};
    private int _oldProtocolType = 0;
    private boolean bNodeIdChanged = false;
    private SecurityLevel _securityLevel = null;
    private TDMTerminology _tdmTerm;
    private static boolean isRemoted = RemoteEleConstants.MODE.isNetRemote;
    private static ElementFactory localElementFactory = ElementFactory.getElementFactoryInstance();
    private static final SDebug sdb = new SDebug("NodeModel");
    private INodeModel peerNode;
    private boolean fvActive;
    private UObservable incompatObs = new UObservable(){};
    private boolean bPauseMakeDelegate = false;
    private static HashMap clToDelegate = new HashMap();
    private final Inited inited = new Inited();
    private final NotInited notInited = new NotInited();
    private final Incompatible incompatible = new Incompatible();
    private final AuthenticationFailed authenticationFailed = new AuthenticationFailed();
    private final Disabled disabled = new Disabled();
    private NodeFSM _FSM;

    public void setPeerNe(INodeModel iNodeModel) {
        this.peerNode = iNodeModel;
    }

    public INodeModel getPeerNode() {
        return this.peerNode;
    }

    private static String asIp(String string) throws UnknownHostException {
        String string2 = Character.isDigit(string.charAt(0)) ? string : InetAddress.getByName(string).getHostAddress().trim();
        return string2;
    }

    private static int asInt(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            n = (n << 8) + Integer.valueOf(stringTokenizer.nextToken());
        }
        return n;
    }

    public static String getDebugName(String string) {
        InetAddress inetAddress = null;
        inetAddress = trans.getActualAddress(string);
        if (inetAddress != null) {
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length == 4) {
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return inetAddress.getHostAddress();
        }
        return string;
    }

    public NodeModel(String string, int n, String string2, String string3) {
        this(string, n, string2, string3, "Unknown");
    }

    public NodeModel(String string, int n, String string2, String string3, String string4) {
        super(new SDebug("Node" + NodeModel.getDebugName(string)), string, n);
        if (sdb.on()) {
            this.db.set(true);
        }
        this._loggingIn = false;
        if (string == null) {
            throw new IllegalArgumentException("The IP address of the node is null.");
        }
        this._nodeName = this._defNodeName = string4;
        this._nodeIPv6Name = "0:0:0:0:0:0:0:0";
        this._hostName = string;
        this._neType = null;
        this._swVersion = "";
        this._username = string2;
        this._password = string3;
        this._decoder = null;
        this._cmsHost = false;
        this._enabled = false;
        this._disconnectedIsPosted = false;
        this._incompatibleIsPosted = false;
        this._authFailedIsPosted = false;
        this._connectionNotifier = new ConnectionNotifier();
        this._connModels = new ConnectionModels(this);
        this._cktFactoryModel = new CircuitFactoryModel(this);
        this._elementModels = new ElementModels(this);
        this._ohConnModels = new OhConnectionModels(this);
        this._ohCktFactoryModel = new OhCircuitFactoryModel(this);
        this._vcatTermModels = new VcatTermModels(this);
        this._svlanCktModels = new SvlanCircuitModels(this);
        this._tdmTerm = null;
        this._nmdb = new NodeModelDebug(this.db, "NodeDbg", this);
        this._delegate = null;
        this._delegateSupportsRemoteEle = null;
        this._FSM = new NodeFSM();
        NetworkAlarmStore.instance().addNodeKey(this._hostName, this._nodeId);
        EventBus.instance().addObserver((Observer)this, (Object)"JAR_DELETED");
        NodeModel.addNode(this);
    }

    private boolean enabledByDefault() {
        boolean bl = true;
        String string = "ctc.node";
        String string2 = "enabled";
        String string3 = System.getProperty(string + "." + string2);
        if (string3 == null) {
            string3 = Preferences.instance().getProperty(string, string2, null);
        }
        if (string3 != null) {
            bl = Boolean.valueOf(string3);
        }
        return bl;
    }

    private synchronized void makeDelegate() {
        if (this.db.on()) {
            this.db.fine("NM.makeDelegate(): Entry");
        }
        if (this.isEnabled()) {
            if (this._delegate == null) {
                if (this._delegateCreator == null) {
                    if (this.db.on()) {
                        this.db.fine("NM.makeDelegate(): create creator");
                    }
                    this._delegateCreator = new DelegateCreator(this._hostName, this._nodeId);
                    if (this.db.on()) {
                        this.db.fine("NM.makeDelegate(): start creator");
                    }
                    this._delegateCreator.start();
                } else if (this.db.on()) {
                    this.db.fine("NM.makeDelegate(): creator running");
                }
            } else if (this.db.on()) {
                this.db.fine("NM.makeDelegate(): delegate exists");
            }
        } else if (this.db.on()) {
            this.db.fine("NM.makeDelegate(): not enabled");
        }
        if (this.db.on()) {
            this.db.fine("NM.makeDelegate(): Exit");
        }
    }

    private synchronized void setDelegate(INodeModel iNodeModel) {
        if (this.db.on()) {
            if (iNodeModel == null) {
                this.db.fine("NM.setDelegate(null): Entry");
            } else {
                this.db.fine("NM.setDelegate(non-null): Entry");
            }
        }
        if (iNodeModel == null) {
            if (this._delegate != null) {
                if (this.db.on()) {
                    this.db.fine("NM.setDelegate(null): destroyDelegate()");
                }
                this.destroyDelegate();
            }
        } else {
            if (this.db.on()) {
                this.db.fine("NM.setDelegate(non-null): creator = null");
            }
            this._delegateCreator = null;
            this._delegate = iNodeModel;
            if (this.isEnabled()) {
                if (this.db.on()) {
                    this.db.fine("NM.setDelegate(non-null): initDelegate()");
                }
                this._failedException = null;
                this.initDelegate(iNodeModel);
            } else {
                if (this.db.on()) {
                    this.db.fine("NM.setDelegate(non-null): no longer enabled");
                }
                this._failedException = new Exception("The node is no longer enabled.");
                this.destroyDelegate();
            }
            if (this.db.on()) {
                this.db.fine("NM.setDelegate(non-null): notifyAll");
            }
            this.notifyAll();
        }
        if (this.db.on()) {
            this.db.fine("NM.setDelegate(): Exit");
        }
    }

    private synchronized void failDelegate(Exception exception) {
        if (this.db.on()) {
            this.db.fine("failDelegate()");
        }
        this._delegateCreator = null;
        this._failedException = exception;
        if (this.db.on()) {
            this.db.fine("failDelegate(): notifyAll");
        }
        this.notifyAll();
    }

    @Override
    public INodeModel getNodeModel() {
        return this;
    }

    private void waitNoInterrupt(Object object) {
        boolean bl = true;
        while (bl) {
            try {
                object.wait();
                bl = false;
            }
            catch (InterruptedException interruptedException) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean bl) {
        block16: {
            boolean bl2;
            if (this.db.on()) {
                this.db.fine("NM.setEnabled(" + bl + "): Entry");
            }
            NodeModel nodeModel = this;
            synchronized (nodeModel) {
                bl2 = bl != this._enabled;
                this._enabled = bl;
            }
            if (bl2) {
                if (bl) {
                    if (this.db.on()) {
                        this.db.fine("NM.setEnabled(): calling makeDelegate()");
                    }
                    this.makeDelegate();
                } else {
                    if (this.getFSM().setState(this.disabled)) {
                        this.synchronizeMyAlarms();
                    }
                    if (this.db.on()) {
                        this.db.fine("NM.setEnabled(): call setDelegate(null)");
                    }
                    nodeModel = this._poller;
                    this.setDelegate(null);
                    try {
                        if (this.db.on()) {
                            this.db.fine("NM.setEnabled(): call recover()");
                        }
                        if (nodeModel != null) {
                            nodeModel.recover(1);
                        }
                    }
                    catch (NodePollerException nodePollerException) {
                        this.db.fine("NM.setEnabled(): Benign recover() call on poller of a destroyed delegate.");
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (!this.db.on()) break block16;
                        this.db.fine("NM.setEnabled(): Benign recover call on innaccessible delegate poller");
                    }
                }
            }
        }
        if (this.db.on()) {
            this.db.fine("NM.setEnabled(): Exit");
        }
    }

    public synchronized boolean isEnabled() {
        return this._enabled;
    }

    public void reinitNM(boolean bl) {
        if (bl) {
            this.setEnabled(false);
            this.setEnabled(true);
        } else if (this.isEnabled()) {
            this.setEnabled(false);
            this.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firstInit() throws NoRouteToHostException, UnknownHostException, IllegalArgumentException, AbstractCmsSecurityException, InvalidUserOrPasswordException, IncompatibleException, Exception {
        this._loggingIn = true;
        try {
            this.init();
        }
        finally {
            this._loggingIn = false;
        }
    }

    private synchronized void waitForDelegate() {
        if (this._delegate == null) {
            if (this.db.on()) {
                this.db.fine("init(): waiting for delegate");
            }
            this.waitNoInterrupt(this);
            if (this.db.on()) {
                this.db.fine("init(): done waiting for delegate");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws NoRouteToHostException, UnknownHostException, IllegalArgumentException, AbstractCmsSecurityException, InvalidUserOrPasswordException, IncompatibleException, Exception {
        if (this.db.on()) {
            this.db.fine("init(): enter");
        }
        this.init0();
        try {
            this.waitForDelegate();
            while (this._delegate != null && !this.delegateIsInited()) {
                ConnectionNotifier connectionNotifier = this._connectionNotifier;
                synchronized (connectionNotifier) {
                    if (this.db.on()) {
                        this.db.fine("init(): waiting to be isInited()");
                    }
                    this.waitNoInterrupt(this._connectionNotifier);
                    if (this.db.on()) {
                        this.db.fine("init(): done waiting to be isInited()");
                    }
                }
            }
            if (this._delegate == null) {
                if (this.db.on()) {
                    this.db.fine("init(): delegate is still null, throwing exception.");
                }
                throw this._failedException;
            }
            this._failedException = this.getInitFailureException();
            if (this.db.on()) {
                this.db.fine("init(): getInitFailureException = " + this._failedException);
            }
        }
        finally {
            if (this.db.on()) {
                this.db.fine("init(): exit failedException=" + this._failedException);
            }
        }
    }

    private void initDelegate(INodeModel iNodeModel) {
        if (this.db.on()) {
            this.db.fine("NM.initDelegate(): Entry");
        }
        if (this._delegate != iNodeModel) {
            this._delegateSupportsRemoteEle = null;
        }
        this._delegate = iNodeModel;
        if (this.db.on()) {
            this.db.fine("NM.initDelegate(): MIO.addObserver(delegate,this)");
        }
        ModelIndirectObservable.instance().addObserver((IObservable)iNodeModel, this);
        if (this.db.on()) {
            this.db.fine("NM.initDelegate(): call NM.CN.init()");
        }
        this._connectionNotifier.init();
        this.db.finest("Setting the delegate for ConnectionModels and circuit factory");
        this._connModels.setDelegate(iNodeModel.getConnectionModels());
        this._cktFactoryModel.setDelegate(iNodeModel.getCircuitFactoryModel());
        if (this.provides(Feature.SVLAN_CKT)) {
            this.db.finest("Setting the delegate for SVLAN circuits");
            this._svlanCktModels.setDelegate(iNodeModel.getSvlanCircuitModels());
        } else {
            this.db.finest("Does not support SVLAN CIRCUIT");
        }
        if (this.provides(Feature.VCAT)) {
            this.db.finest("Setting the delegate for vcat circuits");
            this._vcatTermModels.setDelegate(iNodeModel.getVcatTermModels());
        } else {
            this.db.finest("Does not support VCAT");
        }
        if (this.provides(Feature.AICI)) {
            this.db.finest("Setting the delegate for overhead connections and overhead circuit factory");
            this._ohConnModels.setDelegate(iNodeModel.getOhConnectionModels());
            this._ohCktFactoryModel.setDelegate(iNodeModel.getOhCircuitFactoryModel());
        } else {
            this.db.finest("Does not support AICI");
        }
        if (this.provides(Feature.NET_BLSR_WIZ)) {
            this.db.finest("Setting the delegate for ElementModels");
            this._elementModels.setDelegate(this._delegate.getIElementModels());
        } else {
            this.db.finest("Does not support NET_BLSR_WIZ");
        }
        this._connModels.init();
        this._cktFactoryModel.init();
        if (this.provides(Feature.VCAT)) {
            this._vcatTermModels.init();
        }
        if (this.provides(Feature.AICI)) {
            this._ohConnModels.init();
            this._ohCktFactoryModel.init();
        }
        if (this.provides(Feature.SVLAN_CKT)) {
            this._svlanCktModels.init();
        }
        if (this.provides(Feature.NODE_POLLER_INTERFACE)) {
            if (this.db.on()) {
                this.db.fine("NMMinitDelegate(): provides NODE_POLLER_INTERFACE,will call getPoller()");
            }
            this._poller = this._delegate.getPoller();
        } else if (this.db.on()) {
            this.db.fine("NM.initDelegate(): NMD does not provide NODE_POLLER_INTERFACE ");
        }
        if (this.db.on()) {
            this.db.fine("NM.initDelegate(): about to call startPollerThread()");
        }
        this._delegate.startPollerThread();
        if (this.db.on()) {
            this.db.fine("NM.initDelegate(): Exit");
        }
    }

    private void disposeModel(NetModelObserver netModelObserver) {
        block3: {
            try {
                if (netModelObserver != null) {
                    netModelObserver.dispose();
                }
            }
            catch (Exception exception) {
                this.db.fine("Unexpected exception occurred while trying to dispose " + netModelObserver);
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void destroyDelegate() {
        if (this.db.on()) {
            this.db.fine("NM.destroyDelegate(): Entry");
        }
        this.disposeModel(this._connModels);
        this.disposeModel(this._cktFactoryModel);
        this.disposeModel(this._elementModels);
        this.disposeModel(this._vcatTermModels);
        this.disposeModel(this._ohConnModels);
        this.disposeModel(this._ohCktFactoryModel);
        this.disposeModel(this._svlanCktModels);
        INodeModel iNodeModel = this._delegate;
        this._delegate = null;
        if (this._connectionNotifier != null) {
            this._connectionNotifier.dispose();
        }
        this._delegateSupportsRemoteEle = null;
        if (this.db.on()) {
            this.db.fine("NM.destroyDelegate(): invoke MIO.deleteObserver(delegate, this)");
        }
        ModelIndirectObservable.instance().deleteObserver((IObservable)iNodeModel, this);
        if (this.db.on()) {
            try {
                IEventStore iEventStore = iNodeModel.getElementEventStore();
                if (iEventStore != null) {
                    UObservable uObservable = iEventStore.getStoreObservable();
                    CmsObservable.listObservers(iEventStore, uObservable.getObservers());
                }
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                this.db.fine("NM.destroyDelegate(): UndeclaredThrowableException attempting to list ElementEventStore observers: " + undeclaredThrowableException);
                SDebug.printStackTrace((Throwable)undeclaredThrowableException);
            }
            catch (AbstractMethodError abstractMethodError) {
                this.db.fine("NM.destroyDelegate(): AbstractMethodError attempting to list ElementEventStore observers: " + abstractMethodError);
            }
        }
        this._poller = null;
        iNodeModel.destroy();
        if (this.db.on()) {
            this.db.fine("NM.destroyDelegate(): Exit");
        }
    }

    @Override
    public void liteInit() {
    }

    @Override
    public IJobControl createDataRebootJob(int n, IJobProgressControl iJobProgressControl) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("createDataRebootJob");
        }
        return iNodeModel.createDataRebootJob(n, iJobProgressControl);
    }

    @Override
    public IEtherMacAddr getNodeEtherMACAddress() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getNodeEtherMACAddress");
        }
        return iNodeModel.getNodeEtherMACAddress();
    }

    public IEtherMacAddr getSecureEtherMACAddress() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getSecureEtherMACAddress");
        }
        if (this.provides(Feature.TCC2P_SECURITY_MODE)) {
            return iNodeModel.getSecureEtherMACAddress();
        }
        throw new FeatureNotSupported("getSecureIpConfig()");
    }

    public byte[] getSecurityTicket() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && iNodeModel.provides(Feature.SECURITY_TICKET)) {
            return iNodeModel.getSecurityTicket();
        }
        return new byte[0];
    }

    public SystemTime getSystemTime() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.provides(Feature.SYSTEM_TIME)) {
            return iNodeModel.getSystemTime();
        }
        return new SystemTime();
    }

    @Override
    public void synchronizeAlarm() throws AbstractCmsIOException {
        if (this._disconnectedIsPosted) {
            this.postNetworkAlarm((short)1028, 2, '\u0000');
        }
        if (this._incompatibleIsPosted) {
            this.postNetworkAlarm((short)1025, 2, '\u0000');
        }
        if (this._authFailedIsPosted) {
            this.postNetworkAlarm((short)1024, 2, '\u0000');
        }
        if (this.getFSM().useDelegate()) {
            if (this.db.on()) {
                this.db.fine("Calling synchronizeAlarm on delegate...");
            }
            this._delegate.synchronizeAlarm();
        }
    }

    private void synchronizeMyAlarms() {
        if (this.db.on()) {
            this.db.fine("Calling synchronizeMyAlarms...");
        }
        this._disconnectedIsPosted = this.postDisconnectedAlarm();
        this._incompatibleIsPosted = this.postIncompatibleAlarm();
        this._authFailedIsPosted = this.postAuthenticationFailedAlarm();
        if (this.getFSM().useDelegate()) {
            if (this.db.on()) {
                this.db.fine("Calling synchronizeAlarm on delegate...");
            }
            try {
                this._delegate.synchronizeAlarm();
                this.updateSendPDIP();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.db.fine("NodeModel::synchronizeMyAlarms() -- Couldn't retrieve alarms from node.");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            catch (RuntimeException runtimeException) {
                this.db.fine("Caught an unexpected exception in synchronizeMyAlarms!");
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    private boolean postDisconnectedAlarm() {
        if (this.getConnectionState()) {
            if (this._disconnectedIsPosted) {
                this.postNetworkAlarm((short)1028, 2, '\u0001');
                return false;
            }
        } else if (this.isAuthenticationFailed() || this.isIncompatible()) {
            if (this._disconnectedIsPosted) {
                this.postNetworkAlarm((short)1028, 2, '\u0001');
                return false;
            }
        } else if (!this._disconnectedIsPosted) {
            this.postNetworkAlarm((short)1028, 2, '\u0000');
            return true;
        }
        return this._disconnectedIsPosted;
    }

    private boolean postIncompatibleAlarm() {
        if (this.isIncompatible()) {
            if (!this._incompatibleIsPosted) {
                this.postNetworkAlarm((short)1025, 2, '\u0000');
                return true;
            }
        } else if (this._incompatibleIsPosted) {
            this.postNetworkAlarm((short)1025, 2, '\u0001');
            return false;
        }
        return this._incompatibleIsPosted;
    }

    private boolean postAuthenticationFailedAlarm() {
        if (this.isAuthenticationFailed()) {
            if (!this._authFailedIsPosted) {
                this.postNetworkAlarm((short)1024, 2, '\u0000');
                return true;
            }
        } else if (this._authFailedIsPosted) {
            this.postNetworkAlarm((short)1024, 2, '\u0001');
            return false;
        }
        return this._authFailedIsPosted;
    }

    private NetworkAlarmDecoder getAlarmDecoder() {
        if (this._decoder == null) {
            this._decoder = new NetworkAlarmDecoder();
        }
        return this._decoder;
    }

    private static int convertMilliSecToSec(long l) {
        return (int)(l / 1000L);
    }

    private void postNetworkAlarm(short s, int n, char c) {
        if (this.db.on()) {
            this.db.fine("Posting Network Alarm: condition=" + s + " severity=" + n + " state=" + (c == '\u0001' ? "C" : "R") + " nodeID=" + this.getNodeId() + " old=" + this.getOldNodeId());
        }
        String string = "SYSTEM";
        long l = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        String string2 = simpleDateFormat.format(new Date(l)).toString();
        String string3 = string2 + "*";
        ObjectIdent objectIdent = new ObjectIdent(0, 0, 0, string.toCharArray(), 0, 0, 0, 0, new String().toCharArray());
        OneAlarmState oneAlarmState = null;
        oneAlarmState = this.provides(Feature.TCA_DIRECTION) ? new OneAlarmState(s, n, 0, c, 0, 0, 0, 'n', "", "") : new OneAlarmState(s, n, 0, c, 0, 0, 0, 'n', "", "");
        AlarmMessage alarmMessage = new AlarmMessage(objectIdent, oneAlarmState, NodeModel.convertMilliSecToSec(l), 0, 0);
        EventInfo eventInfo = new EventInfo((INodeModel)this, l, string2, string3, (IAlarmMessage)alarmMessage, (IAlarmDecoder)this.getAlarmDecoder());
        EventInfo eventInfo2 = NetworkAlarmStore.instance().postNetworkAlarm(eventInfo);
        if (eventInfo2 == null || eventInfo2.getState() != eventInfo.getState()) {
            ArrayList<EventInfo> arrayList = new ArrayList<EventInfo>(1);
            arrayList.add(eventInfo);
            NetworkEventStore.instance().update((Observable)((Object)this), arrayList);
        }
    }

    @Override
    public int getBiggestStitchedEtherPath() {
        INodeModel iNodeModel = this._delegate;
        int n = iNodeModel != null && this.provides(Feature.BIGGEST_STITCHED_ETHER_PATH) ? iNodeModel.getBiggestStitchedEtherPath() : (this._neType == "15327" ? 2 : 3);
        return n;
    }

    public String getDefaultName() {
        return this._defNodeName;
    }

    @Override
    public String getName() {
        return this._nodeName;
    }

    public String getIPv6Name() {
        return this._nodeIPv6Name;
    }

    private void updateName() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && (this.delegateIsInited() || this.isLiteInited())) {
            this._nodeName = trans.translateIPsVirtualToActual(iNodeModel.getName());
        }
    }

    private void updateIPv6Name() {
        INodeModel iNodeModel = this._delegate;
        String string = this._nodeIPv6Name;
        if (this.provides(Feature.IPV6_NATPT)) {
            try {
                InetAddress inetAddress = IPAddressTranslator.instance().findVirtualAddress(this.getNodeId());
                InetAddress inetAddress2 = IPAddressTranslator.instance().getActualAddress(inetAddress);
                if (iNodeModel != null && (this.delegateIsInited() || this.isLiteInited())) {
                    this._nodeIPv6Name = InetUtil.makeDottedStringV6(iNodeModel.getIpConfig().getIpv6Address());
                    if (this.db.on()) {
                        this.db.println("Inside updateIPv6Name: oldIPv6 - " + string + " New IPv6 - " + this._nodeIPv6Name);
                    }
                    if (string.compareTo("0:0:0:0:0:0:0:0") != 0 && this._nodeIPv6Name.compareTo(string) != 0 && this._nmdb != null) {
                        IPAddressTranslator.instance().updateIPv6Address(inetAddress, this.getNodeId(), InetAddress.getByName(this._nodeIPv6Name));
                        if (inetAddress2.getAddress().length == 16) {
                            this.updateProxiesForIpChange(inetAddress2.getHostAddress(), this._nodeIPv6Name);
                        }
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.db.println("Lookup of virtual Address for the specified nodeID = " + this.getNodeId() + " failed");
            }
            catch (IOException iOException) {
                this.db.println("Error encountered while updating the Proxy Layer for IP change");
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
    }

    @Override
    public void setName(String string) throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            iNodeModel.setName(string);
        }
    }

    private void updateSendPDIP() {
        if (this.provides(Feature.SEND_PDIP)) {
            this.db.fine("updateSendPDIP(): about to checkSendPDIPConsistency");
            NetworkConsistencyChecker networkConsistencyChecker = NetworkConsistencyChecker.instance();
            networkConsistencyChecker.checkSendPDIPConsistency(this.getName(), this.getSendPDIP());
        }
    }

    public boolean getSendPDIP() throws AbstractCmsIOException {
        boolean bl = false;
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getSendPDIP()");
        }
        if (this.provides(Feature.SEND_PDIP)) {
            bl = iNodeModel.getSendPDIP();
        } else {
            this.db.fine("SEND_PDIP feature not supported");
        }
        return bl;
    }

    public void setSendPDIP(boolean bl) throws InvalidOperation, AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getSendPDIP()");
        }
        if (this.provides(Feature.SEND_PDIP)) {
            iNodeModel.setSendPDIP(bl);
        } else {
            this.db.fine("SEND_PDIP feature not supported");
        }
    }

    @Override
    public String getLatitude() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel == null ? "N355900000" : iNodeModel.getLatitude();
    }

    @Override
    public String getLongitude() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel == null ? "W1105900000" : iNodeModel.getLongitude();
    }

    @Override
    public IIpConfig getIpConfig() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getIpConfig");
        }
        return iNodeModel.getIpConfig();
    }

    public ISecureIpConfig getSecureIpConfig() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getSecureIpConfig");
        }
        if (this.provides(Feature.TCC2P_SECURITY_MODE)) {
            return iNodeModel.getSecureIpConfig();
        }
        throw new FeatureNotSupported("getSecureIpConfig()");
    }

    public boolean isSecureMode() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("isSecureMode");
        }
        if (this.provides(Feature.TCC2P_SECURITY_MODE)) {
            return iNodeModel.isSecureMode();
        }
        throw new FeatureNotSupported("isSecureMode()");
    }

    @Override
    public short getUpsrSdBerLevel(int n) throws AbstractCmsIOException, InvalidOperation {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getUpsrSdBerLevel");
        }
        if (!this.provides(Feature.UPSR_VT_THRESH)) {
            return iNodeModel.getUpsrSdBerLevel();
        }
        return iNodeModel.getUpsrSdBerLevel(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setUpsrSdBerLevel(int n, short s) throws AbstractCmsIOException, InvalidOperation, ConfigError {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("setUpsrSdBerLevel");
        }
        if (!this.provides(Feature.UPSR_VT_THRESH)) {
            if (n != 2) throw new InvalidOperation("setUpsrSdBerLevel");
            iNodeModel.setUpsrSdBerLevel(s);
            return;
        } else {
            iNodeModel.setUpsrSdBerLevel(n, s);
        }
    }

    @Override
    public short getUpsrSfBerLevel(int n) throws AbstractCmsIOException, InvalidOperation {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getUpsrSfBerLevel");
        }
        if (!this.provides(Feature.UPSR_VT_THRESH)) {
            return iNodeModel.getUpsrSfBerLevel();
        }
        return iNodeModel.getUpsrSfBerLevel(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setUpsrSfBerLevel(int n, short s) throws AbstractCmsIOException, InvalidOperation, ConfigError {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("setUpsrSfBerLevel");
        }
        if (!this.provides(Feature.UPSR_VT_THRESH)) {
            if (n != 2) throw new InvalidOperation("setUpsrSdBerLevel");
            iNodeModel.setUpsrSfBerLevel(s);
            return;
        } else {
            iNodeModel.setUpsrSfBerLevel(n, s);
        }
    }

    public AbstractVersionedFeature getVersionedFeature(Feature feature) {
        AbstractVersionedFeature abstractVersionedFeature = null;
        if (this._delegate != null) {
            abstractVersionedFeature = this._delegate.getVersionedFeature(feature);
        }
        return abstractVersionedFeature;
    }

    @Override
    public boolean provides(String string) {
        return this.provides(Feature.nameToFeature((String)string));
    }

    @Override
    public boolean provides(int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.provides(Feature.from_int((int)n));
            }
            catch (CmsMissingFeatureException cmsMissingFeatureException) {
                if (!this.db.on()) break block2;
                this.db.fine("provides( " + n + " ) doesn't exist, returning false.");
            }
        }
        return bl;
    }

    @Override
    public boolean provides(Feature feature) {
        boolean bl = false;
        boolean bl2 = isRemoted;
        if (!bl2) {
            return Feature.provides((INodeModel)this._delegate, (Feature)feature);
        }
        if (this._delegate == null || feature == null) {
            bl = false;
        } else {
            try {
                boolean bl3;
                if (this._delegateSupportsRemoteEle == null) {
                    bl3 = this.staticProvides(Feature.REMOTE_ELE_V1);
                    this._delegateSupportsRemoteEle = bl3 ? Boolean.TRUE : Boolean.FALSE;
                } else {
                    bl3 = this._delegateSupportsRemoteEle;
                }
                if (feature.equals((Object)Feature.REMOTE_ELE_V1)) {
                    bl = bl3;
                } else if (!bl3) {
                    bl = Feature.provides((INodeModel)this._delegate, (Feature)feature);
                } else if (this.staticProvides(feature)) {
                    bl = true;
                } else {
                    Boolean bl4 = this.isKnownDynamic(feature);
                    if (bl4 == Boolean.FALSE) {
                        bl = false;
                    } else if (bl4 == null) {
                        if (this._delegate != null) {
                            boolean bl5 = this.isDynamic(feature);
                            this.setKnownDynamic(feature, bl5);
                            bl = bl5 ? Feature.provides((INodeModel)this._delegate, (Feature)feature) : false;
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = Feature.provides((INodeModel)this._delegate, (Feature)feature);
                    }
                }
            }
            catch (Throwable throwable) {
                SDebug.printStackTrace((Throwable)throwable);
                try {
                    bl = Feature.provides((INodeModel)this._delegate, (Feature)feature);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean staticProvides(Feature feature) throws Exception {
        return localElementFactory.provides(feature, this._hostName, this._swVersion, this._neType);
    }

    private Boolean isKnownDynamic(Feature feature) throws Exception {
        return localElementFactory.isKnownDynamic(feature, this._hostName, this._swVersion, this._neType);
    }

    private void setKnownDynamic(Feature feature, boolean bl) throws Exception {
        localElementFactory.setDynamic(feature, bl, this._hostName, this._swVersion, this._neType);
    }

    public boolean isDynamic(Feature feature) {
        if (this._delegate == null) {
            return false;
        }
        try {
            return this._delegate.isDynamic(feature);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.fine((Object)((Object)abstractCmsIOException) + ": during isDynamic()");
            }
            throw this.noDelegate("isDynamic");
        }
    }

    @Override
    public int swUpgrade() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("swUpgrade");
        }
        return iNodeModel.swUpgrade();
    }

    public boolean neTypeKnown() {
        return this._neType != null;
    }

    @Override
    public String getNeType() {
        block3: {
            if (this._neType == null) {
                try {
                    this._neType = CtcHttpRetriever.getNeType((String)this._hostName);
                }
                catch (IOException iOException) {
                    this.db.fine("CtcHttpRetriever.getNeType() failed: " + iOException);
                    if (!this.db.on()) break block3;
                    SDebug.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this._neType;
    }

    public boolean is15305Node() {
        NETypeEnum nETypeEnum = NETypeEnum.getType((String)this.getNeType());
        return nETypeEnum.equals((Object)NETypeEnum.NE_306);
    }

    public boolean isM6Node() {
        NETypeEnum nETypeEnum = NETypeEnum.getType((String)this.getNeType());
        return nETypeEnum.equals((Object)NETypeEnum.NE_M6);
    }

    public boolean isM2Node() {
        NETypeEnum nETypeEnum = NETypeEnum.getType((String)this.getNeType());
        return nETypeEnum.equals((Object)NETypeEnum.NE_M2);
    }

    public boolean isM6SDHNode() {
        NETypeEnum nETypeEnum = NETypeEnum.getType((String)this.getNeType());
        return nETypeEnum.equals((Object)NETypeEnum.NE_M6SDH);
    }

    public boolean isM2SDHNode() {
        NETypeEnum nETypeEnum = NETypeEnum.getType((String)this.getNeType());
        return nETypeEnum.equals((Object)NETypeEnum.NE_M2SDH);
    }

    private boolean is15600Node() {
        NETypeEnum nETypeEnum = NETypeEnum.getType((String)this.getNeType());
        return nETypeEnum.equals((Object)NETypeEnum.NE_600) || nETypeEnum.equals((Object)NETypeEnum.NE_601);
    }

    public boolean doesProvideTcc2pSecureMode() {
        return this.provides(Feature.TCC2P_SECURITY_MODE) && !this.is15600Node();
    }

    public String getSwVersion() {
        return this._swVersion;
    }

    private void retrieveSwVersion() {
        block3: {
            try {
                this._swVersion = null;
                this._swVersion = CtcHttpRetriever.getSwVersion((String)this._hostName);
            }
            catch (IOException iOException) {
                this.db.fine("CtcHttpRetriever.getSwVersion() failed: " + iOException);
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        if (this.db.on()) {
            this.db.fine("getSwVersion(): name=" + this.getActualHostName() + " swVer=" + this._swVersion);
        }
    }

    private boolean isNeCompatibleWith(NodeModel nodeModel) {
        boolean bl = true;
        if (!this.isCmsHost() && nodeModel != null && this.getNeType() != null) {
            boolean bl2;
            boolean bl3 = this.getNeType().equals("crs") || nodeModel.getNeType().equals("crs");
            boolean bl4 = !this.getNeType().endsWith("SDH");
            boolean bl5 = bl2 = !nodeModel.getNeType().endsWith("SDH");
            if (!bl3 && bl4 != bl2) {
                bl = false;
            }
        }
        if (this.db.on()) {
            this.db.fine((bl ? "" : "NOT ") + "compatible with the Network");
        }
        return bl;
    }

    protected String getNodeTypeString() {
        String string = "an unknown";
        if (this._neType != null) {
            string = this._neType.endsWith("SDH") ? "an SDH" : "a SONET";
        }
        return string;
    }

    @Override
    public ArrayList getMfgData(int n) {
        INodeModel iNodeModel = this._delegate;
        if (this.provides(Feature.MULTISHELF)) {
            if (iNodeModel == null) {
                throw this.noDelegate("getMfgData");
            }
            return iNodeModel.getMfgData(n);
        }
        throw new FeatureNotSupported("getMfgData(int shelfid) ");
    }

    @Override
    public ArrayList getMfgData() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getMfgData");
        }
        return iNodeModel.getMfgData();
    }

    @Override
    public IJobControl createDataTransferJob(String string, int n, IJobProgressControl iJobProgressControl) throws Exception {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("createDataTransferJob");
        }
        return iNodeModel.createDataTransferJob(string, n, iJobProgressControl);
    }

    public boolean isSafeToUpgrade() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("createDataTransferJob");
        }
        return iNodeModel.isSafeToUpgrade();
    }

    @Override
    public IJobControl createDataTransferJob(String string, int n, IJobProgressControl iJobProgressControl, int[] nArray) throws Exception {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("createDataTransferJob");
        }
        return iNodeModel.createDataTransferJob(string, n, iJobProgressControl, nArray);
    }

    @Override
    public IConnectionModels getConnectionModels() {
        return this._connModels;
    }

    public ISvlanCircuitModels getSvlanCircuitModels() {
        return this._svlanCktModels;
    }

    public IOhConnectionModels getOhConnectionModels() {
        return this._ohConnModels;
    }

    public IVcatTermModels getVcatTermModels() {
        return this._vcatTermModels;
    }

    @Override
    public IEntityTableModel getEntityTable() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel != null ? iNodeModel.getEntityTable() : null;
    }

    public IEntityTableModel getEntityTableModel() {
        return this.getEntityTable();
    }

    public IDatabaseManagementModel getDatabaseManagementModel() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel != null ? iNodeModel.getDatabaseManagementModel() : null;
    }

    public boolean isResetAllowed() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel != null ? iNodeModel.isResetAllowed() : false;
    }

    @Override
    public IEntityModel getChassis() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getChassis");
        }
        return iNodeModel.getChassis();
    }

    public IEntityModel[] getChassisModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getChassisModels");
        }
        try {
            if (this.provides(Feature.MULTISHELF)) {
                return iNodeModel.getChassisModels();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.println((Object)((Object)abstractCmsIOException) + ": during getChassisModels()");
            }
            throw this.noDelegate("getChassisModels");
        }
        return new IEntityModel[0];
    }

    public IChassisModels getIChassisModelsInstance() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getChassisModels");
        }
        try {
            if (this.provides(Feature.MULTISHELF)) {
                return iNodeModel.getIChassisModelsInstance();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.println((Object)((Object)abstractCmsIOException) + ": during getChassisModels()");
            }
            throw this.noDelegate("getChassisModels");
        }
        return null;
    }

    @Override
    public IInterfaceModels getInterfaceModels() {
        return null;
    }

    @Override
    public ISecurityModel getSecurityModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getSecurityModel");
        }
        return iNodeModel.getSecurityModel();
    }

    public ISnmpModel getSnmpModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getSnmpModel");
        }
        return iNodeModel.getSnmpModel();
    }

    @Override
    public IEtherBridgeModel getEtherBridgeModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getEtherBridgeModel");
        }
        return iNodeModel.getEtherBridgeModel();
    }

    public IRprModel getRprModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getRprModel");
        }
        return iNodeModel.getRprModel();
    }

    @Override
    public ICircuitFactoryModel getCircuitFactoryModel() {
        return this._cktFactoryModel;
    }

    public IElementModels getIElementModels() {
        return this._elementModels;
    }

    public ElementModels getElementModels() {
        return this._elementModels;
    }

    public IUcpCircuits getUcpCircuits() {
        return null;
    }

    public IUcpLinks getUcpLinks() {
        return null;
    }

    @Override
    public String getDefaultValue(String string) throws NoSuchDefault {
        String string2;
        block6: {
            INodeModel iNodeModel = this._delegate;
            string2 = null;
            Preferences preferences = Preferences.instance();
            if (iNodeModel == null || !iNodeModel.isInited() || !this.provides(Feature.NODE_DEFAULTS)) {
                string2 = preferences.getProperty("ctc.defaults", string.toLowerCase(), null);
                if (string2 == null) {
                    throw new NoSuchDefault();
                }
            } else {
                try {
                    string2 = iNodeModel.getDefaultValue(string);
                    preferences.setProperty("ctc.defaults", string.toLowerCase(), string2);
                }
                catch (NoSuchDefault noSuchDefault) {
                    throw noSuchDefault;
                }
                catch (Exception exception) {
                    string2 = preferences.getProperty("ctc.defaults" + this.getName(), string.toLowerCase(), null);
                    if (string2 != null) break block6;
                    throw new NoSuchDefault();
                }
            }
        }
        return string2;
    }

    public IOhCircuitFactoryModel getOhCircuitFactoryModel() {
        return this._ohCktFactoryModel;
    }

    @Override
    public IAlarmModel getAlarmModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getAlarmModel");
        }
        return iNodeModel.getAlarmModel();
    }

    @Override
    public IOspfLanConfigModel getOspfLanConfigModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getOspfLanConfigModel");
        }
        return iNodeModel.getOspfLanConfigModel();
    }

    public IOspfTopologyModel getOspfTopologyModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getOspfTopologyModel");
        }
        if (this.provides(Feature.REMOTE_ELE_V1)) {
            return iNodeModel.getOspfTopologyModel();
        }
        try {
            Object object = iNodeModel.getClass().getMethod("getOspfTopologyModel", null).invoke((Object)this._delegate, null);
            if (object == null) {
                throw this.noDelegate("getOspfTopologyModel");
            }
            return (IOspfTopologyModel)object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)noSuchMethodException);
            }
            throw this.noDelegate("getOspfTopologyModel");
        }
        catch (IllegalAccessException illegalAccessException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)illegalAccessException);
            }
            throw this.noDelegate("getOspfTopologyModel");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)invocationTargetException);
            }
            throw this.noDelegate("getOspfTopologyModel");
        }
    }

    public ILanRipConfigModel getLanRipConfigModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getLanRipConfigModel");
        }
        return iNodeModel.getLanRipConfigModel();
    }

    public IRipAddressSummaryModel getRipAddressSummaryModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getRipAddressSummaryModel");
        }
        return iNodeModel.getRipAddressSummaryModel();
    }

    @Override
    public IPoolModels getPoolModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getPoolModels");
        }
        return iNodeModel.getPoolModels();
    }

    public int getFramingType() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getFramingType");
        }
        if (this.provides(Feature.SDH_AU3)) {
            throw new DeprecatedMethodCalled("NodeModel.getFramingType()");
        }
        return iNodeModel.getFramingType();
    }

    public IFramingType getFramingTypeObj() {
        return FramingType.getFramingType((int)this.getFramingType());
    }

    public int getTdmProtocolType() {
        INodeModel iNodeModel = this._delegate;
        int n = this._oldProtocolType;
        if (iNodeModel != null) {
            try {
                if (this.provides(Feature.SDH_AU3)) {
                    n = iNodeModel.getTdmProtocolType();
                } else {
                    int n2 = n = iNodeModel.getFramingType() == 0 ? 0 : 1;
                }
                if (this._oldProtocolType != n) {
                    this._oldProtocolType = n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public ITdmProtocolType getTdmProtocolTypeObj() {
        return TdmProtocolType.getTdmProtocolType((int)this.getTdmProtocolType());
    }

    public int[] getSupportedFramingTypes() {
        INodeModel iNodeModel = this._delegate;
        int[] nArray = this._oldFramingTypes;
        if (iNodeModel != null) {
            try {
                nArray = this.provides(Feature.SDH_AU3) ? iNodeModel.getSupportedFramingTypes() : new int[]{iNodeModel.getFramingType()};
                if (ComparisonUtil.compare((int[])this._oldFramingTypes, (int[])nArray) != 0) {
                    this._oldFramingTypes = nArray;
                }
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                // empty catch block
            }
        }
        return nArray;
    }

    public TDMTerminology getTDMTerminology() {
        return this.getTdmProtocolTypeObj().getTDMTerminology();
    }

    public UObservable getIncompatibleObservable() {
        return this.incompatObs;
    }

    @Override
    public INodeModel.AbstractConnectionNotifier getConnectionNotifier() {
        return this._connectionNotifier;
    }

    public IObservable getTheConnectionNotifier() {
        return this.getConnectionNotifier();
    }

    public int getProxyConfiguration() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getProxyConfiguration");
        }
        return iNodeModel.getProxyConfiguration();
    }

    public boolean getProxyEnable() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getProxyEnable");
        }
        return iNodeModel.getProxyEnable();
    }

    public boolean getFirewallEnable() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getFirewallEnable");
        }
        return iNodeModel.getFirewallEnable();
    }

    public boolean getCraftAccessOnly() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getCraftAccessOnly");
        }
        return iNodeModel.getCraftAccessOnly();
    }

    @Override
    public int getNodeId() {
        block3: {
            INodeModel iNodeModel;
            if ((this._nodeId == 0 || this._nodeId == -1) && this.isInited() && (iNodeModel = this._delegate) != null) {
                try {
                    this._nodeId = iNodeModel.getNodeId();
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block3;
                    this.db.fine("NM.getNodeId(): Exception caught and swallowed: " + exception);
                }
            }
        }
        return this._nodeId;
    }

    private void updateNodeId() {
        block7: {
            INodeModel iNodeModel = this._delegate;
            int n = 0;
            if (iNodeModel != null) {
                try {
                    n = iNodeModel.getNodeId();
                    if (n != this._nodeId) {
                        if (this.db.on()) {
                            this.db.fine("updateNodeId: updating " + this.getActualHostName() + "(" + Integer.toHexString(this._nodeId) + ") to " + Integer.toHexString(n));
                        }
                        trans.updateNodeId(this._hostName, n);
                        this.setOldNodeId(this._nodeId);
                        this._nodeId = n;
                        if (this.getOldNodeId() != 0 && this.getOldNodeId() != -1) {
                            this.bNodeIdChanged = true;
                            NetworkAlarmStore.instance().swapNodeId(this._oldNodeId, this._nodeId);
                        }
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this.db.println("updateNodeId: Caught UnknownHostException " + unknownHostException.getMessage());
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block7;
                    this.db.fine("NodeModel.updateNodeId(): Exception caught and swallowed: " + exception);
                }
            }
        }
    }

    public int getOldNodeId() {
        return this._oldNodeId;
    }

    private void setOldNodeId(int n) {
        block3: {
            if (this.provides(Feature.MEMORY_FOOTPRINT) && this._oldNodeId != 0) {
                INodeAdapter iNodeAdapter = this.getNodeAdapter();
                try {
                    iNodeAdapter.removePersistedNodeId(this._oldNodeId);
                }
                catch (CTCUserException cTCUserException) {
                    this.db.fine("setOldNodeId(" + n + ") failed");
                    if (!this.db.on()) break block3;
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
            }
        }
        this._oldNodeId = n;
    }

    @Override
    public SecurityLevel getSecurityLevel() {
        block5: {
            try {
                INodeModel iNodeModel = this._delegate;
                if (iNodeModel != null) {
                    if (iNodeModel.isInited()) {
                        this._securityLevel = iNodeModel.getSecurityLevel();
                    }
                    return this._securityLevel;
                }
            }
            catch (Exception exception) {
                if (!this.db.isFineEnabled()) break block5;
                this.db.fine("Could not retrieve security level");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this._securityLevel != null) {
            return this._securityLevel;
        }
        return SecurityLevel.RETRIEVE;
    }

    @Override
    public boolean getConnectionState() {
        return this.getFSM().isConnected();
    }

    @Override
    public boolean getInitializationState() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel == null ? false : iNodeModel.getInitializationState();
    }

    @Override
    public boolean isInited() {
        return this.getFSM().isInited();
    }

    private boolean delegateIsInited() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel == null ? false : iNodeModel.isInited();
    }

    @Override
    public boolean isLiteInited() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel == null ? false : iNodeModel.isLiteInited();
    }

    @Override
    public boolean isAuthenticationFailed() {
        return this.getFSM().isAuthenticationFailed();
    }

    private boolean delegateIsAuthenticationFailed() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel == null ? false : iNodeModel.isAuthenticationFailed();
    }

    @Override
    public void startPollerThread() {
    }

    @Override
    public boolean isIncompatible() {
        return this.getFSM().isIncompatible();
    }

    private boolean delegateIsIncompatible() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel == null ? false : iNodeModel.isIncompatible();
    }

    @Override
    public Exception getInitFailureException() {
        Exception exception;
        INodeModel iNodeModel = this._delegate;
        Exception exception2 = exception = iNodeModel != null ? iNodeModel.getInitFailureException() : this._failedException;
        if (this.db.on()) {
            if (exception.getMessage().equals(IStateTransition.NO_EXCEPTION.getMessage())) {
                this.db.fine("NM.getInitFailureException(): res = (No except'n)");
            } else {
                this.db.fine("NM.getInitFailureException(): res = " + exception);
            }
        }
        if (exception != null && exception.getMessage().equals(IStateTransition.NO_EXCEPTION.getMessage())) {
            exception = null;
        }
        return exception;
    }

    @Override
    public String getHostName() {
        return this._hostName;
    }

    public String getActualHostName() {
        return trans.getActualAddressDisplay(this._hostName);
    }

    private void updateProxiesForIpChange(String string, String string2) throws IOException {
        InetAddress inetAddress = CtcProxyFactory.updateProxiesForIpChange((String)string, (String)string2);
        if (inetAddress != null && this.db.on()) {
            this.db.println("updateProxiesForIpChange: configuring new perm gne (or DSS changed, old = " + string + ", new = " + string2);
        }
    }

    private String updateIPAddressTranslation() {
        String string = this.getPublicHostName();
        if (this.provides(Feature.TCC2P_SECURITY_MODE)) {
            string = this.getSecureHostName();
        }
        return string;
    }

    public String getPublicHostName() {
        IIpConfig iIpConfig = null;
        String string = trans.getPublicAddressDisplay(this._hostName);
        try {
            iIpConfig = this.getIpConfig();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.fine("getPublicHostName: caught " + abstractCmsIOException.getMessage());
            return "";
        }
        if (iIpConfig != null) {
            string = InetUtil.makeDottedString(iIpConfig.getIpAddress());
            try {
                String string2 = trans.getActualAddressDisplay(this._hostName);
                trans.updatePublicIpAddress(this._hostName, string);
            }
            catch (UnknownHostException unknownHostException) {
                this.db.fine("getPublicHostName: caught " + unknownHostException.getMessage());
            }
        }
        return string;
    }

    public String getSecureHostName() {
        if (!this.doesProvideTcc2pSecureMode()) {
            String string = this.getPublicHostName();
            try {
                trans.updateSecureIpAddress(this._hostName, string);
            }
            catch (UnknownHostException unknownHostException) {
                this.db.fine("getSecureHostName: caught " + unknownHostException.getMessage());
            }
            return string;
        }
        ISecureIpConfig iSecureIpConfig = null;
        String string = trans.getSecureAddressDisplay(this._hostName);
        try {
            iSecureIpConfig = this.getSecureIpConfig();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.fine("getSecureHostName: caught " + abstractCmsIOException.getMessage());
            return "";
        }
        if (iSecureIpConfig != null) {
            string = InetUtil.makeDottedString(iSecureIpConfig.getIpAddress());
            try {
                trans.updateSecureIpAddress(this._hostName, string);
            }
            catch (UnknownHostException unknownHostException) {
                this.db.fine("getSecureHostName: caught " + unknownHostException.getMessage());
            }
        }
        return string;
    }

    public synchronized String updateHostName(String string, boolean bl) throws UnknownHostException, CTCUserException {
        if (this.db.on()) {
            trans.dumpAddressTranslations((KDebug)this.db);
            SDebug.printStackTrace((Throwable)new Exception("entering updateHostName"));
        }
        string = NodeModel.asIp(string);
        if (bl && (this.isInited() || this._delegate != null)) {
            this.db.fine("NodeModel : Sorry cannot change _hostName as NM is inited.");
            throw new CTCUserException("NodeModel : Sorry cannot change _hostName as NM is inited.");
        }
        String string2 = trans.getActualAddressDisplay(this._hostName);
        if (!string.equals(string2) && !string.equals(this._hostName)) {
            String string3;
            String string4;
            block16: {
                string4 = " updating host " + string2 + "(" + Integer.toHexString(this.getNodeId()) + ") to ip address " + string;
                this.db.fine("updateHostName: " + string4);
                if (!IPAddressTranslator.instance().isVirtualMapped(this._hostName) && !IPAddressTranslator.instance().isVirtualMapped(string)) {
                    throw new UnknownHostException("virtual translation for " + string + "(" + Integer.toHexString(this.getNodeId()) + ") does not exist");
                }
                String string5 = "";
                string3 = null;
                string5 = IPAddressTranslator.instance().isVirtualMapped(this._hostName) ? trans.getActualAddressDisplay(this._hostName) : trans.getActualAddressDisplay(string);
                if (this.db.on()) {
                    this.db.println("NM:updateHostName actOldHostName : " + string5);
                }
                if (bl) {
                    trans.removeVirtual(string5);
                    trans.getVirtualAddress(string, this._nodeId);
                    string3 = string;
                } else {
                    string3 = this.updateIPAddressTranslation();
                }
                if (trans.isEnabled()) {
                    if (trans.isVirtualMapped(string)) {
                        this._hostName = string;
                        string3 = trans.getActualAddressDisplay(string);
                    } else {
                        this._hostName = trans.getVirtualAddress(string, this._nodeId).getHostAddress();
                        string3 = string;
                    }
                } else {
                    this._hostName = string;
                }
                if (this.db.on()) {
                    this.db.println("NM:updateHostName after IPAddressTranslator updates");
                    trans.dumpAddressTranslations((KDebug)this.db);
                }
                try {
                    if (InetAddress.getByName(string5).getAddress().length != 16) {
                        this.updateProxiesForIpChange(string5, string3);
                    }
                }
                catch (IOException iOException) {
                    if (this._hostName.startsWith(UNKNOWN_HOST) && !this.db.on()) break block16;
                    this.db.println("updateProxiesForIpChange: error detected on attempted PGNE change, old = " + string5 + ", new = " + string3);
                    SDebug.printStackTrace((Throwable)iOException);
                }
            }
            this.db.setName("Node" + NodeModel.getDebugName(string3));
            this.db.fine("updateHostName: completed" + string4 + " virtual " + this._hostName);
        } else {
            this.updateIPAddressTranslation();
            this.db.fine("NM:updateHostName: no action taken for : " + string);
            this.db.fine("NM:updateHostName: current hostName is : " + this._hostName);
        }
        return string;
    }

    public synchronized String updateIPv6HostName(String string) throws UnknownHostException, CTCUserException {
        block11: {
            String string2 = this._nodeIPv6Name;
            String string3 = "";
            String string4 = this.getSwVersion();
            if (string4 == null || string4.equals("")) {
                this.db.fine("Unable to determine the Software Version");
                throw new CTCUserException("Unable to determine the Software Version");
            }
            int n = 0;
            String string5 = string4.substring(0, string4.indexOf("."));
            try {
                n = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                this.db.fine("Unable to determine the Software Version: Error in parseInt()");
                throw new CTCUserException("Unable to determine the Software Version: Error in parseInt()");
            }
            if (n >= 9) {
                if (this.isInited() || this._delegate != null) {
                    this.db.fine("NodeModel : Sorry cannot change IPv6HostName as NM is inited.");
                    throw new CTCUserException("NodeModel : Sorry cannot change IPv6HostName as NM is inited.");
                }
                if (this.getNodeId() == 0 || this.getNodeId() == -1) {
                    this.db.fine("NodeModel : Sorry cannot change IPv6HostName as NodeID is invalid.");
                    throw new CTCUserException("NodeModel : Sorry cannot change IPv6HostName as NodeID is invalid.");
                }
            } else {
                this.db.fine("NodeModel: updateIPv6HostName() is incompatible with this Sowftware Version");
                throw new CTCUserException("NodeModel : updateIPv6HostName() is incompatible with this Sowftware Version");
            }
            InetAddress inetAddress = InetAddress.getByName(string);
            if (inetAddress.getAddress().length != 16) {
                this.db.fine("NodeModel: updateIPv6HostName() - The address given, " + string + " is not an IPv6 address.");
                throw new CTCUserException("NodeModel: updateIPv6HostName() - The address given, " + string + " is not an IPv6 address.");
            }
            InetAddress inetAddress2 = InetAddress.getByName(this._hostName);
            if (inetAddress2.getAddress().length == 16) {
                this.db.fine("Detected IPv6 address: Calling updateHostName with " + string + ".");
                this.updateHostName(string, true);
            }
            InetAddress inetAddress3 = IPAddressTranslator.instance().findVirtualAddress(this.getNodeId());
            IPAddressTranslator.instance().updateIPv6Address(inetAddress3, this.getNodeId(), InetAddress.getByName(string));
            this._nodeIPv6Name = InetUtil.makeDottedStringV6(InetUtil.makeIpAddr(string));
            try {
                this.updateProxiesForIpChange(string2, string);
            }
            catch (IOException iOException) {
                if (this._hostName.startsWith(UNKNOWN_HOST) && !this.db.on()) break block11;
                this.db.println("updateProxiesForIpChange: error detected on attempted PGNE change, old = " + string2 + ", new = " + string);
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        return string;
    }

    @Override
    public void setHostName(String string) throws UnknownHostException {
        INodeModel iNodeModel;
        String string2 = string;
        InetAddress inetAddress = InetAddress.getByName(string2);
        if (trans.isEnabled() && trans.isVirtual(inetAddress) && this.is15305Node()) {
            string2 = trans.getActualAddressDisplay(string2);
        }
        if ((iNodeModel = this._delegate) != null) {
            iNodeModel.setHostName(string2);
        } else {
            this.db.fine("Unable to call setHostName(), delegate is NULL.");
        }
    }

    public void update(IObservable iObservable, Object object) {
        this._update(iObservable, object);
    }

    @Override
    public void update(Observable observable, Object object) {
        this._update(observable, object);
    }

    private void _update(Object object, Object object2) {
        Object object3;
        if (this.db.on()) {
            this.db.fine("NM.CN.update(Obs,Obj): Entry. from=" + object.toString() + "; arg=" + object2.toString());
        }
        if (object2 instanceof BusEvent) {
            object3 = (BusEvent)object2;
            String string = (String)object3.getSource();
            Object object4 = object3.getEvent();
            if (string != null && string.equals("JAR_DELETED") && object4 instanceof JarFileDeleteEvent) {
                this.handleDeletedJarFile((JarFileDeleteEvent)object4);
            }
        }
        if (this._delegate != null) {
            object3 = null;
            try {
                object3 = this._delegate.getHostName();
                this.updateHostName((String)object3, false);
            }
            catch (UnknownHostException unknownHostException) {
                SDebug.printStackTrace((Throwable)unknownHostException);
                this.db.println("got error in updateHostName(" + (String)object3 + ")");
            }
            catch (CTCUserException cTCUserException) {
                SDebug.printStackTrace((Throwable)cTCUserException);
                this.db.println("got error in updateHostName(" + (String)object3 + ")");
            }
        }
        this.updateName();
        this.updateIPv6Name();
        this.updateSendPDIP();
        if (this.db.on()) {
            this.db.fine("NM.update(): notifyObservers(CHANGED)");
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
        if (this.db.on()) {
            this.db.fine("NM.update(): Exit");
        }
    }

    private void handleDeletedJarFile(JarFileDeleteEvent jarFileDeleteEvent) {
        if (this._delegate != null) {
            ClassLoader classLoader = this.loader();
            if (jarFileDeleteEvent.getClassLoader().equals(classLoader)) {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public String toString() {
        String string = trans.getActualAddressDisplay(this._hostName);
        return "NM(" + string + ")";
    }

    public String myName() {
        return this.toString();
    }

    public ClassLoader getNetworkClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public ClassLoader loader() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel != null ? iNodeModel.loader() : null;
    }

    public void setOspfStaticRoute(IStaticRoute iStaticRoute) throws InvalidStaticRouteToSelf, InvalidStaticRouteToSelfSubnet, InvalidStaticRouteToAllOnes, InvalidStaticRouteToLocalNet, InvalidMask, InvalidStaticDefaultRouteMask, InvalidStaticRouteToInternalNet, InvalidStaticRouteToClassDE, InvalidStaticRouteToClassA, InvalidStaticRouteToClassB, InvalidStaticRouteToClassC, InvalidStaticRouteToBroadcast, InvalidNextHop, DefaultRouterConflict, MaxStaticRoutes, DestinationExists, DefaultGreTunnelExists {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            iNodeModel.setOspfStaticRoute(iStaticRoute);
        }
    }

    @Override
    public short queryCodeVol(StringHolder stringHolder, StringHolder stringHolder2) throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("queryCodeVol");
        }
        return iNodeModel.queryCodeVol(stringHolder, stringHolder2);
    }

    @Override
    public boolean shellDiagnosticRetrieve(int n, StringHolder stringHolder) throws InvalidOperation {
        INodeModel iNodeModel = this._delegate;
        boolean bl = false;
        if (iNodeModel == null) {
            throw this.noDelegate("shellDiagnosticRetrieve");
        }
        bl = iNodeModel.shellDiagnosticRetrieve(n, stringHolder);
        return bl;
    }

    @Override
    public void shellDebugCommand(int n, StringHolder stringHolder) throws InvalidOperation {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("shellDebugCommand");
        }
        iNodeModel.shellDebugCommand(n, stringHolder);
    }

    public short queryCodeVol(cerent.util.StringHolder stringHolder, cerent.util.StringHolder stringHolder2) throws AbstractCmsIOException {
        short s;
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("queryCodeVol");
        }
        if (this.provides(Feature.REMOTE_ELE_V1)) {
            s = iNodeModel.queryCodeVol(stringHolder, stringHolder2);
        } else {
            StringHolder[] stringHolderArray = new StringHolder[]{new StringHolder(stringHolder.toString()), new StringHolder(stringHolder2.toString())};
            s = iNodeModel.queryCodeVol(stringHolderArray[0], stringHolderArray[1]);
            stringHolder.setValue(stringHolderArray[0].value);
            stringHolder2.setValue(stringHolderArray[1].value);
        }
        return s;
    }

    @Override
    public void deleteOspfStaticRoute(IIpAddr iIpAddr) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            iNodeModel.deleteOspfStaticRoute(iIpAddr);
        }
    }

    @Override
    public IStaticRoute[] getOspfStaticRoutes() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getOspfStaticRoutes");
        }
        return iNodeModel.getOspfStaticRoutes();
    }

    public boolean canSupportCircuitSize(int n) {
        throw new DeprecatedMethodCalled("NodeModel.canSupportCircuitSize(int)");
    }

    public boolean canSupportCircuitSize(int n, int n2) {
        boolean bl = false;
        if (this.provides(Feature.SDH_AU3)) {
            bl = this._delegate.canSupportCircuitSize(n, n2);
        } else if (this.provides(Feature.PATH_WIDTH)) {
            if (!CircuitType.getCircuitType((int)n).isHoCircuitType() || n2 != 11) {
                bl = this._delegate.canSupportCircuitSize(n2);
            }
        } else if (n2 == 0 && (this.provides(Feature.XCVT) || this.provides(Feature.XCVXC))) {
            bl = true;
        } else if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 7 || n2 == 4 || n2 == 27 || n2 == 8 || n2 == 25 || n2 == 5 || n2 == 6) {
            bl = true;
        }
        return bl;
    }

    @Override
    public IRevertiveBehavior getUpsrReversion() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getUpsrReversion");
        }
        return iNodeModel.getUpsrReversion();
    }

    @Override
    public INodeModel getDelegate() {
        if (this.db.on()) {
            this.db.fine("NM.getDelegate(): Entry. this=" + this.toString());
        }
        INodeModel iNodeModel = null;
        INodeModel iNodeModel2 = this._delegate;
        while (iNodeModel2 != null && (iNodeModel = iNodeModel2.getDelegate()) != iNodeModel2) {
            if (this.db.on()) {
                this.db.fine("NM.getDelegate(): delegate=" + iNodeModel2.toString());
            }
            iNodeModel2 = iNodeModel;
        }
        if (this.db.on()) {
            this.db.fine("NM.getDelegate(): Exit. Returning delegate=" + (iNodeModel2 == null ? "null" : iNodeModel2.toString()));
        }
        return iNodeModel2;
    }

    @Override
    public INodeAdapter getNodeAdapter() {
        return this._delegate.getNodeAdapter();
    }

    @Override
    public String getEnvAlarmCode(int n) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getEnvAlarmCode");
        }
        return iNodeModel.getEnvAlarmCode(n);
    }

    @Override
    public String getEnvAlarmDesc(int n) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getEnvAlarmDesc");
        }
        return iNodeModel.getEnvAlarmDesc(n);
    }

    @Override
    public IAlarmStore getElementAlarmStore() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getElementAlarmStore");
        }
        return iNodeModel.getElementAlarmStore();
    }

    @Override
    public IEventStore getElementEventStore() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getElementEventStore");
        }
        return iNodeModel.getElementEventStore();
    }

    @Override
    public String getProperty(String string) throws NoSuchProperty, AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getProperty");
        }
        return iNodeModel.getProperty(string);
    }

    @Override
    public void setProperty(String string, String string2) throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            iNodeModel.setProperty(string, string2);
        }
    }

    @Override
    public void removeProperty(String string) throws NoSuchProperty, AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            iNodeModel.removeProperty(string);
        }
    }

    @Override
    public IStringTag[] getAlarmableList() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getAlarmableList");
        }
        return iNodeModel.getAlarmableList();
    }

    @Override
    public IStringTag[] getAlarmProfileList() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getAlarmProfileList");
        }
        return iNodeModel.getAlarmProfileList();
    }

    @Override
    public String getAlarmSeveritiesFromProfile(String string) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getAlarmSeveritiesFromProfile");
        }
        return iNodeModel.getAlarmSeveritiesFromProfile(string);
    }

    @Override
    public void setAlarmProfile(String string, String string2) throws InvalidData, ObjNotFound, InvalidUpperBound {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            iNodeModel.setAlarmProfile(string, string2);
        }
    }

    @Override
    public ArrayList getNodeConditionList(boolean bl) throws AbstractCmsIOException {
        ArrayList arrayList = null;
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.isInited()) {
            if (this.provides(Feature.CONDITIONS_WITH_EXCLUSION)) {
                arrayList = iNodeModel.getNodeConditionList(bl);
            } else {
                try {
                    arrayList = iNodeModel.getNodeConditionList();
                }
                catch (AbstractMethodError abstractMethodError) {
                    arrayList = iNodeModel.getNodeAlarmList();
                }
            }
        } else {
            throw this.noDelegate("getNodeConditionList");
        }
        return arrayList;
    }

    public ArrayList getNodeAlarmHistory() {
        return this.getNodeAlarmHistory(0L, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getNodeAlarmHistory(long l, long l2) throws AbstractCmsIOException {
        ArrayList arrayList = null;
        INodeModel iNodeModel = this._delegate;
        ArrayList arrayList2 = new ArrayList();
        if (iNodeModel == null) throw this.noDelegate("getNodeAlarmHistory");
        if (!this.isInited()) throw this.noDelegate("getNodeAlarmHistory");
        if (this.provides(Feature.CTM_ALARM_HISTORY)) {
            arrayList = new ArrayList();
            if (this.provides(Feature.CTM_ALARM_LOG_FILTER)) {
                return iNodeModel.getNodeAlarmHistory(l, l2);
            }
            arrayList2 = iNodeModel.getNodeAlarmHistory();
            this.getEventUtils().getFilteredNodeConditionList(arrayList, arrayList2, l, l2);
            return arrayList;
        }
        if (!this.db.on()) throw new FeatureNotSupported(" getNodeAlarmHistory(startNeTime, endNeTime)");
        this.db.fine(" Unsupported method: getNodeAlarmHistory");
        throw new FeatureNotSupported(" getNodeAlarmHistory(startNeTime, endNeTime)");
    }

    @Override
    public ArrayList getNodeConditionList() throws AbstractCmsIOException {
        return this.getNodeConditionList(false);
    }

    public ArrayList getAlarmConditionList() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.provides(Feature.ALARM_EVENT_FILTER)) {
            return iNodeModel.getAlarmConditionList();
        }
        return new ArrayList();
    }

    public List getNodeAlarms(int n) throws AbstractCmsCommFailException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getNodeAlarms");
        }
        if (this.provides(Feature.NODE_ALARM_INTERFACE)) {
            return iNodeModel.getNodeAlarms(n);
        }
        throw new FeatureNotSupported("getNodeAlarms");
    }

    @Override
    public ArrayList getNodeAlarmList() throws AbstractCmsIOException {
        return this.getNodeConditionList(false);
    }

    @Override
    public IProgressManager getProgressManager() {
        return ProgressManager.instance();
    }

    @Override
    public Object getOrb() {
        if (this.db.on()) {
            this.db.fine("in NodeModel.getOrb()");
        }
        return CtcApplication.instance().getOrb();
    }

    @Override
    public String getUserName() {
        if (this.db.on()) {
            this.db.fine("in NodeModel.getUserName()");
        }
        return this._username;
    }

    @Override
    public String getUserPassword() {
        if (this.db.on()) {
            this.db.fine("in NodeModel.getUserPassword()");
        }
        return this._password;
    }

    @Override
    public void setUserName(String string) {
        if (this.db.on()) {
            this.db.fine("NodeModel.setUserName(): setting new username");
        }
        this._username = string;
        if (this._delegate != null) {
            this._delegate.setUserName(string);
        }
    }

    @Override
    public void setUserPassword(String string) {
        if (this.db.on()) {
            this.db.fine("NodeModel.setUserPassword(): setting new password");
        }
        this._password = string;
        if (this._delegate != null && this.provides(Feature.SEC_GET_USERS)) {
            this._delegate.setUserPassword(string);
        }
    }

    @Override
    public boolean isCmsHost() {
        return this._cmsHost;
    }

    public void setCmsHost(boolean bl) {
        this._cmsHost = bl;
    }

    @Override
    public int getNodeIpV4Add() {
        INodeModel iNodeModel = this._delegate;
        return iNodeModel != null ? iNodeModel.getNodeIpV4Add() : NodeModel.asInt(this._hostName);
    }

    @Override
    public short getTl1TcpPort() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getTl1TcpPort");
        }
        return iNodeModel.getTl1TcpPort();
    }

    public boolean doesTl1UseSsh() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && iNodeModel.provides(Feature.SECURITY_VERSIONING)) {
            return iNodeModel.doesTl1UseSsh();
        }
        return false;
    }

    public boolean isTl1Enabled() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && iNodeModel.provides(Feature.SECURITY_VERSIONING)) {
            return iNodeModel.isTl1Enabled();
        }
        return true;
    }

    public IEntityModel[] getTimingRefEntities() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            return iNodeModel.getTimingRefEntities();
        }
        return new IEntityModel[0];
    }

    public int[] getVWMasks() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.NODE_STATUS_LIST)) {
                return iNodeModel.getVWMasks();
            }
            throw new FeatureNotSupported("getVWMasks");
        }
        throw this.noDelegate("getVWMasks");
    }

    public OneNodeStatus[] getNodeStatusList() throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.NODE_STATUS_LIST)) {
                return iNodeModel.getNodeStatusList();
            }
            throw new FeatureNotSupported("getNodeStatusList");
        }
        throw this.noDelegate("getNodeStatusList");
    }

    public void updateCircuitIds(int n, int n2) throws AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (!this.provides(Feature.ENHANCED_CIRCUIT_REPAIR)) {
                throw new FeatureNotSupported("updateCircuitIds");
            }
        } else {
            throw this.noDelegate("updateCircuitIds");
        }
        iNodeModel.updateCircuitIds(n, n2);
    }

    @Override
    public IUiToolkit getUiToolkit() {
        return UiToolkit.instance();
    }

    public IVirtualLinksManager getVirtualLinksManager() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getVirtualLinksManager");
        }
        if (!this.provides(Feature.VLINK_PROVISIONING)) {
            throw new FeatureNotSupported("getVirtualLinksManager");
        }
        return iNodeModel.getVirtualLinksManager();
    }

    public ISideModels getSideModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getSideModels");
        }
        if (!this.provides(Feature.OPTICAL_SIDE)) {
            throw new FeatureNotSupported("getSideModels");
        }
        return iNodeModel.getSideModels();
    }

    public IFvSideModel[] getIFvSideModels() {
        ISideModel[] iSideModelArray = this.getSideModels().getSides();
        IFvSideModel[] iFvSideModelArray = new IFvSideModel[iSideModelArray.length];
        for (int i = 0; i < iSideModelArray.length; ++i) {
            iFvSideModelArray[i] = iSideModelArray[i];
        }
        return iFvSideModelArray;
    }

    public IRamanModel getRamanModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getRamanModel");
        }
        if (!this.provides(Feature.RAMAN_DAY0_WIZARD)) {
            throw new FeatureNotSupported("getRamanModel");
        }
        return iNodeModel.getRamanModels();
    }

    public IServerTrailsManager getServerTrailsManager() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getServerTrailsManager");
        }
        if (!this.provides(Feature.SERVER_TRAIL)) {
            throw new FeatureNotSupported("getServerTrailManager");
        }
        return iNodeModel.getServerTrailsManager();
    }

    @Override
    public IDccConnectionTableModel getIDccConnectionTableModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getIDccConnectionTableModel");
        }
        return iNodeModel.getIDccConnectionTableModel();
    }

    public ITermConnectionModel getDccTermConnectionModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.GCC_PROVISIONING)) {
                return iNodeModel.getDccTermConnectionModel();
            }
            throw new FeatureNotSupported("getDccTermConnectionModel");
        }
        throw this.noDelegate("getDccTermConnectionModel");
    }

    public ITermConnectionModel getLdccTermConnectionModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.ENHANCED_DCC)) {
                return iNodeModel.getLdccTermConnectionModel();
            }
            throw new FeatureNotSupported("getLdccTermConnectionModel");
        }
        throw this.noDelegate("getLdccTermConnectionModel");
    }

    public EventUtils getEventUtils() {
        EventUtils eventUtils = EventUtils.getInstance();
        return eventUtils;
    }

    public ITermConnectionModel getGccTermConnectionModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.GCC_PROVISIONING)) {
                return iNodeModel.getGccTermConnectionModel();
            }
            throw new FeatureNotSupported("getGccTermConnectionModel");
        }
        throw this.noDelegate("getGccTermConnectionModel");
    }

    public ISwUpgradeModel getSwUpgradeModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            return iNodeModel.getSwUpgradeModel();
        }
        throw this.noDelegate("getSwUpgradeModel");
    }

    public IDelayedUpgradeModel getDelayedUpgradeModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.ML_VERSION_UP)) {
                return iNodeModel.getDelayedUpgradeModel();
            }
            throw new FeatureNotSupported("getDelayedUpgradeModel");
        }
        throw this.noDelegate("getDelayedUpgradeModel");
    }

    public String[] getSpanLoss(int n) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.OCHNC_BIDI_PROVISIONING)) {
                return iNodeModel.getSpanLoss(n);
            }
            throw new FeatureNotSupported("getExpectedSpanLoss");
        }
        throw this.noDelegate("getExpectedSpanLoss");
    }

    public int getNodeInputEntityIdx(int n) throws NoSuchEquipment {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.OCHNC_PROVISIONING)) {
                return iNodeModel.getNodeInputEntityIdx(n);
            }
            throw new FeatureNotSupported("getNodeInputEntityIdx");
        }
        throw this.noDelegate("getNodeInputEntityIdx");
    }

    public int getNodeOutputEntityIdx(int n) throws NoSuchEquipment {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.OCHNC_PROVISIONING)) {
                return iNodeModel.getNodeOutputEntityIdx(n);
            }
            throw new FeatureNotSupported("getNodeOutputEntityIdx");
        }
        throw this.noDelegate("getNodeOutputEntityIdx");
    }

    public boolean getOchncPathAvailability(int n, int n2, int n3) throws AlreadyInUse, AbstractCmsIOException {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.OCHNC_PROVISIONING)) {
                return iNodeModel.getOchncPathAvailability(n, n2, n3);
            }
            throw new FeatureNotSupported("getOchncPathAvailability");
        }
        return false;
    }

    public int getNodeOpticalType() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.OCHNC_PROVISIONING)) {
                return iNodeModel.getNodeOpticalType();
            }
            throw new FeatureNotSupported("getNodeOpticalType");
        }
        throw this.noDelegate("getNodeOpticalType");
    }

    public int getNodeType() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.OCHNC_PROVISIONING)) {
                return iNodeModel.getNodeType();
            }
            return 3;
        }
        throw this.noDelegate("getNodeType");
    }

    public ITermConnectionModel getOscTermConnectionModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (this.provides(Feature.OCHNC_PROVISIONING)) {
                return iNodeModel.getOscTermConnectionModel();
            }
            throw new FeatureNotSupported("getOscTermCOnnectionModel");
        }
        throw this.noDelegate("getOscTermConnectionModel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDelegate(INodeModel iNodeModel) throws Exception {
        ClassLoader classLoader = iNodeModel.loader();
        HashMap hashMap = clToDelegate;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)clToDelegate.get(classLoader);
            if (arrayList != null && arrayList.contains(iNodeModel)) {
                if (this.db.on()) {
                    this.db.fine("removeDelegate(): delegate found on list");
                }
                arrayList.remove(iNodeModel);
                if (arrayList.size() == 0) {
                    if (this.db.on()) {
                        this.db.fine("removeDelegate(): removing class loader");
                    }
                    clToDelegate.remove(classLoader);
                }
            } else {
                throw new Exception("Attempting to removeDelegate " + iNodeModel + " that is not present in the NodeModel.clToDelegate map!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelegate(INodeModel iNodeModel) {
        ClassLoader classLoader = iNodeModel.loader();
        HashMap hashMap = clToDelegate;
        synchronized (hashMap) {
            if (!clToDelegate.containsKey(classLoader)) {
                clToDelegate.put(classLoader, new ArrayList());
            }
            ArrayList arrayList = (ArrayList)clToDelegate.get(classLoader);
            arrayList.add(iNodeModel);
        }
    }

    @Override
    public IModel getModel(int n, int n2, int n3, int n4, int n5) {
        return this.getModel(n, 1, n2, n3, n4, n5);
    }

    public IModel getModel(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this._delegate != null) {
            if (this.provides(Feature.MULTISHELF)) {
                return this._delegate.getModel(n, n2, n3, n4, n5, n6);
            }
            if (this.provides(Feature.CTM_SUPPORT_INTERFACE)) {
                return this._delegate.getModel(n, n3, n4, n5, n6);
            }
            throw new FeatureNotSupported("getModel(int port)");
        }
        this.db.fine("NodeModel.getObject .. delegate is null");
        throw this.noDelegate("getModel");
    }

    public IModel getModel(int n, int n2, int[] nArray, int n3, int n4) {
        return this.getModel(n, 1, n2, nArray, n3, n4);
    }

    public IModel getModel(int n, int n2, int n3, int[] nArray, int n4, int n5) {
        if (this._delegate != null) {
            if (this.provides(Feature.MULTISHELF)) {
                return this._delegate.getModel(n, n2, n3, nArray, n4, n5);
            }
            if (this.provides(Feature.EXP_PORT_NUM)) {
                return this._delegate.getModel(n, n3, nArray, n4, n5);
            }
            if (nArray.length == 1) {
                return this.getModel(n, n3, nArray[0], n4, n5);
            }
            throw new FeatureNotSupported("getModel(int[] port)");
        }
        this.db.fine("NodeModel.getObject .. delegate is null");
        throw this.noDelegate("getModel");
    }

    private void destroyModel(NetModelObserver netModelObserver) {
        block3: {
            try {
                if (netModelObserver != null) {
                    netModelObserver.destroy();
                }
            }
            catch (Exception exception) {
                this.db.fine("Unexpected exception occurred while trying to destroy " + netModelObserver);
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                if (this.db.on()) {
                                    this.db.fine("NM.destroy(): Entry");
                                }
                                super.destroy();
                                this.setEnabled(false);
                                this.incompatObs.deleteObservers();
                                try {
                                    this._connectionNotifier.dispose();
                                    this._connectionNotifier = null;
                                }
                                catch (Exception exception) {
                                    this.db.fine("Caught exception while dispose connectionNotifier.");
                                    if (!this.db.on()) break block18;
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                            try {
                                if (this._delegate != null) {
                                    this.destroyDelegate();
                                }
                                this._delegateCreator = null;
                            }
                            catch (Exception exception) {
                                this.db.fine("Caught exception while destroy delegate.");
                                if (!this.db.on) break block19;
                                SDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        this.destroyModel(this._connModels);
                        this.destroyModel(this._cktFactoryModel);
                        this.destroyModel(this._elementModels);
                        this.destroyModel(this._vcatTermModels);
                        this.destroyModel(this._ohConnModels);
                        this.destroyModel(this._ohCktFactoryModel);
                        this.destroyModel(this._svlanCktModels);
                        this._cmsHost = false;
                        try {
                            if (this._nmdb != null) {
                                this._nmdb.dispose();
                                this._nmdb = null;
                            }
                        }
                        catch (Exception exception) {
                            this.db.fine("Caught exception while dispose nodemodel debug.");
                            if (!this.db.on()) break block20;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    try {
                        if (this._disconnectedIsPosted) {
                            this.postNetworkAlarm((short)1028, 2, '\u0001');
                        }
                    }
                    catch (Exception exception) {
                        this.db.fine("Caught exception while postNetworkAlarm");
                        if (!this.db.on()) break block21;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                this._poller = null;
                try {
                    NodeModel.removeNode(this);
                }
                catch (Exception exception) {
                    this.db.fine("Caught exception while removeNode");
                    if (!this.db.on()) break block22;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                EventBus.instance().deleteObserver((Observer)this, (Object)"JAR_DELETED");
            }
            catch (Exception exception) {
                this.db.fine("Caught exception while deleteObserver");
                if (!this.db.on()) break block23;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.db.on()) {
            this.db.fine("NM.destroy(): Exit");
        }
        if (this.db != null) {
            this.db.dispose();
        }
    }

    @Override
    public IPoller getPoller() {
        return null;
    }

    public boolean poll() {
        if (this._poller != null) {
            return this._poller.poll();
        }
        if (this.db.on()) {
            this.db.fine("poll(): _poller is NULL");
        }
        return false;
    }

    public int recover(int n) throws NodePollerException {
        if (this.db.on()) {
            this.db.fine("NM.recover(): Entry");
        }
        if (!this.isEnabled()) {
            if (this.db.on()) {
                this.db.fine("NM.recover(): Node is disabled");
            }
            throw new NodePollerException("The node is disabled.");
        }
        this.makeDelegate();
        this.waitForDelegate();
        if (this._delegate == null) {
            Exception exception;
            if (this.db.on()) {
                this.db.fine("NM.recover(): delegate is still null, throwing exception.");
            }
            throw new NodePollerException((exception = this._failedException) != null ? exception.getMessage() : "The delegate creation failed.");
        }
        if (this._poller != null) {
            int n2 = 0;
            if (this.provides(Feature.CTM_RESYNC)) {
                n2 = this._poller.recoverWithStatus(n);
            } else {
                this._poller.recover(n);
            }
            if (this.db.on()) {
                this.db.fine("NM.recover(): Exit w/return status=" + n2);
            }
            return n2;
        }
        if (this.db.on()) {
            this.db.fine("NM.recover(): Exit. _poller is NULL; throwing NodePollerException");
        }
        throw new NodePollerException("The poller is null.");
    }

    public void stoprecover() throws NodePollerException {
        if (this._poller == null) {
            if (this.db.on()) {
                this.db.fine("recover(): _poller is NULL");
            }
            throw new NodePollerException("The poller is null.");
        }
        this._poller.stoprecover();
    }

    private AbstractCmsCommFailException noDelegate(String string) {
        return new NetCmsCommFailException("Error in NodeModel::" + string + " -- attempt to access node-specific information while" + " communications are suspended");
    }

    @Override
    public void activate(int n, int n2, IJobProgressControl iJobProgressControl) throws Exception {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (!this.provides(Feature.CTM_SUPPORT_INTERFACE) || this.provides(Feature.HTTP_DATA_TRANSFER)) {
                throw new FeatureNotSupported("activate");
            }
        } else {
            throw this.noDelegate("activate");
        }
        iNodeModel.activate(n, n2, iJobProgressControl);
    }

    @Override
    public void revert(int n, int n2, IJobProgressControl iJobProgressControl) throws Exception {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (!this.provides(Feature.CTM_SUPPORT_INTERFACE) || this.provides(Feature.HTTP_DATA_TRANSFER)) {
                throw new FeatureNotSupported("revert");
            }
        } else {
            throw this.noDelegate("revert");
        }
        iNodeModel.revert(n, n2, iJobProgressControl);
    }

    @Override
    public void dataReceive(String string, IJobProgressControl iJobProgressControl) throws Exception {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            if (!this.provides(Feature.CTM_SUPPORT_INTERFACE) || this.provides(Feature.HTTP_DATA_TRANSFER)) {
                throw new FeatureNotSupported("dataReceive");
            }
        } else {
            throw this.noDelegate("dataReceive");
        }
        iNodeModel.dataReceive(string, iJobProgressControl);
    }

    @Override
    public void dataTransfer(String string, int n, IJobProgressControl iJobProgressControl) throws Exception {
    }

    public boolean isMultishelf() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("isMultishelf");
        }
        try {
            if (this.provides(Feature.MULTISHELF)) {
                return iNodeModel.isMultishelf();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.println((Object)((Object)abstractCmsIOException) + ": during isMultishelf()");
            }
            throw this.noDelegate("isMultishelf");
        }
        return false;
    }

    public List getAvailablePortsForUpgrade(ILinkModel iLinkModel, Object object, Method method) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getAvailablePortsForUpgrade");
        }
        List<ITdmPortModel> list = null;
        if (!this.provides(Feature.MULTISHELF)) {
            list = new ArrayList();
            IEntityModel iEntityModel = this.getChassis();
            List list2 = iEntityModel.getChildren();
            IEntityModel iEntityModel2 = (IEntityModel)list2.get(0);
            List list3 = iEntityModel2.getChildren();
            for (int i = 1; i <= list3.size(); ++i) {
                IEntityModel iEntityModel3 = (IEntityModel)list3.get(i - 1);
                List list4 = iEntityModel3.getChildren();
                if (list4.size() <= 0) continue;
                IEntityModel iEntityModel4 = (IEntityModel)list4.get(0);
                Object[] objectArray = new Object[]{iEntityModel4, iLinkModel};
                try {
                    List list5 = (List)method.invoke(object, objectArray);
                    for (int j = 0; j < list5.size(); ++j) {
                        ITdmPortModel iTdmPortModel = (ITdmPortModel)list5.get(j);
                        list.add(iTdmPortModel);
                    }
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    SDebug.printStackTrace((Throwable)illegalAccessException);
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    SDebug.printStackTrace((Throwable)invocationTargetException);
                }
            }
        } else {
            list = iNodeModel.getAvailablePortsForUpgrade(iLinkModel, object, method);
        }
        return list;
    }

    public IModuleModel[] getIosModuleList() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getIosModuleList");
        }
        if (!this.provides(Feature.MULTISHELF)) {
            ArrayList<IModuleModel> arrayList = new ArrayList<IModuleModel>();
            try {
                ArrayList arrayList2 = this.getMfgData();
                IEntityModel iEntityModel = this.getChassis();
                List list = iEntityModel.getDescendantsOfClassType(1);
                list = ((IEntityModel)list.get(0)).getDescendantsOfClassType(6);
                for (int i = 0; i < list.size(); ++i) {
                    IEntityModel iEntityModel2 = (IEntityModel)list.get(i);
                    if (!(iEntityModel2 instanceof IModuleModel)) continue;
                    IModuleModel iModuleModel = (IModuleModel)iEntityModel2;
                    String string = (String)arrayList2.get(iModuleModel.getSlot() - 1);
                    int n = iModuleModel.getEqType();
                    if (string == null || string.length() <= 0 || n != 102 && n != 103 && n != 238 && n != 164 && n != 248) continue;
                    arrayList.add(iModuleModel);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return arrayList.toArray(new IModuleModel[0]);
        }
        return iNodeModel.getIosModuleList();
    }

    public List getValidRollSlots(Method method) {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getValidRollSlots");
        }
        List<IEntityModel> list = null;
        if (!this.provides(Feature.MULTISHELF)) {
            list = new ArrayList();
            IEntityTableModel iEntityTableModel = this.getEntityTable();
            if (iEntityTableModel == null) {
                return list;
            }
            IEntityModel iEntityModel = iEntityTableModel.getChassis();
            if (iEntityModel == null) {
                return list;
            }
            List list2 = iEntityModel.getDescendantsOfClassType(1);
            List list3 = ((IEntityModel)list2.get(0)).getChildren();
            for (IEntityModel iEntityModel2 : list3) {
                IModuleModel iModuleModel;
                if (iEntityModel2.getChildren().size() < 1 || (iModuleModel = (IModuleModel)iEntityModel2.getChildren().get(0)) == null) continue;
                Object[] objectArray = new Object[]{new Integer(iModuleModel.getEqType())};
                try {
                    if (!((Boolean)method.invoke(null, objectArray)).booleanValue()) continue;
                    list.add(iEntityModel2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    SDebug.printStackTrace((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    SDebug.printStackTrace((Throwable)invocationTargetException);
                }
            }
        } else {
            list = iNodeModel.getValidRollSlots(method);
        }
        return list;
    }

    public ArrayList getAlarmProfileUsage() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getAlarmProfileUsage");
        }
        ArrayList<Object> arrayList = null;
        if (!this.provides(Feature.MULTISHELF)) {
            Object[] objectArray;
            List list;
            Object[] objectArray2;
            arrayList = new ArrayList<Object>();
            Object[] objectArray3 = new Object[4];
            objectArray3[0] = this.getName();
            IEntityModel iEntityModel = this.getChassis();
            if (iEntityModel == null) {
                objectArray3[1] = "N/A";
                objectArray3[2] = "- ERROR: Try again after initialization -";
                objectArray3[3] = null;
                arrayList.add(objectArray3);
                return arrayList;
            }
            List list2 = iEntityModel.getDescendantsOfClassType(1);
            if (list2 == null || list2.size() == 0) {
                if (this.db.on()) {
                    this.db.fine("Can't get backplane!");
                }
                objectArray3[1] = "N/A";
                objectArray3[2] = "- ERROR: Try again after initialization -";
                objectArray3[3] = null;
                arrayList.add(objectArray3);
                return arrayList;
            }
            objectArray3[1] = "CHASSIS";
            objectArray3[2] = iEntityModel.getAlarmProfileName();
            objectArray3[3] = iEntityModel;
            arrayList.add(objectArray3);
            List list3 = iEntityModel.getDescendantsOfClassType(4);
            Object[] objectArray4 = list3.toArray();
            IEntityModel[] iEntityModelArray = new IEntityModel[objectArray4.length];
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                iEntityModelArray[i] = (IEntityModel)objectArray4[i];
                objectArray2 = new Object[]{this.getName(), "Fan_Slot_" + iEntityModelArray[i].getPositionInParent(), iEntityModelArray[i].getAlarmProfileName(), iEntityModelArray[i]};
                arrayList.add(objectArray2);
            }
            if (this.provides(Feature.CUSTOMER_ACCESS_PANEL) && (list = iEntityModel.getDescendantsOfEqType(94)).size() > 0) {
                objectArray2 = (Object[])list.get(0);
                objectArray = new Object[]{this.getName(), objectArray2.getEqLabel(), objectArray2.getAlarmProfileName(), objectArray2};
                arrayList.add(objectArray);
            }
            IEntityModel iEntityModel2 = (IEntityModel)list2.get(0);
            objectArray2 = iEntityModel2.getDescendantsOfClassType(6);
            arrayList.add(new Object[]{objectArray3[0], iEntityModel2.getEqTypeName(), iEntityModel2.getAlarmProfileName(), iEntityModel2});
            objectArray = objectArray2.toArray();
            IEntityModel[] iEntityModelArray2 = new IEntityModel[objectArray.length];
            for (int i = 0; i < iEntityModelArray2.length; ++i) {
                iEntityModelArray2[i] = (IEntityModel)objectArray[i];
                Object[] objectArray5 = new Object[]{this.getName() + ", slot " + iEntityModelArray2[i].getParent().getPositionInParent(), iEntityModelArray2[i].getEqTypeName(), iEntityModelArray2[i].getAlarmProfileName(), iEntityModelArray2[i]};
                arrayList.add(objectArray5);
                Object[] objectArray6 = iEntityModelArray2[i].getChildren().toArray();
                if (objectArray6 == null || objectArray6.length <= 0) continue;
                IEntityModel[] iEntityModelArray3 = new IEntityModel[objectArray6.length];
                for (int j = 0; j < objectArray6.length; ++j) {
                    iEntityModelArray3[j] = (IEntityModel)objectArray6[j];
                    Object[] objectArray7 = new Object[]{objectArray5[0] + ", port " + iEntityModelArray3[j].getPort(), iEntityModelArray3[j].getEqTypeName(), iEntityModelArray3[j].getAlarmProfileName(), iEntityModelArray3[j]};
                    arrayList.add(objectArray7);
                }
            }
        } else {
            arrayList = iNodeModel.getAlarmProfileUsage();
        }
        return arrayList;
    }

    @Override
    public int getIndex() {
        if (this._delegate == null) {
            return 0;
        }
        int n = this._delegate.getIndex();
        if (this.db.on()) {
            this.db.finer("getIndex=> " + n);
        }
        return n;
    }

    private NodeFSM getFSM() {
        return this._FSM;
    }

    public INodeOpticsTopologyModel getINodeOpticsTopologyModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getINodeOpticsTopologyModel");
        }
        return iNodeModel.getINodeOpticsTopologyModel();
    }

    public IDwdmApcModels getIDwdmApcModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getIDwdmApcModels");
        }
        return iNodeModel.getIDwdmApcModels();
    }

    public IOpticalPatchCordModel getIOpticalPatchCordModel() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getIOpticalPatchCordModel");
        }
        return iNodeModel.getIOpticalPatchCordModel();
    }

    @Override
    public boolean isVersionUpStateEnabled() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("isVersionUpStateEnabled");
        }
        if (this.provides(Feature.ML_VERSION_UP_ENH)) {
            return iNodeModel.isVersionUpStateEnabled();
        }
        return false;
    }

    public boolean isManageable() {
        INodeModel iNodeModel = this._delegate;
        if (this.provides(Feature.CRS_OCHTRAIL_LMP)) {
            if (iNodeModel == null) {
                throw this.noDelegate("isManageable");
            }
            return iNodeModel.isManageable();
        }
        return true;
    }

    public ILmpCtrlChannelModels getILmpCtrlChannelModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getLmpCtrlChannelModels");
        }
        if (this.provides(Feature.CRS_OCHTRAIL_LMP)) {
            return iNodeModel.getILmpCtrlChannelModels();
        }
        return null;
    }

    public ILmpTeLinkModels getILmpTeLinkModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getLmpTeLinkModels");
        }
        if (this.provides(Feature.CRS_OCHTRAIL_LMP)) {
            return iNodeModel.getILmpTeLinkModels();
        }
        return null;
    }

    public ILmpDataLinkModels getILmpDataLinkModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getLmpDataLinkModels");
        }
        if (this.provides(Feature.CRS_OCHTRAIL_LMP)) {
            return iNodeModel.getILmpDataLinkModels();
        }
        return null;
    }

    public ISVlanProfileModels getISVlanProfileModels() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("getISVlanProfileModels");
        }
        if (this.provides(Feature.SVLAN_PROFILE)) {
            return iNodeModel.getISVlanProfileModels();
        }
        return null;
    }

    @Override
    public long getUniqueNodeSRLG() throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            try {
                return iNodeModel.getUniqueNodeSRLG();
            }
            catch (InvalidNodeId invalidNodeId) {
                if (this.db.on()) {
                    this.db.fine("NM.getUniqueNodeSRLG(): Exception caught: " + (Object)((Object)invalidNodeId));
                }
                throw new InvalidNodeId(invalidNodeId.getMessage());
            }
        }
        throw new InvalidNodeId("Error while obtaining the Delegate");
    }

    @Override
    public void setUniqueNodeSRLG(long l) throws InvalidNodeId, ConfigError {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            try {
                iNodeModel.setUniqueNodeSRLG(l);
            }
            catch (InvalidNodeId invalidNodeId) {
                if (this.db.on()) {
                    this.db.fine("NM.setUniqueNodeSRLG(): Exception caught: " + (Object)((Object)invalidNodeId));
                }
                throw new InvalidNodeId(invalidNodeId.getMessage());
            }
        }
    }

    @Override
    public void setDefaultUniqueNodeSRLG() throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            try {
                iNodeModel.setDefaultUniqueNodeSRLG();
            }
            catch (InvalidNodeId invalidNodeId) {
                if (this.db.on()) {
                    this.db.fine("NM.setUniqueNodeSRLG(): Exception caught: " + (Object)((Object)invalidNodeId));
                }
                throw new InvalidNodeId(invalidNodeId.getMessage());
            }
        }
    }

    @Override
    public String getAdditionalNodeSRLG() throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            try {
                return iNodeModel.getAdditionalNodeSRLG();
            }
            catch (InvalidNodeId invalidNodeId) {
                if (this.db.on()) {
                    this.db.fine("NM.getAdditionalNodeSRLG(): Exception caught: " + (Object)((Object)invalidNodeId));
                }
                throw new InvalidNodeId(invalidNodeId.getMessage());
            }
        }
        throw new InvalidNodeId("Error while obtaining the Delegate");
    }

    @Override
    public void setAdditionalNodeSRLG(String string) throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            try {
                iNodeModel.setAdditionalNodeSRLG(string);
            }
            catch (InvalidNodeId invalidNodeId) {
                if (this.db.on()) {
                    this.db.fine("NM.setAdditionalNodeSRLG(): Exception caught: " + (Object)((Object)invalidNodeId));
                }
                throw new InvalidNodeId(invalidNodeId.getMessage());
            }
        }
    }

    @Override
    public void setDefaultAdditionalNodeSRLG() throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            try {
                iNodeModel.setDefaultAdditionalNodeSRLG();
            }
            catch (InvalidNodeId invalidNodeId) {
                if (this.db.on()) {
                    this.db.fine("NM.setAdditionalNodeSRLG(): Exception caught: " + (Object)((Object)invalidNodeId));
                }
                throw new InvalidNodeId(invalidNodeId.getMessage());
            }
        }
    }

    @Override
    public int[] getCoordMaintList() throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            try {
                return iNodeModel.getCoordMaintList();
            }
            catch (InvalidNodeId invalidNodeId) {
                if (this.db.on()) {
                    this.db.fine("NM.getCoordMaintList(): Exception caught: " + (Object)((Object)invalidNodeId));
                }
                throw new InvalidNodeId(invalidNodeId.getMessage());
            }
        }
        throw new InvalidNodeId("Error while obtaining the Delegate");
    }

    public IFvEleAlarmStore getTheElementAlarmStore() {
        return this.getElementAlarmStore();
    }

    public IViewGraph getNodeFv(IFvNetSidePosition iFvNetSidePosition) {
        NodeModel nodeModel = this;
        try {
            IFvNodeModel iFvNodeModel = this.getFvDelegate();
            return iFvNodeModel.startFv((IFvEditDialog)FunctionalNetworkDialog.instance(), iFvNetSidePosition, (IFvOpenActions)new FunctOpenActions());
        }
        catch (InvalidNodeId invalidNodeId) {
            return null;
        }
    }

    public void fvActive(boolean bl) {
        this.fvActive = bl;
    }

    public boolean isFVActive() {
        return this.fvActive;
    }

    public boolean isMspp() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.provides(Feature.PACKAGE_SPLIT)) {
            return iNodeModel.isMspp();
        }
        return false;
    }

    public boolean isMstpUts() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.provides(Feature.PACKAGE_SPLIT)) {
            return iNodeModel.isMstpUts();
        }
        return false;
    }

    public boolean isMstpLite() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.provides(Feature.PACKAGE_SPLIT)) {
            return iNodeModel.isMstpLite();
        }
        return false;
    }

    public String getPackageTypeStr() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.provides(Feature.PACKAGE_SPLIT)) {
            return iNodeModel.getPackageTypeStr();
        }
        return "";
    }

    public boolean isInCircuit() {
        try {
            return this.getFvDelegate().isInCircuit();
        }
        catch (InvalidNodeId invalidNodeId) {
            return false;
        }
    }

    public void setInCircuit(boolean bl) {
        block2: {
            try {
                this.getFvDelegate().setInCircuit(bl);
            }
            catch (InvalidNodeId invalidNodeId) {
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)invalidNodeId);
            }
        }
    }

    public void setOpen(boolean bl) {
        block2: {
            try {
                this.getFvDelegate().setOpen(bl);
            }
            catch (InvalidNodeId invalidNodeId) {
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)invalidNodeId);
            }
        }
    }

    public boolean isPowerCalculated() {
        try {
            return this.getFvDelegate().isPowerCalculated();
        }
        catch (InvalidNodeId invalidNodeId) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)invalidNodeId);
            }
            return false;
        }
    }

    public void setPowerCalculated(boolean bl) {
        block2: {
            try {
                this.getFvDelegate().setPowerCalculated(bl);
            }
            catch (InvalidNodeId invalidNodeId) {
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)invalidNodeId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IFvNodeModel getFvDelegate() throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        IFvNodeModel iFvNodeModel = null;
        if (iNodeModel == null) throw new InvalidNodeId("Error while obtaining the Delegate in FV");
        if (!this.provides(Feature.NETWORK_FUNCTIONAL_VIEW)) throw new InvalidNodeId("Ne does not support Network Functional View");
        iFvNodeModel = iNodeModel.getFvNodeModelDelegate();
        if (iFvNodeModel != null) return iFvNodeModel;
        throw new InvalidNodeId("the Platform does not have the Delegate in FV (CRS ?) ");
    }

    public IFvInterfaceModel getInterfaceModelByIndex(int n) throws InvalidNodeId {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null) {
            return (IFvInterfaceModel)iNodeModel.getNodeAdapter().getModel("cerent.cms.InterfaceModel", n);
        }
        throw new InvalidNodeId("Error while obtaining the Delegate in FV");
    }

    public boolean hasSubtendedUtsChassis() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel == null) {
            throw this.noDelegate("hasSubtendedUtsChassis");
        }
        try {
            if (this.provides(Feature.MULTISHELF)) {
                return iNodeModel.hasSubtendedUtsChassis();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.println((Object)((Object)abstractCmsIOException) + ": during hasSubtendedUtsChassis()");
            }
            throw this.noDelegate("hasSubtendedUtsChassis");
        }
        return false;
    }

    public IAlarmDecoderDefs getAlarmDecoderDefs() {
        INodeModel iNodeModel = this._delegate;
        if (iNodeModel != null && this.provides(Feature.PACKAGE_SPLIT)) {
            return iNodeModel.getAlarmDecoderDefs();
        }
        return null;
    }

    static /* synthetic */ Disabled access$3000(NodeModel nodeModel) {
        return nodeModel.disabled;
    }

    static {
        Class<DOMUtil> clazz = DOMUtil.class;
    }

    private class AuthenticationFailed
    extends NodeState {
        public AuthenticationFailed() {
            super("AuthenticationFailed");
        }

        @Override
        public boolean isInited() {
            return false;
        }

        @Override
        public boolean isAuthenticationFailed() {
            return true;
        }

        @Override
        public boolean isIncompatible() {
            return false;
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public boolean useDelegate() {
            return false;
        }
    }

    public class ConnectionNotifier
    extends INodeModel.AbstractConnectionNotifier
    implements Observer {
        private final SDebug db;

        public ConnectionNotifier() {
            this.db = NodeModel.this.db.getChildDebug("cn");
        }

        public void init() {
            if (NodeModel.this.db.on()) {
                this.db.set(true);
            }
            if (this.db.on()) {
                this.db.fine("NM.CN.init(): Entry.  Register with the delegate (NMD, NMDP, or NMDPL).");
            }
            if (NodeModel.this._delegate != null) {
                NodeModel.this._delegate.getConnectionNotifier().addObserver((Observer)this);
            } else {
                this.db.fine("NM.CN.init(): Invoked with a null delegate.  SHOULD NEVER HAPPEN.");
            }
            this.updateLocal();
            if (this.db.on()) {
                if (this.hasChanged()) {
                    this.db.fine("NM.CN.init(): notifyObservers(CHANGED)");
                } else {
                    this.db.fine("NM.CN.init(): No changes, no notifyObservers()");
                }
            }
            this.notifyObservers(ModelUpdateType.CHANGED);
            if (this.db.on()) {
                this.db.fine("NM.CN.init(): Exit");
            }
        }

        public void dispose() {
            if (this.db.on()) {
                this.db.fine("NM.CN.dispose(): Entry.  notifyObservers(CHANGED)");
            }
            this.changed();
            this.notifyObservers(ModelUpdateType.CHANGED);
            if (NodeModel.this._delegate != null) {
                NodeModel.this._delegate.getConnectionNotifier().deleteObserver((Observer)this);
            }
            if (this.db.on()) {
                this.db.fine("NM.CN.dispose(): Exit");
            }
        }

        protected void updateLocal() {
            if (this.db.on()) {
                this.db.fine("NM.CN.updateLocal(): Entry");
            }
            if (NodeModel.this.delegateIsIncompatible()) {
                if (this.db.on()) {
                    this.db.fine("NM.CN.updateLocal(): Delegate is incompatible");
                }
                if (NodeModel.this.getFSM().setState(NodeModel.this.incompatible)) {
                    this.changed();
                    NodeModel.this.synchronizeMyAlarms();
                }
                NodeModel.this._failedException = NodeModel.this.getInitFailureException();
                NodeModel.this.setDelegate(null);
                if (NodeModel.this.bNodeIdChanged) {
                    if (this.db.on()) {
                        this.db.fine("NM.CN.updateLocal(): notifyObservers(CHANGED) for NodeId change");
                    }
                    this.getNodeModel().setChanged();
                    this.getNodeModel().notifyObservers(ModelUpdateType.CHANGED);
                    NodeModel.this.setOldNodeId(NodeModel.this._nodeId);
                    NodeModel.this.bNodeIdChanged = false;
                }
                NodeModel.this.incompatObs.changed();
                NodeModel.this.incompatObs.notifyObservers((Object)NodeModel.this);
            } else if (NodeModel.this.delegateIsAuthenticationFailed()) {
                if (this.db.on()) {
                    this.db.fine("NM.CN.updateLocal(): delegate authentication failed");
                }
                if (NodeModel.this.getFSM().setState(NodeModel.this.authenticationFailed)) {
                    this.changed();
                    NodeModel.this.synchronizeMyAlarms();
                }
                NodeModel.this._failedException = NodeModel.this.getInitFailureException();
                NodeModel.this.setDelegate(null);
            } else if (NodeModel.this.delegateIsInited()) {
                if (this.db.on()) {
                    this.db.fine("NM.CN.updateLocal(): delegate is inited");
                }
                NodeModel.this.getFSM().setState(NodeModel.this.inited);
                this.changed();
                try {
                    NodeModel.this.updateHostName(NodeModel.this._delegate.getHostName(), false);
                }
                catch (CTCUserException cTCUserException) {
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                catch (UnknownHostException unknownHostException) {
                    SDebug.printStackTrace((Throwable)unknownHostException);
                }
                NodeModel.this.updateName();
                NodeModel.this.updateIPv6Name();
                NodeModel.this.bPauseMakeDelegate = false;
                NodeModel.this.synchronizeMyAlarms();
                NodeModel.this.getSecurityLevel();
            } else {
                if (this.db.on()) {
                    this.db.fine("NM.CN.updateLocal(): delegate is not inited");
                }
                if (NodeModel.this.getFSM().setState(NodeModel.this.notInited)) {
                    this.changed();
                    NodeModel.this.synchronizeMyAlarms();
                }
            }
            if (this.db.on()) {
                this.db.fine("NM.CN.updateLocal(): Exit");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(Observable observable, Object object) {
            if (this.db.on()) {
                this.db.fine("NM.CN.update(Obs,Obj): Entry. from=" + observable.toString() + "; arg=" + object.toString());
            }
            try {
                if (object.equals(ModelUpdateType.DELETED)) {
                    if (this.db.on()) {
                        if (observable == this.getNodeModel()) {
                            this.db.fine("NM.CN.update(DELETED): From NodeModel for the destroyed delegate");
                        } else {
                            this.db.fine("NM.CN.update(DELETED)");
                        }
                    }
                    if (observable != this.getNodeModel()) {
                        observable.deleteObserver(this);
                    }
                    if (!NodeModel.this._loggingIn && !NodeModel.this.isAuthenticationFailed() && NodeModel.this._enabled) {
                        NodeModel.this.makeDelegate();
                    }
                    this.changed();
                } else if (object == ModelUpdateType.CHANGED) {
                    if (this.db.on()) {
                        this.db.fine("NM.CN.update(): CHANGED");
                    }
                    NodeModel.this.updateNodeId();
                    this.updateLocal();
                } else if (object == ModelUpdateType.LOGOUT) {
                    if (this.db.on()) {
                        this.db.fine("NM.CN.update(): LOGOUT");
                    }
                    NodeModel.this.setEnabled(false);
                } else {
                    this.db.fine("NM.CN.update(): Unexpected update type=" + object);
                }
                ConnectionNotifier connectionNotifier = this;
                synchronized (connectionNotifier) {
                    if (this.db.on()) {
                        this.db.fine("NM.CN.update(): notifyAll (wake up waiting threads)");
                    }
                    this.notifyAll();
                }
            }
            finally {
                if (this.db.on()) {
                    if (this.hasChanged()) {
                        this.db.fine("NM.CN.update(): notifyObservers(CHANGED)");
                    } else {
                        this.db.fine("NM.CN.update(): No changes, no notifyObservers()");
                    }
                }
                this.notifyObservers(ModelUpdateType.CHANGED);
                if (this.db.on()) {
                    this.db.fine("NM.CN.update(): Exit");
                }
            }
        }

        public void changed() {
            this.setChanged();
        }

        public NodeModel getNodeModel() {
            return NodeModel.this;
        }
    }

    private class DelegateCreator
    extends Thread {
        public DelegateCreator(String string, int n) {
            super("NMD creator for " + string);
        }

        private void error(String string, Exception exception) {
            NodeModel.this.db.fine(this.prefix() + string);
            if (NodeModel.this.db.on()) {
                SDebug cfr_ignored_0 = NodeModel.this.db;
                SDebug.printStackTrace((Throwable)exception);
            }
        }

        private void slumber() {
            if (NodeModel.this.db.on()) {
                NodeModel.this.db.fine("DelegateCreator : slumber()");
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                this.error("slumber interrupted", interruptedException);
            }
        }

        private void checkCompatibility() throws IncompatibleException {
            NodeModel nodeModel = (NodeModel)NetworkModel.instance().getCmsHostModel();
            if (!NodeModel.this.isNeCompatibleWith(nodeModel)) {
                String string = trans.getActualAddressDisplay(NodeModel.this._hostName);
                ErrorMsg.displayError(null, NEMC.EID_INCOMPATIBLE_NODE_TYPE, string, NodeModel.this.getNodeTypeString(), nodeModel.getNodeTypeString());
                String string2 = ErrorMsg.getString((EID)NEMC.EID_INCOMPATIBLE_NODE_TYPE, (Object[])new Object[]{string, NodeModel.this.getNodeTypeString(), nodeModel.getNodeTypeString()});
                throw new IncompatibleException(string2);
            }
        }

        private String prefix() {
            return "[hostname=" + NodeModel.this.getActualHostName() + " neType=" + NodeModel.this._neType + " nodeId=" + NodeModel.this._nodeId + "]NMD.DelegateCreator";
        }

        @Override
        public void run() {
            if (NodeModel.this.db.on()) {
                NodeModel.this.db.fine(this.prefix() + ".run(): Entry : _hostName = " + NodeModel.this._hostName);
            }
            INodeModel iNodeModel = null;
            if (NodeModel.this.bPauseMakeDelegate) {
                this.slumber();
            }
            NodeModel.this.bPauseMakeDelegate = true;
            while (iNodeModel == null) {
                try {
                    IElementFactory iElementFactory;
                    if (NodeModel.this.db.on()) {
                        NodeModel.this.db.fine(this.prefix() + ".run(): getNeType ");
                    }
                    NodeModel.this.getNeType();
                    if (NodeModel.this.db.on()) {
                        NodeModel.this.db.fine(this.prefix() + ".run(): getSwVersion ");
                    }
                    NodeModel.this.retrieveSwVersion();
                    if (NodeModel.this._delegateCreator == null) {
                        if (NodeModel.this.db.on()) {
                            NodeModel.this.db.fine(this.prefix() + ".run(): node destroyed");
                        }
                        throw new Exception("The node was destroyed.");
                    }
                    if (NodeModel.this._neType == null) {
                        throw new Exception("The node is unreachable because its type could not be determined.");
                    }
                    if (NodeModel.this.is15305Node()) {
                        NodeModel.this._hostName = CoreConstants.GetActualAddress((String)NodeModel.this._hostName);
                    }
                    this.checkCompatibility();
                    if (NodeModel.this.db.on()) {
                        NodeModel.this.db.fine(this.prefix() + ".run(): create node model");
                    }
                    if ((iElementFactory = ElementFactoryFinder.getElementFactory(NodeModel.this)) == null) {
                        throw new Exception("The Element Factory was not found.");
                    }
                    iNodeModel = iElementFactory.createNodeModel((INodeModel)NodeModel.this, (KDebug)NodeModel.this.db, NodeModel.this._hostName, NodeModel.this._neType, NodeModel.this._nodeId);
                    if (iNodeModel != null) continue;
                    this.slumber();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.error(fileNotFoundException.toString(), fileNotFoundException);
                    NodeModel.this.failDelegate(fileNotFoundException);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.error(classNotFoundException.toString(), classNotFoundException);
                    NodeModel.this.failDelegate(classNotFoundException);
                    return;
                }
                catch (IncompatibleException incompatibleException) {
                    this.error(incompatibleException.toString(), (Exception)((Object)incompatibleException));
                    ModelAttributeCacheManager.instance();
                    ModelAttributeCacheManager.invalidateAll(NodeModel.this);
                    NodeModel.this.failDelegate((Exception)((Object)incompatibleException));
                    return;
                }
                catch (Exception exception) {
                    this.error(exception.toString(), exception);
                    if (NodeModel.this._loggingIn) {
                        NodeModel.this.failDelegate(exception);
                        return;
                    }
                    iNodeModel = null;
                    this.slumber();
                }
            }
            if (NodeModel.this.db.on()) {
                NodeModel.this.db.fine(this.prefix() + ".run(): setDelegate");
            }
            NodeModel.this.setDelegate(iNodeModel);
            if (NodeModel.this.db.on()) {
                NodeModel.this.db.fine(this.prefix() + ".run(): Exit");
            }
        }
    }

    private class Disabled
    extends NodeState {
        public Disabled() {
            super("Disabled");
        }

        @Override
        public boolean isInited() {
            return false;
        }

        @Override
        public boolean isAuthenticationFailed() {
            return false;
        }

        @Override
        public boolean isIncompatible() {
            return false;
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public boolean useDelegate() {
            return false;
        }
    }

    private static interface INodeState {
        public boolean isInited();

        public boolean isAuthenticationFailed();

        public boolean isIncompatible();

        public boolean isConnected();

        public boolean useDelegate();
    }

    private class Incompatible
    extends NodeState {
        public Incompatible() {
            super("Incompatible");
        }

        @Override
        public boolean isInited() {
            return false;
        }

        @Override
        public boolean isAuthenticationFailed() {
            return false;
        }

        @Override
        public boolean isIncompatible() {
            return true;
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public boolean useDelegate() {
            return false;
        }
    }

    private class Inited
    extends NodeState {
        public Inited() {
            super("Inited");
        }

        @Override
        public boolean isInited() {
            return true;
        }

        @Override
        public boolean isAuthenticationFailed() {
            return false;
        }

        @Override
        public boolean isIncompatible() {
            return false;
        }

        @Override
        public boolean isConnected() {
            INodeModel iNodeModel = NodeModel.this._delegate;
            return iNodeModel == null ? false : iNodeModel.getConnectionState();
        }

        @Override
        public boolean useDelegate() {
            return true;
        }
    }

    private class NodeFSM
    implements INodeState {
        private final SDebug dbFSM;
        private INodeState _currentState;

        public NodeFSM() {
            this.dbFSM = NodeModel.this.db.getChildDebug("FSM");
            if (this.dbFSM.on()) {
                this.dbFSM.fine("NM.NodeFSM.ctor: state = " + NodeModel.this.notInited);
            }
            this._currentState = NodeModel.this.notInited;
        }

        @Override
        public boolean isInited() {
            if (this.dbFSM.on()) {
                this.dbFSM.fine("NM.NodeFSM.isInited() = " + this._currentState.isInited());
            }
            return this._currentState.isInited();
        }

        @Override
        public boolean isAuthenticationFailed() {
            if (this.dbFSM.on()) {
                this.dbFSM.fine("FSM isAuthenticationFailed = " + this._currentState.isAuthenticationFailed());
            }
            return this._currentState.isAuthenticationFailed();
        }

        @Override
        public boolean isIncompatible() {
            if (this.dbFSM.on()) {
                this.dbFSM.fine("FSM isIncompatible = " + this._currentState.isIncompatible());
            }
            return this._currentState.isIncompatible();
        }

        @Override
        public boolean isConnected() {
            if (this.dbFSM.on()) {
                this.dbFSM.fine("FSM isConnected = " + this._currentState.isConnected());
            }
            return this._currentState.isConnected();
        }

        @Override
        public boolean useDelegate() {
            if (this.dbFSM.on()) {
                this.dbFSM.fine("FSM useDelegate = " + this._currentState.useDelegate());
            }
            return this._currentState.useDelegate();
        }

        /*
         * Unable to fully structure code
         */
        private synchronized boolean setState(INodeState var1_1) {
            block20: {
                if (this.dbFSM.on()) {
                    this.dbFSM.fine("NM.NodeFSM.setState(" + var1_1 + "): Entry");
                }
                if (this._currentState == var1_1) {
                    if (this.dbFSM.on()) {
                        this.dbFSM.fine("NM.NodeFSM.setState(" + var1_1 + "): Exit. No change.");
                    }
                    return false;
                }
                if (this._currentState == NodeModel.access$1200(NodeModel.this) && var1_1 == NodeModel.access$2500(NodeModel.this) || this._currentState == NodeModel.access$2000(NodeModel.this) && var1_1 != NodeModel.access$2200(NodeModel.this) && var1_1 != NodeModel.access$3000(NodeModel.this) || this._currentState == NodeModel.access$3000(NodeModel.this) && var1_1 != NodeModel.access$2200(NodeModel.this)) {
                    if (this.dbFSM.on()) {
                        this.dbFSM.fine("NM.NodeFSM.setState(): State change to " + var1_1 + " denied.");
                    }
                    return false;
                }
                if (var1_1 == NodeModel.access$2200(NodeModel.this)) {
                    try {
                        NodeModel.this.getTDMTerminology();
                        var2_2 = NodeModel.access$1000(NodeModel.this);
                        var3_6 = NetworkEventStore.instance();
                        var4_8 = NetworkAlarmStore.instance();
                        var5_10 = var2_2.getElementEventStore();
                        var6_12 = var2_2.getElementAlarmStore();
                        if (var5_10 != null) {
                            var5_10.addObserver((Observer)var3_6);
                        }
                        if (var6_12 != null) {
                            var6_12.addObserver((Observer)var4_8);
                        }
                        if (var5_10 != null) {
                            var3_6.addChild(var5_10);
                        }
                        if (this.dbFSM.on()) {
                            this.dbFSM.fine("NM.NodeFSM.setState(): State changed from " + this._currentState + " to " + var1_1);
                        }
                        this._currentState = var1_1;
                        if (var6_12 != null) {
                            var4_8.addChild(NodeModel.this._hostName, NodeModel.this.getNodeId(), var6_12);
                        }
                        if (this.dbFSM.on()) {
                            this.dbFSM.fine("NM.NodeFSM.setState(): Exit. Successful.");
                        }
                        return true;
                    }
                    catch (Exception var2_3) {
                        this.dbFSM.fine("NM.NodeFSM.setState():  Caught exception while entering inited state");
                        if (!this.dbFSM.on()) ** GOTO lbl54
                        SDebug.printStackTrace((Throwable)var2_3);
                    }
                } else if (this._currentState == NodeModel.access$2200(NodeModel.this)) {
                    try {
                        var2_4 = NodeModel.access$1000(NodeModel.this);
                        var3_7 = NetworkEventStore.instance();
                        var4_9 = NetworkAlarmStore.instance();
                        var5_11 = var2_4.getElementEventStore();
                        var3_7.deleteChild(var5_11);
                        var4_9.deleteChild(NodeModel.this._nodeId);
                    }
                    catch (Exception var2_5) {
                        this.dbFSM.fine("NM.NodeFSM.setState(): Caught exception while leaving inited");
                        if (!this.dbFSM.on()) break block20;
                        SDebug.printStackTrace((Throwable)var2_5);
                    }
                }
            }
            if (this.dbFSM.on()) {
                this.dbFSM.fine("NM.NodeFSM.setState(): State changed from " + this._currentState + " to " + var1_1);
            }
            this._currentState = var1_1;
            if (this.dbFSM.on()) {
                this.dbFSM.fine("NM.NodeFSM.setState(" + var1_1 + "): Exit. Returning false");
            }
            return true;
        }
    }

    public class NodeModelDebug
    extends SDebug {
        private NodeModel nm;

        public NodeModelDebug(String string, NodeModel nodeModel2) {
            super(string);
            this.nm = null;
            this.nm = nodeModel2;
        }

        public NodeModelDebug(KDebug kDebug, String string, NodeModel nodeModel2) {
            super(kDebug, string);
            this.nm = null;
            this.nm = nodeModel2;
        }

        public final void freeElementClassLoader() {
            block3: {
                INodeModel iNodeModel = NodeModel.this._delegate;
                if (iNodeModel != null) {
                    this.nm.setDelegate(null);
                    try {
                        ElementFactoryFinder.getElementFactory(this.nm).removeClassLoader(iNodeModel.loader());
                    }
                    catch (Exception exception) {
                        NodeModel.this.db.println("Exception caught in freeElementClassLoader: " + exception);
                        if (!this.on()) break block3;
                        NodeModelDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
        }

        public final void enable() {
            NodeModel.this.setEnabled(true);
        }

        public final void disable() {
            NodeModel.this.setEnabled(false);
        }

        public final void dbgUpHostName(String string) {
            try {
                NodeModel.this.updateHostName(string, true);
            }
            catch (Exception exception) {
                SDebug cfr_ignored_0 = NodeModel.this.db;
                SDebug.printStackTrace((Throwable)exception);
                NodeModel.this.db.println("Exception while updating HostName to " + string);
            }
        }

        public final void dbgUpIPv6HostName(String string) {
            try {
                NodeModel.this.updateIPv6HostName(string);
            }
            catch (Exception exception) {
                SDebug cfr_ignored_0 = NodeModel.this.db;
                SDebug.printStackTrace((Throwable)exception);
                NodeModel.this.db.println("Exception while updating HostName to " + string);
            }
        }

        public final void enabled() {
            NodeModel.this.db.println(NodeModel.this._enabled ? "is enabled" : "is not enabled");
        }

        public void dispose() {
            this.nm = null;
            super.dispose();
        }

        public final void testGetDefault() {
            try {
                String string = NodeModel.this.getDefaultValue("NODE.circuits.CreateLikeTL1");
                NodeModel.this.db.println("CIRCUITS_LIKE_TL1 = " + string);
                string = NodeModel.this.getDefaultValue("NODE.circuits.CreateLikeIT");
                NodeModel.this.db.println("INVALID TEST = " + string);
            }
            catch (Exception exception) {
                NodeModel.this.db.println("GOT EXCEPTION - " + exception);
            }
        }

        public final void testGetHoConnModels() {
            IConnectionModels iConnectionModels = NodeModel.this.getConnectionModels();
            IHoConnectionModel[] iHoConnectionModelArray = iConnectionModels.getHoConnectionModels();
            NodeModel.this.db.fine("HoConnectionModels: cmArray.length=> " + iHoConnectionModelArray.length);
            for (int i = 0; i < iHoConnectionModelArray.length; ++i) {
                NodeModel.this.db.fine("    index=> " + iHoConnectionModelArray[i].getIndex());
            }
        }

        public final void testPathTrace() {
            try {
                IInterfaceModels iInterfaceModels = NodeModel.this.getInterfaceModels();
                Map map = iInterfaceModels.getIfModels();
                for (IInterfaceModel iInterfaceModel : map.values()) {
                    if (iInterfaceModel instanceof ITdmHoModel) {
                        NodeModel.this.db.println("PathTrace=" + ((ITdmHoModel)iInterfaceModel).getHoPathTraceModel());
                        continue;
                    }
                    NodeModel.this.db.println("InterfaceModel=" + iInterfaceModel.getClass().getName());
                }
            }
            catch (Exception exception) {
                NodeModel.this.db.println("Caught " + exception);
                exception.printStackTrace();
            }
        }

        public final void testEntityModelSerialization() {
            NodeModel.this.db.println(" In testEntityModelSerialization");
            try {
                IEntityModel iEntityModel = NodeModel.this.getEntityTable().getChassis();
                Class<?> clazz = iEntityModel.getClass();
                if (Proxy.class.isAssignableFrom(clazz)) {
                    NodeModel.this.db.println("em=> dynamic proxy " + clazz.getName() + " (" + Proxy.getInvocationHandler(iEntityModel).getClass().getName() + ")");
                } else {
                    NodeModel.this.db.println("em=> " + clazz.getName());
                }
                NodeModel.this.db.println("em Chassis EqLabel : " + iEntityModel.getEqLabel());
                if (NodeModel.this.provides(Feature.REMOTE_ELE_V1)) {
                    NodeModel.this.db.println("now testing NET->ELE serialization");
                    NodeModel.this.getEntityTable().testEntity(iEntityModel);
                    NodeModel.this.db.println("done testing NET->ELE serialization");
                }
            }
            catch (Exception exception) {
                NodeModelDebug.printStackTrace((Throwable)exception);
            }
        }

        public final void testModelSerialization() {
            NodeModel.this.db.println(" In testModelSerialization");
            try {
                IEntityModel iEntityModel = NodeModel.this.getEntityTable().getChassis();
                Class<?> clazz = iEntityModel.getClass();
                if (Proxy.class.isAssignableFrom(clazz)) {
                    NodeModel.this.db.println("em=> dynamic proxy " + clazz.getName() + " (" + Proxy.getInvocationHandler(iEntityModel).getClass().getName() + ")");
                } else {
                    NodeModel.this.db.println("em=> " + clazz.getName());
                }
                ClassLoader classLoader = NodeModel.class.getClassLoader();
                IEntityModel iEntityModel2 = (IEntityModel)SerializationUtil.testSerialization((Object)iEntityModel, (ClassLoader)classLoader);
                clazz = iEntityModel2.getClass();
                if (Proxy.class.isAssignableFrom(clazz)) {
                    NodeModel.this.db.println("em=> dynamic proxy " + clazz.getName() + " (" + Proxy.getInvocationHandler(iEntityModel2).getClass().getName() + ")");
                } else {
                    NodeModel.this.db.println("sEM=> " + clazz.getName());
                }
                NodeModel.this.db.println("em Chassis EqLabel : " + iEntityModel.getEqLabel());
                NodeModel.this.db.println("sEM Chassis EqLabel : " + iEntityModel2.getEqLabel());
            }
            catch (Exception exception) {
                NodeModelDebug.printStackTrace((Throwable)exception);
            }
        }

        public final void testVlanListSerialization() {
            IEtherBridgeModel iEtherBridgeModel = NodeModel.this.getEtherBridgeModel();
            IVlanModel[] iVlanModelArray = iEtherBridgeModel.getVlanList();
            if (iVlanModelArray == null || iVlanModelArray.length == 0) {
                return;
            }
            ClassLoader classLoader = NodeModel.class.getClassLoader();
            IVlanModel[] iVlanModelArray2 = (IVlanModel[])SerializationUtil.testSerialization((Object)iVlanModelArray, (ClassLoader)classLoader);
            int n = iVlanModelArray2 == null ? 0 : iVlanModelArray2.length;
            NodeModel.this.db.println("# serialized vlans: " + n);
            for (int i = 0; i < n; ++i) {
                IVlanModel iVlanModel = iVlanModelArray2[i];
                NodeModel.this.db.println("  serialized vlan " + i + " : " + (iVlanModel == null ? "null" : iVlanModel.getClass().getName()));
            }
        }

        public final void testChassis() {
            IEntityModel iEntityModel = NodeModel.this.getChassis();
            NodeModel.this.db.println("chassis: " + iEntityModel);
        }

        public final void testBlsrModels() {
            IElementModels iElementModels = NodeModel.this.getNodeModel().getIElementModels();
            Set set = iElementModels.getBlsrElements();
            NodeModel.this.db.println(set.size() + " blsr elements");
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                IEntityModel iEntityModel;
                NodeModel.this.db.println("...blsr #: " + n);
                IBlsrModel iBlsrModel = (IBlsrModel)iterator.next();
                try {
                    iEntityModel = iBlsrModel.getEastEntityModel();
                    NodeModel.this.db.println("  east entity : " + iEntityModel.getEntityIndex());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    NodeModelDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                try {
                    iEntityModel = iBlsrModel.getEastProtectEntityModel();
                    NodeModel.this.db.println("  east prot entity : " + iEntityModel.getEntityIndex());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    NodeModelDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                try {
                    iEntityModel = iBlsrModel.getWestEntityModel();
                    NodeModel.this.db.println("  west entity : " + iEntityModel.getEntityIndex());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    NodeModelDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                try {
                    iEntityModel = iBlsrModel.getWestProtectEntityModel();
                    NodeModel.this.db.println("  west prot entity : " + iEntityModel.getEntityIndex());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    NodeModelDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                ++n;
            }
        }

        public final void loadSessionManagement() throws ClassNotFoundException {
            Class.forName("cerent.cms.loader.session.SessionManagement");
        }

        public final void testGetDelegate() {
            INodeModel iNodeModel = NodeModel.this.getDelegate();
            NodeModel.this.db.println("delegate: " + ReflectionUtil.getClassName((Object)iNodeModel));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void xmlCommand(String string) throws Exception {
            String string2;
            INodeAdapter iNodeAdapter = NodeModel.this.getNodeAdapter();
            StringBuffer stringBuffer = new StringBuffer();
            File file = new File(string);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        SDebug cfr_ignored_0 = NodeModel.this.db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            string2 = stringBuffer.toString();
            String string3 = iNodeAdapter.xmlCommand(string2);
            String string4 = "schema/CTCSchema.xsd";
            URL uRL = new URL("file", "", string4);
            XercesDOMParser xercesDOMParser = XercesDOMParser.instance((URL)uRL, (KDebug)this);
            Document document = xercesDOMParser.parseString(string3);
            String string5 = DOMUtil.nodeToString((Node)document, (int)2, (boolean)false);
            sdb.println(string5);
        }

        public final void getAssociation(String string, int n, String string2) throws Exception {
            INodeAdapter iNodeAdapter = NodeModel.this.getNodeAdapter();
            List list = iNodeAdapter.getAssociation(string, n, string2);
            int n2 = list == null ? 0 : list.size();
            sdb.println("# of results: " + n2);
            String string3 = "schema/CTCSchema.xsd";
            URL uRL = new URL("file", "", string3);
            XercesDOMParser xercesDOMParser = XercesDOMParser.instance((URL)uRL, (KDebug)this);
            Iterator iterator = list.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                sdb.println("XML resp # " + n3 + ": ");
                String string4 = (String)iterator.next();
                Document document = xercesDOMParser.parseString(string4);
                String string5 = DOMUtil.nodeToString((Node)document, (int)2, (boolean)false);
                sdb.println(string5);
                ++n3;
            }
        }
    }

    private abstract class NodeState
    implements INodeState {
        private String _name;

        public NodeState(String string) {
            this._name = string;
        }

        public String toString() {
            return this._name;
        }
    }

    private class NotInited
    extends NodeState {
        public NotInited() {
            super("NotInited");
        }

        @Override
        public boolean isInited() {
            return false;
        }

        @Override
        public boolean isAuthenticationFailed() {
            return false;
        }

        @Override
        public boolean isIncompatible() {
            return false;
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public boolean useDelegate() {
            return false;
        }
    }
}

