/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;

public class OchTrailAttrsHelper {
    private static final SDebug db = new SDebug("OchTrailAttrsHelper");

    public static boolean checkTrunkAttrs(IModuleModel iModuleModel, TrunkInfo trunkInfo, IModuleModel iModuleModel2, TrunkInfo trunkInfo2) {
        boolean bl = false;
        if (db.on()) {
            db.println("checkTrunkAttrs:\n" + trunkInfo + "\n" + trunkInfo2);
        }
        bl = OchTrailAttrsHelper.areG709Equivalent(iModuleModel, trunkInfo.isG709(), iModuleModel2, trunkInfo2.isG709()) ? OchTrailAttrsHelper.areFECEquivalent(iModuleModel, trunkInfo.getFecMode(), iModuleModel2, trunkInfo2.getFecMode()) && trunkInfo.getSdBer() == trunkInfo2.getSdBer() && OchTrailAttrsHelper.areMappingEquivalent(trunkInfo.getMappingType(), trunkInfo2.getMappingType()) : false;
        if (db.on()) {
            db.println("Check result: " + bl);
        }
        return bl;
    }

    public static boolean checkProtectionAttrs(ProtectionInfo protectionInfo, ProtectionInfo protectionInfo2) {
        boolean bl = false;
        if (db.on()) {
            db.println("checkProtectionAttrs:\n" + protectionInfo + "\n" + protectionInfo2);
        }
        if (protectionInfo.isProtected() == protectionInfo2.isProtected()) {
            if (protectionInfo.isProtected()) {
                IRevertiveBehavior iRevertiveBehavior = protectionInfo.getRevertiveBehavior();
                IRevertiveBehavior iRevertiveBehavior2 = protectionInfo2.getRevertiveBehavior();
                bl = iRevertiveBehavior != null ? iRevertiveBehavior.equals(iRevertiveBehavior2) : iRevertiveBehavior2 == null;
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        if (db.on()) {
            db.println("Check result: " + bl);
        }
        return bl;
    }

    public static IRevertiveBehavior getReversion(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException {
        int n = iEntityModel.getEqType();
        IRevertiveBehavior iRevertiveBehavior = null;
        if (OchTrailHelper.isProtected(iEntityModel.getModuleModel())) {
            INodeModel iNodeModel;
            IEntityModel iEntityModel2 = iEntityModel;
            if (OchTrailHelper.isClientPort(iEntityModel)) {
                iNodeModel = iEntityModel2.getNodeModel();
                iEntityModel2 = OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex())[0];
            }
            if ((iNodeModel = OchTrailAttrsHelper.getYCableModel(iEntityModel2)) != null) {
                iRevertiveBehavior = iNodeModel.getReversion();
                if (db.on()) {
                    db.println("Got Reversion = " + iRevertiveBehavior);
                }
            }
        } else if (db.on()) {
            db.println("Non-protected cards have not reversion");
        }
        return iRevertiveBehavior;
    }

    public static void setReversion(IRevertiveBehavior iRevertiveBehavior, IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException {
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            if (db.on()) {
                db.println("setReversion invoked on a PlimPort, nothing to do. ");
            }
            return;
        }
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IElementModel iElementModel = iDwdmPortModel.getElementModel();
        if (iElementModel != null && iElementModel instanceof IYCableModel) {
            IYCableModel iYCableModel = (IYCableModel)iElementModel;
            iYCableModel.setReversion(iRevertiveBehavior);
            if (db.on()) {
                db.println("Configured Reversion = " + iRevertiveBehavior);
            }
        } else if (db.on()) {
            db.println("Cannot find Element Model or is not a IYCableModel: " + iElementModel);
        }
    }

    public static int getProtectionOp(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        if (db.on()) {
            db.println("getProtectionOp(" + iEntityModel + ")");
        }
        int n = -1;
        IYCableModel iYCableModel = OchTrailAttrsHelper.getYCableModel(iEntityModel);
        if (iYCableModel != null) {
            n = iYCableModel.getProtection();
        }
        if (db.on()) {
            db.println("getProtectionOp() return " + n);
        }
        return n;
    }

    public static void setProtectionOp(IEntityModel iEntityModel, int n) throws AbstractCmsNoSuchElementException, InvalidProtectionOp, InternalCommError {
        IYCableModel iYCableModel;
        if (db.on()) {
            db.println("switchToProtect(" + iEntityModel + ")");
        }
        if ((iYCableModel = OchTrailAttrsHelper.getYCableModel(iEntityModel)) != null) {
            iYCableModel.setProtection(n);
        }
        if (db.on()) {
            db.println("switchToProtect() completed ");
        }
    }

    public static TrunkInfo getTrunkAttrs(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface, WrongInterfaceType {
        TrunkInfo trunkInfo = null;
        int n = iEntityModel.getEqType();
        int n2 = iEntityModel.getModuleModel().getEqType();
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            IPlimTrkLineModel iPlimTrkLineModel = (IPlimTrkLineModel)iInterfaceModel;
            if (db.on()) {
                db.println("Found trunk plim port: " + iEntityModel);
            }
            short s = iPlimTrkLineModel.getOTNSdBerLevel();
            trunkInfo = new TrunkInfo(iPlimTrkLineModel.getOTNStatus(), iPlimTrkLineModel.getFECModeValue(), s, 0, 0, 1, 30, 1, 2000);
            trunkInfo.setTriggerThresholdStr("1E-3");
            trunkInfo.setRevertThresholdStr("1E-4");
            if (db.on()) {
                db.println("Found trunk attrs: " + trunkInfo);
            }
        } else if (!OchTrailHelper.isLineCard(n2)) {
            INodeModel iNodeModel;
            IEntityModel iEntityModel2 = iEntityModel;
            if (OchTrailHelper.isClientPort(iEntityModel)) {
                iNodeModel = iEntityModel2.getNodeModel();
                iEntityModel2 = OchTrailHelper.getTrunkPorts(iNodeModel, iEntityModel.getEntityIndex())[0];
            }
            iNodeModel = (IDwdmPortModel)iEntityModel2;
            IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iNodeModel.getInterfaceModel();
            if (db.on()) {
                db.println("Found trunk port: " + iEntityModel2);
            }
            short s = iDwdmTrkLineModel.getOTNSdBerLevel();
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            if (iNodeModel.getModuleModel().getEqType() == 293 && Feature.provides((INodeModel)iNodeModel.getNodeModel(), (Feature)Feature.CRS_PROACTIVE_PROTECTION)) {
                n7 = iDwdmTrkLineModel.getProactiveProtection();
                n3 = iDwdmTrkLineModel.getTriggerThreshold();
                n4 = iDwdmTrkLineModel.getRevertThreshold();
                n5 = iDwdmTrkLineModel.getTriggerWindow();
                n6 = iDwdmTrkLineModel.getRevertWindow();
            }
            trunkInfo = new TrunkInfo(iDwdmTrkLineModel.getOTNStatus(), iDwdmTrkLineModel.getFECModeValue(), s, iDwdmTrkLineModel.getMappingTypeValue(), n7, n3, n5, n4, n6);
            if (db.on()) {
                db.println("Found trunk attrs: " + trunkInfo);
            }
        } else if (db.on()) {
            db.println("Line cards have no trunk attrs");
        }
        return trunkInfo;
    }

    public static void setTrunkFrrAttrs(TrunkInfo trunkInfo, IEntityModel iEntityModel) throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ProvisionError {
        IInterfaceModel iInterfaceModel;
        if (trunkInfo == null) {
            if (db.on()) {
                db.println("Null Trunk attrs for " + iEntityModel);
            }
            return;
        }
        if (db.on()) {
            db.println("Configuring Trunk Frr attrs for " + iEntityModel + " to " + trunkInfo);
        }
        if ((iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel()) instanceof IPlimTrkLineModel) {
            IPlimTrkLineModel iPlimTrkLineModel = (IPlimTrkLineModel)iInterfaceModel;
            if (trunkInfo.getTriggerThreshold() != -1 && Feature.provides((INodeModel)iPlimTrkLineModel.getNodeModel(), (Feature)Feature.CRS_PROACTIVE_PROTECTION)) {
                if (db.on()) {
                    db.println("Setting on CRS -" + iEntityModel.getNodeModel().getHostName());
                    db.println("Proactive Prot = " + (trunkInfo.getProactiveProtection() == 0 ? "disable" : "enable"));
                }
                iPlimTrkLineModel.setFrrAttributes(trunkInfo.getProactiveProtection(), trunkInfo.getTriggerThresholdStr(), trunkInfo.getRevertThresholdStr(), trunkInfo.getTriggerWindow() + "", trunkInfo.getRevertWindow() + "");
            }
            return;
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (!(iModuleModel instanceof IDwdmModuleModel)) {
            return;
        }
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
        if (iModuleModel.getEqType() == 293 && Feature.provides((INodeModel)iDwdmPortModel.getNodeModel(), (Feature)Feature.CRS_PROACTIVE_PROTECTION) && iDwdmPortModel.getRegenPeerLineModel() != null && trunkInfo.getTriggerThreshold() != -1) {
            iDwdmTrkLineModel.setProactiveProtection(0);
            if (db.on()) {
                db.println("Disabled FRR initially..Going to configure new FRR params");
            }
            if (db.on()) {
                db.println("FRR Params to set Trigger Thr:" + trunkInfo.getTriggerThreshold() + "\n Revert thresh : " + trunkInfo.getRevertThreshold() + " \nTrigg window : " + trunkInfo.getTriggerWindow() + "\nrevert window : " + trunkInfo.getRevertWindow() + "\n\n\n");
            }
            iDwdmTrkLineModel.setFrrAttributes(trunkInfo.getTriggerThreshold(), trunkInfo.getRevertThreshold(), trunkInfo.getTriggerWindow(), trunkInfo.getRevertWindow());
            iDwdmTrkLineModel.setProactiveProtection(trunkInfo.proactiveProtection);
            if (db.on()) {
                db.println("Configured FRR");
            }
        }
    }

    public static void setTrunkAttrs(TrunkInfo trunkInfo, IEntityModel iEntityModel) throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ProvisionError {
        if (trunkInfo == null) {
            if (db.on()) {
                db.println("Null Trunk attrs for " + iEntityModel);
            }
            return;
        }
        if (db.on()) {
            db.println("Configuring Trunk attrs for " + iEntityModel + " to " + trunkInfo);
        }
        boolean bl = OchTrailAttrsHelper.isTrunkInIS(iEntityModel);
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            IPlimTrkLineModel iPlimTrkLineModel = (IPlimTrkLineModel)iInterfaceModel;
            boolean bl2 = trunkInfo.isG709();
            int n = trunkInfo.getFecMode();
            int n2 = trunkInfo.getSdBer();
            if (!bl) {
                iPlimTrkLineModel.setOTNData(bl2, n, n2, 0);
                if (db.on()) {
                    db.println("Configured G709 = " + bl2 + " FEC = " + n);
                }
            }
            if (trunkInfo.getTriggerThreshold() != -1 && Feature.provides((INodeModel)iPlimTrkLineModel.getNodeModel(), (Feature)Feature.CRS_PROACTIVE_PROTECTION)) {
                if (db.on()) {
                    db.println("Setting on CRS -" + iEntityModel.getNodeModel().getHostName());
                    db.println("Proactive Prot = " + (trunkInfo.getProactiveProtection() == 0 ? "disable" : "enable"));
                }
                iPlimTrkLineModel.setFrrAttributes(trunkInfo.getProactiveProtection(), trunkInfo.getTriggerThresholdStr(), trunkInfo.getRevertThresholdStr(), trunkInfo.getTriggerWindow() + "", trunkInfo.getRevertWindow() + "");
            }
            return;
        }
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (!(iModuleModel instanceof IDwdmModuleModel)) {
            return;
        }
        int n = iModuleModel.getEqType();
        if (((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            int n3;
            boolean bl3 = trunkInfo.isG709();
            int n4 = trunkInfo.getFecMode();
            if (Feature.provides((INodeModel)iDwdmPortModel.getNodeModel(), (Feature)Feature.CRS_PROACTIVE_PROTECTION) && iDwdmPortModel.getRegenPeerLineModel() != null) {
                iDwdmTrkLineModel.setProactiveProtection(0);
            }
            if (n == 182 || n == 243 || n == 282 || n == 181 || n == 273 || n == 293) {
                n3 = trunkInfo.getMappingType();
                if (n == 182 && n3 == Mapping.MAPPING_SYNCH.getValue()) {
                    n3 = Mapping.MAPPING_ODU_MUX.getValue();
                } else if (!bl3) {
                    n3 = Mapping.MAPPING_SYNCH.getValue();
                }
            } else {
                n3 = Mapping.MAPPING_NOTUSED.getValue();
            }
            if (!bl) {
                if (n == 243 || n == 282 || n == 273) {
                    iDwdmTrkLineModel.setOTNData(bl3, n4, n3);
                } else if (!bl3) {
                    iDwdmTrkLineModel.setMappingType(n3);
                    iDwdmTrkLineModel.setFECModeValue(n4);
                    iDwdmTrkLineModel.setOTNStatus(bl3);
                } else {
                    iDwdmTrkLineModel.setOTNStatus(bl3);
                    iDwdmTrkLineModel.setFECModeValue(n4);
                    iDwdmTrkLineModel.setMappingType(n3);
                }
                if (db.on()) {
                    db.println("Configured G709 = " + bl3 + " FEC = " + n4 + " Mapping = " + n3);
                }
            }
        } else if (db.on()) {
            db.println("OTN Setup skipped (not supported by " + iModuleModel + ")");
        }
        if (!bl) {
            iDwdmTrkLineModel.setOTNSdBerLevel((short)trunkInfo.getSdBer());
            if (db.on()) {
                db.println("Configured SD BER = " + trunkInfo.getSdBer());
            }
        }
        if (iModuleModel.getEqType() == 293 && Feature.provides((INodeModel)iDwdmPortModel.getNodeModel(), (Feature)Feature.CRS_PROACTIVE_PROTECTION) && iDwdmPortModel.getRegenPeerLineModel() != null && trunkInfo.getTriggerThreshold() != -1) {
            if (db.on()) {
                db.println("FRR Params to set Trigger Thr:" + trunkInfo.getTriggerThreshold() + "\n Revert thresh : " + trunkInfo.getRevertThreshold() + " \nTrigg window : " + trunkInfo.getTriggerWindow() + "\nrevert window : " + trunkInfo.getRevertWindow() + "\n\n\n");
            }
            iDwdmTrkLineModel.setFrrAttributes(trunkInfo.getTriggerThreshold(), trunkInfo.getRevertThreshold(), trunkInfo.getTriggerWindow(), trunkInfo.getRevertWindow());
            iDwdmTrkLineModel.setProactiveProtection(trunkInfo.proactiveProtection);
            if (db.on()) {
                db.println("Configured FRR");
            }
        }
    }

    public static IYCableModel getYCableModel(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IElementModel iElementModel = iDwdmPortModel.getElementModel();
        if (iElementModel != null && iElementModel instanceof IYCableModel) {
            IYCableModel iYCableModel = (IYCableModel)iElementModel;
            return iYCableModel;
        }
        if (db.on()) {
            db.println("Cannot find Element Model or is not a IYCableModel: " + iElementModel);
        }
        return null;
    }

    public static boolean isTrunkInUse(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            return false;
        }
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
        int n = iDwdmTrkLineModel.getAdminState();
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (db.on()) {
            db.println("Trunk port " + iEntityModel + " is in state " + iNodeModel.getTDMTerminology().getTermForAdminState(n));
        }
        if (n == 0) {
            if (db.on()) {
                db.println("Trunk port is already in service");
            }
            return true;
        }
        int n2 = iEntityModel.getEntityIndex();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        IOchccConnectionModel[] iOchccConnectionModelArray = iConnectionModels.getOchccConnectionModels();
        if (db.on()) {
            db.println("Found " + iOchccConnectionModelArray.length + " OCHCCs connections on this node");
        }
        List list = iEntityModel.getConnectionsList();
        for (IConnectionModel iConnectionModel : list) {
            if (!(iConnectionModel instanceof IOchccConnectionModel)) continue;
            if (db.on()) {
                db.println("This OCHCC:  " + iConnectionModel.getConnectionName() + " involves the selected trunk [" + n2 + "]");
            }
            return true;
        }
        return false;
    }

    public static boolean isTrunkInIS(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            return false;
        }
        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
        IDwdmTrkLineModel iDwdmTrkLineModel = (IDwdmTrkLineModel)iDwdmPortModel.getInterfaceModel();
        int n = iDwdmTrkLineModel.getAdminState();
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (db.on()) {
            db.println("Trunk port " + iEntityModel + " is in state " + iNodeModel.getTDMTerminology().getTermForAdminState(n));
        }
        if (n == 0) {
            if (db.on()) {
                db.println("Trunk port is already in service");
            }
            return true;
        }
        return false;
    }

    public static boolean filterProtection(boolean bl, IModuleModel iModuleModel) {
        boolean bl2 = false;
        if (db.on()) {
            db.println("Filtering protection info: " + bl);
        }
        if (bl) {
            if (OchTrailHelper.isProtected(iModuleModel)) {
                bl2 = true;
            }
        } else if (!OchTrailHelper.isProtected(iModuleModel)) {
            bl2 = true;
        }
        if (db.on()) {
            db.println("Filter result: " + bl2);
        }
        return bl2;
    }

    private static boolean areG709Equivalent(IModuleModel iModuleModel, boolean bl, IModuleModel iModuleModel2, boolean bl2) {
        if (iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            return true;
        }
        if (iModuleModel2 instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel2).supportsOTN()) {
            return true;
        }
        return bl == bl2;
    }

    private static boolean areFECEquivalent(IModuleModel iModuleModel, int n, IModuleModel iModuleModel2, int n2) {
        if (iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            return true;
        }
        if (iModuleModel2 instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel2).supportsOTN()) {
            return true;
        }
        return n == n2;
    }

    private static boolean areMappingEquivalent(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (n == Mapping.MAPPING_ASYNCH.getValue() && n2 == Mapping.MAPPING_ODU_MUX.getValue()) {
            return true;
        }
        if (n2 == Mapping.MAPPING_ASYNCH.getValue() && n == Mapping.MAPPING_ODU_MUX.getValue()) {
            return true;
        }
        return n == Mapping.MAPPING_NOTUSED.getValue() || n2 == Mapping.MAPPING_NOTUSED.getValue();
    }

    public static FecValues[] getCommonFecValues(int[] nArray) {
        block3: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 181: 
                case 182: 
                case 243: 
                case 271: 
                case 272: 
                case 273: 
                case 276: 
                case 282: {
                    continue block3;
                }
                default: {
                    return new FecValues[]{FecValues.FEC_DISABLE, FecValues.FEC_ENABLE};
                }
            }
        }
        return FecValues.values();
    }

    public static IDwdmTrkLineModel getIDwdmTrkLineModel(IPortModel iPortModel) {
        IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
        if (iInterfaceModel instanceof IDwdmTrkLineModel) {
            return (IDwdmTrkLineModel)iInterfaceModel;
        }
        return null;
    }

    public static IPlimTrkLineModel getIPlimTrkLineModel(IPortModel iPortModel) {
        IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            return (IPlimTrkLineModel)iInterfaceModel;
        }
        return null;
    }

    public static Mapping[] getAvailableMapping(ArrayList<Mapping> arrayList, ArrayList<Mapping> arrayList2) {
        if (arrayList.size() == 1 && arrayList.contains((Object)Mapping.MAPPING_NOTUSED)) {
            return arrayList2.toArray(new Mapping[0]);
        }
        if (arrayList2.size() == 1 && arrayList2.contains((Object)Mapping.MAPPING_NOTUSED)) {
            return arrayList.toArray(new Mapping[0]);
        }
        ArrayList<Mapping> arrayList3 = new ArrayList<Mapping>();
        for (Mapping mapping : arrayList) {
            if (!arrayList2.contains((Object)mapping)) continue;
            arrayList3.add(mapping);
        }
        return arrayList3.toArray(new Mapping[0]);
    }

    public static enum FecValues {
        FEC_DISABLE(0, "Disable"),
        FEC_ENABLE(1, "Standard"),
        FEC_ENHANCED(2, "Enhanced");

        int value;
        String string;

        private FecValues(int n2, String string2) {
            this.value = n2;
            this.string = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.string;
        }

        public static FecValues getFecValueFromString(String string) {
            if (string.equals("Standard")) {
                return FEC_ENABLE;
            }
            if (string.equals("Disable")) {
                return FEC_DISABLE;
            }
            if (string.equals("Enhanced")) {
                return FEC_ENHANCED;
            }
            return null;
        }

        public static FecValues getFecValue(int n) {
            return FecValues.values()[n];
        }

        public static String getFecValueAsString(int n) {
            return FecValues.getFecValue(n).toString();
        }
    }

    public static enum Mapping {
        MAPPING_NOTUSED(0, "Not Used"),
        MAPPING_ASYNCH(1, "Asynch"),
        MAPPING_SYNCH(2, "Synch"),
        MAPPING_ODU_MUX(3, "ODU Multiplex");

        int value;
        String string;

        private Mapping(int n2, String string2) {
            this.value = n2;
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }

        public int getValue() {
            return this.value;
        }

        public static Mapping getMapping(int n) {
            switch (n) {
                case 0: {
                    return MAPPING_NOTUSED;
                }
                case 1: {
                    return MAPPING_ASYNCH;
                }
                case 2: {
                    return MAPPING_SYNCH;
                }
                case 3: {
                    return MAPPING_ODU_MUX;
                }
            }
            return null;
        }

        public static Mapping getMappingFromString(String string) {
            if (string.equals(MAPPING_NOTUSED.toString())) {
                return MAPPING_NOTUSED;
            }
            if (string.equals(MAPPING_ASYNCH.toString())) {
                return MAPPING_ASYNCH;
            }
            if (string.equals(MAPPING_SYNCH.toString())) {
                return MAPPING_SYNCH;
            }
            if (string.equals(MAPPING_ODU_MUX.toString())) {
                return MAPPING_ODU_MUX;
            }
            return null;
        }

        public static String getMappingAsString(int n) {
            return Mapping.getMapping(n).toString();
        }
    }

    public static enum OTNStatus {
        OTN_ENABLE(true, "Enable"),
        OTN_DISABLE(false, "Disable");

        boolean status;
        String string;

        private OTNStatus(boolean bl, String string2) {
            this.status = bl;
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }

        public boolean getStatusAsBoolean() {
            return this.status;
        }
    }

    public static class ProtectionInfo {
        private boolean isProtected;
        private IRevertiveBehavior revertiveBehavior;

        public ProtectionInfo(boolean bl, IRevertiveBehavior iRevertiveBehavior) {
            this.isProtected = bl;
            this.revertiveBehavior = iRevertiveBehavior;
        }

        public ProtectionInfo(boolean bl) {
            this.isProtected = bl;
        }

        public boolean isProtected() {
            return this.isProtected;
        }

        public IRevertiveBehavior getRevertiveBehavior() {
            return this.revertiveBehavior;
        }

        public boolean isRevertive() {
            return this.revertiveBehavior.getReversionMode() == 2;
        }

        public String toString() {
            if (this.revertiveBehavior == null) {
                return "Protected: " + this.isProtected;
            }
            return "Protected: " + this.isProtected + (this.isProtected ? ", Revertive = " + this.isRevertive() + (this.isRevertive() ? ", Revertive time = " + this.revertiveBehavior.getReversionTime() : "") : "");
        }
    }

    public static enum SdBerValues {
        ONE_E_5(5, "1E-5"),
        ONE_E_6(6, "1E-6"),
        ONE_E_7(7, "1E-7"),
        ONE_E_8(8, "1E-8"),
        ONE_E_9(9, "1E-9");

        int value;
        String string;

        private SdBerValues(int n2, String string2) {
            this.value = n2;
            this.string = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.string;
        }

        public static SdBerValues getSdBerValue(int n) {
            switch (n) {
                case 5: {
                    return ONE_E_5;
                }
                case 6: {
                    return ONE_E_6;
                }
                case 7: {
                    return ONE_E_7;
                }
                case 8: {
                    return ONE_E_8;
                }
                case 9: {
                    return ONE_E_9;
                }
            }
            return null;
        }

        public static SdBerValues getSdBerValueFromString(String string) {
            if (string.equals(ONE_E_5.toString())) {
                return ONE_E_5;
            }
            if (string.equals(ONE_E_6.toString())) {
                return ONE_E_6;
            }
            if (string.equals(ONE_E_7.toString())) {
                return ONE_E_7;
            }
            if (string.equals(ONE_E_8.toString())) {
                return ONE_E_8;
            }
            if (string.equals(ONE_E_9.toString())) {
                return ONE_E_9;
            }
            return null;
        }

        public static String getSdBerValueAsString(int n) {
            return SdBerValues.getSdBerValue(n).toString();
        }
    }

    public static enum SfBerValues {
        ONE_E_3(3, "1E-3"),
        ONE_E_4(4, "1E-4"),
        ONE_E_5(5, "1E-5");

        int value;
        String string;

        private SfBerValues(int n2, String string2) {
            this.value = n2;
            this.string = string2;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.string;
        }

        public static SfBerValues getSfBerValue(int n) {
            switch (n) {
                case 3: {
                    return ONE_E_3;
                }
                case 4: {
                    return ONE_E_4;
                }
                case 5: {
                    return ONE_E_5;
                }
            }
            return null;
        }

        public static SfBerValues getSfBerValueFromString(String string) {
            if (string.equals(ONE_E_3.toString())) {
                return ONE_E_3;
            }
            if (string.equals(ONE_E_4.toString())) {
                return ONE_E_4;
            }
            if (string.equals(ONE_E_5.toString())) {
                return ONE_E_5;
            }
            return null;
        }

        public static String getSfBerValueAsString(int n) {
            return SfBerValues.getSfBerValue(n).toString();
        }
    }

    public static class TrunkInfo {
        private boolean isG709;
        private int fecMode;
        private int sdBer;
        private int mappingType;
        private int triggerThreshold = -1;
        private int revertThreshold = -1;
        private int triggerWindow = -1;
        private int revertWindow = -1;
        private String triggerThresholdStr = "";
        private String revertThresholdStr = "";
        private int proactiveProtection = 0;

        public TrunkInfo(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.isG709 = bl;
            this.fecMode = n;
            this.sdBer = n2;
            this.mappingType = n3;
            this.proactiveProtection = n4;
            this.triggerThreshold = n5;
            this.triggerWindow = n6;
            this.revertThreshold = n7;
            this.revertWindow = n8;
        }

        public TrunkInfo() {
        }

        public boolean isG709() {
            return this.isG709;
        }

        public int getFecMode() {
            return this.fecMode;
        }

        public int getSdBer() {
            return this.sdBer;
        }

        public int getMappingType() {
            return this.mappingType;
        }

        public int getTriggerThreshold() {
            return this.triggerThreshold;
        }

        public void setTriggerThreshold(int n) {
            this.triggerThreshold = n;
        }

        public int getRevertThreshold() {
            return this.revertThreshold;
        }

        public int getRevertWindow() {
            return this.revertWindow;
        }

        public int getTriggerWindow() {
            return this.triggerWindow;
        }

        public void setRevertThreshold(int n) {
            this.revertThreshold = n;
        }

        public void setRevertWindow(int n) {
            this.revertWindow = n;
        }

        public void setTriggerWindow(int n) {
            this.triggerWindow = n;
        }

        public String getRevertThresholdStr() {
            return this.revertThresholdStr;
        }

        public String getTriggerThresholdStr() {
            return this.triggerThresholdStr;
        }

        public void setRevertThresholdStr(String string) {
            this.revertThresholdStr = string;
        }

        public void setTriggerThresholdStr(String string) {
            this.triggerThresholdStr = string;
        }

        public void setMappingType(int n) {
            this.mappingType = n;
        }

        public String toString() {
            return "G709: " + this.isG709 + ", FEC = " + this.fecMode + ", SD BER = " + this.sdBer + ", mapping = " + this.mappingType + ", Trigger Thresh = " + this.triggerThreshold;
        }

        public void setProactiveProtection(int n) {
            this.proactiveProtection = n;
        }

        public int getProactiveProtection() {
            return this.proactiveProtection;
        }
    }
}

