/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.ISVlanProfile;
import cerent.cms.model.ISVlanProfileImportExporter;
import cerent.cms.model.SVlanProfile;
import cerent.util.DetailedLog;
import cerent.util.SDebug;
import cerent.util.SortableProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SVlanProfileImportExporter
implements ISVlanProfileImportExporter {
    private static final String PREFIX = "svlan.profile.";
    private static final int PREFIX_LEN = "svlan.profile.".length();
    private static final String VERSION_PROP = "version";
    private static final String CIR_PROP = "committedinforate";
    private static final String CBS_PROP = "committedburstsize";
    private static final String PIR_PROP = "peakinforate";
    private static final String PBS_PROP = "peakBurstSize";
    private static final String CF_PROP = "couplingflag";
    private static final String CM_PROP = "colormode";
    private static final String LI_PROP = "linkintegrity";
    private static SVlanProfileImportExporter instance = new SVlanProfileImportExporter();
    private static final SDebug db = new SDebug("SVlanProfileImportExporter");

    public static SVlanProfileImportExporter instance() {
        return instance;
    }

    private SVlanProfileImportExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Collection<? extends ISVlanProfile> collection, String string, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream must be non-null");
        }
        SortableProperties sortableProperties = new SortableProperties(null);
        sortableProperties.setSortedKeys(true);
        sortableProperties.setProperty("svlan.profile.version", "1.0");
        for (ISVlanProfile iSVlanProfile : collection) {
            SVlanProfileImportExporter.toProps(iSVlanProfile, (Properties)sortableProperties);
        }
        try {
            sortableProperties.store(outputStream, string);
        }
        finally {
            outputStream.close();
        }
    }

    private static void toProps(ISVlanProfile iSVlanProfile, Properties properties) {
        String string = iSVlanProfile.getName();
        String string2 = PREFIX + string + ".";
        properties.setProperty(string2 + CIR_PROP, Short.toString(iSVlanProfile.getCommittedInfoRate()));
        properties.setProperty(string2 + CBS_PROP, Integer.toString(iSVlanProfile.getCommittedBurstSize()));
        properties.setProperty(string2 + PIR_PROP, Short.toString(iSVlanProfile.getPeakInfoRate()));
        properties.setProperty(string2 + PBS_PROP, Integer.toString(iSVlanProfile.getPeakBurstSize()));
        properties.setProperty(string2 + CF_PROP, Boolean.toString(iSVlanProfile.getCouplingFlag()));
        properties.setProperty(string2 + CM_PROP, Boolean.toString(iSVlanProfile.getColorMode()));
        properties.setProperty(string2 + LI_PROP, Boolean.toString(iSVlanProfile.getLinkIntegrity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Collection<? super ISVlanProfile> collection, InputStream inputStream, String string, DetailedLog detailedLog) throws IOException {
        boolean bl = true;
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream must be non-null");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        Map<String, String> map = SVlanProfileImportExporter.processNames(properties);
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2);
            SVlanProfile sVlanProfile = null;
            try {
                sVlanProfile = new SVlanProfile(string3);
                SVlanProfileImportExporter.fromProps(properties, sVlanProfile, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)illegalArgumentException);
                }
                if (detailedLog == null) continue;
                DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while loading SVLAN profile: '" + string3 + "' from file: " + string, (Exception)illegalArgumentException);
                detailedLog.addChild(detailedLog2);
                detailedLog.updateTime();
                continue;
            }
            collection.add(sVlanProfile);
        }
        return bl;
    }

    private static Map<String, String> processNames(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(PREFIX) || (n = string.lastIndexOf(".")) <= PREFIX_LEN) continue;
            String string2 = string.substring(PREFIX_LEN, n);
            String string3 = PREFIX + string2;
            if (hashMap.get(string3) != null || string2.equals("Defaults")) continue;
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    private static void fromProps(Properties properties, ISVlanProfile iSVlanProfile, String string) {
        String string2 = iSVlanProfile.getName();
        if (db.on()) {
            db.println("decoding profile '" + string2 + "' from: " + string);
        }
        String string3 = PREFIX + string2 + ".";
        String string4 = properties.getProperty(string3 + CIR_PROP);
        iSVlanProfile.setCommittedInfoRate(Short.decode(string4).shortValue());
        string4 = properties.getProperty(string3 + CBS_PROP);
        iSVlanProfile.setCommittedBurstSize(Integer.decode(string4).intValue());
        string4 = properties.getProperty(string3 + PIR_PROP);
        iSVlanProfile.setPeakInfoRate(Short.decode(string4).shortValue());
        string4 = properties.getProperty(string3 + PBS_PROP);
        iSVlanProfile.setPeakBurstSize(Integer.decode(string4).intValue());
        string4 = properties.getProperty(string3 + CF_PROP);
        iSVlanProfile.setCouplingFlag(Boolean.parseBoolean(string4));
        string4 = properties.getProperty(string3 + CM_PROP);
        iSVlanProfile.setColorMode(Boolean.parseBoolean(string4));
        string4 = properties.getProperty(string3 + LI_PROP);
        iSVlanProfile.setLinkIntegrity(Boolean.parseBoolean(string4));
    }

    public static void main(String[] stringArray) throws IOException {
        SVlanProfileImportExporter sVlanProfileImportExporter = SVlanProfileImportExporter.instance();
        SVlanProfile sVlanProfile = new SVlanProfile(0, "some profile", 1, 2, 3, 4, true, false, true);
        String string = "profiles.txt";
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ArrayList<SVlanProfile> arrayList = new ArrayList<SVlanProfile>();
        System.out.println("# stored profile: " + sVlanProfile);
        arrayList.add(sVlanProfile);
        sVlanProfileImportExporter.store(arrayList, "profile import/export unit test", fileOutputStream);
        System.out.println("# profiles stored: " + arrayList.size());
        arrayList.clear();
        FileInputStream fileInputStream = new FileInputStream(file);
        sVlanProfileImportExporter.load(arrayList, fileInputStream, string, null);
        System.out.println("# profiles loaded: " + arrayList.size());
        ISVlanProfile iSVlanProfile = (ISVlanProfile)arrayList.get(0);
        System.out.println("# loaded profile: " + iSVlanProfile);
        System.out.println("# loaded profile equals stored profile: " + iSVlanProfile.equals(sVlanProfile));
    }
}

