/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILocalCirData;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.PathInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongNumberOfPaths;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;

public class SvlanCircuitModels
extends Model
implements ISvlanCircuitModels {
    private ISvlanCircuitModels delegate;
    private NodeModel node;

    public SvlanCircuitModels(NodeModel nodeModel) {
        super(null);
        this.node = nodeModel;
        this.delegate = null;
        this.db = new SvlanCircuitModelsDebug(nodeModel.db, "SvlanCircuitModels");
    }

    public void init() {
        this.init0();
    }

    public ISvlanConnectionModel createSvlanConnection(ISvlanPathDefModel[] iSvlanPathDefModelArray, String string, boolean bl) throws PathInUse, InvalidPath, InvalidCircuitName, WrongNumberOfPaths, WrongInterfaceType, NoSuchInterface, CTCUserException {
        if (this.node.provides(Feature.SVLAN_CKT)) {
            return this.delegate.createSvlanConnection(iSvlanPathDefModelArray, string, bl);
        }
        return null;
    }

    public void deleteSvlanConnection(ISvlanConnectionModel iSvlanConnectionModel) throws WrongInterfaceType, InvalidPath, Busy {
        if (!this.node.provides(Feature.SVLAN_CKT)) {
            throw new FeatureNotSupported("deleteSvlanConnection");
        }
        this.delegate.deleteSvlanConnection(iSvlanConnectionModel);
    }

    public void addRemoveSvlanConnPath(ISvlanPathDefModel[] iSvlanPathDefModelArray, ISvlanPathDefModel iSvlanPathDefModel, boolean bl) throws CTCUserException {
        if (!this.node.provides(Feature.SVLAN_CKT)) {
            throw new FeatureNotSupported("addRemoneSvlanConnPath");
        }
        this.delegate.addRemoveSvlanConnPath(iSvlanPathDefModelArray, iSvlanPathDefModel, bl);
    }

    public List getSvlanConnectionModels(SvlanRange[] svlanRangeArray) {
        if (this.node.provides(Feature.SVLAN_CKT)) {
            return this.delegate.getSvlanConnectionModels(svlanRangeArray);
        }
        return new ArrayList();
    }

    public IEntityModel[] getAvailEntitiesForSvlanCkt(short s, boolean bl, boolean bl2) {
        return this.delegate == null ? new IEntityModel[]{} : this.delegate.getAvailEntitiesForSvlanCkt(s, bl, bl2);
    }

    public boolean isSvlanAvailable(int n, short s, boolean bl) throws WrongInterfaceType, NoSuchInterface {
        if (this.delegate != null) {
            if (this.node.provides(Feature.SVLAN_CKT)) {
                return this.delegate.isSvlanAvailable(n, s, bl);
            }
            throw new FeatureNotSupported("isSvlanAvailable");
        }
        if (this.db.on()) {
            this.db.println("ERROR! isSvlanAvailable: delegate == null");
        }
        return false;
    }

    public ILocalCirData[] getLocalCirs(int n) throws WrongInterfaceType, NoSuchInterface {
        if (this.node.provides(Feature.CHANNEL_GROUP)) {
            return this.delegate.getLocalCirs(n);
        }
        throw new FeatureNotSupported("deleteSvlanConnection");
    }

    public HashMap<Integer, short[]> getPassThroughSvlans(int n) throws WrongInterfaceType, NoSuchInterface {
        if (this.node.provides(Feature.CHANNEL_GROUP)) {
            return this.delegate.getPassThroughSvlans(n);
        }
        throw new FeatureNotSupported("deleteSvlanConnection");
    }

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose");
        }
        SvlanCircuitModels svlanCircuitModels = this;
        synchronized (svlanCircuitModels) {
            if (this.delegate != null) {
                this.destroyDelegate();
            }
        }
        this.db.dispose();
        super.dispose();
    }

    private void destroyDelegate() {
        if (this.db.on()) {
            this.db.println("destroyDelegate(): Entry");
        }
        this.delegate = null;
        if (this.db.on()) {
            this.db.println("destroyDelegate(): Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(ISvlanCircuitModels iSvlanCircuitModels) {
        if (this.db.on()) {
            this.db.println("setDelegate");
        }
        SvlanCircuitModels svlanCircuitModels = this;
        synchronized (svlanCircuitModels) {
            if (this.delegate != null) {
                this.destroyDelegate();
            }
            this.delegate = iSvlanCircuitModels;
        }
    }

    @Override
    public INodeModel getNodeModel() {
        return this.node;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update from delegate");
        }
    }

    public class SvlanCircuitModelsDebug
    extends SDebug {
        public SvlanCircuitModelsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }
    }
}

