/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvVirtualLink;
import cerent.cms.fv.net.IFvVirtualLinksDirector;
import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DuplicateLocalVlinkId;
import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.IVirtualLinksManager;
import cerent.cms.model.MissingLink;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchVirtualLink;
import cerent.cms.model.NodeModel;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.WarningMessageException;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.IPartitioner;
import cerent.cms.topo.Network;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.Wavelength;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class VirtualLinksDirector
extends Model
implements Observer,
IFvVirtualLinksDirector {
    public static final String ORIG = "Origination";
    public static final String TERM = "Termination";
    private static final Network network = Network.instance();
    private static final short NC_SHELF_ID = 1;
    private Set<INodeModel> nodes = new TreeSet<INodeModel>(new NodeComparator());
    private static final IVirtualLinkModel[] IVIRTUAL_LINK_MODEL_TEMPLATE = new IVirtualLinkModel[0];
    private static VirtualLinksDirector instance = null;
    private static final SDebug db = new VlinkDebug("VirtualLinksDirector");

    public static final synchronized VirtualLinksDirector instance() {
        if (instance == null) {
            instance = new VirtualLinksDirector();
        }
        return instance;
    }

    public synchronized INodeModel[] getKnownNodes() {
        return this.nodes.toArray(new INodeModel[this.nodes.size()]);
    }

    public synchronized Integer[] getKnownShelfIds(INodeModel iNodeModel) {
        IEntityModel[] iEntityModelArray = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (iVirtualLinksManager != null) {
            iEntityModelArray = iVirtualLinksManager.getVirtualLinkCandidates();
        }
        if (iEntityModelArray != null) {
            for (int i = 0; i < iEntityModelArray.length; ++i) {
                int n = iEntityModelArray[i].getShelfId();
                if (arrayList.contains(n)) continue;
                arrayList.add(n);
            }
        }
        Object[] objectArray = arrayList.toArray(new Integer[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<IVirtualLinkModel> getVirtualLinks() {
        TreeSet<IVirtualLinkModel> treeSet = new TreeSet<IVirtualLinkModel>();
        Set<INodeModel> set = this.nodes;
        synchronized (set) {
            for (INodeModel iNodeModel : this.nodes) {
                IVirtualLinkModel[] iVirtualLinkModelArray = this.getVirtualLinks(iNodeModel);
                if (iVirtualLinkModelArray == null) continue;
                db.fine(iNodeModel.getName() + " returned " + iVirtualLinkModelArray.length + " vlinks.");
                treeSet.addAll(Arrays.asList(iVirtualLinkModelArray));
            }
        }
        return this.combineVlinkFragments(treeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVirtualLinkModel[] getVirtualLinks(INodeModel iNodeModel) {
        int n = 0;
        try {
            IVirtualLinkModel[] iVirtualLinkModelArray = iNodeModel.getVirtualLinksManager().getVirtualLinks();
            ArrayList<IVirtualLinkModel> arrayList = null;
            if (iVirtualLinkModelArray != null) {
                n = iVirtualLinkModelArray.length;
                arrayList = new ArrayList<IVirtualLinkModel>(iVirtualLinkModelArray.length);
                for (IVirtualLinkModel iVirtualLinkModel : iVirtualLinkModelArray) {
                    if (!network.isMember(iVirtualLinkModel, iNodeModel)) {
                        if (!db.on()) continue;
                        db.println("Skipping virtual link: " + iVirtualLinkModel + " due to network.isMember() returning false");
                        continue;
                    }
                    arrayList.add(iVirtualLinkModel);
                }
            }
            IVirtualLinkModel[] iVirtualLinkModelArray2 = arrayList.toArray(IVIRTUAL_LINK_MODEL_TEMPLATE);
            return iVirtualLinkModelArray2;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            if (n > 0) {
                network.lastMember(iNodeModel, IPartitioner.AdjacencyType.VIRTUAL_LINK);
            }
        }
        return null;
    }

    public static final boolean isVLIDInUse(INodeModel iNodeModel, short s) {
        Set<IVirtualLinkModel> set = VirtualLinksDirector.instance().getVirtualLinks();
        boolean bl = false;
        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
        Iterator<IVirtualLinkModel> iterator = set.iterator();
        while (!bl && iterator.hasNext()) {
            IVirtualLinkModel iVirtualLinkModel = iterator.next();
            if ((iVirtualLinkModel.getOrigVLID() != s || iVirtualLinkModel.getOrigNode().compareTo((Object)iIpAddr) != 0) && (iVirtualLinkModel.getTermVLID() != s || iVirtualLinkModel.getTermNode().compareTo((Object)iIpAddr) != 0)) continue;
            bl = true;
        }
        return bl;
    }

    public synchronized void deleteVirtualLink(IIpAddr iIpAddr, short s) throws Exception {
        INetElement iNetElement = network.findNetElemByIp(VirtualLinksDirector.ipToString(iIpAddr));
        if (iNetElement == null) {
            throw new Exception("The NE corresponding to the IP address " + VirtualLinksDirector.ipToString(iIpAddr) + " cannot be located.");
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        this.deleteVirtualLink(iNodeModel, s);
    }

    public synchronized void deleteVirtualLink(INodeModel iNodeModel, short s) throws Exception {
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (iVirtualLinksManager == null) {
            throw new NoSuchVirtualLink("The VLM for the node " + iNodeModel.getName() + " cannot be located.");
        }
        iVirtualLinksManager.deleteVirtualLink(s);
    }

    private void rollback(IVirtualLinksManager iVirtualLinksManager, short s) {
        try {
            iVirtualLinksManager.deleteVirtualLink(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void createVirtualLink(short s, INodeModel iNodeModel, IEntityModel iEntityModel, short s2, INodeModel iNodeModel2) throws NoSuchInterface, WrongInterfaceType, ProvisionError, DuplicateLocalVlinkId, DuplicateRemoteVlinkId, EndPointInUse, FeatureUnsupported, UnknownHostException {
        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
        if (iNodeModel.isSecureMode()) {
            iIpAddr = iNodeModel.getSecureIpConfig().getIpAddress();
        }
        if (iNodeModel2.isSecureMode()) {
            iIpAddr2 = iNodeModel2.getSecureIpConfig().getIpAddress();
        }
        if (iIpAddr == null) {
            throw new UnknownHostException("The IP address for the node " + iNodeModel.getName() + " cannot be located.");
        }
        if (iIpAddr2 == null) {
            throw new UnknownHostException("The IP address for the node " + iNodeModel2.getName() + " cannot be located.");
        }
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        try {
            iVirtualLinksManager.createVirtualLink(iEntityModel, s, iIpAddr, s2, iIpAddr2);
        }
        catch (FeatureUnsupported featureUnsupported) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
            }
            this.rollback(iVirtualLinksManager, s);
            throw featureUnsupported;
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            this.rollback(iVirtualLinksManager, s);
            throw noSuchInterface;
        }
        catch (EndPointInUse endPointInUse) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)endPointInUse);
            }
            this.rollback(iVirtualLinksManager, s);
            throw endPointInUse;
        }
        catch (DuplicateLocalVlinkId duplicateLocalVlinkId) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)duplicateLocalVlinkId);
            }
            this.rollback(iVirtualLinksManager, s);
            throw duplicateLocalVlinkId;
        }
        catch (DuplicateRemoteVlinkId duplicateRemoteVlinkId) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)duplicateRemoteVlinkId);
            }
            this.rollback(iVirtualLinksManager, s);
            throw duplicateRemoteVlinkId;
        }
        catch (ProvisionError provisionError) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)provisionError);
            }
            this.rollback(iVirtualLinksManager, s);
            throw provisionError;
        }
    }

    public synchronized IEntityModel[] getVirtualLinkCandidates(INodeModel iNodeModel) {
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (iVirtualLinksManager != null) {
            return iVirtualLinksManager.getVirtualLinkCandidates();
        }
        return new IEntityModel[0];
    }

    public synchronized IEntityModel[] getVirtualLinkCandidatesForL2(INodeModel iNodeModel) {
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SVLAN_CKT) && iVirtualLinksManager != null) {
            return iVirtualLinksManager.getVirtualLinkCandidatesForL2();
        }
        return new IEntityModel[0];
    }

    public synchronized IEntityModel[] getVirtualLinkCandidatesForOTS(INodeModel iNodeModel, boolean bl) {
        IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
        if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.COLOR_DIR_LESS) && iVirtualLinksManager != null) {
            return iVirtualLinksManager.getVirtualLinkCandidatesForOTS(bl);
        }
        return new IEntityModel[0];
    }

    public IVirtualLinkModel getVirtualLinkModel(short s, IIpAddr iIpAddr, IEntityModel iEntityModel, short s2, IIpAddr iIpAddr2, IEntityModel iEntityModel2) {
        return new VlinkHolder(s, iIpAddr, iEntityModel, s2, iIpAddr2, iEntityModel2);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.isFinestEnabled()) {
            db.finest("update from " + observable + " regarding " + object);
        }
        if (observable instanceof Network.NetElementCreationNotifier) {
            INetElement iNetElement;
            INodeModel iNodeModel;
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier;
            if (object instanceof INetElement && (abstractConnectionNotifier = (iNodeModel = (iNetElement = (INetElement)object).getNodeModel()).getConnectionNotifier()) != null) {
                abstractConnectionNotifier.addObserver(this);
            }
        } else if (observable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)((Object)observable);
            NodeModel nodeModel = connectionNotifier.getNodeModel();
            if (object == ModelUpdateType.DELETED) {
                this.deregisterNode(nodeModel, connectionNotifier);
            } else {
                this.registerNode(nodeModel);
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        } else if (observable instanceof IVirtualLinksManager) {
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    public void addNode(String string) throws UnknownHostException {
        String string2 = null;
        string2 = InetAddress.getByName(string).getHostAddress().trim();
        NetworkModel.instance().addNetElement(string2, null, null);
    }

    public synchronized void deleteNode(INodeModel iNodeModel) {
        Iterator<INodeModel> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel2 = iterator.next();
            if (iNodeModel2 != iNodeModel) continue;
            iterator.remove();
            break;
        }
    }

    public IEntityModel isProtected(IEntityModel iEntityModel) {
        IEntityModel iEntityModel2;
        block10: {
            iEntityModel2 = null;
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
                iEntityModel2 = iEntityModel.isProtected();
            } else {
                try {
                    IElementModels iElementModels = iNodeModel.getIElementModels();
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SELECTOR_ADDED_ATTRS)) {
                        IElementModel iElementModel = iElementModels.getIElementModel(iEntityModel);
                        switch (iElementModel.getType()) {
                            case 1: 
                            case 4: {
                                int n = iElementModel.getProtectEntityIndex();
                                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                                iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n);
                                break;
                            }
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.isFineEnabled()) {
                        db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in isProtected(" + iEntityModel + ")");
                    }
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.isFineEnabled()) break block10;
                    db.fine("Caught " + (Object)((Object)abstractCmsNoSuchElementException) + " in isProtected(" + iEntityModel + ")");
                }
            }
        }
        return iEntityModel2;
    }

    public IEntityModel isYCableProtected(IEntityModel iEntityModel) {
        IEntityModel iEntityModel2;
        block10: {
            iEntityModel2 = null;
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
                iEntityModel2 = iEntityModel.isYCableProtected();
            } else {
                try {
                    IElementModels iElementModels = iNodeModel.getIElementModels();
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SELECTOR_ADDED_ATTRS)) {
                        IElementModel iElementModel = iElementModels.getIElementModel(iEntityModel);
                        switch (iElementModel.getType()) {
                            case 4: {
                                int n = iElementModel.getProtectEntityIndex();
                                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                                iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n);
                                break;
                            }
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.isFineEnabled()) {
                        db.fine("Caught " + (Object)((Object)abstractCmsNoSuchEntityException) + " in isYCableProtected(" + iEntityModel + ")");
                    }
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.isFineEnabled()) break block10;
                    db.fine("Caught " + (Object)((Object)abstractCmsNoSuchElementException) + " in isYCableProtected(" + iEntityModel + ")");
                }
            }
        }
        return iEntityModel2;
    }

    public short obtainUnusedVLID(INodeModel iNodeModel, short s) {
        IVirtualLinkModel[] iVirtualLinkModelArray = this.getVirtualLinks(iNodeModel);
        int n = 0;
        for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
            short s2 = iVirtualLinkModelArray[i].getOrigVLID();
            n = (short)Math.max(n, s2);
        }
        return (short)(Math.max(n, s) + 1);
    }

    private VirtualLinksDirector() {
        super(db);
        this.updateNodeTable();
        Network.instance().getNetElementCreationNotifier().addObserver(this);
    }

    private void updateNodeTable() {
        for (INetElement iNetElement : Network.instance().getElements()) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = iNodeModel.getConnectionNotifier();
            if (abstractConnectionNotifier != null) {
                abstractConnectionNotifier.addObserver(this);
            }
            this.registerNode(iNodeModel);
        }
    }

    private Set<IVirtualLinkModel> combineVlinkFragments(TreeSet<IVirtualLinkModel> treeSet) {
        TreeSet<IVirtualLinkModel> treeSet2 = new TreeSet<IVirtualLinkModel>();
        if (db.isFinestEnabled()) {
            db.finest("combineVlinkFragements ---- BEFORE (" + treeSet.size() + ") ----");
            for (IVirtualLinkModel iVirtualLinkModel : treeSet) {
                db.finest("  " + iVirtualLinkModel);
            }
            db.finest("combineVlinkFragements ^^^^ BEFORE ^^^^");
        }
        while (treeSet.size() > 0) {
            IVirtualLinkModel iVirtualLinkModel;
            boolean bl = false;
            iVirtualLinkModel = treeSet.first();
            if (!treeSet.remove(iVirtualLinkModel)) {
                db.warning("***** ERROR removing " + iVirtualLinkModel + " from set! *****");
            }
            Iterator<IVirtualLinkModel> iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                IVirtualLinkModel iVirtualLinkModel2 = iterator.next();
                if (iVirtualLinkModel.getOrigVLID() != iVirtualLinkModel2.getTermVLID() || iVirtualLinkModel.getOrigNode().compareTo((Object)iVirtualLinkModel2.getTermNode()) != 0 || iVirtualLinkModel.getTermVLID() != iVirtualLinkModel2.getOrigVLID() || iVirtualLinkModel.getTermNode().compareTo((Object)iVirtualLinkModel2.getOrigNode()) != 0) continue;
                try {
                    IEntityModel iEntityModel = iVirtualLinkModel.getOrigEntity();
                    IEntityModel iEntityModel2 = iVirtualLinkModel2.getOrigEntity();
                    VirtualLinksDirector.checkPortCompatibility(false, iEntityModel.getNodeModel(), iEntityModel, iEntityModel2.getNodeModel(), iEntityModel2);
                    iterator.remove();
                    treeSet2.add(this.combineVlinks(iVirtualLinkModel, iVirtualLinkModel2));
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    if (!db.on()) continue;
                    db.println("Incompatible endpoints discovered for PPC -> " + exception.getMessage() + " Reason could be wrong ppc created by user using TL1.");
                }
            }
            if (bl) continue;
            if (db.isFineEnabled()) {
                db.fine("Couldn't find partner for " + iVirtualLinkModel);
            }
            treeSet2.add(iVirtualLinkModel);
        }
        if (db.isFinestEnabled()) {
            db.finest("combineVlinkFragements ---- AFTER (" + treeSet2.size() + ") ----");
            for (IVirtualLinkModel iVirtualLinkModel : treeSet2) {
                db.finest("  " + iVirtualLinkModel);
            }
            db.finest("combineVlinkFragements ^^^^ AFTER ^^^^");
        }
        return treeSet2;
    }

    private IVirtualLinkModel combineVlinks(IVirtualLinkModel iVirtualLinkModel, IVirtualLinkModel iVirtualLinkModel2) {
        if (db.isFinestEnabled()) {
            db.finest(" combining " + iVirtualLinkModel + "       and " + iVirtualLinkModel2);
        }
        return new VlinkHolder(iVirtualLinkModel.getOrigVLID(), iVirtualLinkModel.getOrigNode(), iVirtualLinkModel.getOrigEntity(), iVirtualLinkModel2.getOrigVLID(), iVirtualLinkModel2.getOrigNode(), iVirtualLinkModel2.getOrigEntity());
    }

    private synchronized void registerNode(INodeModel iNodeModel) {
        block5: {
            db.fine("registerNode(" + iNodeModel + ")");
            if (iNodeModel.provides(Feature.VLINK_PROVISIONING) && iNodeModel.isInited() && !this.nodes.contains(iNodeModel)) {
                try {
                    this.nodes.add(iNodeModel);
                    iNodeModel.getVirtualLinksManager().addObserver((Observer)this);
                }
                catch (FeatureNotSupported featureNotSupported) {
                    db.fine(iNodeModel.getName() + " does not support virtual links.");
                    if (db.isFineEnabled()) {
                        SDebug.printStackTrace((Throwable)featureNotSupported);
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    db.fine(iNodeModel.getName() + " is not connected.");
                    if (!db.isFineEnabled()) break block5;
                    SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
                }
            }
        }
    }

    private synchronized void deregisterNode(INodeModel iNodeModel, INodeModel.AbstractConnectionNotifier abstractConnectionNotifier) {
        block2: {
            db.fine("deregisterNode(" + iNodeModel + ")");
            abstractConnectionNotifier.deleteObserver((Observer)this);
            try {
                iNodeModel.getVirtualLinksManager().deleteObserver((Observer)this);
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                if (!db.isFineEnabled()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        this.nodes.remove(iNodeModel);
    }

    public String getNodeNameByIp(IIpAddr iIpAddr) {
        INodeModel iNodeModel;
        String string = VirtualLinksDirector.ipToString(iIpAddr);
        INetElement iNetElement = network.findNetElemByIp(string);
        INodeModel iNodeModel2 = iNodeModel = iNetElement != null ? iNetElement.getNodeModel() : null;
        if (iNodeModel != null && iNodeModel.getConnectionState()) {
            try {
                string = iNodeModel.getName();
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                string = VirtualLinksDirector.ipToString(iIpAddr);
            }
        }
        return string;
    }

    public INodeModel getNodeModelFromString(String string) {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            if (db.on()) {
                db.println("Cannot find IP name " + string + ": " + unknownHostException.getMessage());
            }
            return null;
        }
        INetElement iNetElement = network.findNetElemByIp(string2);
        if (iNetElement == null) {
            Collection collection = network.getAllElements();
            for (INetElement iNetElement2 : collection) {
                if (iNetElement2.getNodeModel().getName().compareToIgnoreCase(string) != 0) continue;
                iNetElement = iNetElement2;
                break;
            }
        }
        if (iNetElement != null) {
            return iNetElement.getNodeModel();
        }
        return null;
    }

    public static boolean shouldSwap(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        boolean bl = false;
        if (iEntityModel != null && iEntityModel2 != null) {
            if (VirtualLinksDirector.isOch(iEntityModel)) {
                bl = OchPortsHelper.isAddPort(iEntityModel);
            } else if (VirtualLinksDirector.isOch(iEntityModel2)) {
                bl = !OchPortsHelper.isAddPort(iEntityModel2);
            } else if (VirtualLinksDirector.isOts(iEntityModel)) {
                bl = OchPortsHelper.isPortTypeRx(iEntityModel);
            }
        }
        return bl;
    }

    public static boolean isSwappable(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        boolean bl = false;
        if (iEntityModel != null && iEntityModel2 != null) {
            if (VirtualLinksDirector.isOch(iEntityModel)) {
                bl = true;
            } else if (VirtualLinksDirector.isOch(iEntityModel2)) {
                bl = true;
            } else if (VirtualLinksDirector.isOts(iEntityModel)) {
                bl = true;
            }
        }
        return bl;
    }

    public static final String ipToString(IIpAddr iIpAddr) {
        byte[] byArray = iIpAddr.getAddr();
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < byArray.length; ++i) {
            if (bl && byArray[i] == 0) continue;
            bl = false;
            stringBuilder.append(Integer.toString(byArray[i] & 0xFF));
            if (i + 1 >= byArray.length) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static boolean hasSeparateTxRx(VirtualNetLink virtualNetLink) throws AbstractCmsNoSuchEntityException {
        IEntityModel iEntityModel;
        Object object;
        boolean bl = false;
        ILinkModel iLinkModel = virtualNetLink.getLinkModel();
        ILinkModel iLinkModel2 = null;
        INetLink iNetLink = network.findNetLinkFromLinkModel(iLinkModel);
        if (iNetLink != null) {
            object = network.findReverseLink(iNetLink);
            iLinkModel2 = object != null ? object.getLinkModel() : null;
        }
        object = iLinkModel.src();
        int n = iLinkModel.srcEntityIndex();
        if (n == 0 && iLinkModel2 != null) {
            n = iLinkModel2.dstEntityIndex();
        }
        IEntityTableModel iEntityTableModel = object != null ? object.getEntityTable() : null;
        IEntityModel iEntityModel2 = iEntityModel = iEntityTableModel != null ? iEntityTableModel.getEntityModelByIndex(n) : null;
        if (iEntityModel != null && OchPortsHelper.isOchPort(iEntityModel)) {
            bl = true;
        } else {
            IEntityModel iEntityModel3;
            INodeModel iNodeModel = iLinkModel.dst();
            int n2 = iLinkModel.dstEntityIndex();
            if (n2 == 0 && iLinkModel2 != null) {
                n2 = iLinkModel2.srcEntityIndex();
            }
            IEntityTableModel iEntityTableModel2 = iNodeModel != null ? iNodeModel.getEntityTable() : null;
            IEntityModel iEntityModel4 = iEntityModel3 = iEntityTableModel2 != null ? iEntityTableModel2.getEntityModelByIndex(n2) : null;
            if (iEntityModel3 != null && OchPortsHelper.isOchPort(iEntityModel3)) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean arePeers(VirtualNetLink virtualNetLink, VirtualNetLink virtualNetLink2) throws AbstractCmsNoSuchEntityException {
        boolean bl = false;
        ILinkModel iLinkModel = virtualNetLink.getLinkModel();
        ILinkModel iLinkModel2 = virtualNetLink2.getLinkModel();
        INodeModel iNodeModel = iLinkModel.src();
        INodeModel iNodeModel2 = iLinkModel2.src();
        INodeModel iNodeModel3 = iLinkModel.dst();
        INodeModel iNodeModel4 = iLinkModel2.dst();
        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
        IIpAddr iIpAddr3 = iNodeModel3.getIpConfig().getIpAddress();
        IIpAddr iIpAddr4 = iNodeModel4.getIpConfig().getIpAddress();
        if (iIpAddr.compareTo((Object)iIpAddr2) == 0 && iIpAddr3.compareTo((Object)iIpAddr4) == 0 || iIpAddr.compareTo((Object)iIpAddr4) == 0 && iIpAddr3.compareTo((Object)iIpAddr2) == 0) {
            int n = virtualNetLink.getSrcEntityIndex();
            int n2 = virtualNetLink2.getSrcEntityIndex();
            int n3 = virtualNetLink.getDstEntityIndex();
            int n4 = virtualNetLink2.getDstEntityIndex();
            if (db.isFineEnabled()) {
                db.fine("arePeers([" + iNodeModel.getName() + "/" + iLinkModel.getSrcLinkId() + "/0x" + Integer.toHexString(n) + " - " + iNodeModel3.getName() + "/" + iLinkModel.getDstLinkId() + "/0x" + Integer.toHexString(n3) + "]\n\tagainst [" + iNodeModel2.getName() + "/" + iLinkModel2.getSrcLinkId() + "/0x" + Integer.toHexString(n2) + " - " + iNodeModel4.getName() + "/" + iLinkModel2.getDstLinkId() + "/0x" + Integer.toHexString(n4) + "])");
            }
            if (n == n2 || n3 == n4 || n == n4 || n3 == n2) {
                bl = true;
            }
        }
        return bl;
    }

    public static INetLink[] getLinkTerminations(VirtualNetLink virtualNetLink) throws MissingLink {
        Object object;
        db.fine("getLinkTerminations(" + virtualNetLink + ")");
        INetElement iNetElement = virtualNetLink.getSrc();
        INetElement iNetElement2 = virtualNetLink.getDst();
        if (!iNetElement.isInited() || !iNetElement2.isInited()) {
            throw new MissingLink("The source/destination node is not initialized!");
        }
        IEntityTableModel iEntityTableModel = iNetElement.getNodeModel().getEntityTable();
        IEntityTableModel iEntityTableModel2 = iNetElement2.getNodeModel().getEntityTable();
        IEntityModel iEntityModel = null;
        try {
            if (iEntityTableModel != null) {
                iEntityModel = iEntityTableModel.getEntityModelByIndex(virtualNetLink.getSrcEntityIndex());
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new MissingLink((Exception)((Object)abstractCmsNoSuchEntityException));
        }
        boolean bl = VirtualLinksDirector.isOch(iEntityModel);
        INetLink iNetLink = network.findReverseLink(virtualNetLink);
        if (iNetLink == null) {
            throw new MissingLink("Link terminations cannot be resolved because the link has no reverse counterpart!");
        }
        if (!bl) {
            object = null;
            try {
                if (iEntityTableModel2 != null) {
                    object = iEntityTableModel2.getEntityModelByIndex(iNetLink.getSrcEntityIndex());
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                throw new MissingLink((Exception)((Object)abstractCmsNoSuchEntityException));
            }
            bl = VirtualLinksDirector.isOch(object);
        }
        if (db.isFineEnabled()) {
            db.fine("Calling getLinkTerminations for: " + virtualNetLink.prettyString() + " (isBarolo: " + bl + ")");
        }
        object = null;
        INetLink iNetLink2 = null;
        if (bl) {
            Collection collection = network.findVirtualLinks(iNetElement, iNetElement2);
            for (VirtualNetLink virtualNetLink2 : collection) {
                if (virtualNetLink2 == virtualNetLink || virtualNetLink2 == iNetLink) continue;
                if (db.isFineEnabled()) {
                    db.fine("candidate: " + virtualNetLink2.prettyString());
                }
                try {
                    if (!VirtualLinksDirector.arePeers(virtualNetLink, virtualNetLink2)) continue;
                    object = virtualNetLink2;
                }
                catch (Exception exception) {
                    db.fine("Caught " + exception);
                }
            }
            if (object == null) {
                throw new MissingLink("Link terminations cannot be resolved because the link has no peer.");
            }
            iNetLink2 = network.findReverseLink((INetLink)object);
            if (iNetLink2 == null) {
                throw new MissingLink("Link terminations cannot be resolved because the reverse link has no peer.");
            }
        }
        if (db.isFinestEnabled()) {
            db.finest("Found all links: \nvl: " + virtualNetLink.prettyString() + (virtualNetLink.isDeleted() ? "[deleted]" : "") + "\n" + "reverse: " + iNetLink.prettyString() + (iNetLink.isDeleted() ? "[deleted]" : "") + (bl ? "\npeer: " + object.prettyString() + (object.isDeleted() ? "[deleted]" : "") + ": " + "\n" + "peer reverse: " + iNetLink2.prettyString() + (iNetLink2.isDeleted() ? "[deleted]" : "") : ""));
        }
        if (bl) {
            return new INetLink[]{virtualNetLink, iNetLink, object, iNetLink2};
        }
        return new INetLink[]{virtualNetLink, iNetLink};
    }

    public static INetLink[] getCoupledLinkTerminations(VirtualNetLink virtualNetLink) {
        db.fine("getCoupledLinkTerminations(" + virtualNetLink.prettyString() + ")");
        INetLink[] iNetLinkArray = VirtualLinksDirector.getAvailLinkTerminations(virtualNetLink);
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        block2: for (int i = 0; i < iNetLinkArray.length - 1; ++i) {
            INetLink iNetLink = iNetLinkArray[i];
            for (int j = i; j < iNetLinkArray.length; ++j) {
                INetLink iNetLink2 = iNetLinkArray[j];
                try {
                    if (!VirtualLinksDirector.arePeers((VirtualNetLink)iNetLink, (VirtualNetLink)iNetLink2)) continue;
                    linkedList.add(iNetLink);
                    continue block2;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.fine("Caugt " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        return linkedList.toArray(new INetLink[0]);
    }

    public static INetLink[] getAvailLinkTerminations(VirtualNetLink virtualNetLink) {
        db.fine("getAvailLinkTerminations(" + virtualNetLink.prettyString() + ")");
        HashSet<INetLink> hashSet = new HashSet<INetLink>();
        if (!virtualNetLink.isDeleted()) {
            hashSet.add(virtualNetLink);
        } else if (db.isFineEnabled()) {
            db.fine(virtualNetLink.prettyString() + " is deleted.");
        }
        INetElement iNetElement = virtualNetLink.getSrc();
        INetElement iNetElement2 = virtualNetLink.getDst();
        INetLink iNetLink = network.findReverseLink(virtualNetLink);
        if (iNetLink != null) {
            if (!iNetLink.isDeleted()) {
                hashSet.add(iNetLink);
            } else if (db.isFineEnabled()) {
                db.fine("reverse is deleted.");
            }
        } else if (db.isFineEnabled()) {
            db.fine("reverse is null.");
        }
        INetLink iNetLink2 = null;
        INetLink iNetLink3 = null;
        Collection collection = network.findVirtualLinks(iNetElement, iNetElement2);
        for (VirtualNetLink virtualNetLink2 : collection) {
            if (virtualNetLink2 == virtualNetLink || virtualNetLink2 == iNetLink) continue;
            if (db.isFinestEnabled()) {
                db.finest("candidate: " + virtualNetLink2.prettyString());
            }
            try {
                if (!VirtualLinksDirector.arePeers(virtualNetLink, virtualNetLink2)) continue;
                iNetLink2 = virtualNetLink2;
            }
            catch (Exception exception) {
                db.fine("Caugt " + exception);
            }
        }
        if (iNetLink2 != null) {
            if (!iNetLink2.isDeleted()) {
                hashSet.add(iNetLink2);
            } else if (db.isFineEnabled()) {
                db.fine("peer is deleted.");
            }
        } else if (db.isFineEnabled()) {
            db.fine("peer is null.");
        }
        iNetLink3 = network.findReverseLink(iNetLink2);
        if (iNetLink3 != null) {
            if (!iNetLink3.isDeleted()) {
                hashSet.add(iNetLink3);
            } else if (db.isFineEnabled()) {
                db.fine("reversePeer is deleted.");
            }
        } else if (db.isFineEnabled()) {
            db.fine("reversePeer is null.");
        }
        if (db.isFineEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found " + hashSet.size() + " available links:");
            if (virtualNetLink != null && !virtualNetLink.isDeleted()) {
                stringBuilder.append("\nvnl: " + virtualNetLink.prettyString());
            }
            if (iNetLink != null && !iNetLink.isDeleted()) {
                stringBuilder.append("\nreverse: " + iNetLink.prettyString());
            }
            if (iNetLink2 != null && !iNetLink2.isDeleted()) {
                stringBuilder.append("\npeer: " + iNetLink2.prettyString());
            }
            if (iNetLink3 != null && !iNetLink3.isDeleted()) {
                stringBuilder.append("\nreversePeer: " + iNetLink3.prettyString());
            }
            db.fine(stringBuilder.toString());
        }
        return hashSet.toArray(new INetLink[0]);
    }

    public boolean isLinkUp(VirtualNetLink virtualNetLink) {
        int n;
        INetLink[] iNetLinkArray;
        try {
            iNetLinkArray = VirtualLinksDirector.getLinkTerminations(virtualNetLink);
        }
        catch (MissingLink missingLink) {
            db.warning("Cannot calculate VL state.\n" + missingLink.getMessage());
            return false;
        }
        boolean bl = true;
        for (int i = 0; bl && i < iNetLinkArray.length; ++i) {
            n = iNetLinkArray[i].getLinkModel().state();
            bl = !iNetLinkArray[i].isDeleted() && n == 1;
        }
        if (db.isFineEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("isLinkUp state summary: ");
            for (n = 0; n < iNetLinkArray.length; ++n) {
                int n2 = iNetLinkArray[n].getLinkModel().state();
                switch (n) {
                    case 0: {
                        stringBuilder.append("vl state=");
                        break;
                    }
                    case 1: {
                        stringBuilder.append("reverse state=");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("peer state=");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("peer reverse state=");
                    }
                }
                stringBuilder.append(n2);
            }
            stringBuilder.append("; Is link up: " + bl);
            db.fine(stringBuilder.toString());
        }
        return bl;
    }

    public static void deletionSanityCheck(IVirtualLinkModel iVirtualLinkModel) throws ResourceInUse, NoSuchVirtualLink {
        if (iVirtualLinkModel != null) {
            if (iVirtualLinkModel.getOrigEntity() != null && iVirtualLinkModel.getTermEntity() != null) {
                List list = iVirtualLinkModel.getOrigEntity().getConnectionsList();
                list.addAll(iVirtualLinkModel.getTermEntity().getConnectionsList());
                for (IConnectionModel iConnectionModel : list) {
                    if (iConnectionModel instanceof IOchncConnectionModel && OchPortsHelper.isOtsPort(iVirtualLinkModel.getOrigEntity()) && OchPortsHelper.isOtsPort(iVirtualLinkModel.getTermEntity())) {
                        throw new ResourceInUse("This PPC cannot be deleted as one or more circuits are provisioned over it.");
                    }
                    if (!(iConnectionModel instanceof IOchTrailAditModel) && !(iConnectionModel instanceof IOchccConnectionModel)) continue;
                    throw new ResourceInUse("This PPC cannot be deleted as one or more circuits are provisioned over it.");
                }
            }
        } else {
            throw new NoSuchVirtualLink("An attempt was made to delete an invalid PPC!");
        }
    }

    public static final void sanityCheck(INodeModel iNodeModel, short s, short s2, IEntityModel iEntityModel, IEntityModel iEntityModel2, INodeModel iNodeModel2, short s3, short s4, IEntityModel iEntityModel3, IEntityModel iEntityModel4) throws Exception {
        IIpAddr iIpAddr;
        IIpAddr iIpAddr2;
        boolean bl;
        boolean bl2 = s2 != -1 && iEntityModel2 != null & s4 != -1 && iEntityModel4 != null ? true : (bl = false);
        if (s < 1) {
            throw new Exception("The Origination patchcord identifier " + s + " is invalid.");
        }
        if (VirtualLinksDirector.isVLIDInUse(iNodeModel, s)) {
            throw new Exception("The Origination patchcord identifier " + s + " is in use.");
        }
        if (iEntityModel == null) {
            throw new Exception("The Origination port has not been selected.");
        }
        if (s3 < 1) {
            throw new Exception("The Termination patchcord identifier " + s3 + " is invalid.");
        }
        if (VirtualLinksDirector.isVLIDInUse(iNodeModel2, s3)) {
            throw new Exception("The Termination patchcord identifier " + s3 + " is in use.");
        }
        if (iEntityModel3 == null) {
            throw new Exception("The Termination port has not been selected.");
        }
        if (bl) {
            if (s2 < 1) {
                throw new Exception("The Origination RX patchcord identifier " + s2 + " is invalid.");
            }
            if (VirtualLinksDirector.isVLIDInUse(iNodeModel, s2)) {
                throw new Exception("The Origination RX patchcord identifier " + s2 + " is in use.");
            }
            if (s4 < 1) {
                throw new Exception("The Termination RX patchcord identifier " + s4 + " is invalid.");
            }
            if (VirtualLinksDirector.isVLIDInUse(iNodeModel2, s4)) {
                throw new Exception("The Termination RX patchcord identifier " + s4 + " is in use.");
            }
            if (iEntityModel2 == null) {
                throw new Exception("The Origination RX port has not been selected.");
            }
            if (iEntityModel4 == null) {
                throw new Exception("The Termination RX port has not been selected.");
            }
            if (s == s2) {
                throw new Exception("The Origination TX and RX patchcord identifiers cannot be the same.");
            }
            if (s3 == s4) {
                throw new Exception("The Termination TX and RX patchcord identifiers cannot be the same.");
            }
        }
        if ((iIpAddr2 = iNodeModel.getIpConfig().getIpAddress()).compareTo((Object)(iIpAddr = iNodeModel2.getIpConfig().getIpAddress())) == 0) {
            if (iEntityModel3 == iEntityModel) {
                throw new Exception("The Origination and Termination ports must be different.");
            }
            if (iEntityModel.getModuleModel() == iEntityModel3.getModuleModel()) {
                throw new Exception("The Origination and Termination ports must be on different cards.");
            }
        }
        if (bl) {
            VirtualLinksDirector.checkPortCompatibility(iNodeModel, iEntityModel, iEntityModel2, iNodeModel2, iEntityModel3, iEntityModel4);
        } else {
            VirtualLinksDirector.checkPortCompatibility(true, iNodeModel, iEntityModel, iNodeModel2, iEntityModel3);
        }
    }

    private static final boolean isTxp25G(int n) {
        return n == 120 || n == 121;
    }

    private static final boolean isMxp25G(int n) {
        return n == 183 || n == 184;
    }

    private static final boolean is25GTrunk(int n) {
        return VirtualLinksDirector.isTxp25G(n) || VirtualLinksDirector.isMxp25G(n);
    }

    private static final boolean is10GTrunk(int n) {
        return VirtualLinksDirector.is10GTransponder(n) || VirtualLinksDirector.is10GMuxponder(n) || n == 243 || n == 282 || n == 271 || n == 293;
    }

    private static final boolean isOC48Txp(int n) {
        return VirtualLinksDirector.isTxp25G(n) || n == 119 || n == 182;
    }

    private static final boolean is10GTransponder(int n) {
        return VirtualLinksDirector.isTxp10G(n) || VirtualLinksDirector.isTxp10E(n);
    }

    private static final boolean is10GMuxponder(int n) {
        return VirtualLinksDirector.isMxp10G(n) || VirtualLinksDirector.isMxp10E(n);
    }

    private static final boolean isTxp10G(int n) {
        return n == 118;
    }

    private static final boolean isMxp10G(int n) {
        return n == 119;
    }

    private static final boolean isTxp10E(int n) {
        return n == 181;
    }

    private static final boolean isMxp10E(int n) {
        return n == 182;
    }

    private static final boolean isOC192Txp(int n) {
        return VirtualLinksDirector.isTxp10G(n) || VirtualLinksDirector.isTxp10E(n) || n == 293 || n == 356 || n == 301;
    }

    private static boolean isOch(IEntityModel iEntityModel) {
        return OchPortsHelper.isOchPort(iEntityModel);
    }

    private static boolean isOts(IEntityModel iEntityModel) {
        return OchPortsHelper.isOtsPort(iEntityModel);
    }

    private static final boolean hasSeparateTxRxOnCard(IModuleModel iModuleModel) {
        int n = iModuleModel.getEqType();
        return n == 133 || n == 134 || n == 135 || n == 136 || n == 137 || n == 138;
    }

    private static final void checkPortCompatibility(INodeModel iNodeModel, IEntityModel iEntityModel, IEntityModel iEntityModel2, INodeModel iNodeModel2, IEntityModel iEntityModel3, IEntityModel iEntityModel4) throws Exception {
        boolean bl;
        VirtualLinksDirector.checkPortCompatibility(false, iNodeModel, iEntityModel, iNodeModel2, iEntityModel3);
        VirtualLinksDirector.checkPortCompatibility(true, iNodeModel, iEntityModel2, iNodeModel2, iEntityModel4);
        boolean bl2 = bl = VirtualLinksDirector.isOts(iEntityModel) && VirtualLinksDirector.isOts(iEntityModel2) && VirtualLinksDirector.isOts(iEntityModel3) && VirtualLinksDirector.isOts(iEntityModel4);
        if (bl) {
            return;
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
        IModuleModel iModuleModel3 = iEntityModel3.getModuleModel();
        IModuleModel iModuleModel4 = iEntityModel4.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        IEntityCellRenderer iEntityCellRenderer2 = ElementFactoryFinder.getElementFactory(iNodeModel2).createEntityCellRenderer(iModuleModel3);
        if (iModuleModel.getNodeModel().provides(Feature.PASSIVE_UNITS) && iModuleModel3.getNodeModel().provides(Feature.PASSIVE_UNITS)) {
            boolean bl3;
            IEntityModel[] iEntityModelArray;
            if (iEntityModel instanceof IOpticsPortModel && iEntityModel2 instanceof IOpticsPortModel) {
                iEntityModelArray = ((IOpticsPortModel)iEntityModel).getReversePortModels();
                bl3 = false;
                for (IEntityModel iEntityModel5 : iEntityModelArray) {
                    if (iEntityModel5 != iEntityModel2) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    throw new Exception("On the node " + iNodeModel.getName() + ", " + iEntityCellRenderer2.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel2, "slot ") + " cannot be part of the same\nPPC. Please select a different port.");
                }
            }
            if (iEntityModel3 instanceof IOpticsPortModel && iEntityModel4 instanceof IOpticsPortModel) {
                iEntityModelArray = ((IOpticsPortModel)iEntityModel3).getReversePortModels();
                bl3 = false;
                for (IEntityModel iEntityModel5 : iEntityModelArray) {
                    if (iEntityModel5 != iEntityModel4) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    throw new Exception("On the node " + iNodeModel2.getName() + ", " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " cannot be part of the same\nPPC. Please select a different port.");
                }
            }
        } else {
            int n;
            int n2;
            if ((VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel) || VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel2)) && iModuleModel != iModuleModel2) {
                throw new Exception("On the node " + iNodeModel.getName() + ", " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " are not on the same\ncard. Please select a different port.");
            }
            if ((VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel3) || VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel4)) && iModuleModel3 != iModuleModel4) {
                throw new Exception("On the node " + iNodeModel2.getName() + ", " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " are not on the same\ncard. Please select a different port.");
            }
            if (VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel) && VirtualLinksDirector.isOch(iEntityModel) || VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel3) && VirtualLinksDirector.isOch(iEntityModel3)) {
                n2 = -1;
                n = -1;
                if (VirtualLinksDirector.isOch(iEntityModel)) {
                    n2 = iEntityModel.getPort();
                    if (n2 != (n = iEntityModel2.getPort()) + 1) {
                        throw new Exception("On the node " + iNodeModel.getName() + ", " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " must be on the same\nchannel. Please select a different port.");
                    }
                } else if (VirtualLinksDirector.isOch(iEntityModel3) && (n2 = iEntityModel3.getPort()) != (n = iEntityModel4.getPort()) + 1) {
                    throw new Exception("On the node " + iNodeModel2.getName() + ", " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " must be on the same\nchannel. Please select a different port.");
                }
            }
            if (VirtualLinksDirector.isOch(iEntityModel) && !VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel) || VirtualLinksDirector.isOch(iEntityModel3) && !VirtualLinksDirector.hasSeparateTxRxOnCard(iModuleModel3)) {
                n2 = -1;
                n = -1;
                if (VirtualLinksDirector.isOch(iEntityModel)) {
                    n2 = iEntityModel.getPort();
                    if (n2 != (n = iEntityModel2.getPort())) {
                        throw new Exception("On the node " + iNodeModel.getName() + ", " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " must be on the same\nchannel. Please select a different port.");
                    }
                } else if (VirtualLinksDirector.isOch(iEntityModel3) && (n2 = iEntityModel3.getPort()) != (n = iEntityModel4.getPort())) {
                    throw new Exception("On the node " + iNodeModel2.getName() + ", " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " must be on the same\nchannel. Please select a different port.");
                }
            }
            if (VirtualLinksDirector.isOch(iEntityModel) && iModuleModel.getEqType() == 133 || VirtualLinksDirector.isOch(iEntityModel3) && iModuleModel3.getEqType() == 133) {
                n2 = -1;
                n = -1;
                if (iModuleModel.getEqType() == 133) {
                    n2 = iEntityModel.getPort();
                    if (n2 != (n = iEntityModel2.getPort()) + 1) {
                        throw new Exception("On the node " + iNodeModel.getName() + ", " + iEntityCellRenderer.getString((Object)iEntityModel, "slot ") + " and\n" + iEntityCellRenderer.getString((Object)iEntityModel2, "slot ") + " must be on the same\nchannel. Please select a different port.");
                    }
                } else if (iModuleModel3.getEqType() == 133 && (n2 = iEntityModel3.getPort()) != (n = iEntityModel4.getPort()) + 1) {
                    throw new Exception("On the node " + iNodeModel2.getName() + ", " + iEntityCellRenderer2.getString((Object)iEntityModel3, "slot ") + " and\n" + iEntityCellRenderer2.getString((Object)iEntityModel4, "slot ") + " must be on the same\nchannel. Please select a different port.");
                }
            }
        }
    }

    private static final void checkPortCompatibility(boolean bl, INodeModel iNodeModel, IEntityModel iEntityModel, INodeModel iNodeModel2, IEntityModel iEntityModel2) throws Exception {
        int n;
        String string;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3 = iEntityModel.getEqType();
        int n4 = iEntityModel2.getEqType();
        int n5 = iEntityModel.getModuleModel().getEqType();
        if (n5 == 293) {
            n3 = VirtualLinksDirector.getActualPortType(iEntityModel);
        }
        if ((n2 = iEntityModel2.getModuleModel().getEqType()) == 293) {
            n4 = VirtualLinksDirector.getActualPortType(iEntityModel2);
        }
        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IModuleModel iModuleModel2 = iEntityModel2.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        IEntityCellRenderer iEntityCellRenderer2 = ElementFactoryFinder.getElementFactory(iNodeModel2).createEntityCellRenderer(iModuleModel2);
        if ((n3 == 28 || n3 == 29) && n4 == 122 && !VirtualLinksDirector.isTxp25G(n2) || (n4 == 28 || n4 == 29) && n3 == 122 && !VirtualLinksDirector.isTxp25G(n5)) {
            throw new Exception("Provisionable patchcords between OC3/OC12 ports and non-multirate transponders are not supported.");
        }
        if (n3 == 30 && n4 == 122 && !VirtualLinksDirector.isOC48Txp(n2) || n4 == 30 && n3 == 122 && !VirtualLinksDirector.isOC48Txp(n5)) {
            throw new Exception("Provisionable patchcords between OC48 ports and non-2.5G transponders are not supported.");
        }
        if (n3 == 61 && n4 == 122 && !VirtualLinksDirector.isOC192Txp(n2) || n4 == 61 && n3 == 122 && !VirtualLinksDirector.isOC192Txp(n5)) {
            throw new Exception("Provisionable patchcords between OC192 ports and non-10G transponders are not supported.");
        }
        if (n3 == 122 && n4 == 122) {
            object3 = (IDwdmModuleModel)iModuleModel;
            object2 = (IDwdmModuleModel)iModuleModel2;
            if (VirtualLinksDirector.isTxp10G(n5) && !VirtualLinksDirector.isTxp10G(n2) || VirtualLinksDirector.isTxp10E(n5) && !VirtualLinksDirector.isTxp10E(n2) || VirtualLinksDirector.isTxp25G(n5) && !VirtualLinksDirector.isTxp25G(n2) || iIpAddr.compareTo((Object)iIpAddr2) != 0 || object3.getSlot() == object2.getSlot() || object3.getRegenPeer() != object2.getSlot() || object2.getRegenPeer() != object3.getSlot()) {
                throw new Exception("Provisionable patchcords between transponder client ports must be part of the same regeneration group.");
            }
        }
        if (n3 == 123 && n4 == 123 && (VirtualLinksDirector.is10GTrunk(n5) && !VirtualLinksDirector.is10GTrunk(n2) || VirtualLinksDirector.is10GTrunk(n2) && !VirtualLinksDirector.is10GTrunk(n5) || VirtualLinksDirector.is25GTrunk(n5) && !VirtualLinksDirector.is25GTrunk(n2) || VirtualLinksDirector.is25GTrunk(n2) && !VirtualLinksDirector.is25GTrunk(n5))) {
            throw new Exception("Provisionable patchcords between transponder trunk ports must be the same rate.");
        }
        if (n3 == 123 && n4 == 122 || n3 == 122 && n4 == 123) {
            throw new Exception("Provisionable patchcords may not be created between transponder client and trunk ports.");
        }
        if (n3 == 123 && (n4 == 28 || n4 == 29 || n4 == 30 || n4 == 61) || n4 == 123 && (n3 == 28 || n3 == 29 || n3 == 30 || n3 == 61)) {
            throw new Exception("Provisionable patchcords may not be created between transponder trunk ports and SONET/SDH ports.");
        }
        if (VirtualLinksDirector.isOch(iEntityModel) && n4 == 122 || VirtualLinksDirector.isOch(iEntityModel2) && n3 == 122) {
            throw new Exception("Provisionable patchcords may not be created between transponder client ports and OCH ports.");
        }
        if (VirtualLinksDirector.isOch(iEntityModel) && VirtualLinksDirector.isOch(iEntityModel2) && iIpAddr.compareTo((Object)iIpAddr2) == 0) {
            throw new Exception("Provisionable patchcords are not replacements for ANS;\nin this case, at least one endpoint must be a transponder trunk port.");
        }
        if (n3 == 123 && n4 == 123) {
            object3 = "";
            object2 = "";
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                object3 = Wavelength.getWavelengthStringFromWavelength(VirtualLinksDirector.getWlen(iEntityModel));
            } else {
                object = (IDwdmModuleModel)iEntityModel.getModuleModel();
                object3 = object.getWavelengthAsString();
            }
            if (Feature.provides((INodeModel)iNodeModel2, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                object2 = Wavelength.getWavelengthStringFromWavelength(VirtualLinksDirector.getWlen(iEntityModel2));
            } else {
                object = (IDwdmModuleModel)iEntityModel2.getModuleModel();
                object2 = object.getWavelengthAsString();
            }
            if (object3 != null && object2 != null && !((String)object3).equals(object2)) {
                throw new Exception("Provisionable patchcords between transponder/muxponder trunk ports must use the same wavelength:\n" + (String)object3 + " is not equal to " + (String)object2 + ".");
            }
        }
        if (VirtualLinksDirector.isOch(iEntityModel) && n4 == 123 || VirtualLinksDirector.isOch(iEntityModel2) && n3 == 123) {
            if (iIpAddr.compareTo((Object)iIpAddr2) == 0) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TRUNK_MUXDEMUX_SAMENODE));
            }
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCH_TRAIL_PROVISIONING) && Feature.provides((INodeModel)iNodeModel2, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                if (db.isFinestEnabled()) {
                    db.finest("DWDM trunk <-> Barolo client wlen check");
                }
                int n6 = VirtualLinksDirector.getWlen(iEntityModel);
                int n7 = VirtualLinksDirector.getWlen(iEntityModel2);
                if (db.isFinestEnabled()) {
                    db.finest("local wlen = " + Wavelength.getWavelengthStringFromWavelength(n6) + "remote wlen = " + Wavelength.getWavelengthStringFromWavelength(n7));
                }
                if (n6 != n7) {
                    object = Wavelength.getWavelengthStringFromWavelength(n6);
                    string = Wavelength.getWavelengthStringFromWavelength(n7);
                    String string2 = null;
                    String string3 = null;
                    n = 0;
                    if (n6 == 0) {
                        if (n3 == 123) {
                            object = (String)object + " /\"first tunable wavelength\"";
                            string2 = string;
                            string3 = iEntityCellRenderer.getString((Object)iEntityModel, "slot ");
                            n = VirtualLinksDirector.attemptProvisionWlen(iEntityModel, n7);
                        } else if (OchPortsHelper.isColorlessPort(iEntityModel)) {
                            n = 1;
                        }
                    }
                    if (n7 == 0) {
                        if (n4 == 123) {
                            string = string + " /\"first tunable wavelength\"";
                            string2 = object;
                            string3 = iEntityCellRenderer2.getString((Object)iEntityModel2, "slot ");
                            n = VirtualLinksDirector.attemptProvisionWlen(iEntityModel2, n6);
                        } else if (OchPortsHelper.isColorlessPort(iEntityModel2)) {
                            n = 1;
                        }
                    }
                    if (n == 0) {
                        if (string2 != null && string3 != null) {
                            throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TXPMXP_MUXDEMUX_WLEN_PARAM_4, (Object)object, (Object)string, (Object)string2, string3));
                        }
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TXPMXP_MUXDEMUX_WLEN_PARAM_2, (Object)object, (Object)string));
                    }
                } else if (n6 == 0) {
                    boolean bl2 = true;
                    if (n3 != 123) {
                        bl2 = OchPortsHelper.isColorlessPort(iEntityModel);
                    } else if (n4 != 123) {
                        bl2 = OchPortsHelper.isColorlessPort(iEntityModel2);
                    }
                    if (!bl2) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TXPMXP_MUXDEMUX_COLORLESS));
                    }
                }
            } else if (db.isFinestEnabled()) {
                db.finest("DWDM trunk <-> Barolo client wlen check skipped due to feature check");
            }
        }
        if (VirtualLinksDirector.isSdh(n3) && VirtualLinksDirector.isOch(iEntityModel2) || VirtualLinksDirector.isOch(iEntityModel) && VirtualLinksDirector.isSdh(n4)) {
            if (VirtualLinksDirector.isSdh(n3) && (n3 == 28 || n3 == 29)) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OC3OC12_MUXDEMUX));
            }
            if (VirtualLinksDirector.isSdh(n4) && (n4 == 28 || n4 == 29)) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OC3OC12_MUXDEMUX));
            }
            if (iIpAddr.compareTo((Object)iIpAddr2) == 0) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_TRUNK_MUXDEMUX_SAMENODE));
            }
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCH_TRAIL_PROVISIONING) && Feature.provides((INodeModel)iNodeModel2, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                boolean bl3;
                IModuleModel iModuleModel3;
                if (db.isFinestEnabled()) {
                    db.finest("SONET/SDH trunk <-> Barolo client check");
                }
                if (VirtualLinksDirector.isSdh(n3)) {
                    iModuleModel3 = iEntityModel.getModuleModel();
                    string = (IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel();
                    bl3 = string.isWavelengthSupported();
                } else {
                    iModuleModel3 = iEntityModel2.getModuleModel();
                    string = (IOpticsChannelModel)((IPortModel)iEntityModel2).getInterfaceModel();
                    bl3 = string.isWavelengthSupported();
                }
                boolean bl4 = iModuleModel3.isPreProvisioned();
                if (db.isFinestEnabled()) {
                    db.finest("isLcPreProvisioned = " + bl4);
                    db.finest("isWLenSupported = " + bl3);
                }
                if (!bl4) {
                    if (!bl3) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_NON_COLORED_OCN));
                    }
                    int n8 = VirtualLinksDirector.getWlen(iEntityModel);
                    int n9 = VirtualLinksDirector.getWlen(iEntityModel2);
                    if (db.isFinestEnabled()) {
                        db.finest("local wlen = " + Wavelength.getWavelengthStringFromWavelength(n8) + "remote wlen = " + Wavelength.getWavelengthStringFromWavelength(n9));
                    }
                    if (n8 != n9) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OCN_MUXDEMUX_WLEN_PARAM_2, (Object)Wavelength.getWavelengthStringFromWavelength(n8), (Object)Wavelength.getWavelengthStringFromWavelength(n9)));
                    }
                } else {
                    if (db.isFinestEnabled()) {
                        db.finest("SONET/SDH trunk <-> Barolo client wlen check skipped due to pre-provisioned line card");
                    }
                    if (bl && bl4) {
                        throw new WarningMessageException(ErrorMsg.getString((EID)NEMC.WID_VL_OCN_PREPROV_WLEN_SKIPPED));
                    }
                }
            } else if (db.isFinestEnabled()) {
                db.finest("SONET/SDH trunk <-> Barolo client wlen check skipped due to feature check");
            }
        }
        if (VirtualLinksDirector.isSdh(n3) && VirtualLinksDirector.isSdh(n4)) {
            if (n3 == 28 || n3 == 29 || n4 == 28 || n4 == 29) {
                throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_OC3OC12_MUXDEMUX));
            }
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OCH_TRAIL_PROVISIONING) && Feature.provides((INodeModel)iNodeModel2, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                if (db.isFinestEnabled()) {
                    db.finest("SONET/SDH trunk <-> SONET/SDH trunk check");
                }
                IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel();
                boolean bl5 = iOpticsChannelModel.isWavelengthSupported();
                iOpticsChannelModel = (IOpticsChannelModel)((IPortModel)iEntityModel2).getInterfaceModel();
                boolean bl6 = iOpticsChannelModel.isWavelengthSupported();
                boolean bl7 = iEntityModel.getModuleModel().isPreProvisioned();
                boolean bl8 = iEntityModel2.getModuleModel().isPreProvisioned();
                if (db.isFinestEnabled()) {
                    db.finest("isLcPreProvisioned = " + bl7 + "isRemoteLcPreProvisioned = " + bl8);
                }
                if (!bl7 && !bl8) {
                    if (db.isFinestEnabled()) {
                        db.finest("isWLenSupported = " + bl5 + "isRemoteWLenSupported = " + bl6);
                    }
                    if (!bl5 && !bl6) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_BOTH_NON_COLORED_OCN));
                    }
                    if (!bl5) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_NON_COLORED_OCN_OCN));
                    }
                    if (!bl6) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_NON_COLORED_OCN_OCN));
                    }
                    int n10 = VirtualLinksDirector.getWlen(iEntityModel);
                    n = VirtualLinksDirector.getWlen(iEntityModel2);
                    if (db.isFinestEnabled()) {
                        db.finest("local wlen = " + Wavelength.getWavelengthStringFromWavelength(n10) + "remote wlen = " + Wavelength.getWavelengthStringFromWavelength(n));
                    }
                    if (n10 != n) {
                        throw new Exception(ErrorMsg.getString((EID)NEMC.EID_ERROR_VL_OCN_MUXDEMUX_WLEN_PARAM_2, (Object)Wavelength.getWavelengthStringFromWavelength(n10), (Object)Wavelength.getWavelengthStringFromWavelength(n)));
                    }
                } else {
                    if (db.isFinestEnabled()) {
                        db.finest("SONET/SDH trunk <-> Barolo client wlen check skipped due to pre-provisioned line card");
                    }
                    if (bl) {
                        throw new WarningMessageException(ErrorMsg.getString((EID)NEMC.WID_VL_OCN_PREPROV_WLEN_SKIPPED));
                    }
                }
            } else if (db.isFinestEnabled()) {
                db.finest("SONET/SDH trunk <-> SONET client check skipped due to feature check");
            }
        }
        if (VirtualLinksDirector.isOts(iEntityModel) && VirtualLinksDirector.isOts(iEntityModel2)) {
            if (iIpAddr.compareTo((Object)iIpAddr2) == 0) {
                throw new Exception("OTS ports must be on different nodes.");
            }
            int n11 = OchPortsHelper.getSideRole(iEntityModel);
            int n12 = OchPortsHelper.getSideRole(iEntityModel2);
            if (n11 != 0 && n12 != 0 && n11 != n12) {
                throw new Exception("OTS ports must be on compatible side roles.");
            }
        }
        if (n3 == 167 && n4 == 168 || n3 == 168 && n4 == 167) {
            throw new Exception(ErrorMsg.getString((EID)NEMC.EID_PPC_PORTS_NOT_COMPATIBLE));
        }
    }

    private static final boolean isSdh(int n) {
        return n == 28 || n == 29 || n == 30 || n == 61;
    }

    private static final int getWlen(IEntityModel iEntityModel) throws NoSuchInterface, WrongInterfaceType {
        IPortModel iPortModel = (IPortModel)iEntityModel;
        IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)iPortModel.getInterfaceModel();
        int n = iOpticsChannelModel.getActualWaveLength();
        if (n == 0) {
            if (db.isFineEnabled()) {
                db.fine("Using expected wlen for local port");
            }
            n = iOpticsChannelModel.getExpectedWaveLength();
        } else if (db.isFineEnabled()) {
            db.fine("Using expected wlen for local port");
        }
        return n;
    }

    private static final boolean attemptProvisionWlen(IEntityModel iEntityModel, int n) {
        boolean bl;
        block8: {
            bl = false;
            db.fine("attemptProvisionWlen(" + iEntityModel + ", " + n + ")");
            try {
                IOpticsChannelModel iOpticsChannelModel = (IOpticsChannelModel)((IPortModel)iEntityModel).getInterfaceModel();
                iOpticsChannelModel.setWaveLength(n);
                db.finest("\tprovisioning the wavelength succeeded.");
                bl = true;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (DetailedConfigError detailedConfigError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)detailedConfigError);
                }
            }
            catch (ProvisionError provisionError) {
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)provisionError);
            }
        }
        return bl;
    }

    private static int getActualPortType(IEntityModel iEntityModel) {
        int n = 0;
        if (iEntityModel instanceof IDwdmPortModel) {
            n = ((IDwdmPortModel)iEntityModel).isClientPort() ? 122 : 123;
        }
        return n;
    }

    public IFvNetLink[] getTheLinkTerminations(IFvVirtualLink iFvVirtualLink) throws MissingLink {
        return VirtualLinksDirector.getLinkTerminations((VirtualNetLink)iFvVirtualLink);
    }

    public boolean isTheLinkUp(IFvVirtualLink iFvVirtualLink) {
        return this.isLinkUp((VirtualNetLink)iFvVirtualLink);
    }

    public IFvNetLink[] getTheAvailLinkTerminations(IFvVirtualLink iFvVirtualLink) {
        return VirtualLinksDirector.getAvailLinkTerminations((VirtualNetLink)iFvVirtualLink);
    }

    public boolean hasASeparateTxRx(IFvVirtualLink iFvVirtualLink) throws AbstractCmsNoSuchEntityException {
        return VirtualLinksDirector.hasSeparateTxRx((VirtualNetLink)iFvVirtualLink);
    }

    public class NodeComparator
    implements Comparator<INodeModel> {
        @Override
        public int compare(INodeModel iNodeModel, INodeModel iNodeModel2) {
            try {
                IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
                IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
                if (iIpAddr != null && iIpAddr2 != null) {
                    try {
                        return iIpAddr.compareTo((Object)iIpAddr2);
                    }
                    catch (ClassCastException classCastException) {
                        return -iIpAddr2.compareTo((Object)iIpAddr);
                    }
                }
                if (iIpAddr != null) {
                    return 1;
                }
                return -1;
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                if (iNodeModel == iNodeModel2) {
                    return 0;
                }
                return 1;
            }
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof NodeComparator) {
                NodeComparator nodeComparator = (NodeComparator)object;
                bl = nodeComparator == this;
            }
            return bl;
        }
    }

    protected static class VlinkDebug
    extends SDebug {
        public VlinkDebug(String string) {
            super(string);
        }

        public final void dumpNodes() {
            INodeModel[] iNodeModelArray;
            db.println("Known Nodes:");
            for (INodeModel iNodeModel : iNodeModelArray = instance.getKnownNodes()) {
                db.println("\t" + iNodeModel.getName());
            }
        }

        public final void dumpLinks() {
            db.println("Known Links:");
            Set<IVirtualLinkModel> set = instance.getVirtualLinks();
            for (IVirtualLinkModel iVirtualLinkModel : set) {
                db.println("\t" + iVirtualLinkModel);
            }
        }
    }

    protected class VlinkHolder
    extends Model
    implements IVirtualLinkModel {
        private short origVLID;
        private IIpAddr origNode;
        private IEntityModel origEntity;
        private short termVLID;
        private IIpAddr termNode;
        private IEntityModel termEntity;
        private short termShelfId;
        private short origShelfId;

        public VlinkHolder(short s, IIpAddr iIpAddr, IEntityModel iEntityModel, short s2, IIpAddr iIpAddr2, IEntityModel iEntityModel2) {
            super(db);
            this.origVLID = s;
            this.origNode = iIpAddr;
            this.origEntity = iEntityModel;
            this.termVLID = s2;
            this.termNode = iIpAddr2;
            this.termEntity = iEntityModel2;
        }

        public short getOrigVLID() {
            return this.origVLID;
        }

        public IIpAddr getOrigNode() {
            return this.origNode;
        }

        public IEntityModel getOrigEntity() {
            return this.origEntity;
        }

        public IEntityModel getTermEntity() {
            return this.termEntity;
        }

        public IIpAddr getTermNode() {
            return this.termNode;
        }

        public short getTermVLID() {
            return this.termVLID;
        }

        public short getOrigShelfId() {
            if (this.origEntity != null && Feature.provides((INodeModel)this.origEntity.getNodeModel(), (Feature)Feature.MULTISHELF) && this.origEntity.getNodeModel().isMultishelf()) {
                return (short)this.origEntity.getShelfId();
            }
            return 1;
        }

        public short getTermShelfId() {
            if (this.termEntity != null && Feature.provides((INodeModel)this.termEntity.getNodeModel(), (Feature)Feature.MULTISHELF)) {
                return (short)this.termEntity.getShelfId();
            }
            return 1;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            if (object != null && object instanceof IVirtualLinkModel) {
                IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)object;
                if (this.db.isFineEnabled()) {
                    this.db.fine("compareTo: this is " + this + "          other is " + iVirtualLinkModel);
                }
                if (iVirtualLinkModel.getOrigVLID() == this.origVLID) {
                    if (iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode) == 0) {
                        if (iVirtualLinkModel.getOrigEntity() != null && iVirtualLinkModel.getOrigEntity().equals(this.origEntity) || iVirtualLinkModel.getOrigEntity() == null && this.origEntity == null) {
                            if (iVirtualLinkModel.getTermVLID() == this.origVLID) {
                                if (iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode) == 0) {
                                    if (iVirtualLinkModel.getTermEntity() == null && this.termEntity == null || iVirtualLinkModel.getTermEntity().equals(this.termEntity)) {
                                        return 0;
                                    }
                                    if (iVirtualLinkModel.getTermEntity() != null && this.termEntity == null) {
                                        return -1;
                                    }
                                    return 1;
                                }
                                return iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode);
                            }
                            return new Integer(this.termVLID).compareTo(new Integer(iVirtualLinkModel.getTermVLID()));
                        }
                        if (iVirtualLinkModel.getOrigEntity() != null && this.origEntity == null) {
                            return -1;
                        }
                        return 1;
                    }
                    return iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode);
                }
                return new Integer(this.origVLID).compareTo(new Integer(iVirtualLinkModel.getOrigVLID()));
            }
            return 1;
        }

        public void swap() {
            short s = this.origVLID;
            IIpAddr iIpAddr = this.origNode;
            IEntityModel iEntityModel = this.origEntity;
            short s2 = this.origShelfId;
            this.origVLID = this.termVLID;
            this.origNode = this.termNode;
            this.origEntity = this.termEntity;
            this.origShelfId = this.termShelfId;
            this.termVLID = s;
            this.termNode = iIpAddr;
            this.termEntity = iEntityModel;
            this.termShelfId = s2;
        }

        public String toString() {
            IEntityCellRenderer iEntityCellRenderer;
            INodeModel iNodeModel;
            StringBuilder stringBuilder = new StringBuilder("[");
            stringBuilder.append(Short.toString(this.origVLID) + ", ");
            stringBuilder.append(VirtualLinksDirector.ipToString(this.origNode) + ", ");
            if (this.origEntity != null) {
                iNodeModel = this.origEntity.getNodeModel();
                iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(this.origEntity.getModuleModel());
                stringBuilder.append(iEntityCellRenderer.getString((Object)this.origEntity, "slot ") + ", ");
            } else {
                stringBuilder.append("<null entity>, ");
            }
            stringBuilder.append(Short.toString(this.termVLID) + ", ");
            stringBuilder.append(VirtualLinksDirector.ipToString(this.termNode) + ", ");
            if (this.termEntity != null) {
                iNodeModel = this.termEntity.getNodeModel();
                iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(this.termEntity.getModuleModel());
                stringBuilder.append(iEntityCellRenderer.getString((Object)this.termEntity, "slot ") + "]");
            } else {
                stringBuilder.append("<null entity>]");
            }
            return stringBuilder.toString();
        }

        @Override
        public void update(Observable observable, Object object) {
        }
    }
}

