/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.Busy;
import cerent.cms.model.blsr.BlsrNode;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;

class BlsrUnprovisionAgent
implements IJobControl {
    private BlsrNode blsrNode;
    private boolean abort = false;
    private static final SDebug db = new SDebug("BlsrUnprovisionAgent");

    public BlsrUnprovisionAgent(BlsrNode blsrNode) {
        this.blsrNode = blsrNode;
    }

    public JobStatus executeJob() throws Exception {
        JobStatus jobStatus = new JobStatus(1, (Object)this.blsrNode);
        if (!this.abort) {
            try {
                this.blsrNode.delete();
                jobStatus = new JobStatus(4, (Object)this.blsrNode);
            }
            catch (Busy busy) {
                db.println(this.blsrNode.toString() + ": busy.  Could not unprovision it.");
                SDebug.printStackTrace((Throwable)busy);
                jobStatus = new JobStatus(2, (Object)this.blsrNode);
            }
            catch (IllegalStateException illegalStateException) {
                SDebug.printStackTrace((Throwable)illegalStateException);
                jobStatus = new JobStatus(2, (Object)this.blsrNode);
            }
        } else {
            jobStatus = new JobStatus(3, (Object)this.blsrNode);
        }
        return jobStatus;
    }

    public void abortJob() {
        this.abort = true;
    }

    public String getName() {
        return "BlsrUnprovisionAgent";
    }
}

