/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.circuits.CircuitFilterCriteriaPreferences;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.ComparisonUtil;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;

public class CircuitFilterCriteria
extends Observable
implements Observer {
    public static final String EMPTY_DEFAULT = "";
    public static final int ANY_DEFAULT = -1;
    public static final int ONE_SRC_ONE_DROP = 1;
    public static final int MULTI_SRC_MULTI_DROP = 2;
    private static CircuitFilterCriteria criteria;
    private CircuitFilterCriteriaPreferences prefs = CircuitFilterCriteriaPreferences.instance();
    private String name = "";
    private int direction = -1;
    private int optDir = -1;
    private int optChannel = -1;
    private int status = -1;
    private int serviceState = -1;
    private int protectionType = -1;
    private int slot = -1;
    private int shelf = -1;
    private int[] port = null;
    private int type = -1;
    private int[] size = null;
    private BlsrRingModel ring = null;
    private INetElement[] netElems = null;
    private INetLink link = null;
    private int srcDropType = -1;
    private static final SDebug db;

    private CircuitFilterCriteria() {
        this.prefs.loadInto(this);
    }

    public static CircuitFilterCriteria instance() {
        if (criteria == null) {
            criteria = new CircuitFilterCriteria();
        }
        return criteria;
    }

    public void saveCriteriaPreferences() {
        this.prefs.saveFrom(this);
    }

    public void setName(String string) {
        if (!this.equals(this.name, string)) {
            this.name = string;
            this.setChanged();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDirection(int n) {
        if (this.direction != n) {
            this.direction = n;
            this.setChanged();
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setOptDir(int n) {
        if (this.optDir != n) {
            this.optDir = n;
            this.setChanged();
        }
    }

    public int getOptDir() {
        return this.optDir;
    }

    public void setOptChannel(int n) {
        if (this.optChannel != n) {
            this.optChannel = n;
            this.setChanged();
        }
    }

    public int getOptChannel() {
        return this.optChannel;
    }

    public void setStatus(int n) {
        if (this.status != n) {
            this.status = n;
            this.setChanged();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setServiceState(int n) {
        if (this.serviceState != n) {
            this.serviceState = n;
            this.setChanged();
        }
    }

    public int getServiceState() {
        return this.serviceState;
    }

    public void setProtectionType(int n) {
        if (this.protectionType != n) {
            this.protectionType = n;
            this.setChanged();
        }
    }

    public int getProtectionType() {
        return this.protectionType;
    }

    public void setShelf(int n) {
        if (this.shelf != n) {
            this.shelf = n;
            this.setChanged();
        }
    }

    public int getShelf() {
        return this.shelf;
    }

    public void setSlot(int n) {
        if (this.slot != n) {
            this.slot = n;
            this.setChanged();
        }
    }

    public int getSlot() {
        return this.slot;
    }

    public void setPort(int[] nArray) {
        if (ComparisonUtil.compare((int[])this.port, (int[])nArray) != 0) {
            this.port = nArray;
            this.setChanged();
        }
    }

    public int[] getPort() {
        return this.port;
    }

    public void setType(int n) {
        if (this.type != n) {
            this.type = n;
            this.setChanged();
        }
    }

    public int getType() {
        return this.type;
    }

    public void setSize(int[] nArray) {
        if (ComparisonUtil.compare((int[])this.size, (int[])nArray) != 0) {
            this.size = nArray;
            this.setChanged();
        }
    }

    public int[] getSize() {
        return this.size;
    }

    public void setRing(BlsrRingModel blsrRingModel) {
        if (!this.equals(this.ring, blsrRingModel)) {
            this.stopObserving((IObservable)this.ring);
            this.ring = blsrRingModel;
            this.setChanged();
            this.startObserving((IObservable)this.ring);
        }
    }

    public BlsrRingModel getRing() {
        return this.ring;
    }

    public void setNetElements(INetElement[] iNetElementArray) {
        if (!Arrays.equals(this.netElems, iNetElementArray)) {
            this.stopObserving((IObservable[])this.netElems);
            this.netElems = iNetElementArray;
            this.setChanged();
            this.startObserving((IObservable[])this.netElems);
        }
    }

    public INetElement[] getNetElements() {
        return this.netElems;
    }

    public void setLink(INetLink iNetLink) {
        if (!this.equals(this.link, iNetLink)) {
            this.stopObserving((IObservable)this.link);
            this.link = iNetLink;
            this.setChanged();
            this.startObserving((IObservable)this.link);
        }
    }

    public INetLink getLink() {
        return this.link;
    }

    public void setSrcDropType(int n) {
        this.srcDropType = n;
        this.setChanged();
    }

    public int getSrcDropType() {
        return this.srcDropType;
    }

    public void destroy() {
        this.name = null;
        this.port = null;
        this.size = null;
        this.stopObserving((IObservable)this.ring);
        this.stopObserving((IObservable[])this.netElems);
        this.stopObserving((IObservable)this.link);
        this.ring = null;
        this.netElems = null;
        this.link = null;
    }

    private void stopObserving(IObservable iObservable) {
        if (iObservable != null) {
            iObservable.deleteObserver((Observer)this);
        }
    }

    private void stopObserving(IObservable[] iObservableArray) {
        if (iObservableArray != null) {
            for (int i = 0; i < iObservableArray.length; ++i) {
                this.stopObserving(iObservableArray[i]);
            }
        }
    }

    private void startObserving(IObservable iObservable) {
        if (iObservable != null) {
            iObservable.addObserver((Observer)this);
        }
    }

    private void startObserving(IObservable[] iObservableArray) {
        if (iObservableArray != null) {
            for (int i = 0; i < iObservableArray.length; ++i) {
                this.startObserving(iObservableArray[i]);
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == ModelUpdateType.DELETED) {
            if (observable instanceof BlsrRingModel) {
                this.setRing(null);
            } else if (observable instanceof INetLink) {
                this.setLink(null);
            } else if (observable instanceof INetElement) {
                ArrayList<INetElement> arrayList = new ArrayList<INetElement>(Arrays.asList(this.netElems));
                arrayList.remove(observable);
                this.setNetElements(arrayList.toArray(new INetElement[arrayList.size()]));
            }
        }
        this.filterCriteriaChanged();
    }

    private boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public void filterCriteriaChanged() {
        if (db.on()) {
            db.println("notify changed to " + this.countObservers() + " observers");
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    static {
        db = new SDebug("CircuitFilterCriteria");
    }
}

